<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_company_list = new shipping_company_list();

// Run the page
$shipping_company_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_company_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shipping_company->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fshipping_companylist = currentForm = new ew.Form("fshipping_companylist", "list");
fshipping_companylist.formKeyCountName = '<?php echo $shipping_company_list->FormKeyCountName ?>';

// Form_CustomValidate event
fshipping_companylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_companylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_companylist.lists["x_operator"] = <?php echo $shipping_company_list->operator->Lookup->toClientList() ?>;
fshipping_companylist.lists["x_operator"].options = <?php echo JsonEncode($shipping_company_list->operator->lookupOptions()) ?>;
fshipping_companylist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fshipping_companylistsrch = currentSearchForm = new ew.Form("fshipping_companylistsrch");

// Filters
fshipping_companylistsrch.filterList = <?php echo $shipping_company_list->getFilterList() ?>;

// Init search panel as collapsed
fshipping_companylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shipping_company->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($shipping_company_list->TotalRecs > 0 && $shipping_company_list->ExportOptions->visible()) { ?>
<?php $shipping_company_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_company_list->ImportOptions->visible()) { ?>
<?php $shipping_company_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_company_list->SearchOptions->visible()) { ?>
<?php $shipping_company_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_company_list->FilterOptions->visible()) { ?>
<?php $shipping_company_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$shipping_company_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$shipping_company->isExport() && !$shipping_company->CurrentAction) { ?>
<form name="fshipping_companylistsrch" id="fshipping_companylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($shipping_company_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fshipping_companylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="shipping_company">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($shipping_company_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($shipping_company_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $shipping_company_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($shipping_company_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($shipping_company_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($shipping_company_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($shipping_company_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $shipping_company_list->showPageHeader(); ?>
<?php
$shipping_company_list->showMessage();
?>
<?php if ($shipping_company_list->TotalRecs > 0 || $shipping_company->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($shipping_company_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> shipping_company">
<?php if (!$shipping_company->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$shipping_company->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shipping_company_list->Pager)) $shipping_company_list->Pager = new PrevNextPager($shipping_company_list->StartRec, $shipping_company_list->DisplayRecs, $shipping_company_list->TotalRecs, $shipping_company_list->AutoHidePager) ?>
<?php if ($shipping_company_list->Pager->RecordCount > 0 && $shipping_company_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shipping_company_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shipping_company_list->pageUrl() ?>start=<?php echo $shipping_company_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shipping_company_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shipping_company_list->pageUrl() ?>start=<?php echo $shipping_company_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shipping_company_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shipping_company_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shipping_company_list->pageUrl() ?>start=<?php echo $shipping_company_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shipping_company_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shipping_company_list->pageUrl() ?>start=<?php echo $shipping_company_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shipping_company_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shipping_company_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shipping_company_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shipping_company_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shipping_company_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shipping_company_list->TotalRecs > 0 && (!$shipping_company_list->AutoHidePageSizeSelector || $shipping_company_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shipping_company">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shipping_company_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shipping_company_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shipping_company_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shipping_company_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shipping_company_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shipping_company->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shipping_company_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fshipping_companylist" id="fshipping_companylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_company_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_company_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_company">
<div id="gmp_shipping_company" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($shipping_company_list->TotalRecs > 0 || $shipping_company->isGridEdit()) { ?>
<table id="tbl_shipping_companylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$shipping_company_list->RowType = ROWTYPE_HEADER;

// Render list options
$shipping_company_list->renderListOptions();

// Render list options (header, left)
$shipping_company_list->ListOptions->render("header", "left");
?>
<?php if ($shipping_company->id->Visible) { // id ?>
	<?php if ($shipping_company->sortUrl($shipping_company->id) == "") { ?>
		<th data-name="id" class="<?php echo $shipping_company->id->headerCellClass() ?>"><div id="elh_shipping_company_id" class="shipping_company_id"><div class="ew-table-header-caption"><?php echo $shipping_company->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $shipping_company->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_company->SortUrl($shipping_company->id) ?>',2);"><div id="elh_shipping_company_id" class="shipping_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_company->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_company->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_company->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_company->name->Visible) { // name ?>
	<?php if ($shipping_company->sortUrl($shipping_company->name) == "") { ?>
		<th data-name="name" class="<?php echo $shipping_company->name->headerCellClass() ?>"><div id="elh_shipping_company_name" class="shipping_company_name"><div class="ew-table-header-caption"><?php echo $shipping_company->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $shipping_company->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_company->SortUrl($shipping_company->name) ?>',2);"><div id="elh_shipping_company_name" class="shipping_company_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_company->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_company->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_company->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_company->tracking_url->Visible) { // tracking_url ?>
	<?php if ($shipping_company->sortUrl($shipping_company->tracking_url) == "") { ?>
		<th data-name="tracking_url" class="<?php echo $shipping_company->tracking_url->headerCellClass() ?>"><div id="elh_shipping_company_tracking_url" class="shipping_company_tracking_url"><div class="ew-table-header-caption"><?php echo $shipping_company->tracking_url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tracking_url" class="<?php echo $shipping_company->tracking_url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_company->SortUrl($shipping_company->tracking_url) ?>',2);"><div id="elh_shipping_company_tracking_url" class="shipping_company_tracking_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_company->tracking_url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_company->tracking_url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_company->tracking_url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_company->operator->Visible) { // operator ?>
	<?php if ($shipping_company->sortUrl($shipping_company->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $shipping_company->operator->headerCellClass() ?>"><div id="elh_shipping_company_operator" class="shipping_company_operator"><div class="ew-table-header-caption"><?php echo $shipping_company->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $shipping_company->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_company->SortUrl($shipping_company->operator) ?>',2);"><div id="elh_shipping_company_operator" class="shipping_company_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_company->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_company->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_company->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_company->datetime->Visible) { // datetime ?>
	<?php if ($shipping_company->sortUrl($shipping_company->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $shipping_company->datetime->headerCellClass() ?>"><div id="elh_shipping_company_datetime" class="shipping_company_datetime"><div class="ew-table-header-caption"><?php echo $shipping_company->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $shipping_company->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_company->SortUrl($shipping_company->datetime) ?>',2);"><div id="elh_shipping_company_datetime" class="shipping_company_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_company->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_company->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_company->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$shipping_company_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($shipping_company->ExportAll && $shipping_company->isExport()) {
	$shipping_company_list->StopRec = $shipping_company_list->TotalRecs;
} else {

	// Set the last record to display
	if ($shipping_company_list->TotalRecs > $shipping_company_list->StartRec + $shipping_company_list->DisplayRecs - 1)
		$shipping_company_list->StopRec = $shipping_company_list->StartRec + $shipping_company_list->DisplayRecs - 1;
	else
		$shipping_company_list->StopRec = $shipping_company_list->TotalRecs;
}
$shipping_company_list->RecCnt = $shipping_company_list->StartRec - 1;
if ($shipping_company_list->Recordset && !$shipping_company_list->Recordset->EOF) {
	$shipping_company_list->Recordset->moveFirst();
	$selectLimit = $shipping_company_list->UseSelectLimit;
	if (!$selectLimit && $shipping_company_list->StartRec > 1)
		$shipping_company_list->Recordset->move($shipping_company_list->StartRec - 1);
} elseif (!$shipping_company->AllowAddDeleteRow && $shipping_company_list->StopRec == 0) {
	$shipping_company_list->StopRec = $shipping_company->GridAddRowCount;
}

// Initialize aggregate
$shipping_company->RowType = ROWTYPE_AGGREGATEINIT;
$shipping_company->resetAttributes();
$shipping_company_list->renderRow();
while ($shipping_company_list->RecCnt < $shipping_company_list->StopRec) {
	$shipping_company_list->RecCnt++;
	if ($shipping_company_list->RecCnt >= $shipping_company_list->StartRec) {
		$shipping_company_list->RowCnt++;

		// Set up key count
		$shipping_company_list->KeyCount = $shipping_company_list->RowIndex;

		// Init row class and style
		$shipping_company->resetAttributes();
		$shipping_company->CssClass = "";
		if ($shipping_company->isGridAdd()) {
		} else {
			$shipping_company_list->loadRowValues($shipping_company_list->Recordset); // Load row values
		}
		$shipping_company->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$shipping_company->RowAttrs = array_merge($shipping_company->RowAttrs, array('data-rowindex'=>$shipping_company_list->RowCnt, 'id'=>'r' . $shipping_company_list->RowCnt . '_shipping_company', 'data-rowtype'=>$shipping_company->RowType));

		// Render row
		$shipping_company_list->renderRow();

		// Render list options
		$shipping_company_list->renderListOptions();
?>
	<tr<?php echo $shipping_company->rowAttributes() ?>>
<?php

// Render list options (body, left)
$shipping_company_list->ListOptions->render("body", "left", $shipping_company_list->RowCnt);
?>
	<?php if ($shipping_company->id->Visible) { // id ?>
		<td data-name="id"<?php echo $shipping_company->id->cellAttributes() ?>>
<span id="el<?php echo $shipping_company_list->RowCnt ?>_shipping_company_id" class="shipping_company_id">
<span<?php echo $shipping_company->id->viewAttributes() ?>>
<?php echo $shipping_company->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_company->name->Visible) { // name ?>
		<td data-name="name"<?php echo $shipping_company->name->cellAttributes() ?>>
<span id="el<?php echo $shipping_company_list->RowCnt ?>_shipping_company_name" class="shipping_company_name">
<span<?php echo $shipping_company->name->viewAttributes() ?>>
<?php echo $shipping_company->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_company->tracking_url->Visible) { // tracking_url ?>
		<td data-name="tracking_url"<?php echo $shipping_company->tracking_url->cellAttributes() ?>>
<span id="el<?php echo $shipping_company_list->RowCnt ?>_shipping_company_tracking_url" class="shipping_company_tracking_url">
<span<?php echo $shipping_company->tracking_url->viewAttributes() ?>>
<?php echo $shipping_company->tracking_url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_company->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $shipping_company->operator->cellAttributes() ?>>
<span id="el<?php echo $shipping_company_list->RowCnt ?>_shipping_company_operator" class="shipping_company_operator">
<span<?php echo $shipping_company->operator->viewAttributes() ?>>
<?php echo $shipping_company->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_company->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $shipping_company->datetime->cellAttributes() ?>>
<span id="el<?php echo $shipping_company_list->RowCnt ?>_shipping_company_datetime" class="shipping_company_datetime">
<span<?php echo $shipping_company->datetime->viewAttributes() ?>>
<?php echo $shipping_company->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$shipping_company_list->ListOptions->render("body", "right", $shipping_company_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$shipping_company->isGridAdd())
		$shipping_company_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$shipping_company->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($shipping_company_list->Recordset)
	$shipping_company_list->Recordset->Close();
?>
<?php if (!$shipping_company->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$shipping_company->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shipping_company_list->Pager)) $shipping_company_list->Pager = new PrevNextPager($shipping_company_list->StartRec, $shipping_company_list->DisplayRecs, $shipping_company_list->TotalRecs, $shipping_company_list->AutoHidePager) ?>
<?php if ($shipping_company_list->Pager->RecordCount > 0 && $shipping_company_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shipping_company_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shipping_company_list->pageUrl() ?>start=<?php echo $shipping_company_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shipping_company_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shipping_company_list->pageUrl() ?>start=<?php echo $shipping_company_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shipping_company_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shipping_company_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shipping_company_list->pageUrl() ?>start=<?php echo $shipping_company_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shipping_company_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shipping_company_list->pageUrl() ?>start=<?php echo $shipping_company_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shipping_company_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shipping_company_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shipping_company_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shipping_company_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shipping_company_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shipping_company_list->TotalRecs > 0 && (!$shipping_company_list->AutoHidePageSizeSelector || $shipping_company_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shipping_company">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shipping_company_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shipping_company_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shipping_company_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shipping_company_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shipping_company_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shipping_company->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shipping_company_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($shipping_company_list->TotalRecs == 0 && !$shipping_company->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $shipping_company_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$shipping_company_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shipping_company->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$shipping_company->isExport()) { ?>
<script>
ew.scrollableTable("gmp_shipping_company", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shipping_company_list->terminate();
?>