<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_company_view = new shipping_company_view();

// Run the page
$shipping_company_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_company_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shipping_company->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fshipping_companyview = currentForm = new ew.Form("fshipping_companyview", "view");

// Form_CustomValidate event
fshipping_companyview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_companyview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_companyview.lists["x_operator"] = <?php echo $shipping_company_view->operator->Lookup->toClientList() ?>;
fshipping_companyview.lists["x_operator"].options = <?php echo JsonEncode($shipping_company_view->operator->lookupOptions()) ?>;
fshipping_companyview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shipping_company->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $shipping_company_view->ExportOptions->render("body") ?>
<?php $shipping_company_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $shipping_company_view->showPageHeader(); ?>
<?php
$shipping_company_view->showMessage();
?>
<form name="fshipping_companyview" id="fshipping_companyview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_company_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_company_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_company">
<input type="hidden" name="modal" value="<?php echo (int)$shipping_company_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($shipping_company->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $shipping_company_view->TableLeftColumnClass ?>"><span id="elh_shipping_company_id"><?php echo $shipping_company->id->caption() ?></span></td>
		<td data-name="id"<?php echo $shipping_company->id->cellAttributes() ?>>
<span id="el_shipping_company_id">
<span<?php echo $shipping_company->id->viewAttributes() ?>>
<?php echo $shipping_company->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_company->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $shipping_company_view->TableLeftColumnClass ?>"><span id="elh_shipping_company_name"><?php echo $shipping_company->name->caption() ?></span></td>
		<td data-name="name"<?php echo $shipping_company->name->cellAttributes() ?>>
<span id="el_shipping_company_name">
<span<?php echo $shipping_company->name->viewAttributes() ?>>
<?php echo $shipping_company->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_company->tracking_url->Visible) { // tracking_url ?>
	<tr id="r_tracking_url">
		<td class="<?php echo $shipping_company_view->TableLeftColumnClass ?>"><span id="elh_shipping_company_tracking_url"><?php echo $shipping_company->tracking_url->caption() ?></span></td>
		<td data-name="tracking_url"<?php echo $shipping_company->tracking_url->cellAttributes() ?>>
<span id="el_shipping_company_tracking_url">
<span<?php echo $shipping_company->tracking_url->viewAttributes() ?>>
<?php echo $shipping_company->tracking_url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_company->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $shipping_company_view->TableLeftColumnClass ?>"><span id="elh_shipping_company_operator"><?php echo $shipping_company->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $shipping_company->operator->cellAttributes() ?>>
<span id="el_shipping_company_operator">
<span<?php echo $shipping_company->operator->viewAttributes() ?>>
<?php echo $shipping_company->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_company->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $shipping_company_view->TableLeftColumnClass ?>"><span id="elh_shipping_company_datetime"><?php echo $shipping_company->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $shipping_company->datetime->cellAttributes() ?>>
<span id="el_shipping_company_datetime">
<span<?php echo $shipping_company->datetime->viewAttributes() ?>>
<?php echo $shipping_company->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$shipping_company_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shipping_company->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shipping_company_view->terminate();
?>