<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_details_add = new shipping_details_add();

// Run the page
$shipping_details_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_details_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fshipping_detailsadd = currentForm = new ew.Form("fshipping_detailsadd", "add");

// Validate form
fshipping_detailsadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($shipping_details_add->order_id->Required) { ?>
			elm = this.getElements("x" + infix + "_order_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_details->order_id->caption(), $shipping_details->order_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_order_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($shipping_details->order_id->errorMessage()) ?>");
		<?php if ($shipping_details_add->shipping_company->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_company");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_details->shipping_company->caption(), $shipping_details->shipping_company->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_shipping_company");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($shipping_details->shipping_company->errorMessage()) ?>");
		<?php if ($shipping_details_add->way_bill->Required) { ?>
			elm = this.getElements("x" + infix + "_way_bill");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_details->way_bill->caption(), $shipping_details->way_bill->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_details_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_details->dated->caption(), $shipping_details->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($shipping_details->dated->errorMessage()) ?>");
		<?php if ($shipping_details_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_details->operator->caption(), $shipping_details->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_details_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_details->datetime->caption(), $shipping_details->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshipping_detailsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_detailsadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_detailsadd.lists["x_operator"] = <?php echo $shipping_details_add->operator->Lookup->toClientList() ?>;
fshipping_detailsadd.lists["x_operator"].options = <?php echo JsonEncode($shipping_details_add->operator->lookupOptions()) ?>;
fshipping_detailsadd.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shipping_details_add->showPageHeader(); ?>
<?php
$shipping_details_add->showMessage();
?>
<form name="fshipping_detailsadd" id="fshipping_detailsadd" class="<?php echo $shipping_details_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_details_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_details_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_details">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$shipping_details_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($shipping_details->order_id->Visible) { // order_id ?>
	<div id="r_order_id" class="form-group row">
		<label id="elh_shipping_details_order_id" for="x_order_id" class="<?php echo $shipping_details_add->LeftColumnClass ?>"><?php echo $shipping_details->order_id->caption() ?><?php echo ($shipping_details->order_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_details_add->RightColumnClass ?>"><div<?php echo $shipping_details->order_id->cellAttributes() ?>>
<span id="el_shipping_details_order_id">
<input type="text" data-table="shipping_details" data-field="x_order_id" name="x_order_id" id="x_order_id" size="30" placeholder="<?php echo HtmlEncode($shipping_details->order_id->getPlaceHolder()) ?>" value="<?php echo $shipping_details->order_id->EditValue ?>"<?php echo $shipping_details->order_id->editAttributes() ?>>
</span>
<?php echo $shipping_details->order_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_details->shipping_company->Visible) { // shipping_company ?>
	<div id="r_shipping_company" class="form-group row">
		<label id="elh_shipping_details_shipping_company" for="x_shipping_company" class="<?php echo $shipping_details_add->LeftColumnClass ?>"><?php echo $shipping_details->shipping_company->caption() ?><?php echo ($shipping_details->shipping_company->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_details_add->RightColumnClass ?>"><div<?php echo $shipping_details->shipping_company->cellAttributes() ?>>
<span id="el_shipping_details_shipping_company">
<input type="text" data-table="shipping_details" data-field="x_shipping_company" name="x_shipping_company" id="x_shipping_company" size="30" placeholder="<?php echo HtmlEncode($shipping_details->shipping_company->getPlaceHolder()) ?>" value="<?php echo $shipping_details->shipping_company->EditValue ?>"<?php echo $shipping_details->shipping_company->editAttributes() ?>>
</span>
<?php echo $shipping_details->shipping_company->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_details->way_bill->Visible) { // way_bill ?>
	<div id="r_way_bill" class="form-group row">
		<label id="elh_shipping_details_way_bill" for="x_way_bill" class="<?php echo $shipping_details_add->LeftColumnClass ?>"><?php echo $shipping_details->way_bill->caption() ?><?php echo ($shipping_details->way_bill->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_details_add->RightColumnClass ?>"><div<?php echo $shipping_details->way_bill->cellAttributes() ?>>
<span id="el_shipping_details_way_bill">
<input type="text" data-table="shipping_details" data-field="x_way_bill" name="x_way_bill" id="x_way_bill" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($shipping_details->way_bill->getPlaceHolder()) ?>" value="<?php echo $shipping_details->way_bill->EditValue ?>"<?php echo $shipping_details->way_bill->editAttributes() ?>>
</span>
<?php echo $shipping_details->way_bill->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_details->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_shipping_details_dated" for="x_dated" class="<?php echo $shipping_details_add->LeftColumnClass ?>"><?php echo $shipping_details->dated->caption() ?><?php echo ($shipping_details->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_details_add->RightColumnClass ?>"><div<?php echo $shipping_details->dated->cellAttributes() ?>>
<span id="el_shipping_details_dated">
<input type="text" data-table="shipping_details" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($shipping_details->dated->getPlaceHolder()) ?>" value="<?php echo $shipping_details->dated->EditValue ?>"<?php echo $shipping_details->dated->editAttributes() ?>>
<?php if (!$shipping_details->dated->ReadOnly && !$shipping_details->dated->Disabled && !isset($shipping_details->dated->EditAttrs["readonly"]) && !isset($shipping_details->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fshipping_detailsadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $shipping_details->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shipping_details_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shipping_details_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shipping_details_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shipping_details_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shipping_details_add->terminate();
?>