<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_details_delete = new shipping_details_delete();

// Run the page
$shipping_details_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_details_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fshipping_detailsdelete = currentForm = new ew.Form("fshipping_detailsdelete", "delete");

// Form_CustomValidate event
fshipping_detailsdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_detailsdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_detailsdelete.lists["x_operator"] = <?php echo $shipping_details_delete->operator->Lookup->toClientList() ?>;
fshipping_detailsdelete.lists["x_operator"].options = <?php echo JsonEncode($shipping_details_delete->operator->lookupOptions()) ?>;
fshipping_detailsdelete.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shipping_details_delete->showPageHeader(); ?>
<?php
$shipping_details_delete->showMessage();
?>
<form name="fshipping_detailsdelete" id="fshipping_detailsdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_details_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_details_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_details">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($shipping_details_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($shipping_details->id->Visible) { // id ?>
		<th class="<?php echo $shipping_details->id->headerCellClass() ?>"><span id="elh_shipping_details_id" class="shipping_details_id"><?php echo $shipping_details->id->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_details->order_id->Visible) { // order_id ?>
		<th class="<?php echo $shipping_details->order_id->headerCellClass() ?>"><span id="elh_shipping_details_order_id" class="shipping_details_order_id"><?php echo $shipping_details->order_id->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_details->shipping_company->Visible) { // shipping_company ?>
		<th class="<?php echo $shipping_details->shipping_company->headerCellClass() ?>"><span id="elh_shipping_details_shipping_company" class="shipping_details_shipping_company"><?php echo $shipping_details->shipping_company->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_details->way_bill->Visible) { // way_bill ?>
		<th class="<?php echo $shipping_details->way_bill->headerCellClass() ?>"><span id="elh_shipping_details_way_bill" class="shipping_details_way_bill"><?php echo $shipping_details->way_bill->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_details->dated->Visible) { // dated ?>
		<th class="<?php echo $shipping_details->dated->headerCellClass() ?>"><span id="elh_shipping_details_dated" class="shipping_details_dated"><?php echo $shipping_details->dated->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_details->operator->Visible) { // operator ?>
		<th class="<?php echo $shipping_details->operator->headerCellClass() ?>"><span id="elh_shipping_details_operator" class="shipping_details_operator"><?php echo $shipping_details->operator->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_details->datetime->Visible) { // datetime ?>
		<th class="<?php echo $shipping_details->datetime->headerCellClass() ?>"><span id="elh_shipping_details_datetime" class="shipping_details_datetime"><?php echo $shipping_details->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$shipping_details_delete->RecCnt = 0;
$i = 0;
while (!$shipping_details_delete->Recordset->EOF) {
	$shipping_details_delete->RecCnt++;
	$shipping_details_delete->RowCnt++;

	// Set row properties
	$shipping_details->resetAttributes();
	$shipping_details->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$shipping_details_delete->loadRowValues($shipping_details_delete->Recordset);

	// Render row
	$shipping_details_delete->renderRow();
?>
	<tr<?php echo $shipping_details->rowAttributes() ?>>
<?php if ($shipping_details->id->Visible) { // id ?>
		<td<?php echo $shipping_details->id->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_delete->RowCnt ?>_shipping_details_id" class="shipping_details_id">
<span<?php echo $shipping_details->id->viewAttributes() ?>>
<?php echo $shipping_details->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_details->order_id->Visible) { // order_id ?>
		<td<?php echo $shipping_details->order_id->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_delete->RowCnt ?>_shipping_details_order_id" class="shipping_details_order_id">
<span<?php echo $shipping_details->order_id->viewAttributes() ?>>
<?php echo $shipping_details->order_id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_details->shipping_company->Visible) { // shipping_company ?>
		<td<?php echo $shipping_details->shipping_company->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_delete->RowCnt ?>_shipping_details_shipping_company" class="shipping_details_shipping_company">
<span<?php echo $shipping_details->shipping_company->viewAttributes() ?>>
<?php echo $shipping_details->shipping_company->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_details->way_bill->Visible) { // way_bill ?>
		<td<?php echo $shipping_details->way_bill->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_delete->RowCnt ?>_shipping_details_way_bill" class="shipping_details_way_bill">
<span<?php echo $shipping_details->way_bill->viewAttributes() ?>>
<?php echo $shipping_details->way_bill->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_details->dated->Visible) { // dated ?>
		<td<?php echo $shipping_details->dated->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_delete->RowCnt ?>_shipping_details_dated" class="shipping_details_dated">
<span<?php echo $shipping_details->dated->viewAttributes() ?>>
<?php echo $shipping_details->dated->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_details->operator->Visible) { // operator ?>
		<td<?php echo $shipping_details->operator->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_delete->RowCnt ?>_shipping_details_operator" class="shipping_details_operator">
<span<?php echo $shipping_details->operator->viewAttributes() ?>>
<?php echo $shipping_details->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_details->datetime->Visible) { // datetime ?>
		<td<?php echo $shipping_details->datetime->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_delete->RowCnt ?>_shipping_details_datetime" class="shipping_details_datetime">
<span<?php echo $shipping_details->datetime->viewAttributes() ?>>
<?php echo $shipping_details->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$shipping_details_delete->Recordset->moveNext();
}
$shipping_details_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shipping_details_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$shipping_details_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shipping_details_delete->terminate();
?>