<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_details_list = new shipping_details_list();

// Run the page
$shipping_details_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_details_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shipping_details->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fshipping_detailslist = currentForm = new ew.Form("fshipping_detailslist", "list");
fshipping_detailslist.formKeyCountName = '<?php echo $shipping_details_list->FormKeyCountName ?>';

// Form_CustomValidate event
fshipping_detailslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_detailslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_detailslist.lists["x_operator"] = <?php echo $shipping_details_list->operator->Lookup->toClientList() ?>;
fshipping_detailslist.lists["x_operator"].options = <?php echo JsonEncode($shipping_details_list->operator->lookupOptions()) ?>;
fshipping_detailslist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fshipping_detailslistsrch = currentSearchForm = new ew.Form("fshipping_detailslistsrch");

// Filters
fshipping_detailslistsrch.filterList = <?php echo $shipping_details_list->getFilterList() ?>;

// Init search panel as collapsed
fshipping_detailslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shipping_details->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($shipping_details_list->TotalRecs > 0 && $shipping_details_list->ExportOptions->visible()) { ?>
<?php $shipping_details_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_details_list->ImportOptions->visible()) { ?>
<?php $shipping_details_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_details_list->SearchOptions->visible()) { ?>
<?php $shipping_details_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_details_list->FilterOptions->visible()) { ?>
<?php $shipping_details_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$shipping_details_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$shipping_details->isExport() && !$shipping_details->CurrentAction) { ?>
<form name="fshipping_detailslistsrch" id="fshipping_detailslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($shipping_details_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fshipping_detailslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="shipping_details">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($shipping_details_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($shipping_details_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $shipping_details_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($shipping_details_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($shipping_details_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($shipping_details_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($shipping_details_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $shipping_details_list->showPageHeader(); ?>
<?php
$shipping_details_list->showMessage();
?>
<?php if ($shipping_details_list->TotalRecs > 0 || $shipping_details->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($shipping_details_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> shipping_details">
<?php if (!$shipping_details->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$shipping_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shipping_details_list->Pager)) $shipping_details_list->Pager = new PrevNextPager($shipping_details_list->StartRec, $shipping_details_list->DisplayRecs, $shipping_details_list->TotalRecs, $shipping_details_list->AutoHidePager) ?>
<?php if ($shipping_details_list->Pager->RecordCount > 0 && $shipping_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shipping_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shipping_details_list->pageUrl() ?>start=<?php echo $shipping_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shipping_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shipping_details_list->pageUrl() ?>start=<?php echo $shipping_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shipping_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shipping_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shipping_details_list->pageUrl() ?>start=<?php echo $shipping_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shipping_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shipping_details_list->pageUrl() ?>start=<?php echo $shipping_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shipping_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shipping_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shipping_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shipping_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shipping_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shipping_details_list->TotalRecs > 0 && (!$shipping_details_list->AutoHidePageSizeSelector || $shipping_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shipping_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shipping_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shipping_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shipping_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shipping_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shipping_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shipping_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shipping_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fshipping_detailslist" id="fshipping_detailslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_details_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_details_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_details">
<div id="gmp_shipping_details" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($shipping_details_list->TotalRecs > 0 || $shipping_details->isGridEdit()) { ?>
<table id="tbl_shipping_detailslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$shipping_details_list->RowType = ROWTYPE_HEADER;

// Render list options
$shipping_details_list->renderListOptions();

// Render list options (header, left)
$shipping_details_list->ListOptions->render("header", "left");
?>
<?php if ($shipping_details->id->Visible) { // id ?>
	<?php if ($shipping_details->sortUrl($shipping_details->id) == "") { ?>
		<th data-name="id" class="<?php echo $shipping_details->id->headerCellClass() ?>"><div id="elh_shipping_details_id" class="shipping_details_id"><div class="ew-table-header-caption"><?php echo $shipping_details->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $shipping_details->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_details->SortUrl($shipping_details->id) ?>',2);"><div id="elh_shipping_details_id" class="shipping_details_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_details->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_details->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_details->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_details->order_id->Visible) { // order_id ?>
	<?php if ($shipping_details->sortUrl($shipping_details->order_id) == "") { ?>
		<th data-name="order_id" class="<?php echo $shipping_details->order_id->headerCellClass() ?>"><div id="elh_shipping_details_order_id" class="shipping_details_order_id"><div class="ew-table-header-caption"><?php echo $shipping_details->order_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_id" class="<?php echo $shipping_details->order_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_details->SortUrl($shipping_details->order_id) ?>',2);"><div id="elh_shipping_details_order_id" class="shipping_details_order_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_details->order_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_details->order_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_details->order_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_details->shipping_company->Visible) { // shipping_company ?>
	<?php if ($shipping_details->sortUrl($shipping_details->shipping_company) == "") { ?>
		<th data-name="shipping_company" class="<?php echo $shipping_details->shipping_company->headerCellClass() ?>"><div id="elh_shipping_details_shipping_company" class="shipping_details_shipping_company"><div class="ew-table-header-caption"><?php echo $shipping_details->shipping_company->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_company" class="<?php echo $shipping_details->shipping_company->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_details->SortUrl($shipping_details->shipping_company) ?>',2);"><div id="elh_shipping_details_shipping_company" class="shipping_details_shipping_company">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_details->shipping_company->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_details->shipping_company->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_details->shipping_company->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_details->way_bill->Visible) { // way_bill ?>
	<?php if ($shipping_details->sortUrl($shipping_details->way_bill) == "") { ?>
		<th data-name="way_bill" class="<?php echo $shipping_details->way_bill->headerCellClass() ?>"><div id="elh_shipping_details_way_bill" class="shipping_details_way_bill"><div class="ew-table-header-caption"><?php echo $shipping_details->way_bill->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="way_bill" class="<?php echo $shipping_details->way_bill->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_details->SortUrl($shipping_details->way_bill) ?>',2);"><div id="elh_shipping_details_way_bill" class="shipping_details_way_bill">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_details->way_bill->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_details->way_bill->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_details->way_bill->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_details->dated->Visible) { // dated ?>
	<?php if ($shipping_details->sortUrl($shipping_details->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $shipping_details->dated->headerCellClass() ?>"><div id="elh_shipping_details_dated" class="shipping_details_dated"><div class="ew-table-header-caption"><?php echo $shipping_details->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $shipping_details->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_details->SortUrl($shipping_details->dated) ?>',2);"><div id="elh_shipping_details_dated" class="shipping_details_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_details->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_details->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_details->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_details->operator->Visible) { // operator ?>
	<?php if ($shipping_details->sortUrl($shipping_details->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $shipping_details->operator->headerCellClass() ?>"><div id="elh_shipping_details_operator" class="shipping_details_operator"><div class="ew-table-header-caption"><?php echo $shipping_details->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $shipping_details->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_details->SortUrl($shipping_details->operator) ?>',2);"><div id="elh_shipping_details_operator" class="shipping_details_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_details->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_details->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_details->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_details->datetime->Visible) { // datetime ?>
	<?php if ($shipping_details->sortUrl($shipping_details->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $shipping_details->datetime->headerCellClass() ?>"><div id="elh_shipping_details_datetime" class="shipping_details_datetime"><div class="ew-table-header-caption"><?php echo $shipping_details->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $shipping_details->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_details->SortUrl($shipping_details->datetime) ?>',2);"><div id="elh_shipping_details_datetime" class="shipping_details_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_details->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_details->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_details->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$shipping_details_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($shipping_details->ExportAll && $shipping_details->isExport()) {
	$shipping_details_list->StopRec = $shipping_details_list->TotalRecs;
} else {

	// Set the last record to display
	if ($shipping_details_list->TotalRecs > $shipping_details_list->StartRec + $shipping_details_list->DisplayRecs - 1)
		$shipping_details_list->StopRec = $shipping_details_list->StartRec + $shipping_details_list->DisplayRecs - 1;
	else
		$shipping_details_list->StopRec = $shipping_details_list->TotalRecs;
}
$shipping_details_list->RecCnt = $shipping_details_list->StartRec - 1;
if ($shipping_details_list->Recordset && !$shipping_details_list->Recordset->EOF) {
	$shipping_details_list->Recordset->moveFirst();
	$selectLimit = $shipping_details_list->UseSelectLimit;
	if (!$selectLimit && $shipping_details_list->StartRec > 1)
		$shipping_details_list->Recordset->move($shipping_details_list->StartRec - 1);
} elseif (!$shipping_details->AllowAddDeleteRow && $shipping_details_list->StopRec == 0) {
	$shipping_details_list->StopRec = $shipping_details->GridAddRowCount;
}

// Initialize aggregate
$shipping_details->RowType = ROWTYPE_AGGREGATEINIT;
$shipping_details->resetAttributes();
$shipping_details_list->renderRow();
while ($shipping_details_list->RecCnt < $shipping_details_list->StopRec) {
	$shipping_details_list->RecCnt++;
	if ($shipping_details_list->RecCnt >= $shipping_details_list->StartRec) {
		$shipping_details_list->RowCnt++;

		// Set up key count
		$shipping_details_list->KeyCount = $shipping_details_list->RowIndex;

		// Init row class and style
		$shipping_details->resetAttributes();
		$shipping_details->CssClass = "";
		if ($shipping_details->isGridAdd()) {
		} else {
			$shipping_details_list->loadRowValues($shipping_details_list->Recordset); // Load row values
		}
		$shipping_details->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$shipping_details->RowAttrs = array_merge($shipping_details->RowAttrs, array('data-rowindex'=>$shipping_details_list->RowCnt, 'id'=>'r' . $shipping_details_list->RowCnt . '_shipping_details', 'data-rowtype'=>$shipping_details->RowType));

		// Render row
		$shipping_details_list->renderRow();

		// Render list options
		$shipping_details_list->renderListOptions();
?>
	<tr<?php echo $shipping_details->rowAttributes() ?>>
<?php

// Render list options (body, left)
$shipping_details_list->ListOptions->render("body", "left", $shipping_details_list->RowCnt);
?>
	<?php if ($shipping_details->id->Visible) { // id ?>
		<td data-name="id"<?php echo $shipping_details->id->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_list->RowCnt ?>_shipping_details_id" class="shipping_details_id">
<span<?php echo $shipping_details->id->viewAttributes() ?>>
<?php echo $shipping_details->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_details->order_id->Visible) { // order_id ?>
		<td data-name="order_id"<?php echo $shipping_details->order_id->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_list->RowCnt ?>_shipping_details_order_id" class="shipping_details_order_id">
<span<?php echo $shipping_details->order_id->viewAttributes() ?>>
<?php echo $shipping_details->order_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_details->shipping_company->Visible) { // shipping_company ?>
		<td data-name="shipping_company"<?php echo $shipping_details->shipping_company->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_list->RowCnt ?>_shipping_details_shipping_company" class="shipping_details_shipping_company">
<span<?php echo $shipping_details->shipping_company->viewAttributes() ?>>
<?php echo $shipping_details->shipping_company->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_details->way_bill->Visible) { // way_bill ?>
		<td data-name="way_bill"<?php echo $shipping_details->way_bill->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_list->RowCnt ?>_shipping_details_way_bill" class="shipping_details_way_bill">
<span<?php echo $shipping_details->way_bill->viewAttributes() ?>>
<?php echo $shipping_details->way_bill->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_details->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $shipping_details->dated->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_list->RowCnt ?>_shipping_details_dated" class="shipping_details_dated">
<span<?php echo $shipping_details->dated->viewAttributes() ?>>
<?php echo $shipping_details->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_details->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $shipping_details->operator->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_list->RowCnt ?>_shipping_details_operator" class="shipping_details_operator">
<span<?php echo $shipping_details->operator->viewAttributes() ?>>
<?php echo $shipping_details->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_details->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $shipping_details->datetime->cellAttributes() ?>>
<span id="el<?php echo $shipping_details_list->RowCnt ?>_shipping_details_datetime" class="shipping_details_datetime">
<span<?php echo $shipping_details->datetime->viewAttributes() ?>>
<?php echo $shipping_details->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$shipping_details_list->ListOptions->render("body", "right", $shipping_details_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$shipping_details->isGridAdd())
		$shipping_details_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$shipping_details->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($shipping_details_list->Recordset)
	$shipping_details_list->Recordset->Close();
?>
<?php if (!$shipping_details->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$shipping_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shipping_details_list->Pager)) $shipping_details_list->Pager = new PrevNextPager($shipping_details_list->StartRec, $shipping_details_list->DisplayRecs, $shipping_details_list->TotalRecs, $shipping_details_list->AutoHidePager) ?>
<?php if ($shipping_details_list->Pager->RecordCount > 0 && $shipping_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shipping_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shipping_details_list->pageUrl() ?>start=<?php echo $shipping_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shipping_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shipping_details_list->pageUrl() ?>start=<?php echo $shipping_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shipping_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shipping_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shipping_details_list->pageUrl() ?>start=<?php echo $shipping_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shipping_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shipping_details_list->pageUrl() ?>start=<?php echo $shipping_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shipping_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shipping_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shipping_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shipping_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shipping_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shipping_details_list->TotalRecs > 0 && (!$shipping_details_list->AutoHidePageSizeSelector || $shipping_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shipping_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shipping_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shipping_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shipping_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shipping_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shipping_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shipping_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shipping_details_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($shipping_details_list->TotalRecs == 0 && !$shipping_details->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $shipping_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$shipping_details_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shipping_details->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$shipping_details->isExport()) { ?>
<script>
ew.scrollableTable("gmp_shipping_details", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shipping_details_list->terminate();
?>