<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_details_view = new shipping_details_view();

// Run the page
$shipping_details_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_details_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shipping_details->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fshipping_detailsview = currentForm = new ew.Form("fshipping_detailsview", "view");

// Form_CustomValidate event
fshipping_detailsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_detailsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_detailsview.lists["x_operator"] = <?php echo $shipping_details_view->operator->Lookup->toClientList() ?>;
fshipping_detailsview.lists["x_operator"].options = <?php echo JsonEncode($shipping_details_view->operator->lookupOptions()) ?>;
fshipping_detailsview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shipping_details->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $shipping_details_view->ExportOptions->render("body") ?>
<?php $shipping_details_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $shipping_details_view->showPageHeader(); ?>
<?php
$shipping_details_view->showMessage();
?>
<form name="fshipping_detailsview" id="fshipping_detailsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_details_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_details_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_details">
<input type="hidden" name="modal" value="<?php echo (int)$shipping_details_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($shipping_details->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $shipping_details_view->TableLeftColumnClass ?>"><span id="elh_shipping_details_id"><?php echo $shipping_details->id->caption() ?></span></td>
		<td data-name="id"<?php echo $shipping_details->id->cellAttributes() ?>>
<span id="el_shipping_details_id">
<span<?php echo $shipping_details->id->viewAttributes() ?>>
<?php echo $shipping_details->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_details->order_id->Visible) { // order_id ?>
	<tr id="r_order_id">
		<td class="<?php echo $shipping_details_view->TableLeftColumnClass ?>"><span id="elh_shipping_details_order_id"><?php echo $shipping_details->order_id->caption() ?></span></td>
		<td data-name="order_id"<?php echo $shipping_details->order_id->cellAttributes() ?>>
<span id="el_shipping_details_order_id">
<span<?php echo $shipping_details->order_id->viewAttributes() ?>>
<?php echo $shipping_details->order_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_details->shipping_company->Visible) { // shipping_company ?>
	<tr id="r_shipping_company">
		<td class="<?php echo $shipping_details_view->TableLeftColumnClass ?>"><span id="elh_shipping_details_shipping_company"><?php echo $shipping_details->shipping_company->caption() ?></span></td>
		<td data-name="shipping_company"<?php echo $shipping_details->shipping_company->cellAttributes() ?>>
<span id="el_shipping_details_shipping_company">
<span<?php echo $shipping_details->shipping_company->viewAttributes() ?>>
<?php echo $shipping_details->shipping_company->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_details->way_bill->Visible) { // way_bill ?>
	<tr id="r_way_bill">
		<td class="<?php echo $shipping_details_view->TableLeftColumnClass ?>"><span id="elh_shipping_details_way_bill"><?php echo $shipping_details->way_bill->caption() ?></span></td>
		<td data-name="way_bill"<?php echo $shipping_details->way_bill->cellAttributes() ?>>
<span id="el_shipping_details_way_bill">
<span<?php echo $shipping_details->way_bill->viewAttributes() ?>>
<?php echo $shipping_details->way_bill->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_details->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $shipping_details_view->TableLeftColumnClass ?>"><span id="elh_shipping_details_dated"><?php echo $shipping_details->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $shipping_details->dated->cellAttributes() ?>>
<span id="el_shipping_details_dated">
<span<?php echo $shipping_details->dated->viewAttributes() ?>>
<?php echo $shipping_details->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_details->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $shipping_details_view->TableLeftColumnClass ?>"><span id="elh_shipping_details_operator"><?php echo $shipping_details->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $shipping_details->operator->cellAttributes() ?>>
<span id="el_shipping_details_operator">
<span<?php echo $shipping_details->operator->viewAttributes() ?>>
<?php echo $shipping_details->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_details->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $shipping_details_view->TableLeftColumnClass ?>"><span id="elh_shipping_details_datetime"><?php echo $shipping_details->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $shipping_details->datetime->cellAttributes() ?>>
<span id="el_shipping_details_datetime">
<span<?php echo $shipping_details->datetime->viewAttributes() ?>>
<?php echo $shipping_details->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$shipping_details_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shipping_details->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shipping_details_view->terminate();
?>