<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_line_add = new shipping_line_add();

// Run the page
$shipping_line_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_line_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fshipping_lineadd = currentForm = new ew.Form("fshipping_lineadd", "add");

// Validate form
fshipping_lineadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($shipping_line_add->shipping_line->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_line");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_line->shipping_line->caption(), $shipping_line->shipping_line->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_line_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_line->code->caption(), $shipping_line->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($shipping_line->code->errorMessage()) ?>");
		<?php if ($shipping_line_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_line->status->caption(), $shipping_line->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_line_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_line->operator->caption(), $shipping_line->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_line_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_line->datetime->caption(), $shipping_line->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshipping_lineadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_lineadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_lineadd.lists["x_status"] = <?php echo $shipping_line_add->status->Lookup->toClientList() ?>;
fshipping_lineadd.lists["x_status"].options = <?php echo JsonEncode($shipping_line_add->status->options(FALSE, TRUE)) ?>;
fshipping_lineadd.lists["x_operator"] = <?php echo $shipping_line_add->operator->Lookup->toClientList() ?>;
fshipping_lineadd.lists["x_operator"].options = <?php echo JsonEncode($shipping_line_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shipping_line_add->showPageHeader(); ?>
<?php
$shipping_line_add->showMessage();
?>
<form name="fshipping_lineadd" id="fshipping_lineadd" class="<?php echo $shipping_line_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_line_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_line_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_line">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$shipping_line_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($shipping_line->shipping_line->Visible) { // shipping_line ?>
	<div id="r_shipping_line" class="form-group row">
		<label id="elh_shipping_line_shipping_line" for="x_shipping_line" class="<?php echo $shipping_line_add->LeftColumnClass ?>"><?php echo $shipping_line->shipping_line->caption() ?><?php echo ($shipping_line->shipping_line->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_line_add->RightColumnClass ?>"><div<?php echo $shipping_line->shipping_line->cellAttributes() ?>>
<span id="el_shipping_line_shipping_line">
<input type="text" data-table="shipping_line" data-field="x_shipping_line" name="x_shipping_line" id="x_shipping_line" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($shipping_line->shipping_line->getPlaceHolder()) ?>" value="<?php echo $shipping_line->shipping_line->EditValue ?>"<?php echo $shipping_line->shipping_line->editAttributes() ?>>
</span>
<?php echo $shipping_line->shipping_line->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_line->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_shipping_line_code" for="x_code" class="<?php echo $shipping_line_add->LeftColumnClass ?>"><?php echo $shipping_line->code->caption() ?><?php echo ($shipping_line->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_line_add->RightColumnClass ?>"><div<?php echo $shipping_line->code->cellAttributes() ?>>
<span id="el_shipping_line_code">
<input type="text" data-table="shipping_line" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($shipping_line->code->getPlaceHolder()) ?>" value="<?php echo $shipping_line->code->EditValue ?>"<?php echo $shipping_line->code->editAttributes() ?>>
</span>
<?php echo $shipping_line->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_line->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_shipping_line_status" for="x_status" class="<?php echo $shipping_line_add->LeftColumnClass ?>"><?php echo $shipping_line->status->caption() ?><?php echo ($shipping_line->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_line_add->RightColumnClass ?>"><div<?php echo $shipping_line->status->cellAttributes() ?>>
<span id="el_shipping_line_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shipping_line" data-field="x_status" data-value-separator="<?php echo $shipping_line->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $shipping_line->status->editAttributes() ?>>
		<?php echo $shipping_line->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $shipping_line->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shipping_line_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shipping_line_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shipping_line_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shipping_line_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shipping_line_add->terminate();
?>