<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_line_addopt = new shipping_line_addopt();

// Run the page
$shipping_line_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_line_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fshipping_lineaddopt = currentForm = new ew.Form("fshipping_lineaddopt", "addopt");

// Validate form
fshipping_lineaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($shipping_line_addopt->shipping_line->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_line");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_line->shipping_line->caption(), $shipping_line->shipping_line->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_line_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_line->code->caption(), $shipping_line->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($shipping_line->code->errorMessage()) ?>");
		<?php if ($shipping_line_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_line->status->caption(), $shipping_line->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_line_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_line->operator->caption(), $shipping_line->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_line_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_line->datetime->caption(), $shipping_line->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshipping_lineaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_lineaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_lineaddopt.lists["x_status"] = <?php echo $shipping_line_addopt->status->Lookup->toClientList() ?>;
fshipping_lineaddopt.lists["x_status"].options = <?php echo JsonEncode($shipping_line_addopt->status->options(FALSE, TRUE)) ?>;
fshipping_lineaddopt.lists["x_operator"] = <?php echo $shipping_line_addopt->operator->Lookup->toClientList() ?>;
fshipping_lineaddopt.lists["x_operator"].options = <?php echo JsonEncode($shipping_line_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shipping_line_addopt->showPageHeader(); ?>
<?php
$shipping_line_addopt->showMessage();
?>
<form name="fshipping_lineaddopt" id="fshipping_lineaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($shipping_line_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_line_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $shipping_line_addopt->TableVar ?>">
<?php if ($shipping_line->shipping_line->Visible) { // shipping_line ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_shipping_line"><?php echo $shipping_line->shipping_line->caption() ?><?php echo ($shipping_line->shipping_line->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="shipping_line" data-field="x_shipping_line" name="x_shipping_line" id="x_shipping_line" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($shipping_line->shipping_line->getPlaceHolder()) ?>" value="<?php echo $shipping_line->shipping_line->EditValue ?>"<?php echo $shipping_line->shipping_line->editAttributes() ?>>
<?php echo $shipping_line->shipping_line->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($shipping_line->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $shipping_line->code->caption() ?><?php echo ($shipping_line->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="shipping_line" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($shipping_line->code->getPlaceHolder()) ?>" value="<?php echo $shipping_line->code->EditValue ?>"<?php echo $shipping_line->code->editAttributes() ?>>
<?php echo $shipping_line->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($shipping_line->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $shipping_line->status->caption() ?><?php echo ($shipping_line->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shipping_line" data-field="x_status" data-value-separator="<?php echo $shipping_line->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $shipping_line->status->editAttributes() ?>>
		<?php echo $shipping_line->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $shipping_line->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($shipping_line->operator->Visible) { // operator ?>
	<input type="hidden" data-table="shipping_line" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($shipping_line->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($shipping_line->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="shipping_line" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($shipping_line->datetime->CurrentValue) ?>">
<?php } ?>
</form>
<?php
$shipping_line_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$shipping_line_addopt->terminate();
?>