<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_line_delete = new shipping_line_delete();

// Run the page
$shipping_line_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_line_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fshipping_linedelete = currentForm = new ew.Form("fshipping_linedelete", "delete");

// Form_CustomValidate event
fshipping_linedelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_linedelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_linedelete.lists["x_status"] = <?php echo $shipping_line_delete->status->Lookup->toClientList() ?>;
fshipping_linedelete.lists["x_status"].options = <?php echo JsonEncode($shipping_line_delete->status->options(FALSE, TRUE)) ?>;
fshipping_linedelete.lists["x_operator"] = <?php echo $shipping_line_delete->operator->Lookup->toClientList() ?>;
fshipping_linedelete.lists["x_operator"].options = <?php echo JsonEncode($shipping_line_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shipping_line_delete->showPageHeader(); ?>
<?php
$shipping_line_delete->showMessage();
?>
<form name="fshipping_linedelete" id="fshipping_linedelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_line_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_line_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_line">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($shipping_line_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($shipping_line->id->Visible) { // id ?>
		<th class="<?php echo $shipping_line->id->headerCellClass() ?>"><span id="elh_shipping_line_id" class="shipping_line_id"><?php echo $shipping_line->id->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_line->shipping_line->Visible) { // shipping_line ?>
		<th class="<?php echo $shipping_line->shipping_line->headerCellClass() ?>"><span id="elh_shipping_line_shipping_line" class="shipping_line_shipping_line"><?php echo $shipping_line->shipping_line->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_line->code->Visible) { // code ?>
		<th class="<?php echo $shipping_line->code->headerCellClass() ?>"><span id="elh_shipping_line_code" class="shipping_line_code"><?php echo $shipping_line->code->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_line->status->Visible) { // status ?>
		<th class="<?php echo $shipping_line->status->headerCellClass() ?>"><span id="elh_shipping_line_status" class="shipping_line_status"><?php echo $shipping_line->status->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_line->operator->Visible) { // operator ?>
		<th class="<?php echo $shipping_line->operator->headerCellClass() ?>"><span id="elh_shipping_line_operator" class="shipping_line_operator"><?php echo $shipping_line->operator->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_line->datetime->Visible) { // datetime ?>
		<th class="<?php echo $shipping_line->datetime->headerCellClass() ?>"><span id="elh_shipping_line_datetime" class="shipping_line_datetime"><?php echo $shipping_line->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$shipping_line_delete->RecCnt = 0;
$i = 0;
while (!$shipping_line_delete->Recordset->EOF) {
	$shipping_line_delete->RecCnt++;
	$shipping_line_delete->RowCnt++;

	// Set row properties
	$shipping_line->resetAttributes();
	$shipping_line->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$shipping_line_delete->loadRowValues($shipping_line_delete->Recordset);

	// Render row
	$shipping_line_delete->renderRow();
?>
	<tr<?php echo $shipping_line->rowAttributes() ?>>
<?php if ($shipping_line->id->Visible) { // id ?>
		<td<?php echo $shipping_line->id->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_delete->RowCnt ?>_shipping_line_id" class="shipping_line_id">
<span<?php echo $shipping_line->id->viewAttributes() ?>>
<?php echo $shipping_line->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_line->shipping_line->Visible) { // shipping_line ?>
		<td<?php echo $shipping_line->shipping_line->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_delete->RowCnt ?>_shipping_line_shipping_line" class="shipping_line_shipping_line">
<span<?php echo $shipping_line->shipping_line->viewAttributes() ?>>
<?php echo $shipping_line->shipping_line->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_line->code->Visible) { // code ?>
		<td<?php echo $shipping_line->code->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_delete->RowCnt ?>_shipping_line_code" class="shipping_line_code">
<span<?php echo $shipping_line->code->viewAttributes() ?>>
<?php echo $shipping_line->code->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_line->status->Visible) { // status ?>
		<td<?php echo $shipping_line->status->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_delete->RowCnt ?>_shipping_line_status" class="shipping_line_status">
<span<?php echo $shipping_line->status->viewAttributes() ?>>
<?php echo $shipping_line->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_line->operator->Visible) { // operator ?>
		<td<?php echo $shipping_line->operator->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_delete->RowCnt ?>_shipping_line_operator" class="shipping_line_operator">
<span<?php echo $shipping_line->operator->viewAttributes() ?>>
<?php echo $shipping_line->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_line->datetime->Visible) { // datetime ?>
		<td<?php echo $shipping_line->datetime->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_delete->RowCnt ?>_shipping_line_datetime" class="shipping_line_datetime">
<span<?php echo $shipping_line->datetime->viewAttributes() ?>>
<?php echo $shipping_line->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$shipping_line_delete->Recordset->moveNext();
}
$shipping_line_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shipping_line_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$shipping_line_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shipping_line_delete->terminate();
?>