<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_line_list = new shipping_line_list();

// Run the page
$shipping_line_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_line_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shipping_line->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fshipping_linelist = currentForm = new ew.Form("fshipping_linelist", "list");
fshipping_linelist.formKeyCountName = '<?php echo $shipping_line_list->FormKeyCountName ?>';

// Form_CustomValidate event
fshipping_linelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_linelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_linelist.lists["x_status"] = <?php echo $shipping_line_list->status->Lookup->toClientList() ?>;
fshipping_linelist.lists["x_status"].options = <?php echo JsonEncode($shipping_line_list->status->options(FALSE, TRUE)) ?>;
fshipping_linelist.lists["x_operator"] = <?php echo $shipping_line_list->operator->Lookup->toClientList() ?>;
fshipping_linelist.lists["x_operator"].options = <?php echo JsonEncode($shipping_line_list->operator->lookupOptions()) ?>;

// Form object for search
var fshipping_linelistsrch = currentSearchForm = new ew.Form("fshipping_linelistsrch");

// Filters
fshipping_linelistsrch.filterList = <?php echo $shipping_line_list->getFilterList() ?>;

// Init search panel as collapsed
fshipping_linelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shipping_line->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($shipping_line_list->TotalRecs > 0 && $shipping_line_list->ExportOptions->visible()) { ?>
<?php $shipping_line_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_line_list->ImportOptions->visible()) { ?>
<?php $shipping_line_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_line_list->SearchOptions->visible()) { ?>
<?php $shipping_line_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_line_list->FilterOptions->visible()) { ?>
<?php $shipping_line_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$shipping_line_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$shipping_line->isExport() && !$shipping_line->CurrentAction) { ?>
<form name="fshipping_linelistsrch" id="fshipping_linelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($shipping_line_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fshipping_linelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="shipping_line">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($shipping_line_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($shipping_line_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $shipping_line_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($shipping_line_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($shipping_line_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($shipping_line_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($shipping_line_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $shipping_line_list->showPageHeader(); ?>
<?php
$shipping_line_list->showMessage();
?>
<?php if ($shipping_line_list->TotalRecs > 0 || $shipping_line->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($shipping_line_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> shipping_line">
<?php if (!$shipping_line->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$shipping_line->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shipping_line_list->Pager)) $shipping_line_list->Pager = new PrevNextPager($shipping_line_list->StartRec, $shipping_line_list->DisplayRecs, $shipping_line_list->TotalRecs, $shipping_line_list->AutoHidePager) ?>
<?php if ($shipping_line_list->Pager->RecordCount > 0 && $shipping_line_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shipping_line_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shipping_line_list->pageUrl() ?>start=<?php echo $shipping_line_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shipping_line_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shipping_line_list->pageUrl() ?>start=<?php echo $shipping_line_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shipping_line_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shipping_line_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shipping_line_list->pageUrl() ?>start=<?php echo $shipping_line_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shipping_line_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shipping_line_list->pageUrl() ?>start=<?php echo $shipping_line_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shipping_line_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shipping_line_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shipping_line_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shipping_line_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shipping_line_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shipping_line_list->TotalRecs > 0 && (!$shipping_line_list->AutoHidePageSizeSelector || $shipping_line_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shipping_line">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shipping_line_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shipping_line_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shipping_line_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shipping_line_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shipping_line_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shipping_line->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shipping_line_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fshipping_linelist" id="fshipping_linelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_line_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_line_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_line">
<div id="gmp_shipping_line" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($shipping_line_list->TotalRecs > 0 || $shipping_line->isGridEdit()) { ?>
<table id="tbl_shipping_linelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$shipping_line_list->RowType = ROWTYPE_HEADER;

// Render list options
$shipping_line_list->renderListOptions();

// Render list options (header, left)
$shipping_line_list->ListOptions->render("header", "left");
?>
<?php if ($shipping_line->id->Visible) { // id ?>
	<?php if ($shipping_line->sortUrl($shipping_line->id) == "") { ?>
		<th data-name="id" class="<?php echo $shipping_line->id->headerCellClass() ?>"><div id="elh_shipping_line_id" class="shipping_line_id"><div class="ew-table-header-caption"><?php echo $shipping_line->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $shipping_line->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_line->SortUrl($shipping_line->id) ?>',2);"><div id="elh_shipping_line_id" class="shipping_line_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_line->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_line->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_line->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_line->shipping_line->Visible) { // shipping_line ?>
	<?php if ($shipping_line->sortUrl($shipping_line->shipping_line) == "") { ?>
		<th data-name="shipping_line" class="<?php echo $shipping_line->shipping_line->headerCellClass() ?>"><div id="elh_shipping_line_shipping_line" class="shipping_line_shipping_line"><div class="ew-table-header-caption"><?php echo $shipping_line->shipping_line->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_line" class="<?php echo $shipping_line->shipping_line->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_line->SortUrl($shipping_line->shipping_line) ?>',2);"><div id="elh_shipping_line_shipping_line" class="shipping_line_shipping_line">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_line->shipping_line->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_line->shipping_line->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_line->shipping_line->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_line->code->Visible) { // code ?>
	<?php if ($shipping_line->sortUrl($shipping_line->code) == "") { ?>
		<th data-name="code" class="<?php echo $shipping_line->code->headerCellClass() ?>"><div id="elh_shipping_line_code" class="shipping_line_code"><div class="ew-table-header-caption"><?php echo $shipping_line->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $shipping_line->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_line->SortUrl($shipping_line->code) ?>',2);"><div id="elh_shipping_line_code" class="shipping_line_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_line->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_line->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_line->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_line->status->Visible) { // status ?>
	<?php if ($shipping_line->sortUrl($shipping_line->status) == "") { ?>
		<th data-name="status" class="<?php echo $shipping_line->status->headerCellClass() ?>"><div id="elh_shipping_line_status" class="shipping_line_status"><div class="ew-table-header-caption"><?php echo $shipping_line->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $shipping_line->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_line->SortUrl($shipping_line->status) ?>',2);"><div id="elh_shipping_line_status" class="shipping_line_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_line->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_line->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_line->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_line->operator->Visible) { // operator ?>
	<?php if ($shipping_line->sortUrl($shipping_line->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $shipping_line->operator->headerCellClass() ?>"><div id="elh_shipping_line_operator" class="shipping_line_operator"><div class="ew-table-header-caption"><?php echo $shipping_line->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $shipping_line->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_line->SortUrl($shipping_line->operator) ?>',2);"><div id="elh_shipping_line_operator" class="shipping_line_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_line->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_line->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_line->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_line->datetime->Visible) { // datetime ?>
	<?php if ($shipping_line->sortUrl($shipping_line->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $shipping_line->datetime->headerCellClass() ?>"><div id="elh_shipping_line_datetime" class="shipping_line_datetime"><div class="ew-table-header-caption"><?php echo $shipping_line->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $shipping_line->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_line->SortUrl($shipping_line->datetime) ?>',2);"><div id="elh_shipping_line_datetime" class="shipping_line_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_line->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_line->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_line->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$shipping_line_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($shipping_line->ExportAll && $shipping_line->isExport()) {
	$shipping_line_list->StopRec = $shipping_line_list->TotalRecs;
} else {

	// Set the last record to display
	if ($shipping_line_list->TotalRecs > $shipping_line_list->StartRec + $shipping_line_list->DisplayRecs - 1)
		$shipping_line_list->StopRec = $shipping_line_list->StartRec + $shipping_line_list->DisplayRecs - 1;
	else
		$shipping_line_list->StopRec = $shipping_line_list->TotalRecs;
}
$shipping_line_list->RecCnt = $shipping_line_list->StartRec - 1;
if ($shipping_line_list->Recordset && !$shipping_line_list->Recordset->EOF) {
	$shipping_line_list->Recordset->moveFirst();
	$selectLimit = $shipping_line_list->UseSelectLimit;
	if (!$selectLimit && $shipping_line_list->StartRec > 1)
		$shipping_line_list->Recordset->move($shipping_line_list->StartRec - 1);
} elseif (!$shipping_line->AllowAddDeleteRow && $shipping_line_list->StopRec == 0) {
	$shipping_line_list->StopRec = $shipping_line->GridAddRowCount;
}

// Initialize aggregate
$shipping_line->RowType = ROWTYPE_AGGREGATEINIT;
$shipping_line->resetAttributes();
$shipping_line_list->renderRow();
while ($shipping_line_list->RecCnt < $shipping_line_list->StopRec) {
	$shipping_line_list->RecCnt++;
	if ($shipping_line_list->RecCnt >= $shipping_line_list->StartRec) {
		$shipping_line_list->RowCnt++;

		// Set up key count
		$shipping_line_list->KeyCount = $shipping_line_list->RowIndex;

		// Init row class and style
		$shipping_line->resetAttributes();
		$shipping_line->CssClass = "";
		if ($shipping_line->isGridAdd()) {
		} else {
			$shipping_line_list->loadRowValues($shipping_line_list->Recordset); // Load row values
		}
		$shipping_line->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$shipping_line->RowAttrs = array_merge($shipping_line->RowAttrs, array('data-rowindex'=>$shipping_line_list->RowCnt, 'id'=>'r' . $shipping_line_list->RowCnt . '_shipping_line', 'data-rowtype'=>$shipping_line->RowType));

		// Render row
		$shipping_line_list->renderRow();

		// Render list options
		$shipping_line_list->renderListOptions();
?>
	<tr<?php echo $shipping_line->rowAttributes() ?>>
<?php

// Render list options (body, left)
$shipping_line_list->ListOptions->render("body", "left", $shipping_line_list->RowCnt);
?>
	<?php if ($shipping_line->id->Visible) { // id ?>
		<td data-name="id"<?php echo $shipping_line->id->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_list->RowCnt ?>_shipping_line_id" class="shipping_line_id">
<span<?php echo $shipping_line->id->viewAttributes() ?>>
<?php echo $shipping_line->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_line->shipping_line->Visible) { // shipping_line ?>
		<td data-name="shipping_line"<?php echo $shipping_line->shipping_line->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_list->RowCnt ?>_shipping_line_shipping_line" class="shipping_line_shipping_line">
<span<?php echo $shipping_line->shipping_line->viewAttributes() ?>>
<?php echo $shipping_line->shipping_line->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_line->code->Visible) { // code ?>
		<td data-name="code"<?php echo $shipping_line->code->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_list->RowCnt ?>_shipping_line_code" class="shipping_line_code">
<span<?php echo $shipping_line->code->viewAttributes() ?>>
<?php echo $shipping_line->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_line->status->Visible) { // status ?>
		<td data-name="status"<?php echo $shipping_line->status->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_list->RowCnt ?>_shipping_line_status" class="shipping_line_status">
<span<?php echo $shipping_line->status->viewAttributes() ?>>
<?php echo $shipping_line->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_line->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $shipping_line->operator->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_list->RowCnt ?>_shipping_line_operator" class="shipping_line_operator">
<span<?php echo $shipping_line->operator->viewAttributes() ?>>
<?php echo $shipping_line->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_line->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $shipping_line->datetime->cellAttributes() ?>>
<span id="el<?php echo $shipping_line_list->RowCnt ?>_shipping_line_datetime" class="shipping_line_datetime">
<span<?php echo $shipping_line->datetime->viewAttributes() ?>>
<?php echo $shipping_line->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$shipping_line_list->ListOptions->render("body", "right", $shipping_line_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$shipping_line->isGridAdd())
		$shipping_line_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$shipping_line->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($shipping_line_list->Recordset)
	$shipping_line_list->Recordset->Close();
?>
<?php if (!$shipping_line->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$shipping_line->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shipping_line_list->Pager)) $shipping_line_list->Pager = new PrevNextPager($shipping_line_list->StartRec, $shipping_line_list->DisplayRecs, $shipping_line_list->TotalRecs, $shipping_line_list->AutoHidePager) ?>
<?php if ($shipping_line_list->Pager->RecordCount > 0 && $shipping_line_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shipping_line_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shipping_line_list->pageUrl() ?>start=<?php echo $shipping_line_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shipping_line_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shipping_line_list->pageUrl() ?>start=<?php echo $shipping_line_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shipping_line_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shipping_line_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shipping_line_list->pageUrl() ?>start=<?php echo $shipping_line_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shipping_line_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shipping_line_list->pageUrl() ?>start=<?php echo $shipping_line_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shipping_line_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shipping_line_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shipping_line_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shipping_line_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shipping_line_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shipping_line_list->TotalRecs > 0 && (!$shipping_line_list->AutoHidePageSizeSelector || $shipping_line_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shipping_line">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shipping_line_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shipping_line_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shipping_line_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shipping_line_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shipping_line_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shipping_line->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shipping_line_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($shipping_line_list->TotalRecs == 0 && !$shipping_line->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $shipping_line_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$shipping_line_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shipping_line->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$shipping_line->isExport()) { ?>
<script>
ew.scrollableTable("gmp_shipping_line", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shipping_line_list->terminate();
?>