<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_line_search = new shipping_line_search();

// Run the page
$shipping_line_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_line_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($shipping_line_search->IsModal) { ?>
var fshipping_linesearch = currentAdvancedSearchForm = new ew.Form("fshipping_linesearch", "search");
<?php } else { ?>
var fshipping_linesearch = currentForm = new ew.Form("fshipping_linesearch", "search");
<?php } ?>

// Form_CustomValidate event
fshipping_linesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_linesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_linesearch.lists["x_status"] = <?php echo $shipping_line_search->status->Lookup->toClientList() ?>;
fshipping_linesearch.lists["x_status"].options = <?php echo JsonEncode($shipping_line_search->status->options(FALSE, TRUE)) ?>;
fshipping_linesearch.lists["x_operator"] = <?php echo $shipping_line_search->operator->Lookup->toClientList() ?>;
fshipping_linesearch.lists["x_operator"].options = <?php echo JsonEncode($shipping_line_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fshipping_linesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($shipping_line->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
		return this.onError(elm, "<?php echo JsEncode($shipping_line->code->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($shipping_line->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shipping_line_search->showPageHeader(); ?>
<?php
$shipping_line_search->showMessage();
?>
<form name="fshipping_linesearch" id="fshipping_linesearch" class="<?php echo $shipping_line_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_line_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_line_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_line">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$shipping_line_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($shipping_line->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $shipping_line_search->LeftColumnClass ?>"><span id="elh_shipping_line_id"><?php echo $shipping_line->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $shipping_line_search->RightColumnClass ?>"><div<?php echo $shipping_line->id->cellAttributes() ?>>
			<span id="el_shipping_line_id">
<input type="text" data-table="shipping_line" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($shipping_line->id->getPlaceHolder()) ?>" value="<?php echo $shipping_line->id->EditValue ?>"<?php echo $shipping_line->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($shipping_line->shipping_line->Visible) { // shipping_line ?>
	<div id="r_shipping_line" class="form-group row">
		<label for="x_shipping_line" class="<?php echo $shipping_line_search->LeftColumnClass ?>"><span id="elh_shipping_line_shipping_line"><?php echo $shipping_line->shipping_line->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shipping_line" id="z_shipping_line" value="LIKE"></span>
		</label>
		<div class="<?php echo $shipping_line_search->RightColumnClass ?>"><div<?php echo $shipping_line->shipping_line->cellAttributes() ?>>
			<span id="el_shipping_line_shipping_line">
<input type="text" data-table="shipping_line" data-field="x_shipping_line" name="x_shipping_line" id="x_shipping_line" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($shipping_line->shipping_line->getPlaceHolder()) ?>" value="<?php echo $shipping_line->shipping_line->EditValue ?>"<?php echo $shipping_line->shipping_line->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($shipping_line->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $shipping_line_search->LeftColumnClass ?>"><span id="elh_shipping_line_code"><?php echo $shipping_line->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $shipping_line_search->RightColumnClass ?>"><div<?php echo $shipping_line->code->cellAttributes() ?>>
			<span id="el_shipping_line_code">
<input type="text" data-table="shipping_line" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($shipping_line->code->getPlaceHolder()) ?>" value="<?php echo $shipping_line->code->EditValue ?>"<?php echo $shipping_line->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($shipping_line->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $shipping_line_search->LeftColumnClass ?>"><span id="elh_shipping_line_status"><?php echo $shipping_line->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $shipping_line_search->RightColumnClass ?>"><div<?php echo $shipping_line->status->cellAttributes() ?>>
			<span id="el_shipping_line_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shipping_line" data-field="x_status" data-value-separator="<?php echo $shipping_line->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $shipping_line->status->editAttributes() ?>>
		<?php echo $shipping_line->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($shipping_line->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $shipping_line_search->LeftColumnClass ?>"><span id="elh_shipping_line_operator"><?php echo $shipping_line->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $shipping_line_search->RightColumnClass ?>"><div<?php echo $shipping_line->operator->cellAttributes() ?>>
			<span id="el_shipping_line_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shipping_line" data-field="x_operator" data-value-separator="<?php echo $shipping_line->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $shipping_line->operator->editAttributes() ?>>
		<?php echo $shipping_line->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $shipping_line->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($shipping_line->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $shipping_line_search->LeftColumnClass ?>"><span id="elh_shipping_line_datetime"><?php echo $shipping_line->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $shipping_line_search->RightColumnClass ?>"><div<?php echo $shipping_line->datetime->cellAttributes() ?>>
			<span id="el_shipping_line_datetime">
<input type="text" data-table="shipping_line" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($shipping_line->datetime->getPlaceHolder()) ?>" value="<?php echo $shipping_line->datetime->EditValue ?>"<?php echo $shipping_line->datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shipping_line_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shipping_line_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shipping_line_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shipping_line_search->terminate();
?>