<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_line_view = new shipping_line_view();

// Run the page
$shipping_line_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_line_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shipping_line->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fshipping_lineview = currentForm = new ew.Form("fshipping_lineview", "view");

// Form_CustomValidate event
fshipping_lineview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_lineview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_lineview.lists["x_status"] = <?php echo $shipping_line_view->status->Lookup->toClientList() ?>;
fshipping_lineview.lists["x_status"].options = <?php echo JsonEncode($shipping_line_view->status->options(FALSE, TRUE)) ?>;
fshipping_lineview.lists["x_operator"] = <?php echo $shipping_line_view->operator->Lookup->toClientList() ?>;
fshipping_lineview.lists["x_operator"].options = <?php echo JsonEncode($shipping_line_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shipping_line->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $shipping_line_view->ExportOptions->render("body") ?>
<?php $shipping_line_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $shipping_line_view->showPageHeader(); ?>
<?php
$shipping_line_view->showMessage();
?>
<form name="fshipping_lineview" id="fshipping_lineview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_line_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_line_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_line">
<input type="hidden" name="modal" value="<?php echo (int)$shipping_line_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($shipping_line->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $shipping_line_view->TableLeftColumnClass ?>"><span id="elh_shipping_line_id"><?php echo $shipping_line->id->caption() ?></span></td>
		<td data-name="id"<?php echo $shipping_line->id->cellAttributes() ?>>
<span id="el_shipping_line_id">
<span<?php echo $shipping_line->id->viewAttributes() ?>>
<?php echo $shipping_line->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_line->shipping_line->Visible) { // shipping_line ?>
	<tr id="r_shipping_line">
		<td class="<?php echo $shipping_line_view->TableLeftColumnClass ?>"><span id="elh_shipping_line_shipping_line"><?php echo $shipping_line->shipping_line->caption() ?></span></td>
		<td data-name="shipping_line"<?php echo $shipping_line->shipping_line->cellAttributes() ?>>
<span id="el_shipping_line_shipping_line">
<span<?php echo $shipping_line->shipping_line->viewAttributes() ?>>
<?php echo $shipping_line->shipping_line->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_line->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $shipping_line_view->TableLeftColumnClass ?>"><span id="elh_shipping_line_code"><?php echo $shipping_line->code->caption() ?></span></td>
		<td data-name="code"<?php echo $shipping_line->code->cellAttributes() ?>>
<span id="el_shipping_line_code">
<span<?php echo $shipping_line->code->viewAttributes() ?>>
<?php echo $shipping_line->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_line->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $shipping_line_view->TableLeftColumnClass ?>"><span id="elh_shipping_line_status"><?php echo $shipping_line->status->caption() ?></span></td>
		<td data-name="status"<?php echo $shipping_line->status->cellAttributes() ?>>
<span id="el_shipping_line_status">
<span<?php echo $shipping_line->status->viewAttributes() ?>>
<?php echo $shipping_line->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_line->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $shipping_line_view->TableLeftColumnClass ?>"><span id="elh_shipping_line_operator"><?php echo $shipping_line->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $shipping_line->operator->cellAttributes() ?>>
<span id="el_shipping_line_operator">
<span<?php echo $shipping_line->operator->viewAttributes() ?>>
<?php echo $shipping_line->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_line->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $shipping_line_view->TableLeftColumnClass ?>"><span id="elh_shipping_line_datetime"><?php echo $shipping_line->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $shipping_line->datetime->cellAttributes() ?>>
<span id="el_shipping_line_datetime">
<span<?php echo $shipping_line->datetime->viewAttributes() ?>>
<?php echo $shipping_line->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$shipping_line_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shipping_line->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shipping_line_view->terminate();
?>