<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_type_edit = new shipping_type_edit();

// Run the page
$shipping_type_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_type_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fshipping_typeedit = currentForm = new ew.Form("fshipping_typeedit", "edit");

// Validate form
fshipping_typeedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($shipping_type_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_type->id->caption(), $shipping_type->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_type_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_type->description->caption(), $shipping_type->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_type_edit->min->Required) { ?>
			elm = this.getElements("x" + infix + "_min");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_type->min->caption(), $shipping_type->min->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_min");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($shipping_type->min->errorMessage()) ?>");
		<?php if ($shipping_type_edit->per_pkt->Required) { ?>
			elm = this.getElements("x" + infix + "_per_pkt");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_type->per_pkt->caption(), $shipping_type->per_pkt->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_per_pkt");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($shipping_type->per_pkt->errorMessage()) ?>");
		<?php if ($shipping_type_edit->additional_charges->Required) { ?>
			elm = this.getElements("x" + infix + "_additional_charges");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_type->additional_charges->caption(), $shipping_type->additional_charges->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_additional_charges");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($shipping_type->additional_charges->errorMessage()) ?>");
		<?php if ($shipping_type_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_type->operator->caption(), $shipping_type->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($shipping_type->operator->errorMessage()) ?>");
		<?php if ($shipping_type_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_type->datetime->caption(), $shipping_type->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($shipping_type->datetime->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshipping_typeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_typeedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shipping_type_edit->showPageHeader(); ?>
<?php
$shipping_type_edit->showMessage();
?>
<form name="fshipping_typeedit" id="fshipping_typeedit" class="<?php echo $shipping_type_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_type_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_type_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_type">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$shipping_type_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($shipping_type->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_shipping_type_id" class="<?php echo $shipping_type_edit->LeftColumnClass ?>"><?php echo $shipping_type->id->caption() ?><?php echo ($shipping_type->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_type_edit->RightColumnClass ?>"><div<?php echo $shipping_type->id->cellAttributes() ?>>
<span id="el_shipping_type_id">
<span<?php echo $shipping_type->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shipping_type->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="shipping_type" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($shipping_type->id->CurrentValue) ?>">
<?php echo $shipping_type->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_type->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_shipping_type_description" for="x_description" class="<?php echo $shipping_type_edit->LeftColumnClass ?>"><?php echo $shipping_type->description->caption() ?><?php echo ($shipping_type->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_type_edit->RightColumnClass ?>"><div<?php echo $shipping_type->description->cellAttributes() ?>>
<span id="el_shipping_type_description">
<input type="text" data-table="shipping_type" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($shipping_type->description->getPlaceHolder()) ?>" value="<?php echo $shipping_type->description->EditValue ?>"<?php echo $shipping_type->description->editAttributes() ?>>
</span>
<?php echo $shipping_type->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_type->min->Visible) { // min ?>
	<div id="r_min" class="form-group row">
		<label id="elh_shipping_type_min" for="x_min" class="<?php echo $shipping_type_edit->LeftColumnClass ?>"><?php echo $shipping_type->min->caption() ?><?php echo ($shipping_type->min->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_type_edit->RightColumnClass ?>"><div<?php echo $shipping_type->min->cellAttributes() ?>>
<span id="el_shipping_type_min">
<input type="text" data-table="shipping_type" data-field="x_min" name="x_min" id="x_min" size="30" placeholder="<?php echo HtmlEncode($shipping_type->min->getPlaceHolder()) ?>" value="<?php echo $shipping_type->min->EditValue ?>"<?php echo $shipping_type->min->editAttributes() ?>>
</span>
<?php echo $shipping_type->min->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_type->per_pkt->Visible) { // per_pkt ?>
	<div id="r_per_pkt" class="form-group row">
		<label id="elh_shipping_type_per_pkt" for="x_per_pkt" class="<?php echo $shipping_type_edit->LeftColumnClass ?>"><?php echo $shipping_type->per_pkt->caption() ?><?php echo ($shipping_type->per_pkt->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_type_edit->RightColumnClass ?>"><div<?php echo $shipping_type->per_pkt->cellAttributes() ?>>
<span id="el_shipping_type_per_pkt">
<input type="text" data-table="shipping_type" data-field="x_per_pkt" name="x_per_pkt" id="x_per_pkt" size="30" placeholder="<?php echo HtmlEncode($shipping_type->per_pkt->getPlaceHolder()) ?>" value="<?php echo $shipping_type->per_pkt->EditValue ?>"<?php echo $shipping_type->per_pkt->editAttributes() ?>>
</span>
<?php echo $shipping_type->per_pkt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_type->additional_charges->Visible) { // additional_charges ?>
	<div id="r_additional_charges" class="form-group row">
		<label id="elh_shipping_type_additional_charges" for="x_additional_charges" class="<?php echo $shipping_type_edit->LeftColumnClass ?>"><?php echo $shipping_type->additional_charges->caption() ?><?php echo ($shipping_type->additional_charges->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_type_edit->RightColumnClass ?>"><div<?php echo $shipping_type->additional_charges->cellAttributes() ?>>
<span id="el_shipping_type_additional_charges">
<input type="text" data-table="shipping_type" data-field="x_additional_charges" name="x_additional_charges" id="x_additional_charges" size="30" placeholder="<?php echo HtmlEncode($shipping_type->additional_charges->getPlaceHolder()) ?>" value="<?php echo $shipping_type->additional_charges->EditValue ?>"<?php echo $shipping_type->additional_charges->editAttributes() ?>>
</span>
<?php echo $shipping_type->additional_charges->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_type->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_shipping_type_operator" for="x_operator" class="<?php echo $shipping_type_edit->LeftColumnClass ?>"><?php echo $shipping_type->operator->caption() ?><?php echo ($shipping_type->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_type_edit->RightColumnClass ?>"><div<?php echo $shipping_type->operator->cellAttributes() ?>>
<span id="el_shipping_type_operator">
<input type="text" data-table="shipping_type" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($shipping_type->operator->getPlaceHolder()) ?>" value="<?php echo $shipping_type->operator->EditValue ?>"<?php echo $shipping_type->operator->editAttributes() ?>>
</span>
<?php echo $shipping_type->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_type->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_shipping_type_datetime" for="x_datetime" class="<?php echo $shipping_type_edit->LeftColumnClass ?>"><?php echo $shipping_type->datetime->caption() ?><?php echo ($shipping_type->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_type_edit->RightColumnClass ?>"><div<?php echo $shipping_type->datetime->cellAttributes() ?>>
<span id="el_shipping_type_datetime">
<input type="text" data-table="shipping_type" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($shipping_type->datetime->getPlaceHolder()) ?>" value="<?php echo $shipping_type->datetime->EditValue ?>"<?php echo $shipping_type->datetime->editAttributes() ?>>
<?php if (!$shipping_type->datetime->ReadOnly && !$shipping_type->datetime->Disabled && !isset($shipping_type->datetime->EditAttrs["readonly"]) && !isset($shipping_type->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fshipping_typeedit", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $shipping_type->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shipping_type_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shipping_type_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shipping_type_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shipping_type_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shipping_type_edit->terminate();
?>