<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_type_list = new shipping_type_list();

// Run the page
$shipping_type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_type_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shipping_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fshipping_typelist = currentForm = new ew.Form("fshipping_typelist", "list");
fshipping_typelist.formKeyCountName = '<?php echo $shipping_type_list->FormKeyCountName ?>';

// Form_CustomValidate event
fshipping_typelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_typelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fshipping_typelistsrch = currentSearchForm = new ew.Form("fshipping_typelistsrch");

// Filters
fshipping_typelistsrch.filterList = <?php echo $shipping_type_list->getFilterList() ?>;

// Init search panel as collapsed
fshipping_typelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shipping_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($shipping_type_list->TotalRecs > 0 && $shipping_type_list->ExportOptions->visible()) { ?>
<?php $shipping_type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_type_list->ImportOptions->visible()) { ?>
<?php $shipping_type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_type_list->SearchOptions->visible()) { ?>
<?php $shipping_type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_type_list->FilterOptions->visible()) { ?>
<?php $shipping_type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$shipping_type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$shipping_type->isExport() && !$shipping_type->CurrentAction) { ?>
<form name="fshipping_typelistsrch" id="fshipping_typelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($shipping_type_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fshipping_typelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="shipping_type">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($shipping_type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($shipping_type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $shipping_type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($shipping_type_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($shipping_type_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($shipping_type_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($shipping_type_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $shipping_type_list->showPageHeader(); ?>
<?php
$shipping_type_list->showMessage();
?>
<?php if ($shipping_type_list->TotalRecs > 0 || $shipping_type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($shipping_type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> shipping_type">
<?php if (!$shipping_type->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$shipping_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shipping_type_list->Pager)) $shipping_type_list->Pager = new PrevNextPager($shipping_type_list->StartRec, $shipping_type_list->DisplayRecs, $shipping_type_list->TotalRecs, $shipping_type_list->AutoHidePager) ?>
<?php if ($shipping_type_list->Pager->RecordCount > 0 && $shipping_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shipping_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shipping_type_list->pageUrl() ?>start=<?php echo $shipping_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shipping_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shipping_type_list->pageUrl() ?>start=<?php echo $shipping_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shipping_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shipping_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shipping_type_list->pageUrl() ?>start=<?php echo $shipping_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shipping_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shipping_type_list->pageUrl() ?>start=<?php echo $shipping_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shipping_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shipping_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shipping_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shipping_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shipping_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shipping_type_list->TotalRecs > 0 && (!$shipping_type_list->AutoHidePageSizeSelector || $shipping_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shipping_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shipping_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shipping_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shipping_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shipping_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shipping_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shipping_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shipping_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fshipping_typelist" id="fshipping_typelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_type_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_type_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_type">
<div id="gmp_shipping_type" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($shipping_type_list->TotalRecs > 0 || $shipping_type->isGridEdit()) { ?>
<table id="tbl_shipping_typelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$shipping_type_list->RowType = ROWTYPE_HEADER;

// Render list options
$shipping_type_list->renderListOptions();

// Render list options (header, left)
$shipping_type_list->ListOptions->render("header", "left");
?>
<?php if ($shipping_type->id->Visible) { // id ?>
	<?php if ($shipping_type->sortUrl($shipping_type->id) == "") { ?>
		<th data-name="id" class="<?php echo $shipping_type->id->headerCellClass() ?>"><div id="elh_shipping_type_id" class="shipping_type_id"><div class="ew-table-header-caption"><?php echo $shipping_type->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $shipping_type->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_type->SortUrl($shipping_type->id) ?>',2);"><div id="elh_shipping_type_id" class="shipping_type_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_type->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_type->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_type->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_type->description->Visible) { // description ?>
	<?php if ($shipping_type->sortUrl($shipping_type->description) == "") { ?>
		<th data-name="description" class="<?php echo $shipping_type->description->headerCellClass() ?>"><div id="elh_shipping_type_description" class="shipping_type_description"><div class="ew-table-header-caption"><?php echo $shipping_type->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $shipping_type->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_type->SortUrl($shipping_type->description) ?>',2);"><div id="elh_shipping_type_description" class="shipping_type_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_type->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_type->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_type->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_type->min->Visible) { // min ?>
	<?php if ($shipping_type->sortUrl($shipping_type->min) == "") { ?>
		<th data-name="min" class="<?php echo $shipping_type->min->headerCellClass() ?>"><div id="elh_shipping_type_min" class="shipping_type_min"><div class="ew-table-header-caption"><?php echo $shipping_type->min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="min" class="<?php echo $shipping_type->min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_type->SortUrl($shipping_type->min) ?>',2);"><div id="elh_shipping_type_min" class="shipping_type_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_type->min->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_type->min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_type->min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_type->per_pkt->Visible) { // per_pkt ?>
	<?php if ($shipping_type->sortUrl($shipping_type->per_pkt) == "") { ?>
		<th data-name="per_pkt" class="<?php echo $shipping_type->per_pkt->headerCellClass() ?>"><div id="elh_shipping_type_per_pkt" class="shipping_type_per_pkt"><div class="ew-table-header-caption"><?php echo $shipping_type->per_pkt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="per_pkt" class="<?php echo $shipping_type->per_pkt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_type->SortUrl($shipping_type->per_pkt) ?>',2);"><div id="elh_shipping_type_per_pkt" class="shipping_type_per_pkt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_type->per_pkt->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_type->per_pkt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_type->per_pkt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_type->additional_charges->Visible) { // additional_charges ?>
	<?php if ($shipping_type->sortUrl($shipping_type->additional_charges) == "") { ?>
		<th data-name="additional_charges" class="<?php echo $shipping_type->additional_charges->headerCellClass() ?>"><div id="elh_shipping_type_additional_charges" class="shipping_type_additional_charges"><div class="ew-table-header-caption"><?php echo $shipping_type->additional_charges->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="additional_charges" class="<?php echo $shipping_type->additional_charges->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_type->SortUrl($shipping_type->additional_charges) ?>',2);"><div id="elh_shipping_type_additional_charges" class="shipping_type_additional_charges">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_type->additional_charges->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_type->additional_charges->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_type->additional_charges->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_type->operator->Visible) { // operator ?>
	<?php if ($shipping_type->sortUrl($shipping_type->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $shipping_type->operator->headerCellClass() ?>"><div id="elh_shipping_type_operator" class="shipping_type_operator"><div class="ew-table-header-caption"><?php echo $shipping_type->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $shipping_type->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_type->SortUrl($shipping_type->operator) ?>',2);"><div id="elh_shipping_type_operator" class="shipping_type_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_type->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_type->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_type->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_type->datetime->Visible) { // datetime ?>
	<?php if ($shipping_type->sortUrl($shipping_type->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $shipping_type->datetime->headerCellClass() ?>"><div id="elh_shipping_type_datetime" class="shipping_type_datetime"><div class="ew-table-header-caption"><?php echo $shipping_type->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $shipping_type->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_type->SortUrl($shipping_type->datetime) ?>',2);"><div id="elh_shipping_type_datetime" class="shipping_type_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_type->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_type->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_type->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$shipping_type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($shipping_type->ExportAll && $shipping_type->isExport()) {
	$shipping_type_list->StopRec = $shipping_type_list->TotalRecs;
} else {

	// Set the last record to display
	if ($shipping_type_list->TotalRecs > $shipping_type_list->StartRec + $shipping_type_list->DisplayRecs - 1)
		$shipping_type_list->StopRec = $shipping_type_list->StartRec + $shipping_type_list->DisplayRecs - 1;
	else
		$shipping_type_list->StopRec = $shipping_type_list->TotalRecs;
}
$shipping_type_list->RecCnt = $shipping_type_list->StartRec - 1;
if ($shipping_type_list->Recordset && !$shipping_type_list->Recordset->EOF) {
	$shipping_type_list->Recordset->moveFirst();
	$selectLimit = $shipping_type_list->UseSelectLimit;
	if (!$selectLimit && $shipping_type_list->StartRec > 1)
		$shipping_type_list->Recordset->move($shipping_type_list->StartRec - 1);
} elseif (!$shipping_type->AllowAddDeleteRow && $shipping_type_list->StopRec == 0) {
	$shipping_type_list->StopRec = $shipping_type->GridAddRowCount;
}

// Initialize aggregate
$shipping_type->RowType = ROWTYPE_AGGREGATEINIT;
$shipping_type->resetAttributes();
$shipping_type_list->renderRow();
while ($shipping_type_list->RecCnt < $shipping_type_list->StopRec) {
	$shipping_type_list->RecCnt++;
	if ($shipping_type_list->RecCnt >= $shipping_type_list->StartRec) {
		$shipping_type_list->RowCnt++;

		// Set up key count
		$shipping_type_list->KeyCount = $shipping_type_list->RowIndex;

		// Init row class and style
		$shipping_type->resetAttributes();
		$shipping_type->CssClass = "";
		if ($shipping_type->isGridAdd()) {
		} else {
			$shipping_type_list->loadRowValues($shipping_type_list->Recordset); // Load row values
		}
		$shipping_type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$shipping_type->RowAttrs = array_merge($shipping_type->RowAttrs, array('data-rowindex'=>$shipping_type_list->RowCnt, 'id'=>'r' . $shipping_type_list->RowCnt . '_shipping_type', 'data-rowtype'=>$shipping_type->RowType));

		// Render row
		$shipping_type_list->renderRow();

		// Render list options
		$shipping_type_list->renderListOptions();
?>
	<tr<?php echo $shipping_type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$shipping_type_list->ListOptions->render("body", "left", $shipping_type_list->RowCnt);
?>
	<?php if ($shipping_type->id->Visible) { // id ?>
		<td data-name="id"<?php echo $shipping_type->id->cellAttributes() ?>>
<span id="el<?php echo $shipping_type_list->RowCnt ?>_shipping_type_id" class="shipping_type_id">
<span<?php echo $shipping_type->id->viewAttributes() ?>>
<?php echo $shipping_type->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_type->description->Visible) { // description ?>
		<td data-name="description"<?php echo $shipping_type->description->cellAttributes() ?>>
<span id="el<?php echo $shipping_type_list->RowCnt ?>_shipping_type_description" class="shipping_type_description">
<span<?php echo $shipping_type->description->viewAttributes() ?>>
<?php echo $shipping_type->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_type->min->Visible) { // min ?>
		<td data-name="min"<?php echo $shipping_type->min->cellAttributes() ?>>
<span id="el<?php echo $shipping_type_list->RowCnt ?>_shipping_type_min" class="shipping_type_min">
<span<?php echo $shipping_type->min->viewAttributes() ?>>
<?php echo $shipping_type->min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_type->per_pkt->Visible) { // per_pkt ?>
		<td data-name="per_pkt"<?php echo $shipping_type->per_pkt->cellAttributes() ?>>
<span id="el<?php echo $shipping_type_list->RowCnt ?>_shipping_type_per_pkt" class="shipping_type_per_pkt">
<span<?php echo $shipping_type->per_pkt->viewAttributes() ?>>
<?php echo $shipping_type->per_pkt->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_type->additional_charges->Visible) { // additional_charges ?>
		<td data-name="additional_charges"<?php echo $shipping_type->additional_charges->cellAttributes() ?>>
<span id="el<?php echo $shipping_type_list->RowCnt ?>_shipping_type_additional_charges" class="shipping_type_additional_charges">
<span<?php echo $shipping_type->additional_charges->viewAttributes() ?>>
<?php echo $shipping_type->additional_charges->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_type->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $shipping_type->operator->cellAttributes() ?>>
<span id="el<?php echo $shipping_type_list->RowCnt ?>_shipping_type_operator" class="shipping_type_operator">
<span<?php echo $shipping_type->operator->viewAttributes() ?>>
<?php echo $shipping_type->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_type->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $shipping_type->datetime->cellAttributes() ?>>
<span id="el<?php echo $shipping_type_list->RowCnt ?>_shipping_type_datetime" class="shipping_type_datetime">
<span<?php echo $shipping_type->datetime->viewAttributes() ?>>
<?php echo $shipping_type->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$shipping_type_list->ListOptions->render("body", "right", $shipping_type_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$shipping_type->isGridAdd())
		$shipping_type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$shipping_type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($shipping_type_list->Recordset)
	$shipping_type_list->Recordset->Close();
?>
<?php if (!$shipping_type->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$shipping_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shipping_type_list->Pager)) $shipping_type_list->Pager = new PrevNextPager($shipping_type_list->StartRec, $shipping_type_list->DisplayRecs, $shipping_type_list->TotalRecs, $shipping_type_list->AutoHidePager) ?>
<?php if ($shipping_type_list->Pager->RecordCount > 0 && $shipping_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shipping_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shipping_type_list->pageUrl() ?>start=<?php echo $shipping_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shipping_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shipping_type_list->pageUrl() ?>start=<?php echo $shipping_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shipping_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shipping_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shipping_type_list->pageUrl() ?>start=<?php echo $shipping_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shipping_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shipping_type_list->pageUrl() ?>start=<?php echo $shipping_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shipping_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shipping_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shipping_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shipping_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shipping_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shipping_type_list->TotalRecs > 0 && (!$shipping_type_list->AutoHidePageSizeSelector || $shipping_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shipping_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shipping_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shipping_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shipping_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shipping_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shipping_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shipping_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shipping_type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($shipping_type_list->TotalRecs == 0 && !$shipping_type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $shipping_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$shipping_type_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shipping_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$shipping_type->isExport()) { ?>
<script>
ew.scrollableTable("gmp_shipping_type", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shipping_type_list->terminate();
?>