<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shop_edit = new shop_edit();

// Run the page
$shop_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shop_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fshopedit = currentForm = new ew.Form("fshopedit", "edit");

// Validate form
fshopedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($shop_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->id->caption(), $shop->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->short_description->Required) { ?>
			elm = this.getElements("x" + infix + "_short_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->short_description->caption(), $shop->short_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->includes->Required) { ?>
			elm = this.getElements("x" + infix + "_includes[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->includes->caption(), $shop->includes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->description->caption(), $shop->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->price->caption(), $shop->price->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->discount_coupon->Required) { ?>
			elm = this.getElements("x" + infix + "_discount_coupon");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->discount_coupon->caption(), $shop->discount_coupon->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->discount->Required) { ?>
			elm = this.getElements("x" + infix + "_discount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->discount->caption(), $shop->discount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->amount->caption(), $shop->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->valid_till->Required) { ?>
			elm = this.getElements("x" + infix + "_valid_till");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->valid_till->caption(), $shop->valid_till->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_valid_till");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($shop->valid_till->errorMessage()) ?>");
		<?php if ($shop_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->status->caption(), $shop->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->_response->Required) { ?>
			elm = this.getElements("x" + infix + "__response");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->_response->caption(), $shop->_response->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->admin_notes->Required) { ?>
			elm = this.getElements("x" + infix + "_admin_notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->admin_notes->caption(), $shop->admin_notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->operator->caption(), $shop->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shop_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shop->datetime->caption(), $shop->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshopedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshopedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshopedit.lists["x_short_description"] = <?php echo $shop_edit->short_description->Lookup->toClientList() ?>;
fshopedit.lists["x_short_description"].options = <?php echo JsonEncode($shop_edit->short_description->lookupOptions()) ?>;
fshopedit.lists["x_includes[]"] = <?php echo $shop_edit->includes->Lookup->toClientList() ?>;
fshopedit.lists["x_includes[]"].options = <?php echo JsonEncode($shop_edit->includes->lookupOptions()) ?>;
fshopedit.lists["x_status"] = <?php echo $shop_edit->status->Lookup->toClientList() ?>;
fshopedit.lists["x_status"].options = <?php echo JsonEncode($shop_edit->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shop_edit->showPageHeader(); ?>
<?php
$shop_edit->showMessage();
?>
<form name="fshopedit" id="fshopedit" class="<?php echo $shop_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shop_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shop_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shop">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$shop_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($shop->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_shop_id" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->id->caption() ?><?php echo ($shop->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->id->cellAttributes() ?>>
<span id="el_shop_id">
<span<?php echo $shop->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shop->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="shop" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($shop->id->CurrentValue) ?>">
<?php echo $shop->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->short_description->Visible) { // short_description ?>
	<div id="r_short_description" class="form-group row">
		<label id="elh_shop_short_description" for="x_short_description" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->short_description->caption() ?><?php echo ($shop->short_description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->short_description->cellAttributes() ?>>
<span id="el_shop_short_description">
<span<?php echo $shop->short_description->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shop->short_description->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="shop" data-field="x_short_description" name="x_short_description" id="x_short_description" value="<?php echo HtmlEncode($shop->short_description->CurrentValue) ?>">
<?php echo $shop->short_description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->includes->Visible) { // includes ?>
	<div id="r_includes" class="form-group row">
		<label id="elh_shop_includes" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->includes->caption() ?><?php echo ($shop->includes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->includes->cellAttributes() ?>>
<span id="el_shop_includes">
<span<?php echo $shop->includes->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shop->includes->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="shop" data-field="x_includes" name="x_includes" id="x_includes" value="<?php echo HtmlEncode($shop->includes->CurrentValue) ?>">
<?php echo $shop->includes->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_shop_description" for="x_description" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->description->caption() ?><?php echo ($shop->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->description->cellAttributes() ?>>
<span id="el_shop_description">
<span<?php echo $shop->description->viewAttributes() ?>>
<?php echo $shop->description->EditValue ?></span>
</span>
<input type="hidden" data-table="shop" data-field="x_description" name="x_description" id="x_description" value="<?php echo HtmlEncode($shop->description->CurrentValue) ?>">
<?php echo $shop->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_shop_price" for="x_price" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->price->caption() ?><?php echo ($shop->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->price->cellAttributes() ?>>
<span id="el_shop_price">
<span<?php echo $shop->price->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shop->price->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="shop" data-field="x_price" name="x_price" id="x_price" value="<?php echo HtmlEncode($shop->price->CurrentValue) ?>">
<?php echo $shop->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->discount_coupon->Visible) { // discount_coupon ?>
	<div id="r_discount_coupon" class="form-group row">
		<label id="elh_shop_discount_coupon" for="x_discount_coupon" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->discount_coupon->caption() ?><?php echo ($shop->discount_coupon->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->discount_coupon->cellAttributes() ?>>
<span id="el_shop_discount_coupon">
<input type="text" data-table="shop" data-field="x_discount_coupon" name="x_discount_coupon" id="x_discount_coupon" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($shop->discount_coupon->getPlaceHolder()) ?>" value="<?php echo $shop->discount_coupon->EditValue ?>"<?php echo $shop->discount_coupon->editAttributes() ?>>
</span>
<?php echo $shop->discount_coupon->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->discount->Visible) { // discount ?>
	<div id="r_discount" class="form-group row">
		<label id="elh_shop_discount" for="x_discount" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->discount->caption() ?><?php echo ($shop->discount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->discount->cellAttributes() ?>>
<span id="el_shop_discount">
<span<?php echo $shop->discount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shop->discount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="shop" data-field="x_discount" name="x_discount" id="x_discount" value="<?php echo HtmlEncode($shop->discount->CurrentValue) ?>">
<?php echo $shop->discount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_shop_amount" for="x_amount" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->amount->caption() ?><?php echo ($shop->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->amount->cellAttributes() ?>>
<span id="el_shop_amount">
<span<?php echo $shop->amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shop->amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="shop" data-field="x_amount" name="x_amount" id="x_amount" value="<?php echo HtmlEncode($shop->amount->CurrentValue) ?>">
<?php echo $shop->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->valid_till->Visible) { // valid_till ?>
	<div id="r_valid_till" class="form-group row">
		<label id="elh_shop_valid_till" for="x_valid_till" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->valid_till->caption() ?><?php echo ($shop->valid_till->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->valid_till->cellAttributes() ?>>
<span id="el_shop_valid_till">
<input type="text" data-table="shop" data-field="x_valid_till" name="x_valid_till" id="x_valid_till" placeholder="<?php echo HtmlEncode($shop->valid_till->getPlaceHolder()) ?>" value="<?php echo $shop->valid_till->EditValue ?>"<?php echo $shop->valid_till->editAttributes() ?>>
<?php if (!$shop->valid_till->ReadOnly && !$shop->valid_till->Disabled && !isset($shop->valid_till->EditAttrs["readonly"]) && !isset($shop->valid_till->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fshopedit", "x_valid_till", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $shop->valid_till->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_shop_status" for="x_status" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->status->caption() ?><?php echo ($shop->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->status->cellAttributes() ?>>
<span id="el_shop_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shop" data-field="x_status" data-value-separator="<?php echo $shop->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $shop->status->editAttributes() ?>>
		<?php echo $shop->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $shop->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->_response->Visible) { // response ?>
	<div id="r__response" class="form-group row">
		<label id="elh_shop__response" for="x__response" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->_response->caption() ?><?php echo ($shop->_response->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->_response->cellAttributes() ?>>
<span id="el_shop__response">
<textarea data-table="shop" data-field="x__response" name="x__response" id="x__response" cols="30" rows="3" placeholder="<?php echo HtmlEncode($shop->_response->getPlaceHolder()) ?>"<?php echo $shop->_response->editAttributes() ?>><?php echo $shop->_response->EditValue ?></textarea>
</span>
<?php echo $shop->_response->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shop->admin_notes->Visible) { // admin_notes ?>
	<div id="r_admin_notes" class="form-group row">
		<label id="elh_shop_admin_notes" for="x_admin_notes" class="<?php echo $shop_edit->LeftColumnClass ?>"><?php echo $shop->admin_notes->caption() ?><?php echo ($shop->admin_notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shop_edit->RightColumnClass ?>"><div<?php echo $shop->admin_notes->cellAttributes() ?>>
<span id="el_shop_admin_notes">
<textarea data-table="shop" data-field="x_admin_notes" name="x_admin_notes" id="x_admin_notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($shop->admin_notes->getPlaceHolder()) ?>"<?php echo $shop->admin_notes->editAttributes() ?>><?php echo $shop->admin_notes->EditValue ?></textarea>
</span>
<?php echo $shop->admin_notes->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shop_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shop_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shop_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shop_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shop_edit->terminate();
?>