<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shop_list = new shop_list();

// Run the page
$shop_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shop_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shop->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fshoplist = currentForm = new ew.Form("fshoplist", "list");
fshoplist.formKeyCountName = '<?php echo $shop_list->FormKeyCountName ?>';

// Form_CustomValidate event
fshoplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshoplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fshoplistsrch = currentSearchForm = new ew.Form("fshoplistsrch");

// Validate function for search
fshoplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($shop->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fshoplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshoplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fshoplistsrch.filterList = <?php echo $shop_list->getFilterList() ?>;

// Init search panel as collapsed
fshoplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
$(document).ready(function(){
$(".ew-ext-search-form").hide();
$(".btn-toolbar").hide();
});
var search = function(){
	var ID = $("#x_short_description").val();
	if (ID > 0)
	{
  		location.href='shoplist.php?x_id='+ID;
  	}
  	else
	{
  		location.href='shoplist.php?cmd=reset';
  	}
}	
</script>
<?php } ?>
<?php if (!$shop->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($shop_list->TotalRecs > 0 && $shop_list->ExportOptions->visible()) { ?>
<?php $shop_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($shop_list->ImportOptions->visible()) { ?>
<?php $shop_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($shop_list->SearchOptions->visible()) { ?>
<?php $shop_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($shop_list->FilterOptions->visible()) { ?>
<?php $shop_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$shop_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$shop->isExport() && !$shop->CurrentAction) { ?>
<form name="fshoplistsrch" id="fshoplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($shop_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fshoplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="shop">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$shop_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$shop->RowType = ROWTYPE_SEARCH;

// Render row
$shop->resetAttributes();
$shop_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($shop->id->Visible) { // id ?>
	<div id="xsc_id" class="ew-cell form-group">
		<label for="x_id" class="ew-search-caption ew-label"><?php echo $shop->id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="shop" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($shop->id->getPlaceHolder()) ?>" value="<?php echo $shop->id->EditValue ?>"<?php echo $shop->id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $shop_list->showPageHeader(); ?>
<?php
$shop_list->showMessage();
?>
<?php if ($shop_list->TotalRecs > 0 || $shop->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($shop_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> shop">
<?php if (!$shop->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$shop->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shop_list->Pager)) $shop_list->Pager = new PrevNextPager($shop_list->StartRec, $shop_list->DisplayRecs, $shop_list->TotalRecs, $shop_list->AutoHidePager) ?>
<?php if ($shop_list->Pager->RecordCount > 0 && $shop_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shop_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shop_list->pageUrl() ?>start=<?php echo $shop_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shop_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shop_list->pageUrl() ?>start=<?php echo $shop_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shop_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shop_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shop_list->pageUrl() ?>start=<?php echo $shop_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shop_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shop_list->pageUrl() ?>start=<?php echo $shop_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shop_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shop_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shop_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shop_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shop_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shop_list->TotalRecs > 0 && (!$shop_list->AutoHidePageSizeSelector || $shop_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shop">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shop_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shop_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shop_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shop_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shop_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shop->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shop_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fshoplist" id="fshoplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shop_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shop_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shop">
<div id="gmp_shop" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($shop_list->TotalRecs > 0 || $shop->isGridEdit()) { ?>
<table id="tbl_shoplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$shop_list->RowType = ROWTYPE_HEADER;

// Render list options
$shop_list->renderListOptions();

// Render list options (header, left)
$shop_list->ListOptions->render("header", "left");
?>
<?php if ($shop->id->Visible) { // id ?>
	<?php if ($shop->sortUrl($shop->id) == "") { ?>
		<th data-name="id" class="<?php echo $shop->id->headerCellClass() ?>"><div id="elh_shop_id" class="shop_id"><div class="ew-table-header-caption"><?php echo $shop->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $shop->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shop->SortUrl($shop->id) ?>',2);"><div id="elh_shop_id" class="shop_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shop->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($shop->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shop->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shop->description->Visible) { // description ?>
	<?php if ($shop->sortUrl($shop->description) == "") { ?>
		<th data-name="description" class="<?php echo $shop->description->headerCellClass() ?>"><div id="elh_shop_description" class="shop_description"><div class="ew-table-header-caption"><?php echo $shop->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $shop->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shop->SortUrl($shop->description) ?>',2);"><div id="elh_shop_description" class="shop_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shop->description->caption() ?></span><span class="ew-table-header-sort"><?php if ($shop->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shop->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$shop_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($shop->ExportAll && $shop->isExport()) {
	$shop_list->StopRec = $shop_list->TotalRecs;
} else {

	// Set the last record to display
	if ($shop_list->TotalRecs > $shop_list->StartRec + $shop_list->DisplayRecs - 1)
		$shop_list->StopRec = $shop_list->StartRec + $shop_list->DisplayRecs - 1;
	else
		$shop_list->StopRec = $shop_list->TotalRecs;
}
$shop_list->RecCnt = $shop_list->StartRec - 1;
if ($shop_list->Recordset && !$shop_list->Recordset->EOF) {
	$shop_list->Recordset->moveFirst();
	$selectLimit = $shop_list->UseSelectLimit;
	if (!$selectLimit && $shop_list->StartRec > 1)
		$shop_list->Recordset->move($shop_list->StartRec - 1);
} elseif (!$shop->AllowAddDeleteRow && $shop_list->StopRec == 0) {
	$shop_list->StopRec = $shop->GridAddRowCount;
}

// Initialize aggregate
$shop->RowType = ROWTYPE_AGGREGATEINIT;
$shop->resetAttributes();
$shop_list->renderRow();
while ($shop_list->RecCnt < $shop_list->StopRec) {
	$shop_list->RecCnt++;
	if ($shop_list->RecCnt >= $shop_list->StartRec) {
		$shop_list->RowCnt++;

		// Set up key count
		$shop_list->KeyCount = $shop_list->RowIndex;

		// Init row class and style
		$shop->resetAttributes();
		$shop->CssClass = "";
		if ($shop->isGridAdd()) {
		} else {
			$shop_list->loadRowValues($shop_list->Recordset); // Load row values
		}
		$shop->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$shop->RowAttrs = array_merge($shop->RowAttrs, array('data-rowindex'=>$shop_list->RowCnt, 'id'=>'r' . $shop_list->RowCnt . '_shop', 'data-rowtype'=>$shop->RowType));

		// Render row
		$shop_list->renderRow();

		// Render list options
		$shop_list->renderListOptions();
?>
	<tr<?php echo $shop->rowAttributes() ?>>
<?php

// Render list options (body, left)
$shop_list->ListOptions->render("body", "left", $shop_list->RowCnt);
?>
	<?php if ($shop->id->Visible) { // id ?>
		<td data-name="id"<?php echo $shop->id->cellAttributes() ?>>
<span id="el<?php echo $shop_list->RowCnt ?>_shop_id" class="shop_id">
<span<?php echo $shop->id->viewAttributes() ?>>
<?php echo $shop->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shop->description->Visible) { // description ?>
		<td data-name="description"<?php echo $shop->description->cellAttributes() ?>>
<span id="el<?php echo $shop_list->RowCnt ?>_shop_description" class="shop_description">
<span<?php echo $shop->description->viewAttributes() ?>>
<?php echo $shop->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$shop_list->ListOptions->render("body", "right", $shop_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$shop->isGridAdd())
		$shop_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$shop->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($shop_list->Recordset)
	$shop_list->Recordset->Close();
?>
<?php if (!$shop->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$shop->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shop_list->Pager)) $shop_list->Pager = new PrevNextPager($shop_list->StartRec, $shop_list->DisplayRecs, $shop_list->TotalRecs, $shop_list->AutoHidePager) ?>
<?php if ($shop_list->Pager->RecordCount > 0 && $shop_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shop_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shop_list->pageUrl() ?>start=<?php echo $shop_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shop_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shop_list->pageUrl() ?>start=<?php echo $shop_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shop_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shop_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shop_list->pageUrl() ?>start=<?php echo $shop_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shop_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shop_list->pageUrl() ?>start=<?php echo $shop_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shop_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shop_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shop_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shop_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shop_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shop_list->TotalRecs > 0 && (!$shop_list->AutoHidePageSizeSelector || $shop_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shop">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shop_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shop_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shop_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shop_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shop_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shop->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shop_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($shop_list->TotalRecs == 0 && !$shop->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $shop_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$shop_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shop->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$shop->isExport()) { ?>
<script>
ew.scrollableTable("gmp_shop", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shop_list->terminate();
?>