<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$site_search_delete = new site_search_delete();

// Run the page
$site_search_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$site_search_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fsite_searchdelete = currentForm = new ew.Form("fsite_searchdelete", "delete");

// Form_CustomValidate event
fsite_searchdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsite_searchdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsite_searchdelete.lists["x_status"] = <?php echo $site_search_delete->status->Lookup->toClientList() ?>;
fsite_searchdelete.lists["x_status"].options = <?php echo JsonEncode($site_search_delete->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $site_search_delete->showPageHeader(); ?>
<?php
$site_search_delete->showMessage();
?>
<form name="fsite_searchdelete" id="fsite_searchdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($site_search_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $site_search_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="site_search">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($site_search_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($site_search->id->Visible) { // id ?>
		<th class="<?php echo $site_search->id->headerCellClass() ?>"><span id="elh_site_search_id" class="site_search_id"><?php echo $site_search->id->caption() ?></span></th>
<?php } ?>
<?php if ($site_search->type->Visible) { // type ?>
		<th class="<?php echo $site_search->type->headerCellClass() ?>"><span id="elh_site_search_type" class="site_search_type"><?php echo $site_search->type->caption() ?></span></th>
<?php } ?>
<?php if ($site_search->code->Visible) { // code ?>
		<th class="<?php echo $site_search->code->headerCellClass() ?>"><span id="elh_site_search_code" class="site_search_code"><?php echo $site_search->code->caption() ?></span></th>
<?php } ?>
<?php if ($site_search->status->Visible) { // status ?>
		<th class="<?php echo $site_search->status->headerCellClass() ?>"><span id="elh_site_search_status" class="site_search_status"><?php echo $site_search->status->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$site_search_delete->RecCnt = 0;
$i = 0;
while (!$site_search_delete->Recordset->EOF) {
	$site_search_delete->RecCnt++;
	$site_search_delete->RowCnt++;

	// Set row properties
	$site_search->resetAttributes();
	$site_search->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$site_search_delete->loadRowValues($site_search_delete->Recordset);

	// Render row
	$site_search_delete->renderRow();
?>
	<tr<?php echo $site_search->rowAttributes() ?>>
<?php if ($site_search->id->Visible) { // id ?>
		<td<?php echo $site_search->id->cellAttributes() ?>>
<span id="el<?php echo $site_search_delete->RowCnt ?>_site_search_id" class="site_search_id">
<span<?php echo $site_search->id->viewAttributes() ?>>
<?php echo $site_search->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($site_search->type->Visible) { // type ?>
		<td<?php echo $site_search->type->cellAttributes() ?>>
<span id="el<?php echo $site_search_delete->RowCnt ?>_site_search_type" class="site_search_type">
<span<?php echo $site_search->type->viewAttributes() ?>>
<?php echo $site_search->type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($site_search->code->Visible) { // code ?>
		<td<?php echo $site_search->code->cellAttributes() ?>>
<span id="el<?php echo $site_search_delete->RowCnt ?>_site_search_code" class="site_search_code">
<span<?php echo $site_search->code->viewAttributes() ?>>
<?php echo $site_search->code->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($site_search->status->Visible) { // status ?>
		<td<?php echo $site_search->status->cellAttributes() ?>>
<span id="el<?php echo $site_search_delete->RowCnt ?>_site_search_status" class="site_search_status">
<span<?php echo $site_search->status->viewAttributes() ?>>
<?php echo $site_search->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$site_search_delete->Recordset->moveNext();
}
$site_search_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $site_search_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$site_search_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$site_search_delete->terminate();
?>