<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$site_search_edit = new site_search_edit();

// Run the page
$site_search_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$site_search_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fsite_searchedit = currentForm = new ew.Form("fsite_searchedit", "edit");

// Validate form
fsite_searchedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($site_search_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $site_search->id->caption(), $site_search->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($site_search_edit->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $site_search->type->caption(), $site_search->type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($site_search->type->errorMessage()) ?>");
		<?php if ($site_search_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $site_search->code->caption(), $site_search->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($site_search->code->errorMessage()) ?>");
		<?php if ($site_search_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $site_search->description->caption(), $site_search->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($site_search_edit->keywords->Required) { ?>
			elm = this.getElements("x" + infix + "_keywords");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $site_search->keywords->caption(), $site_search->keywords->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($site_search_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $site_search->status->caption(), $site_search->status->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsite_searchedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsite_searchedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsite_searchedit.lists["x_status"] = <?php echo $site_search_edit->status->Lookup->toClientList() ?>;
fsite_searchedit.lists["x_status"].options = <?php echo JsonEncode($site_search_edit->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $site_search_edit->showPageHeader(); ?>
<?php
$site_search_edit->showMessage();
?>
<form name="fsite_searchedit" id="fsite_searchedit" class="<?php echo $site_search_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($site_search_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $site_search_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="site_search">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$site_search_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($site_search->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_site_search_id" class="<?php echo $site_search_edit->LeftColumnClass ?>"><?php echo $site_search->id->caption() ?><?php echo ($site_search->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $site_search_edit->RightColumnClass ?>"><div<?php echo $site_search->id->cellAttributes() ?>>
<span id="el_site_search_id">
<span<?php echo $site_search->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($site_search->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="site_search" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($site_search->id->CurrentValue) ?>">
<?php echo $site_search->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($site_search->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_site_search_type" for="x_type" class="<?php echo $site_search_edit->LeftColumnClass ?>"><?php echo $site_search->type->caption() ?><?php echo ($site_search->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $site_search_edit->RightColumnClass ?>"><div<?php echo $site_search->type->cellAttributes() ?>>
<span id="el_site_search_type">
<input type="text" data-table="site_search" data-field="x_type" name="x_type" id="x_type" size="30" placeholder="<?php echo HtmlEncode($site_search->type->getPlaceHolder()) ?>" value="<?php echo $site_search->type->EditValue ?>"<?php echo $site_search->type->editAttributes() ?>>
</span>
<?php echo $site_search->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($site_search->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_site_search_code" for="x_code" class="<?php echo $site_search_edit->LeftColumnClass ?>"><?php echo $site_search->code->caption() ?><?php echo ($site_search->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $site_search_edit->RightColumnClass ?>"><div<?php echo $site_search->code->cellAttributes() ?>>
<span id="el_site_search_code">
<input type="text" data-table="site_search" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($site_search->code->getPlaceHolder()) ?>" value="<?php echo $site_search->code->EditValue ?>"<?php echo $site_search->code->editAttributes() ?>>
</span>
<?php echo $site_search->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($site_search->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_site_search_description" for="x_description" class="<?php echo $site_search_edit->LeftColumnClass ?>"><?php echo $site_search->description->caption() ?><?php echo ($site_search->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $site_search_edit->RightColumnClass ?>"><div<?php echo $site_search->description->cellAttributes() ?>>
<span id="el_site_search_description">
<textarea data-table="site_search" data-field="x_description" name="x_description" id="x_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($site_search->description->getPlaceHolder()) ?>"<?php echo $site_search->description->editAttributes() ?>><?php echo $site_search->description->EditValue ?></textarea>
</span>
<?php echo $site_search->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($site_search->keywords->Visible) { // keywords ?>
	<div id="r_keywords" class="form-group row">
		<label id="elh_site_search_keywords" for="x_keywords" class="<?php echo $site_search_edit->LeftColumnClass ?>"><?php echo $site_search->keywords->caption() ?><?php echo ($site_search->keywords->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $site_search_edit->RightColumnClass ?>"><div<?php echo $site_search->keywords->cellAttributes() ?>>
<span id="el_site_search_keywords">
<textarea data-table="site_search" data-field="x_keywords" name="x_keywords" id="x_keywords" cols="35" rows="4" placeholder="<?php echo HtmlEncode($site_search->keywords->getPlaceHolder()) ?>"<?php echo $site_search->keywords->editAttributes() ?>><?php echo $site_search->keywords->EditValue ?></textarea>
</span>
<?php echo $site_search->keywords->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($site_search->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_site_search_status" for="x_status" class="<?php echo $site_search_edit->LeftColumnClass ?>"><?php echo $site_search->status->caption() ?><?php echo ($site_search->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $site_search_edit->RightColumnClass ?>"><div<?php echo $site_search->status->cellAttributes() ?>>
<span id="el_site_search_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="site_search" data-field="x_status" data-value-separator="<?php echo $site_search->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $site_search->status->editAttributes() ?>>
		<?php echo $site_search->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $site_search->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$site_search_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $site_search_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $site_search_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$site_search_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$site_search_edit->terminate();
?>