<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$site_search_list = new site_search_list();

// Run the page
$site_search_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$site_search_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$site_search->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsite_searchlist = currentForm = new ew.Form("fsite_searchlist", "list");
fsite_searchlist.formKeyCountName = '<?php echo $site_search_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsite_searchlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsite_searchlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsite_searchlist.lists["x_status"] = <?php echo $site_search_list->status->Lookup->toClientList() ?>;
fsite_searchlist.lists["x_status"].options = <?php echo JsonEncode($site_search_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$site_search->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($site_search_list->TotalRecs > 0 && $site_search_list->ExportOptions->visible()) { ?>
<?php $site_search_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($site_search_list->ImportOptions->visible()) { ?>
<?php $site_search_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$site_search_list->renderOtherOptions();
?>
<?php $site_search_list->showPageHeader(); ?>
<?php
$site_search_list->showMessage();
?>
<?php if ($site_search_list->TotalRecs > 0 || $site_search->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($site_search_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> site_search">
<?php if (!$site_search->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$site_search->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($site_search_list->Pager)) $site_search_list->Pager = new PrevNextPager($site_search_list->StartRec, $site_search_list->DisplayRecs, $site_search_list->TotalRecs, $site_search_list->AutoHidePager) ?>
<?php if ($site_search_list->Pager->RecordCount > 0 && $site_search_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($site_search_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $site_search_list->pageUrl() ?>start=<?php echo $site_search_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($site_search_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $site_search_list->pageUrl() ?>start=<?php echo $site_search_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $site_search_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($site_search_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $site_search_list->pageUrl() ?>start=<?php echo $site_search_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($site_search_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $site_search_list->pageUrl() ?>start=<?php echo $site_search_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $site_search_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($site_search_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $site_search_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $site_search_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $site_search_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($site_search_list->TotalRecs > 0 && (!$site_search_list->AutoHidePageSizeSelector || $site_search_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="site_search">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($site_search_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($site_search_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($site_search_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($site_search_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($site_search_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($site_search->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $site_search_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsite_searchlist" id="fsite_searchlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($site_search_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $site_search_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="site_search">
<div id="gmp_site_search" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($site_search_list->TotalRecs > 0 || $site_search->isGridEdit()) { ?>
<table id="tbl_site_searchlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$site_search_list->RowType = ROWTYPE_HEADER;

// Render list options
$site_search_list->renderListOptions();

// Render list options (header, left)
$site_search_list->ListOptions->render("header", "left");
?>
<?php if ($site_search->id->Visible) { // id ?>
	<?php if ($site_search->sortUrl($site_search->id) == "") { ?>
		<th data-name="id" class="<?php echo $site_search->id->headerCellClass() ?>"><div id="elh_site_search_id" class="site_search_id"><div class="ew-table-header-caption"><?php echo $site_search->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $site_search->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $site_search->SortUrl($site_search->id) ?>',2);"><div id="elh_site_search_id" class="site_search_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $site_search->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($site_search->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($site_search->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($site_search->type->Visible) { // type ?>
	<?php if ($site_search->sortUrl($site_search->type) == "") { ?>
		<th data-name="type" class="<?php echo $site_search->type->headerCellClass() ?>"><div id="elh_site_search_type" class="site_search_type"><div class="ew-table-header-caption"><?php echo $site_search->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $site_search->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $site_search->SortUrl($site_search->type) ?>',2);"><div id="elh_site_search_type" class="site_search_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $site_search->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($site_search->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($site_search->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($site_search->code->Visible) { // code ?>
	<?php if ($site_search->sortUrl($site_search->code) == "") { ?>
		<th data-name="code" class="<?php echo $site_search->code->headerCellClass() ?>"><div id="elh_site_search_code" class="site_search_code"><div class="ew-table-header-caption"><?php echo $site_search->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $site_search->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $site_search->SortUrl($site_search->code) ?>',2);"><div id="elh_site_search_code" class="site_search_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $site_search->code->caption() ?></span><span class="ew-table-header-sort"><?php if ($site_search->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($site_search->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($site_search->status->Visible) { // status ?>
	<?php if ($site_search->sortUrl($site_search->status) == "") { ?>
		<th data-name="status" class="<?php echo $site_search->status->headerCellClass() ?>"><div id="elh_site_search_status" class="site_search_status"><div class="ew-table-header-caption"><?php echo $site_search->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $site_search->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $site_search->SortUrl($site_search->status) ?>',2);"><div id="elh_site_search_status" class="site_search_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $site_search->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($site_search->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($site_search->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$site_search_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($site_search->ExportAll && $site_search->isExport()) {
	$site_search_list->StopRec = $site_search_list->TotalRecs;
} else {

	// Set the last record to display
	if ($site_search_list->TotalRecs > $site_search_list->StartRec + $site_search_list->DisplayRecs - 1)
		$site_search_list->StopRec = $site_search_list->StartRec + $site_search_list->DisplayRecs - 1;
	else
		$site_search_list->StopRec = $site_search_list->TotalRecs;
}
$site_search_list->RecCnt = $site_search_list->StartRec - 1;
if ($site_search_list->Recordset && !$site_search_list->Recordset->EOF) {
	$site_search_list->Recordset->moveFirst();
	$selectLimit = $site_search_list->UseSelectLimit;
	if (!$selectLimit && $site_search_list->StartRec > 1)
		$site_search_list->Recordset->move($site_search_list->StartRec - 1);
} elseif (!$site_search->AllowAddDeleteRow && $site_search_list->StopRec == 0) {
	$site_search_list->StopRec = $site_search->GridAddRowCount;
}

// Initialize aggregate
$site_search->RowType = ROWTYPE_AGGREGATEINIT;
$site_search->resetAttributes();
$site_search_list->renderRow();
while ($site_search_list->RecCnt < $site_search_list->StopRec) {
	$site_search_list->RecCnt++;
	if ($site_search_list->RecCnt >= $site_search_list->StartRec) {
		$site_search_list->RowCnt++;

		// Set up key count
		$site_search_list->KeyCount = $site_search_list->RowIndex;

		// Init row class and style
		$site_search->resetAttributes();
		$site_search->CssClass = "";
		if ($site_search->isGridAdd()) {
		} else {
			$site_search_list->loadRowValues($site_search_list->Recordset); // Load row values
		}
		$site_search->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$site_search->RowAttrs = array_merge($site_search->RowAttrs, array('data-rowindex'=>$site_search_list->RowCnt, 'id'=>'r' . $site_search_list->RowCnt . '_site_search', 'data-rowtype'=>$site_search->RowType));

		// Render row
		$site_search_list->renderRow();

		// Render list options
		$site_search_list->renderListOptions();
?>
	<tr<?php echo $site_search->rowAttributes() ?>>
<?php

// Render list options (body, left)
$site_search_list->ListOptions->render("body", "left", $site_search_list->RowCnt);
?>
	<?php if ($site_search->id->Visible) { // id ?>
		<td data-name="id"<?php echo $site_search->id->cellAttributes() ?>>
<span id="el<?php echo $site_search_list->RowCnt ?>_site_search_id" class="site_search_id">
<span<?php echo $site_search->id->viewAttributes() ?>>
<?php echo $site_search->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($site_search->type->Visible) { // type ?>
		<td data-name="type"<?php echo $site_search->type->cellAttributes() ?>>
<span id="el<?php echo $site_search_list->RowCnt ?>_site_search_type" class="site_search_type">
<span<?php echo $site_search->type->viewAttributes() ?>>
<?php echo $site_search->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($site_search->code->Visible) { // code ?>
		<td data-name="code"<?php echo $site_search->code->cellAttributes() ?>>
<span id="el<?php echo $site_search_list->RowCnt ?>_site_search_code" class="site_search_code">
<span<?php echo $site_search->code->viewAttributes() ?>>
<?php echo $site_search->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($site_search->status->Visible) { // status ?>
		<td data-name="status"<?php echo $site_search->status->cellAttributes() ?>>
<span id="el<?php echo $site_search_list->RowCnt ?>_site_search_status" class="site_search_status">
<span<?php echo $site_search->status->viewAttributes() ?>>
<?php echo $site_search->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$site_search_list->ListOptions->render("body", "right", $site_search_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$site_search->isGridAdd())
		$site_search_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$site_search->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($site_search_list->Recordset)
	$site_search_list->Recordset->Close();
?>
<?php if (!$site_search->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$site_search->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($site_search_list->Pager)) $site_search_list->Pager = new PrevNextPager($site_search_list->StartRec, $site_search_list->DisplayRecs, $site_search_list->TotalRecs, $site_search_list->AutoHidePager) ?>
<?php if ($site_search_list->Pager->RecordCount > 0 && $site_search_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($site_search_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $site_search_list->pageUrl() ?>start=<?php echo $site_search_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($site_search_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $site_search_list->pageUrl() ?>start=<?php echo $site_search_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $site_search_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($site_search_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $site_search_list->pageUrl() ?>start=<?php echo $site_search_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($site_search_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $site_search_list->pageUrl() ?>start=<?php echo $site_search_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $site_search_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($site_search_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $site_search_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $site_search_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $site_search_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($site_search_list->TotalRecs > 0 && (!$site_search_list->AutoHidePageSizeSelector || $site_search_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="site_search">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($site_search_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($site_search_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($site_search_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($site_search_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($site_search_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($site_search->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $site_search_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($site_search_list->TotalRecs == 0 && !$site_search->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $site_search_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$site_search_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$site_search->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$site_search->isExport()) { ?>
<script>
ew.scrollableTable("gmp_site_search", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$site_search_list->terminate();
?>