<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$site_search_view = new site_search_view();

// Run the page
$site_search_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$site_search_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$site_search->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsite_searchview = currentForm = new ew.Form("fsite_searchview", "view");

// Form_CustomValidate event
fsite_searchview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsite_searchview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsite_searchview.lists["x_status"] = <?php echo $site_search_view->status->Lookup->toClientList() ?>;
fsite_searchview.lists["x_status"].options = <?php echo JsonEncode($site_search_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$site_search->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $site_search_view->ExportOptions->render("body") ?>
<?php $site_search_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $site_search_view->showPageHeader(); ?>
<?php
$site_search_view->showMessage();
?>
<form name="fsite_searchview" id="fsite_searchview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($site_search_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $site_search_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="site_search">
<input type="hidden" name="modal" value="<?php echo (int)$site_search_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($site_search->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $site_search_view->TableLeftColumnClass ?>"><span id="elh_site_search_id"><?php echo $site_search->id->caption() ?></span></td>
		<td data-name="id"<?php echo $site_search->id->cellAttributes() ?>>
<span id="el_site_search_id">
<span<?php echo $site_search->id->viewAttributes() ?>>
<?php echo $site_search->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($site_search->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $site_search_view->TableLeftColumnClass ?>"><span id="elh_site_search_type"><?php echo $site_search->type->caption() ?></span></td>
		<td data-name="type"<?php echo $site_search->type->cellAttributes() ?>>
<span id="el_site_search_type">
<span<?php echo $site_search->type->viewAttributes() ?>>
<?php echo $site_search->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($site_search->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $site_search_view->TableLeftColumnClass ?>"><span id="elh_site_search_code"><?php echo $site_search->code->caption() ?></span></td>
		<td data-name="code"<?php echo $site_search->code->cellAttributes() ?>>
<span id="el_site_search_code">
<span<?php echo $site_search->code->viewAttributes() ?>>
<?php echo $site_search->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($site_search->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $site_search_view->TableLeftColumnClass ?>"><span id="elh_site_search_description"><?php echo $site_search->description->caption() ?></span></td>
		<td data-name="description"<?php echo $site_search->description->cellAttributes() ?>>
<span id="el_site_search_description">
<span<?php echo $site_search->description->viewAttributes() ?>>
<?php echo $site_search->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($site_search->keywords->Visible) { // keywords ?>
	<tr id="r_keywords">
		<td class="<?php echo $site_search_view->TableLeftColumnClass ?>"><span id="elh_site_search_keywords"><?php echo $site_search->keywords->caption() ?></span></td>
		<td data-name="keywords"<?php echo $site_search->keywords->cellAttributes() ?>>
<span id="el_site_search_keywords">
<span<?php echo $site_search->keywords->viewAttributes() ?>>
<?php echo $site_search->keywords->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($site_search->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $site_search_view->TableLeftColumnClass ?>"><span id="elh_site_search_status"><?php echo $site_search->status->caption() ?></span></td>
		<td data-name="status"<?php echo $site_search->status->cellAttributes() ?>>
<span id="el_site_search_status">
<span<?php echo $site_search->status->viewAttributes() ?>>
<?php echo $site_search->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$site_search_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$site_search->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$site_search_view->terminate();
?>