<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sms_record_list = new sms_record_list();

// Run the page
$sms_record_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sms_record_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sms_record->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsms_recordlist = currentForm = new ew.Form("fsms_recordlist", "list");
fsms_recordlist.formKeyCountName = '<?php echo $sms_record_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsms_recordlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsms_recordlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fsms_recordlistsrch = currentSearchForm = new ew.Form("fsms_recordlistsrch");

// Filters
fsms_recordlistsrch.filterList = <?php echo $sms_record_list->getFilterList() ?>;

// Init search panel as collapsed
fsms_recordlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sms_record->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($sms_record_list->TotalRecs > 0 && $sms_record_list->ExportOptions->visible()) { ?>
<?php $sms_record_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($sms_record_list->ImportOptions->visible()) { ?>
<?php $sms_record_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($sms_record_list->SearchOptions->visible()) { ?>
<?php $sms_record_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($sms_record_list->FilterOptions->visible()) { ?>
<?php $sms_record_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$sms_record_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$sms_record->isExport() && !$sms_record->CurrentAction) { ?>
<form name="fsms_recordlistsrch" id="fsms_recordlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($sms_record_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsms_recordlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sms_record">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($sms_record_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($sms_record_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $sms_record_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($sms_record_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($sms_record_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($sms_record_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($sms_record_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sms_record_list->showPageHeader(); ?>
<?php
$sms_record_list->showMessage();
?>
<?php if ($sms_record_list->TotalRecs > 0 || $sms_record->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sms_record_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sms_record">
<?php if (!$sms_record->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$sms_record->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sms_record_list->Pager)) $sms_record_list->Pager = new PrevNextPager($sms_record_list->StartRec, $sms_record_list->DisplayRecs, $sms_record_list->TotalRecs, $sms_record_list->AutoHidePager) ?>
<?php if ($sms_record_list->Pager->RecordCount > 0 && $sms_record_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sms_record_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sms_record_list->pageUrl() ?>start=<?php echo $sms_record_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sms_record_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sms_record_list->pageUrl() ?>start=<?php echo $sms_record_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sms_record_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sms_record_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sms_record_list->pageUrl() ?>start=<?php echo $sms_record_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sms_record_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sms_record_list->pageUrl() ?>start=<?php echo $sms_record_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sms_record_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sms_record_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sms_record_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sms_record_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sms_record_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sms_record_list->TotalRecs > 0 && (!$sms_record_list->AutoHidePageSizeSelector || $sms_record_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sms_record">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sms_record_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sms_record_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sms_record_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sms_record_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sms_record_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sms_record->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sms_record_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsms_recordlist" id="fsms_recordlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sms_record_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sms_record_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sms_record">
<div id="gmp_sms_record" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($sms_record_list->TotalRecs > 0 || $sms_record->isGridEdit()) { ?>
<table id="tbl_sms_recordlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sms_record_list->RowType = ROWTYPE_HEADER;

// Render list options
$sms_record_list->renderListOptions();

// Render list options (header, left)
$sms_record_list->ListOptions->render("header", "left");
?>
<?php if ($sms_record->id->Visible) { // id ?>
	<?php if ($sms_record->sortUrl($sms_record->id) == "") { ?>
		<th data-name="id" class="<?php echo $sms_record->id->headerCellClass() ?>"><div id="elh_sms_record_id" class="sms_record_id"><div class="ew-table-header-caption"><?php echo $sms_record->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $sms_record->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->id) ?>',2);"><div id="elh_sms_record_id" class="sms_record_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sms_record->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sms_record->subject->Visible) { // subject ?>
	<?php if ($sms_record->sortUrl($sms_record->subject) == "") { ?>
		<th data-name="subject" class="<?php echo $sms_record->subject->headerCellClass() ?>"><div id="elh_sms_record_subject" class="sms_record_subject"><div class="ew-table-header-caption"><?php echo $sms_record->subject->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="subject" class="<?php echo $sms_record->subject->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->subject) ?>',2);"><div id="elh_sms_record_subject" class="sms_record_subject">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->subject->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sms_record->subject->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->subject->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sms_record->mobile->Visible) { // mobile ?>
	<?php if ($sms_record->sortUrl($sms_record->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $sms_record->mobile->headerCellClass() ?>"><div id="elh_sms_record_mobile" class="sms_record_mobile"><div class="ew-table-header-caption"><?php echo $sms_record->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $sms_record->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->mobile) ?>',2);"><div id="elh_sms_record_mobile" class="sms_record_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sms_record->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sms_record->status->Visible) { // status ?>
	<?php if ($sms_record->sortUrl($sms_record->status) == "") { ?>
		<th data-name="status" class="<?php echo $sms_record->status->headerCellClass() ?>"><div id="elh_sms_record_status" class="sms_record_status"><div class="ew-table-header-caption"><?php echo $sms_record->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $sms_record->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->status) ?>',2);"><div id="elh_sms_record_status" class="sms_record_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($sms_record->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sms_record->operator->Visible) { // operator ?>
	<?php if ($sms_record->sortUrl($sms_record->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $sms_record->operator->headerCellClass() ?>"><div id="elh_sms_record_operator" class="sms_record_operator"><div class="ew-table-header-caption"><?php echo $sms_record->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $sms_record->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->operator) ?>',2);"><div id="elh_sms_record_operator" class="sms_record_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($sms_record->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sms_record->datetime->Visible) { // datetime ?>
	<?php if ($sms_record->sortUrl($sms_record->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $sms_record->datetime->headerCellClass() ?>"><div id="elh_sms_record_datetime" class="sms_record_datetime"><div class="ew-table-header-caption"><?php echo $sms_record->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $sms_record->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->datetime) ?>',2);"><div id="elh_sms_record_datetime" class="sms_record_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($sms_record->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sms_record->company_id->Visible) { // company_id ?>
	<?php if ($sms_record->sortUrl($sms_record->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $sms_record->company_id->headerCellClass() ?>"><div id="elh_sms_record_company_id" class="sms_record_company_id"><div class="ew-table-header-caption"><?php echo $sms_record->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $sms_record->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->company_id) ?>',2);"><div id="elh_sms_record_company_id" class="sms_record_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sms_record->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sms_record->sender_id->Visible) { // sender_id ?>
	<?php if ($sms_record->sortUrl($sms_record->sender_id) == "") { ?>
		<th data-name="sender_id" class="<?php echo $sms_record->sender_id->headerCellClass() ?>"><div id="elh_sms_record_sender_id" class="sms_record_sender_id"><div class="ew-table-header-caption"><?php echo $sms_record->sender_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sender_id" class="<?php echo $sms_record->sender_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->sender_id) ?>',2);"><div id="elh_sms_record_sender_id" class="sms_record_sender_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->sender_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sms_record->sender_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->sender_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sms_record->user_id->Visible) { // user_id ?>
	<?php if ($sms_record->sortUrl($sms_record->user_id) == "") { ?>
		<th data-name="user_id" class="<?php echo $sms_record->user_id->headerCellClass() ?>"><div id="elh_sms_record_user_id" class="sms_record_user_id"><div class="ew-table-header-caption"><?php echo $sms_record->user_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_id" class="<?php echo $sms_record->user_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->user_id) ?>',2);"><div id="elh_sms_record_user_id" class="sms_record_user_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->user_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sms_record->user_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->user_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sms_record->type->Visible) { // type ?>
	<?php if ($sms_record->sortUrl($sms_record->type) == "") { ?>
		<th data-name="type" class="<?php echo $sms_record->type->headerCellClass() ?>"><div id="elh_sms_record_type" class="sms_record_type"><div class="ew-table-header-caption"><?php echo $sms_record->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $sms_record->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->type) ?>',2);"><div id="elh_sms_record_type" class="sms_record_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($sms_record->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sms_record->_response->Visible) { // response ?>
	<?php if ($sms_record->sortUrl($sms_record->_response) == "") { ?>
		<th data-name="_response" class="<?php echo $sms_record->_response->headerCellClass() ?>"><div id="elh_sms_record__response" class="sms_record__response"><div class="ew-table-header-caption"><?php echo $sms_record->_response->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_response" class="<?php echo $sms_record->_response->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sms_record->SortUrl($sms_record->_response) ?>',2);"><div id="elh_sms_record__response" class="sms_record__response">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sms_record->_response->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sms_record->_response->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sms_record->_response->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sms_record_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sms_record->ExportAll && $sms_record->isExport()) {
	$sms_record_list->StopRec = $sms_record_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sms_record_list->TotalRecs > $sms_record_list->StartRec + $sms_record_list->DisplayRecs - 1)
		$sms_record_list->StopRec = $sms_record_list->StartRec + $sms_record_list->DisplayRecs - 1;
	else
		$sms_record_list->StopRec = $sms_record_list->TotalRecs;
}
$sms_record_list->RecCnt = $sms_record_list->StartRec - 1;
if ($sms_record_list->Recordset && !$sms_record_list->Recordset->EOF) {
	$sms_record_list->Recordset->moveFirst();
	$selectLimit = $sms_record_list->UseSelectLimit;
	if (!$selectLimit && $sms_record_list->StartRec > 1)
		$sms_record_list->Recordset->move($sms_record_list->StartRec - 1);
} elseif (!$sms_record->AllowAddDeleteRow && $sms_record_list->StopRec == 0) {
	$sms_record_list->StopRec = $sms_record->GridAddRowCount;
}

// Initialize aggregate
$sms_record->RowType = ROWTYPE_AGGREGATEINIT;
$sms_record->resetAttributes();
$sms_record_list->renderRow();
while ($sms_record_list->RecCnt < $sms_record_list->StopRec) {
	$sms_record_list->RecCnt++;
	if ($sms_record_list->RecCnt >= $sms_record_list->StartRec) {
		$sms_record_list->RowCnt++;

		// Set up key count
		$sms_record_list->KeyCount = $sms_record_list->RowIndex;

		// Init row class and style
		$sms_record->resetAttributes();
		$sms_record->CssClass = "";
		if ($sms_record->isGridAdd()) {
		} else {
			$sms_record_list->loadRowValues($sms_record_list->Recordset); // Load row values
		}
		$sms_record->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sms_record->RowAttrs = array_merge($sms_record->RowAttrs, array('data-rowindex'=>$sms_record_list->RowCnt, 'id'=>'r' . $sms_record_list->RowCnt . '_sms_record', 'data-rowtype'=>$sms_record->RowType));

		// Render row
		$sms_record_list->renderRow();

		// Render list options
		$sms_record_list->renderListOptions();
?>
	<tr<?php echo $sms_record->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sms_record_list->ListOptions->render("body", "left", $sms_record_list->RowCnt);
?>
	<?php if ($sms_record->id->Visible) { // id ?>
		<td data-name="id"<?php echo $sms_record->id->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record_id" class="sms_record_id">
<span<?php echo $sms_record->id->viewAttributes() ?>>
<?php echo $sms_record->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sms_record->subject->Visible) { // subject ?>
		<td data-name="subject"<?php echo $sms_record->subject->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record_subject" class="sms_record_subject">
<span<?php echo $sms_record->subject->viewAttributes() ?>>
<?php echo $sms_record->subject->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sms_record->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $sms_record->mobile->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record_mobile" class="sms_record_mobile">
<span<?php echo $sms_record->mobile->viewAttributes() ?>>
<?php echo $sms_record->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sms_record->status->Visible) { // status ?>
		<td data-name="status"<?php echo $sms_record->status->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record_status" class="sms_record_status">
<span<?php echo $sms_record->status->viewAttributes() ?>>
<?php echo $sms_record->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sms_record->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $sms_record->operator->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record_operator" class="sms_record_operator">
<span<?php echo $sms_record->operator->viewAttributes() ?>>
<?php echo $sms_record->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sms_record->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $sms_record->datetime->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record_datetime" class="sms_record_datetime">
<span<?php echo $sms_record->datetime->viewAttributes() ?>>
<?php echo $sms_record->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sms_record->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $sms_record->company_id->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record_company_id" class="sms_record_company_id">
<span<?php echo $sms_record->company_id->viewAttributes() ?>>
<?php echo $sms_record->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sms_record->sender_id->Visible) { // sender_id ?>
		<td data-name="sender_id"<?php echo $sms_record->sender_id->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record_sender_id" class="sms_record_sender_id">
<span<?php echo $sms_record->sender_id->viewAttributes() ?>>
<?php echo $sms_record->sender_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sms_record->user_id->Visible) { // user_id ?>
		<td data-name="user_id"<?php echo $sms_record->user_id->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record_user_id" class="sms_record_user_id">
<span<?php echo $sms_record->user_id->viewAttributes() ?>>
<?php echo $sms_record->user_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sms_record->type->Visible) { // type ?>
		<td data-name="type"<?php echo $sms_record->type->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record_type" class="sms_record_type">
<span<?php echo $sms_record->type->viewAttributes() ?>>
<?php echo $sms_record->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sms_record->_response->Visible) { // response ?>
		<td data-name="_response"<?php echo $sms_record->_response->cellAttributes() ?>>
<span id="el<?php echo $sms_record_list->RowCnt ?>_sms_record__response" class="sms_record__response">
<span<?php echo $sms_record->_response->viewAttributes() ?>>
<?php echo $sms_record->_response->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sms_record_list->ListOptions->render("body", "right", $sms_record_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$sms_record->isGridAdd())
		$sms_record_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$sms_record->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($sms_record_list->Recordset)
	$sms_record_list->Recordset->Close();
?>
<?php if (!$sms_record->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$sms_record->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sms_record_list->Pager)) $sms_record_list->Pager = new PrevNextPager($sms_record_list->StartRec, $sms_record_list->DisplayRecs, $sms_record_list->TotalRecs, $sms_record_list->AutoHidePager) ?>
<?php if ($sms_record_list->Pager->RecordCount > 0 && $sms_record_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sms_record_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sms_record_list->pageUrl() ?>start=<?php echo $sms_record_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sms_record_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sms_record_list->pageUrl() ?>start=<?php echo $sms_record_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sms_record_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sms_record_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sms_record_list->pageUrl() ?>start=<?php echo $sms_record_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sms_record_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sms_record_list->pageUrl() ?>start=<?php echo $sms_record_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sms_record_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sms_record_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sms_record_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sms_record_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sms_record_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sms_record_list->TotalRecs > 0 && (!$sms_record_list->AutoHidePageSizeSelector || $sms_record_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sms_record">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sms_record_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sms_record_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sms_record_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sms_record_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sms_record_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sms_record->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sms_record_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sms_record_list->TotalRecs == 0 && !$sms_record->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sms_record_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sms_record_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sms_record->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$sms_record->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sms_record", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sms_record_list->terminate();
?>