<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sms_setup_edit = new sms_setup_edit();

// Run the page
$sms_setup_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sms_setup_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fsms_setupedit = currentForm = new ew.Form("fsms_setupedit", "edit");

// Validate form
fsms_setupedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($sms_setup_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sms_setup->id->caption(), $sms_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sms_setup_edit->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sms_setup->url->caption(), $sms_setup->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sms_setup_edit->sender_id->Required) { ?>
			elm = this.getElements("x" + infix + "_sender_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sms_setup->sender_id->caption(), $sms_setup->sender_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sms_setup_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sms_setup->operator->caption(), $sms_setup->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sms_setup->operator->errorMessage()) ?>");
		<?php if ($sms_setup_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sms_setup->datetime->caption(), $sms_setup->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sms_setup->datetime->errorMessage()) ?>");
		<?php if ($sms_setup_edit->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sms_setup->company_id->caption(), $sms_setup->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sms_setup->company_id->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsms_setupedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsms_setupedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sms_setup_edit->showPageHeader(); ?>
<?php
$sms_setup_edit->showMessage();
?>
<form name="fsms_setupedit" id="fsms_setupedit" class="<?php echo $sms_setup_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sms_setup_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sms_setup_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sms_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$sms_setup_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($sms_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_sms_setup_id" class="<?php echo $sms_setup_edit->LeftColumnClass ?>"><?php echo $sms_setup->id->caption() ?><?php echo ($sms_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sms_setup_edit->RightColumnClass ?>"><div<?php echo $sms_setup->id->cellAttributes() ?>>
<span id="el_sms_setup_id">
<span<?php echo $sms_setup->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sms_setup->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="sms_setup" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($sms_setup->id->CurrentValue) ?>">
<?php echo $sms_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sms_setup->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_sms_setup_url" for="x_url" class="<?php echo $sms_setup_edit->LeftColumnClass ?>"><?php echo $sms_setup->url->caption() ?><?php echo ($sms_setup->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sms_setup_edit->RightColumnClass ?>"><div<?php echo $sms_setup->url->cellAttributes() ?>>
<span id="el_sms_setup_url">
<input type="text" data-table="sms_setup" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($sms_setup->url->getPlaceHolder()) ?>" value="<?php echo $sms_setup->url->EditValue ?>"<?php echo $sms_setup->url->editAttributes() ?>>
</span>
<?php echo $sms_setup->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sms_setup->sender_id->Visible) { // sender_id ?>
	<div id="r_sender_id" class="form-group row">
		<label id="elh_sms_setup_sender_id" for="x_sender_id" class="<?php echo $sms_setup_edit->LeftColumnClass ?>"><?php echo $sms_setup->sender_id->caption() ?><?php echo ($sms_setup->sender_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sms_setup_edit->RightColumnClass ?>"><div<?php echo $sms_setup->sender_id->cellAttributes() ?>>
<span id="el_sms_setup_sender_id">
<input type="text" data-table="sms_setup" data-field="x_sender_id" name="x_sender_id" id="x_sender_id" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($sms_setup->sender_id->getPlaceHolder()) ?>" value="<?php echo $sms_setup->sender_id->EditValue ?>"<?php echo $sms_setup->sender_id->editAttributes() ?>>
</span>
<?php echo $sms_setup->sender_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sms_setup->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_sms_setup_operator" for="x_operator" class="<?php echo $sms_setup_edit->LeftColumnClass ?>"><?php echo $sms_setup->operator->caption() ?><?php echo ($sms_setup->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sms_setup_edit->RightColumnClass ?>"><div<?php echo $sms_setup->operator->cellAttributes() ?>>
<span id="el_sms_setup_operator">
<input type="text" data-table="sms_setup" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($sms_setup->operator->getPlaceHolder()) ?>" value="<?php echo $sms_setup->operator->EditValue ?>"<?php echo $sms_setup->operator->editAttributes() ?>>
</span>
<?php echo $sms_setup->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sms_setup->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_sms_setup_datetime" for="x_datetime" class="<?php echo $sms_setup_edit->LeftColumnClass ?>"><?php echo $sms_setup->datetime->caption() ?><?php echo ($sms_setup->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sms_setup_edit->RightColumnClass ?>"><div<?php echo $sms_setup->datetime->cellAttributes() ?>>
<span id="el_sms_setup_datetime">
<input type="text" data-table="sms_setup" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($sms_setup->datetime->getPlaceHolder()) ?>" value="<?php echo $sms_setup->datetime->EditValue ?>"<?php echo $sms_setup->datetime->editAttributes() ?>>
<?php if (!$sms_setup->datetime->ReadOnly && !$sms_setup->datetime->Disabled && !isset($sms_setup->datetime->EditAttrs["readonly"]) && !isset($sms_setup->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsms_setupedit", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $sms_setup->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sms_setup->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_sms_setup_company_id" for="x_company_id" class="<?php echo $sms_setup_edit->LeftColumnClass ?>"><?php echo $sms_setup->company_id->caption() ?><?php echo ($sms_setup->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sms_setup_edit->RightColumnClass ?>"><div<?php echo $sms_setup->company_id->cellAttributes() ?>>
<span id="el_sms_setup_company_id">
<input type="text" data-table="sms_setup" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($sms_setup->company_id->getPlaceHolder()) ?>" value="<?php echo $sms_setup->company_id->EditValue ?>"<?php echo $sms_setup->company_id->editAttributes() ?>>
</span>
<?php echo $sms_setup->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sms_setup_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sms_setup_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $sms_setup_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sms_setup_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sms_setup_edit->terminate();
?>