<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$social_icons_edit = new social_icons_edit();

// Run the page
$social_icons_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$social_icons_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fsocial_iconsedit = currentForm = new ew.Form("fsocial_iconsedit", "edit");

// Validate form
fsocial_iconsedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($social_icons_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $social_icons->id->caption(), $social_icons->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($social_icons_edit->title->Required) { ?>
			elm = this.getElements("x" + infix + "_title");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $social_icons->title->caption(), $social_icons->title->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($social_icons_edit->icon->Required) { ?>
			elm = this.getElements("x" + infix + "_icon");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $social_icons->icon->caption(), $social_icons->icon->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($social_icons_edit->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $social_icons->url->caption(), $social_icons->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($social_icons_edit->order_by->Required) { ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $social_icons->order_by->caption(), $social_icons->order_by->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($social_icons->order_by->errorMessage()) ?>");
		<?php if ($social_icons_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $social_icons->status->caption(), $social_icons->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($social_icons_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $social_icons->datetime->caption(), $social_icons->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsocial_iconsedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsocial_iconsedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsocial_iconsedit.lists["x_status"] = <?php echo $social_icons_edit->status->Lookup->toClientList() ?>;
fsocial_iconsedit.lists["x_status"].options = <?php echo JsonEncode($social_icons_edit->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $social_icons_edit->showPageHeader(); ?>
<?php
$social_icons_edit->showMessage();
?>
<form name="fsocial_iconsedit" id="fsocial_iconsedit" class="<?php echo $social_icons_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($social_icons_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $social_icons_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="social_icons">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$social_icons_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($social_icons->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_social_icons_id" class="<?php echo $social_icons_edit->LeftColumnClass ?>"><?php echo $social_icons->id->caption() ?><?php echo ($social_icons->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $social_icons_edit->RightColumnClass ?>"><div<?php echo $social_icons->id->cellAttributes() ?>>
<span id="el_social_icons_id">
<span<?php echo $social_icons->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($social_icons->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="social_icons" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($social_icons->id->CurrentValue) ?>">
<?php echo $social_icons->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($social_icons->title->Visible) { // title ?>
	<div id="r_title" class="form-group row">
		<label id="elh_social_icons_title" for="x_title" class="<?php echo $social_icons_edit->LeftColumnClass ?>"><?php echo $social_icons->title->caption() ?><?php echo ($social_icons->title->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $social_icons_edit->RightColumnClass ?>"><div<?php echo $social_icons->title->cellAttributes() ?>>
<span id="el_social_icons_title">
<input type="text" data-table="social_icons" data-field="x_title" name="x_title" id="x_title" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($social_icons->title->getPlaceHolder()) ?>" value="<?php echo $social_icons->title->EditValue ?>"<?php echo $social_icons->title->editAttributes() ?>>
</span>
<?php echo $social_icons->title->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($social_icons->icon->Visible) { // icon ?>
	<div id="r_icon" class="form-group row">
		<label id="elh_social_icons_icon" for="x_icon" class="<?php echo $social_icons_edit->LeftColumnClass ?>"><?php echo $social_icons->icon->caption() ?><?php echo ($social_icons->icon->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $social_icons_edit->RightColumnClass ?>"><div<?php echo $social_icons->icon->cellAttributes() ?>>
<span id="el_social_icons_icon">
<input type="text" data-table="social_icons" data-field="x_icon" name="x_icon" id="x_icon" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($social_icons->icon->getPlaceHolder()) ?>" value="<?php echo $social_icons->icon->EditValue ?>"<?php echo $social_icons->icon->editAttributes() ?>>
</span>
<?php echo $social_icons->icon->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($social_icons->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_social_icons_url" for="x_url" class="<?php echo $social_icons_edit->LeftColumnClass ?>"><?php echo $social_icons->url->caption() ?><?php echo ($social_icons->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $social_icons_edit->RightColumnClass ?>"><div<?php echo $social_icons->url->cellAttributes() ?>>
<span id="el_social_icons_url">
<textarea data-table="social_icons" data-field="x_url" name="x_url" id="x_url" cols="35" rows="4" placeholder="<?php echo HtmlEncode($social_icons->url->getPlaceHolder()) ?>"<?php echo $social_icons->url->editAttributes() ?>><?php echo $social_icons->url->EditValue ?></textarea>
</span>
<?php echo $social_icons->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($social_icons->order_by->Visible) { // order_by ?>
	<div id="r_order_by" class="form-group row">
		<label id="elh_social_icons_order_by" for="x_order_by" class="<?php echo $social_icons_edit->LeftColumnClass ?>"><?php echo $social_icons->order_by->caption() ?><?php echo ($social_icons->order_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $social_icons_edit->RightColumnClass ?>"><div<?php echo $social_icons->order_by->cellAttributes() ?>>
<span id="el_social_icons_order_by">
<input type="text" data-table="social_icons" data-field="x_order_by" name="x_order_by" id="x_order_by" size="30" placeholder="<?php echo HtmlEncode($social_icons->order_by->getPlaceHolder()) ?>" value="<?php echo $social_icons->order_by->EditValue ?>"<?php echo $social_icons->order_by->editAttributes() ?>>
</span>
<?php echo $social_icons->order_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($social_icons->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_social_icons_status" for="x_status" class="<?php echo $social_icons_edit->LeftColumnClass ?>"><?php echo $social_icons->status->caption() ?><?php echo ($social_icons->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $social_icons_edit->RightColumnClass ?>"><div<?php echo $social_icons->status->cellAttributes() ?>>
<span id="el_social_icons_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="social_icons" data-field="x_status" data-value-separator="<?php echo $social_icons->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $social_icons->status->editAttributes() ?>>
		<?php echo $social_icons->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $social_icons->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$social_icons_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $social_icons_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $social_icons_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$social_icons_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$social_icons_edit->terminate();
?>