<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$social_icons_list = new social_icons_list();

// Run the page
$social_icons_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$social_icons_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$social_icons->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsocial_iconslist = currentForm = new ew.Form("fsocial_iconslist", "list");
fsocial_iconslist.formKeyCountName = '<?php echo $social_icons_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsocial_iconslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsocial_iconslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsocial_iconslist.lists["x_status"] = <?php echo $social_icons_list->status->Lookup->toClientList() ?>;
fsocial_iconslist.lists["x_status"].options = <?php echo JsonEncode($social_icons_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fsocial_iconslistsrch = currentSearchForm = new ew.Form("fsocial_iconslistsrch");

// Filters
fsocial_iconslistsrch.filterList = <?php echo $social_icons_list->getFilterList() ?>;

// Init search panel as collapsed
fsocial_iconslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$social_icons->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($social_icons_list->TotalRecs > 0 && $social_icons_list->ExportOptions->visible()) { ?>
<?php $social_icons_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($social_icons_list->ImportOptions->visible()) { ?>
<?php $social_icons_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($social_icons_list->SearchOptions->visible()) { ?>
<?php $social_icons_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($social_icons_list->FilterOptions->visible()) { ?>
<?php $social_icons_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$social_icons_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$social_icons->isExport() && !$social_icons->CurrentAction) { ?>
<form name="fsocial_iconslistsrch" id="fsocial_iconslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($social_icons_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsocial_iconslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="social_icons">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($social_icons_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($social_icons_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $social_icons_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($social_icons_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($social_icons_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($social_icons_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($social_icons_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $social_icons_list->showPageHeader(); ?>
<?php
$social_icons_list->showMessage();
?>
<?php if ($social_icons_list->TotalRecs > 0 || $social_icons->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($social_icons_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> social_icons">
<?php if (!$social_icons->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$social_icons->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($social_icons_list->Pager)) $social_icons_list->Pager = new PrevNextPager($social_icons_list->StartRec, $social_icons_list->DisplayRecs, $social_icons_list->TotalRecs, $social_icons_list->AutoHidePager) ?>
<?php if ($social_icons_list->Pager->RecordCount > 0 && $social_icons_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($social_icons_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $social_icons_list->pageUrl() ?>start=<?php echo $social_icons_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($social_icons_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $social_icons_list->pageUrl() ?>start=<?php echo $social_icons_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $social_icons_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($social_icons_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $social_icons_list->pageUrl() ?>start=<?php echo $social_icons_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($social_icons_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $social_icons_list->pageUrl() ?>start=<?php echo $social_icons_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $social_icons_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($social_icons_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $social_icons_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $social_icons_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $social_icons_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($social_icons_list->TotalRecs > 0 && (!$social_icons_list->AutoHidePageSizeSelector || $social_icons_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="social_icons">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($social_icons_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($social_icons_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($social_icons_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($social_icons_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($social_icons_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($social_icons->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $social_icons_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsocial_iconslist" id="fsocial_iconslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($social_icons_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $social_icons_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="social_icons">
<div id="gmp_social_icons" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($social_icons_list->TotalRecs > 0 || $social_icons->isGridEdit()) { ?>
<table id="tbl_social_iconslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$social_icons_list->RowType = ROWTYPE_HEADER;

// Render list options
$social_icons_list->renderListOptions();

// Render list options (header, left)
$social_icons_list->ListOptions->render("header", "left");
?>
<?php if ($social_icons->id->Visible) { // id ?>
	<?php if ($social_icons->sortUrl($social_icons->id) == "") { ?>
		<th data-name="id" class="<?php echo $social_icons->id->headerCellClass() ?>"><div id="elh_social_icons_id" class="social_icons_id"><div class="ew-table-header-caption"><?php echo $social_icons->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $social_icons->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $social_icons->SortUrl($social_icons->id) ?>',2);"><div id="elh_social_icons_id" class="social_icons_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $social_icons->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($social_icons->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($social_icons->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($social_icons->title->Visible) { // title ?>
	<?php if ($social_icons->sortUrl($social_icons->title) == "") { ?>
		<th data-name="title" class="<?php echo $social_icons->title->headerCellClass() ?>"><div id="elh_social_icons_title" class="social_icons_title"><div class="ew-table-header-caption"><?php echo $social_icons->title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="title" class="<?php echo $social_icons->title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $social_icons->SortUrl($social_icons->title) ?>',2);"><div id="elh_social_icons_title" class="social_icons_title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $social_icons->title->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($social_icons->title->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($social_icons->title->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($social_icons->icon->Visible) { // icon ?>
	<?php if ($social_icons->sortUrl($social_icons->icon) == "") { ?>
		<th data-name="icon" class="<?php echo $social_icons->icon->headerCellClass() ?>"><div id="elh_social_icons_icon" class="social_icons_icon"><div class="ew-table-header-caption"><?php echo $social_icons->icon->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="icon" class="<?php echo $social_icons->icon->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $social_icons->SortUrl($social_icons->icon) ?>',2);"><div id="elh_social_icons_icon" class="social_icons_icon">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $social_icons->icon->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($social_icons->icon->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($social_icons->icon->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($social_icons->url->Visible) { // url ?>
	<?php if ($social_icons->sortUrl($social_icons->url) == "") { ?>
		<th data-name="url" class="<?php echo $social_icons->url->headerCellClass() ?>"><div id="elh_social_icons_url" class="social_icons_url"><div class="ew-table-header-caption"><?php echo $social_icons->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $social_icons->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $social_icons->SortUrl($social_icons->url) ?>',2);"><div id="elh_social_icons_url" class="social_icons_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $social_icons->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($social_icons->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($social_icons->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($social_icons->order_by->Visible) { // order_by ?>
	<?php if ($social_icons->sortUrl($social_icons->order_by) == "") { ?>
		<th data-name="order_by" class="<?php echo $social_icons->order_by->headerCellClass() ?>"><div id="elh_social_icons_order_by" class="social_icons_order_by"><div class="ew-table-header-caption"><?php echo $social_icons->order_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_by" class="<?php echo $social_icons->order_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $social_icons->SortUrl($social_icons->order_by) ?>',2);"><div id="elh_social_icons_order_by" class="social_icons_order_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $social_icons->order_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($social_icons->order_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($social_icons->order_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($social_icons->status->Visible) { // status ?>
	<?php if ($social_icons->sortUrl($social_icons->status) == "") { ?>
		<th data-name="status" class="<?php echo $social_icons->status->headerCellClass() ?>"><div id="elh_social_icons_status" class="social_icons_status"><div class="ew-table-header-caption"><?php echo $social_icons->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $social_icons->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $social_icons->SortUrl($social_icons->status) ?>',2);"><div id="elh_social_icons_status" class="social_icons_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $social_icons->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($social_icons->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($social_icons->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($social_icons->datetime->Visible) { // datetime ?>
	<?php if ($social_icons->sortUrl($social_icons->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $social_icons->datetime->headerCellClass() ?>"><div id="elh_social_icons_datetime" class="social_icons_datetime"><div class="ew-table-header-caption"><?php echo $social_icons->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $social_icons->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $social_icons->SortUrl($social_icons->datetime) ?>',2);"><div id="elh_social_icons_datetime" class="social_icons_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $social_icons->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($social_icons->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($social_icons->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$social_icons_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($social_icons->ExportAll && $social_icons->isExport()) {
	$social_icons_list->StopRec = $social_icons_list->TotalRecs;
} else {

	// Set the last record to display
	if ($social_icons_list->TotalRecs > $social_icons_list->StartRec + $social_icons_list->DisplayRecs - 1)
		$social_icons_list->StopRec = $social_icons_list->StartRec + $social_icons_list->DisplayRecs - 1;
	else
		$social_icons_list->StopRec = $social_icons_list->TotalRecs;
}
$social_icons_list->RecCnt = $social_icons_list->StartRec - 1;
if ($social_icons_list->Recordset && !$social_icons_list->Recordset->EOF) {
	$social_icons_list->Recordset->moveFirst();
	$selectLimit = $social_icons_list->UseSelectLimit;
	if (!$selectLimit && $social_icons_list->StartRec > 1)
		$social_icons_list->Recordset->move($social_icons_list->StartRec - 1);
} elseif (!$social_icons->AllowAddDeleteRow && $social_icons_list->StopRec == 0) {
	$social_icons_list->StopRec = $social_icons->GridAddRowCount;
}

// Initialize aggregate
$social_icons->RowType = ROWTYPE_AGGREGATEINIT;
$social_icons->resetAttributes();
$social_icons_list->renderRow();
while ($social_icons_list->RecCnt < $social_icons_list->StopRec) {
	$social_icons_list->RecCnt++;
	if ($social_icons_list->RecCnt >= $social_icons_list->StartRec) {
		$social_icons_list->RowCnt++;

		// Set up key count
		$social_icons_list->KeyCount = $social_icons_list->RowIndex;

		// Init row class and style
		$social_icons->resetAttributes();
		$social_icons->CssClass = "";
		if ($social_icons->isGridAdd()) {
		} else {
			$social_icons_list->loadRowValues($social_icons_list->Recordset); // Load row values
		}
		$social_icons->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$social_icons->RowAttrs = array_merge($social_icons->RowAttrs, array('data-rowindex'=>$social_icons_list->RowCnt, 'id'=>'r' . $social_icons_list->RowCnt . '_social_icons', 'data-rowtype'=>$social_icons->RowType));

		// Render row
		$social_icons_list->renderRow();

		// Render list options
		$social_icons_list->renderListOptions();
?>
	<tr<?php echo $social_icons->rowAttributes() ?>>
<?php

// Render list options (body, left)
$social_icons_list->ListOptions->render("body", "left", $social_icons_list->RowCnt);
?>
	<?php if ($social_icons->id->Visible) { // id ?>
		<td data-name="id"<?php echo $social_icons->id->cellAttributes() ?>>
<span id="el<?php echo $social_icons_list->RowCnt ?>_social_icons_id" class="social_icons_id">
<span<?php echo $social_icons->id->viewAttributes() ?>>
<?php echo $social_icons->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($social_icons->title->Visible) { // title ?>
		<td data-name="title"<?php echo $social_icons->title->cellAttributes() ?>>
<span id="el<?php echo $social_icons_list->RowCnt ?>_social_icons_title" class="social_icons_title">
<span<?php echo $social_icons->title->viewAttributes() ?>>
<?php echo $social_icons->title->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($social_icons->icon->Visible) { // icon ?>
		<td data-name="icon"<?php echo $social_icons->icon->cellAttributes() ?>>
<span id="el<?php echo $social_icons_list->RowCnt ?>_social_icons_icon" class="social_icons_icon">
<span<?php echo $social_icons->icon->viewAttributes() ?>>
<?php echo $social_icons->icon->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($social_icons->url->Visible) { // url ?>
		<td data-name="url"<?php echo $social_icons->url->cellAttributes() ?>>
<span id="el<?php echo $social_icons_list->RowCnt ?>_social_icons_url" class="social_icons_url">
<span<?php echo $social_icons->url->viewAttributes() ?>>
<?php echo $social_icons->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($social_icons->order_by->Visible) { // order_by ?>
		<td data-name="order_by"<?php echo $social_icons->order_by->cellAttributes() ?>>
<span id="el<?php echo $social_icons_list->RowCnt ?>_social_icons_order_by" class="social_icons_order_by">
<span<?php echo $social_icons->order_by->viewAttributes() ?>>
<?php echo $social_icons->order_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($social_icons->status->Visible) { // status ?>
		<td data-name="status"<?php echo $social_icons->status->cellAttributes() ?>>
<span id="el<?php echo $social_icons_list->RowCnt ?>_social_icons_status" class="social_icons_status">
<span<?php echo $social_icons->status->viewAttributes() ?>>
<?php echo $social_icons->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($social_icons->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $social_icons->datetime->cellAttributes() ?>>
<span id="el<?php echo $social_icons_list->RowCnt ?>_social_icons_datetime" class="social_icons_datetime">
<span<?php echo $social_icons->datetime->viewAttributes() ?>>
<?php echo $social_icons->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$social_icons_list->ListOptions->render("body", "right", $social_icons_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$social_icons->isGridAdd())
		$social_icons_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$social_icons->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($social_icons_list->Recordset)
	$social_icons_list->Recordset->Close();
?>
<?php if (!$social_icons->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$social_icons->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($social_icons_list->Pager)) $social_icons_list->Pager = new PrevNextPager($social_icons_list->StartRec, $social_icons_list->DisplayRecs, $social_icons_list->TotalRecs, $social_icons_list->AutoHidePager) ?>
<?php if ($social_icons_list->Pager->RecordCount > 0 && $social_icons_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($social_icons_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $social_icons_list->pageUrl() ?>start=<?php echo $social_icons_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($social_icons_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $social_icons_list->pageUrl() ?>start=<?php echo $social_icons_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $social_icons_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($social_icons_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $social_icons_list->pageUrl() ?>start=<?php echo $social_icons_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($social_icons_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $social_icons_list->pageUrl() ?>start=<?php echo $social_icons_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $social_icons_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($social_icons_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $social_icons_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $social_icons_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $social_icons_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($social_icons_list->TotalRecs > 0 && (!$social_icons_list->AutoHidePageSizeSelector || $social_icons_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="social_icons">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($social_icons_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($social_icons_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($social_icons_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($social_icons_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($social_icons_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($social_icons->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $social_icons_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($social_icons_list->TotalRecs == 0 && !$social_icons->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $social_icons_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$social_icons_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$social_icons->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$social_icons->isExport()) { ?>
<script>
ew.scrollableTable("gmp_social_icons", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$social_icons_list->terminate();
?>