<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$social_icons_view = new social_icons_view();

// Run the page
$social_icons_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$social_icons_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$social_icons->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsocial_iconsview = currentForm = new ew.Form("fsocial_iconsview", "view");

// Form_CustomValidate event
fsocial_iconsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsocial_iconsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsocial_iconsview.lists["x_status"] = <?php echo $social_icons_view->status->Lookup->toClientList() ?>;
fsocial_iconsview.lists["x_status"].options = <?php echo JsonEncode($social_icons_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$social_icons->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $social_icons_view->ExportOptions->render("body") ?>
<?php $social_icons_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $social_icons_view->showPageHeader(); ?>
<?php
$social_icons_view->showMessage();
?>
<form name="fsocial_iconsview" id="fsocial_iconsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($social_icons_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $social_icons_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="social_icons">
<input type="hidden" name="modal" value="<?php echo (int)$social_icons_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($social_icons->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $social_icons_view->TableLeftColumnClass ?>"><span id="elh_social_icons_id"><?php echo $social_icons->id->caption() ?></span></td>
		<td data-name="id"<?php echo $social_icons->id->cellAttributes() ?>>
<span id="el_social_icons_id">
<span<?php echo $social_icons->id->viewAttributes() ?>>
<?php echo $social_icons->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($social_icons->title->Visible) { // title ?>
	<tr id="r_title">
		<td class="<?php echo $social_icons_view->TableLeftColumnClass ?>"><span id="elh_social_icons_title"><?php echo $social_icons->title->caption() ?></span></td>
		<td data-name="title"<?php echo $social_icons->title->cellAttributes() ?>>
<span id="el_social_icons_title">
<span<?php echo $social_icons->title->viewAttributes() ?>>
<?php echo $social_icons->title->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($social_icons->icon->Visible) { // icon ?>
	<tr id="r_icon">
		<td class="<?php echo $social_icons_view->TableLeftColumnClass ?>"><span id="elh_social_icons_icon"><?php echo $social_icons->icon->caption() ?></span></td>
		<td data-name="icon"<?php echo $social_icons->icon->cellAttributes() ?>>
<span id="el_social_icons_icon">
<span<?php echo $social_icons->icon->viewAttributes() ?>>
<?php echo $social_icons->icon->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($social_icons->url->Visible) { // url ?>
	<tr id="r_url">
		<td class="<?php echo $social_icons_view->TableLeftColumnClass ?>"><span id="elh_social_icons_url"><?php echo $social_icons->url->caption() ?></span></td>
		<td data-name="url"<?php echo $social_icons->url->cellAttributes() ?>>
<span id="el_social_icons_url">
<span<?php echo $social_icons->url->viewAttributes() ?>>
<?php echo $social_icons->url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($social_icons->order_by->Visible) { // order_by ?>
	<tr id="r_order_by">
		<td class="<?php echo $social_icons_view->TableLeftColumnClass ?>"><span id="elh_social_icons_order_by"><?php echo $social_icons->order_by->caption() ?></span></td>
		<td data-name="order_by"<?php echo $social_icons->order_by->cellAttributes() ?>>
<span id="el_social_icons_order_by">
<span<?php echo $social_icons->order_by->viewAttributes() ?>>
<?php echo $social_icons->order_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($social_icons->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $social_icons_view->TableLeftColumnClass ?>"><span id="elh_social_icons_status"><?php echo $social_icons->status->caption() ?></span></td>
		<td data-name="status"<?php echo $social_icons->status->cellAttributes() ?>>
<span id="el_social_icons_status">
<span<?php echo $social_icons->status->viewAttributes() ?>>
<?php echo $social_icons->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($social_icons->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $social_icons_view->TableLeftColumnClass ?>"><span id="elh_social_icons_datetime"><?php echo $social_icons->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $social_icons->datetime->cellAttributes() ?>>
<span id="el_social_icons_datetime">
<span<?php echo $social_icons->datetime->viewAttributes() ?>>
<?php echo $social_icons->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$social_icons_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$social_icons->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$social_icons_view->terminate();
?>