<?php
namespace PHPMaker2019\fibre;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($sorting_dw_grid))
	$sorting_dw_grid = new sorting_dw_grid();

// Run the page
$sorting_dw_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sorting_dw_grid->Page_Render();
?>
<?php if (!$sorting_dw->isExport()) { ?>
<script>

// Form object
var fsorting_dwgrid = new ew.Form("fsorting_dwgrid", "grid");
fsorting_dwgrid.formKeyCountName = '<?php echo $sorting_dw_grid->FormKeyCountName ?>';

// Validate form
fsorting_dwgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($sorting_dw_grid->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sorting_dw->id->caption(), $sorting_dw->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sorting_dw_grid->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sorting_dw->dated->caption(), $sorting_dw->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sorting_dw->dated->errorMessage()) ?>");
		<?php if ($sorting_dw_grid->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sorting_dw->product->caption(), $sorting_dw->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sorting_dw_grid->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sorting_dw->rid->caption(), $sorting_dw->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sorting_dw_grid->tmp_lot->Required) { ?>
			elm = this.getElements("x" + infix + "_tmp_lot");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sorting_dw->tmp_lot->caption(), $sorting_dw->tmp_lot->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_tmp_lot");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sorting_dw->tmp_lot->errorMessage()) ?>");
		<?php if ($sorting_dw_grid->sorting_type->Required) { ?>
			elm = this.getElements("x" + infix + "_sorting_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sorting_dw->sorting_type->caption(), $sorting_dw->sorting_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sorting_dw_grid->IN->Required) { ?>
			elm = this.getElements("x" + infix + "_IN");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sorting_dw->IN->caption(), $sorting_dw->IN->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_IN");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sorting_dw->IN->errorMessage()) ?>");
		<?php if ($sorting_dw_grid->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sorting_dw->packets->caption(), $sorting_dw->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sorting_dw->packets->errorMessage()) ?>");
		<?php if ($sorting_dw_grid->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sorting_dw->packing_type->caption(), $sorting_dw->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sorting_dw_grid->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sorting_dw->godown->caption(), $sorting_dw->godown->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fsorting_dwgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "id", false)) return false;
	if (ew.valueChanged(fobj, infix, "dated", false)) return false;
	if (ew.valueChanged(fobj, infix, "product", false)) return false;
	if (ew.valueChanged(fobj, infix, "rid", false)) return false;
	if (ew.valueChanged(fobj, infix, "tmp_lot", false)) return false;
	if (ew.valueChanged(fobj, infix, "sorting_type", false)) return false;
	if (ew.valueChanged(fobj, infix, "IN", false)) return false;
	if (ew.valueChanged(fobj, infix, "packets", false)) return false;
	if (ew.valueChanged(fobj, infix, "packing_type", false)) return false;
	if (ew.valueChanged(fobj, infix, "godown", false)) return false;
	return true;
}

// Form_CustomValidate event
fsorting_dwgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsorting_dwgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsorting_dwgrid.lists["x_product"] = <?php echo $sorting_dw_grid->product->Lookup->toClientList() ?>;
fsorting_dwgrid.lists["x_product"].options = <?php echo JsonEncode($sorting_dw_grid->product->lookupOptions()) ?>;
fsorting_dwgrid.lists["x_rid"] = <?php echo $sorting_dw_grid->rid->Lookup->toClientList() ?>;
fsorting_dwgrid.lists["x_rid"].options = <?php echo JsonEncode($sorting_dw_grid->rid->lookupOptions()) ?>;
fsorting_dwgrid.lists["x_sorting_type"] = <?php echo $sorting_dw_grid->sorting_type->Lookup->toClientList() ?>;
fsorting_dwgrid.lists["x_sorting_type"].options = <?php echo JsonEncode($sorting_dw_grid->sorting_type->lookupOptions()) ?>;
fsorting_dwgrid.lists["x_packing_type"] = <?php echo $sorting_dw_grid->packing_type->Lookup->toClientList() ?>;
fsorting_dwgrid.lists["x_packing_type"].options = <?php echo JsonEncode($sorting_dw_grid->packing_type->lookupOptions()) ?>;
fsorting_dwgrid.lists["x_godown"] = <?php echo $sorting_dw_grid->godown->Lookup->toClientList() ?>;
fsorting_dwgrid.lists["x_godown"].options = <?php echo JsonEncode($sorting_dw_grid->godown->lookupOptions()) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$sorting_dw_grid->renderOtherOptions();
?>
<?php $sorting_dw_grid->showPageHeader(); ?>
<?php
$sorting_dw_grid->showMessage();
?>
<?php if ($sorting_dw_grid->TotalRecs > 0 || $sorting_dw->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sorting_dw_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sorting_dw">
<?php if ($sorting_dw_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $sorting_dw_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fsorting_dwgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_sorting_dw" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_sorting_dwgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sorting_dw_grid->RowType = ROWTYPE_HEADER;

// Render list options
$sorting_dw_grid->renderListOptions();

// Render list options (header, left)
$sorting_dw_grid->ListOptions->render("header", "left");
?>
<?php if ($sorting_dw->id->Visible) { // id ?>
	<?php if ($sorting_dw->sortUrl($sorting_dw->id) == "") { ?>
		<th data-name="id" class="<?php echo $sorting_dw->id->headerCellClass() ?>"><div id="elh_sorting_dw_id" class="sorting_dw_id"><div class="ew-table-header-caption"><?php echo $sorting_dw->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $sorting_dw->id->headerCellClass() ?>"><div><div id="elh_sorting_dw_id" class="sorting_dw_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->dated->Visible) { // dated ?>
	<?php if ($sorting_dw->sortUrl($sorting_dw->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $sorting_dw->dated->headerCellClass() ?>"><div id="elh_sorting_dw_dated" class="sorting_dw_dated"><div class="ew-table-header-caption"><?php echo $sorting_dw->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $sorting_dw->dated->headerCellClass() ?>"><div><div id="elh_sorting_dw_dated" class="sorting_dw_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->product->Visible) { // product ?>
	<?php if ($sorting_dw->sortUrl($sorting_dw->product) == "") { ?>
		<th data-name="product" class="<?php echo $sorting_dw->product->headerCellClass() ?>"><div id="elh_sorting_dw_product" class="sorting_dw_product"><div class="ew-table-header-caption"><?php echo $sorting_dw->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $sorting_dw->product->headerCellClass() ?>"><div><div id="elh_sorting_dw_product" class="sorting_dw_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->rid->Visible) { // rid ?>
	<?php if ($sorting_dw->sortUrl($sorting_dw->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $sorting_dw->rid->headerCellClass() ?>"><div id="elh_sorting_dw_rid" class="sorting_dw_rid"><div class="ew-table-header-caption"><?php echo $sorting_dw->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $sorting_dw->rid->headerCellClass() ?>"><div><div id="elh_sorting_dw_rid" class="sorting_dw_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($sorting_dw->sortUrl($sorting_dw->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $sorting_dw->tmp_lot->headerCellClass() ?>"><div id="elh_sorting_dw_tmp_lot" class="sorting_dw_tmp_lot"><div class="ew-table-header-caption"><?php echo $sorting_dw->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $sorting_dw->tmp_lot->headerCellClass() ?>"><div><div id="elh_sorting_dw_tmp_lot" class="sorting_dw_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->sorting_type->Visible) { // sorting_type ?>
	<?php if ($sorting_dw->sortUrl($sorting_dw->sorting_type) == "") { ?>
		<th data-name="sorting_type" class="<?php echo $sorting_dw->sorting_type->headerCellClass() ?>"><div id="elh_sorting_dw_sorting_type" class="sorting_dw_sorting_type"><div class="ew-table-header-caption"><?php echo $sorting_dw->sorting_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sorting_type" class="<?php echo $sorting_dw->sorting_type->headerCellClass() ?>"><div><div id="elh_sorting_dw_sorting_type" class="sorting_dw_sorting_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->sorting_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw->sorting_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw->sorting_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->IN->Visible) { // IN ?>
	<?php if ($sorting_dw->sortUrl($sorting_dw->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $sorting_dw->IN->headerCellClass() ?>"><div id="elh_sorting_dw_IN" class="sorting_dw_IN"><div class="ew-table-header-caption"><?php echo $sorting_dw->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $sorting_dw->IN->headerCellClass() ?>"><div><div id="elh_sorting_dw_IN" class="sorting_dw_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->packets->Visible) { // packets ?>
	<?php if ($sorting_dw->sortUrl($sorting_dw->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $sorting_dw->packets->headerCellClass() ?>"><div id="elh_sorting_dw_packets" class="sorting_dw_packets"><div class="ew-table-header-caption"><?php echo $sorting_dw->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $sorting_dw->packets->headerCellClass() ?>"><div><div id="elh_sorting_dw_packets" class="sorting_dw_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->packing_type->Visible) { // packing_type ?>
	<?php if ($sorting_dw->sortUrl($sorting_dw->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $sorting_dw->packing_type->headerCellClass() ?>"><div id="elh_sorting_dw_packing_type" class="sorting_dw_packing_type"><div class="ew-table-header-caption"><?php echo $sorting_dw->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $sorting_dw->packing_type->headerCellClass() ?>"><div><div id="elh_sorting_dw_packing_type" class="sorting_dw_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->godown->Visible) { // godown ?>
	<?php if ($sorting_dw->sortUrl($sorting_dw->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $sorting_dw->godown->headerCellClass() ?>"><div id="elh_sorting_dw_godown" class="sorting_dw_godown"><div class="ew-table-header-caption"><?php echo $sorting_dw->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $sorting_dw->godown->headerCellClass() ?>"><div><div id="elh_sorting_dw_godown" class="sorting_dw_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sorting_dw_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$sorting_dw_grid->StartRec = 1;
$sorting_dw_grid->StopRec = $sorting_dw_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $sorting_dw_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($sorting_dw_grid->FormKeyCountName) && ($sorting_dw->isGridAdd() || $sorting_dw->isGridEdit() || $sorting_dw->isConfirm())) {
		$sorting_dw_grid->KeyCount = $CurrentForm->getValue($sorting_dw_grid->FormKeyCountName);
		$sorting_dw_grid->StopRec = $sorting_dw_grid->StartRec + $sorting_dw_grid->KeyCount - 1;
	}
}
$sorting_dw_grid->RecCnt = $sorting_dw_grid->StartRec - 1;
if ($sorting_dw_grid->Recordset && !$sorting_dw_grid->Recordset->EOF) {
	$sorting_dw_grid->Recordset->moveFirst();
	$selectLimit = $sorting_dw_grid->UseSelectLimit;
	if (!$selectLimit && $sorting_dw_grid->StartRec > 1)
		$sorting_dw_grid->Recordset->move($sorting_dw_grid->StartRec - 1);
} elseif (!$sorting_dw->AllowAddDeleteRow && $sorting_dw_grid->StopRec == 0) {
	$sorting_dw_grid->StopRec = $sorting_dw->GridAddRowCount;
}

// Initialize aggregate
$sorting_dw->RowType = ROWTYPE_AGGREGATEINIT;
$sorting_dw->resetAttributes();
$sorting_dw_grid->renderRow();
if ($sorting_dw->isGridAdd())
	$sorting_dw_grid->RowIndex = 0;
if ($sorting_dw->isGridEdit())
	$sorting_dw_grid->RowIndex = 0;
while ($sorting_dw_grid->RecCnt < $sorting_dw_grid->StopRec) {
	$sorting_dw_grid->RecCnt++;
	if ($sorting_dw_grid->RecCnt >= $sorting_dw_grid->StartRec) {
		$sorting_dw_grid->RowCnt++;
		if ($sorting_dw->isGridAdd() || $sorting_dw->isGridEdit() || $sorting_dw->isConfirm()) {
			$sorting_dw_grid->RowIndex++;
			$CurrentForm->Index = $sorting_dw_grid->RowIndex;
			if ($CurrentForm->hasValue($sorting_dw_grid->FormActionName) && $sorting_dw_grid->EventCancelled)
				$sorting_dw_grid->RowAction = strval($CurrentForm->getValue($sorting_dw_grid->FormActionName));
			elseif ($sorting_dw->isGridAdd())
				$sorting_dw_grid->RowAction = "insert";
			else
				$sorting_dw_grid->RowAction = "";
		}

		// Set up key count
		$sorting_dw_grid->KeyCount = $sorting_dw_grid->RowIndex;

		// Init row class and style
		$sorting_dw->resetAttributes();
		$sorting_dw->CssClass = "";
		if ($sorting_dw->isGridAdd()) {
			if ($sorting_dw->CurrentMode == "copy") {
				$sorting_dw_grid->loadRowValues($sorting_dw_grid->Recordset); // Load row values
				$sorting_dw_grid->setRecordKey($sorting_dw_grid->RowOldKey, $sorting_dw_grid->Recordset); // Set old record key
			} else {
				$sorting_dw_grid->loadRowValues(); // Load default values
				$sorting_dw_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$sorting_dw_grid->loadRowValues($sorting_dw_grid->Recordset); // Load row values
		}
		$sorting_dw->RowType = ROWTYPE_VIEW; // Render view
		if ($sorting_dw->isGridAdd()) // Grid add
			$sorting_dw->RowType = ROWTYPE_ADD; // Render add
		if ($sorting_dw->isGridAdd() && $sorting_dw->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$sorting_dw_grid->restoreCurrentRowFormValues($sorting_dw_grid->RowIndex); // Restore form values
		if ($sorting_dw->isGridEdit()) { // Grid edit
			if ($sorting_dw->EventCancelled)
				$sorting_dw_grid->restoreCurrentRowFormValues($sorting_dw_grid->RowIndex); // Restore form values
			if ($sorting_dw_grid->RowAction == "insert")
				$sorting_dw->RowType = ROWTYPE_ADD; // Render add
			else
				$sorting_dw->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($sorting_dw->isGridEdit() && ($sorting_dw->RowType == ROWTYPE_EDIT || $sorting_dw->RowType == ROWTYPE_ADD) && $sorting_dw->EventCancelled) // Update failed
			$sorting_dw_grid->restoreCurrentRowFormValues($sorting_dw_grid->RowIndex); // Restore form values
		if ($sorting_dw->RowType == ROWTYPE_EDIT) // Edit row
			$sorting_dw_grid->EditRowCnt++;
		if ($sorting_dw->isConfirm()) // Confirm row
			$sorting_dw_grid->restoreCurrentRowFormValues($sorting_dw_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$sorting_dw->RowAttrs = array_merge($sorting_dw->RowAttrs, array('data-rowindex'=>$sorting_dw_grid->RowCnt, 'id'=>'r' . $sorting_dw_grid->RowCnt . '_sorting_dw', 'data-rowtype'=>$sorting_dw->RowType));

		// Render row
		$sorting_dw_grid->renderRow();

		// Render list options
		$sorting_dw_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($sorting_dw_grid->RowAction <> "delete" && $sorting_dw_grid->RowAction <> "insertdelete" && !($sorting_dw_grid->RowAction == "insert" && $sorting_dw->isConfirm() && $sorting_dw_grid->emptyRow())) {
?>
	<tr<?php echo $sorting_dw->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sorting_dw_grid->ListOptions->render("body", "left", $sorting_dw_grid->RowCnt);
?>
	<?php if ($sorting_dw->id->Visible) { // id ?>
		<td data-name="id"<?php echo $sorting_dw->id->cellAttributes() ?>>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_id" class="form-group sorting_dw_id">
<input type="text" data-table="sorting_dw" data-field="x_id" name="x<?php echo $sorting_dw_grid->RowIndex ?>_id" id="x<?php echo $sorting_dw_grid->RowIndex ?>_id" placeholder="<?php echo HtmlEncode($sorting_dw->id->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->id->EditValue ?>"<?php echo $sorting_dw->id->editAttributes() ?>>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_id" name="o<?php echo $sorting_dw_grid->RowIndex ?>_id" id="o<?php echo $sorting_dw_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($sorting_dw->id->OldValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_id" class="form-group sorting_dw_id">
<input type="text" data-table="sorting_dw" data-field="x_id" name="x<?php echo $sorting_dw_grid->RowIndex ?>_id" id="x<?php echo $sorting_dw_grid->RowIndex ?>_id" placeholder="<?php echo HtmlEncode($sorting_dw->id->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->id->EditValue ?>"<?php echo $sorting_dw->id->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_id" class="sorting_dw_id">
<span<?php echo $sorting_dw->id->viewAttributes() ?>>
<?php echo $sorting_dw->id->getViewValue() ?></span>
</span>
<?php if (!$sorting_dw->isConfirm()) { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_id" name="x<?php echo $sorting_dw_grid->RowIndex ?>_id" id="x<?php echo $sorting_dw_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($sorting_dw->id->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_id" name="o<?php echo $sorting_dw_grid->RowIndex ?>_id" id="o<?php echo $sorting_dw_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($sorting_dw->id->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_id" name="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_id" id="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($sorting_dw->id->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_id" name="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_id" id="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($sorting_dw->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sorting_dw->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $sorting_dw->dated->cellAttributes() ?>>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_dated" class="form-group sorting_dw_dated">
<input type="text" data-table="sorting_dw" data-field="x_dated" name="x<?php echo $sorting_dw_grid->RowIndex ?>_dated" id="x<?php echo $sorting_dw_grid->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($sorting_dw->dated->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->dated->EditValue ?>"<?php echo $sorting_dw->dated->editAttributes() ?>>
<?php if (!$sorting_dw->dated->ReadOnly && !$sorting_dw->dated->Disabled && !isset($sorting_dw->dated->EditAttrs["readonly"]) && !isset($sorting_dw->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsorting_dwgrid", "x<?php echo $sorting_dw_grid->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_dated" name="o<?php echo $sorting_dw_grid->RowIndex ?>_dated" id="o<?php echo $sorting_dw_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($sorting_dw->dated->OldValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_dated" class="form-group sorting_dw_dated">
<input type="text" data-table="sorting_dw" data-field="x_dated" name="x<?php echo $sorting_dw_grid->RowIndex ?>_dated" id="x<?php echo $sorting_dw_grid->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($sorting_dw->dated->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->dated->EditValue ?>"<?php echo $sorting_dw->dated->editAttributes() ?>>
<?php if (!$sorting_dw->dated->ReadOnly && !$sorting_dw->dated->Disabled && !isset($sorting_dw->dated->EditAttrs["readonly"]) && !isset($sorting_dw->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsorting_dwgrid", "x<?php echo $sorting_dw_grid->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_dated" class="sorting_dw_dated">
<span<?php echo $sorting_dw->dated->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->dated->getViewValue())) && $sorting_dw->dated->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->dated->linkAttributes() ?>><?php echo $sorting_dw->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sorting_dw->isConfirm()) { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_dated" name="x<?php echo $sorting_dw_grid->RowIndex ?>_dated" id="x<?php echo $sorting_dw_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($sorting_dw->dated->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_dated" name="o<?php echo $sorting_dw_grid->RowIndex ?>_dated" id="o<?php echo $sorting_dw_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($sorting_dw->dated->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_dated" name="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_dated" id="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($sorting_dw->dated->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_dated" name="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_dated" id="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($sorting_dw->dated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sorting_dw->product->Visible) { // product ?>
		<td data-name="product"<?php echo $sorting_dw->product->cellAttributes() ?>>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_product" class="form-group sorting_dw_product">
<?php $sorting_dw->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$sorting_dw->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_product" data-value-separator="<?php echo $sorting_dw->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_product" name="x<?php echo $sorting_dw_grid->RowIndex ?>_product"<?php echo $sorting_dw->product->editAttributes() ?>>
		<?php echo $sorting_dw->product->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $sorting_dw->product->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_product") ?>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_product" name="o<?php echo $sorting_dw_grid->RowIndex ?>_product" id="o<?php echo $sorting_dw_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sorting_dw->product->OldValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_product" class="form-group sorting_dw_product">
<?php $sorting_dw->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$sorting_dw->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_product" data-value-separator="<?php echo $sorting_dw->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_product" name="x<?php echo $sorting_dw_grid->RowIndex ?>_product"<?php echo $sorting_dw->product->editAttributes() ?>>
		<?php echo $sorting_dw->product->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $sorting_dw->product->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_product") ?>
</span>
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_product" class="sorting_dw_product">
<span<?php echo $sorting_dw->product->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->product->getViewValue())) && $sorting_dw->product->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->product->linkAttributes() ?>><?php echo $sorting_dw->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sorting_dw->isConfirm()) { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_product" name="x<?php echo $sorting_dw_grid->RowIndex ?>_product" id="x<?php echo $sorting_dw_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sorting_dw->product->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_product" name="o<?php echo $sorting_dw_grid->RowIndex ?>_product" id="o<?php echo $sorting_dw_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sorting_dw->product->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_product" name="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_product" id="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sorting_dw->product->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_product" name="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_product" id="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sorting_dw->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sorting_dw->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $sorting_dw->rid->cellAttributes() ?>>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_rid" class="form-group sorting_dw_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_rid" data-value-separator="<?php echo $sorting_dw->rid->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_rid" name="x<?php echo $sorting_dw_grid->RowIndex ?>_rid"<?php echo $sorting_dw->rid->editAttributes() ?>>
		<?php echo $sorting_dw->rid->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_rid") ?>
	</select>
</div>
<?php echo $sorting_dw->rid->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_rid") ?>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_rid" name="o<?php echo $sorting_dw_grid->RowIndex ?>_rid" id="o<?php echo $sorting_dw_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sorting_dw->rid->OldValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_rid" class="form-group sorting_dw_rid">
<span<?php echo $sorting_dw->rid->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->rid->EditValue)) && $sorting_dw->rid->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->rid->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->rid->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->rid->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_rid" name="x<?php echo $sorting_dw_grid->RowIndex ?>_rid" id="x<?php echo $sorting_dw_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sorting_dw->rid->CurrentValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_rid" class="sorting_dw_rid">
<span<?php echo $sorting_dw->rid->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->rid->getViewValue())) && $sorting_dw->rid->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->rid->linkAttributes() ?>><?php echo $sorting_dw->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sorting_dw->isConfirm()) { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_rid" name="x<?php echo $sorting_dw_grid->RowIndex ?>_rid" id="x<?php echo $sorting_dw_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sorting_dw->rid->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_rid" name="o<?php echo $sorting_dw_grid->RowIndex ?>_rid" id="o<?php echo $sorting_dw_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sorting_dw->rid->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_rid" name="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_rid" id="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sorting_dw->rid->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_rid" name="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_rid" id="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sorting_dw->rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sorting_dw->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $sorting_dw->tmp_lot->cellAttributes() ?>>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($sorting_dw->tmp_lot->getSessionValue() <> "") { ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_tmp_lot" class="form-group sorting_dw_tmp_lot">
<span<?php echo $sorting_dw->tmp_lot->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->tmp_lot->ViewValue)) && $sorting_dw->tmp_lot->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->tmp_lot->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->tmp_lot->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->tmp_lot->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" name="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" value="<?php echo HtmlEncode($sorting_dw->tmp_lot->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_tmp_lot" class="form-group sorting_dw_tmp_lot">
<input type="text" data-table="sorting_dw" data-field="x_tmp_lot" name="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" id="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->tmp_lot->EditValue ?>"<?php echo $sorting_dw->tmp_lot->editAttributes() ?>>
</span>
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_tmp_lot" name="o<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" id="o<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" value="<?php echo HtmlEncode($sorting_dw->tmp_lot->OldValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($sorting_dw->tmp_lot->getSessionValue() <> "") { ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_tmp_lot" class="form-group sorting_dw_tmp_lot">
<span<?php echo $sorting_dw->tmp_lot->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->tmp_lot->ViewValue)) && $sorting_dw->tmp_lot->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->tmp_lot->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->tmp_lot->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->tmp_lot->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" name="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" value="<?php echo HtmlEncode($sorting_dw->tmp_lot->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_tmp_lot" class="form-group sorting_dw_tmp_lot">
<input type="text" data-table="sorting_dw" data-field="x_tmp_lot" name="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" id="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->tmp_lot->EditValue ?>"<?php echo $sorting_dw->tmp_lot->editAttributes() ?>>
</span>
<?php } ?>
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_tmp_lot" class="sorting_dw_tmp_lot">
<span<?php echo $sorting_dw->tmp_lot->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->tmp_lot->getViewValue())) && $sorting_dw->tmp_lot->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->tmp_lot->linkAttributes() ?>><?php echo $sorting_dw->tmp_lot->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->tmp_lot->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sorting_dw->isConfirm()) { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_tmp_lot" name="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" id="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" value="<?php echo HtmlEncode($sorting_dw->tmp_lot->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_tmp_lot" name="o<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" id="o<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" value="<?php echo HtmlEncode($sorting_dw->tmp_lot->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_tmp_lot" name="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" id="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" value="<?php echo HtmlEncode($sorting_dw->tmp_lot->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_tmp_lot" name="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" id="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" value="<?php echo HtmlEncode($sorting_dw->tmp_lot->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sorting_dw->sorting_type->Visible) { // sorting_type ?>
		<td data-name="sorting_type"<?php echo $sorting_dw->sorting_type->cellAttributes() ?>>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_sorting_type" class="form-group sorting_dw_sorting_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_sorting_type" data-value-separator="<?php echo $sorting_dw->sorting_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" name="x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type"<?php echo $sorting_dw->sorting_type->editAttributes() ?>>
		<?php echo $sorting_dw->sorting_type->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "process_type_f") && !$sorting_dw->sorting_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sorting_dw->sorting_type->caption() ?>" data-title="<?php echo $sorting_dw->sorting_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type',url:'process_type_faddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sorting_dw->sorting_type->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_sorting_type") ?>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_sorting_type" name="o<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" id="o<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" value="<?php echo HtmlEncode($sorting_dw->sorting_type->OldValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_sorting_type" class="form-group sorting_dw_sorting_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_sorting_type" data-value-separator="<?php echo $sorting_dw->sorting_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" name="x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type"<?php echo $sorting_dw->sorting_type->editAttributes() ?>>
		<?php echo $sorting_dw->sorting_type->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "process_type_f") && !$sorting_dw->sorting_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sorting_dw->sorting_type->caption() ?>" data-title="<?php echo $sorting_dw->sorting_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type',url:'process_type_faddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sorting_dw->sorting_type->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_sorting_type") ?>
</span>
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_sorting_type" class="sorting_dw_sorting_type">
<span<?php echo $sorting_dw->sorting_type->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->sorting_type->getViewValue())) && $sorting_dw->sorting_type->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->sorting_type->linkAttributes() ?>><?php echo $sorting_dw->sorting_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->sorting_type->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sorting_dw->isConfirm()) { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_sorting_type" name="x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" id="x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" value="<?php echo HtmlEncode($sorting_dw->sorting_type->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_sorting_type" name="o<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" id="o<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" value="<?php echo HtmlEncode($sorting_dw->sorting_type->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_sorting_type" name="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" id="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" value="<?php echo HtmlEncode($sorting_dw->sorting_type->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_sorting_type" name="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" id="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" value="<?php echo HtmlEncode($sorting_dw->sorting_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sorting_dw->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $sorting_dw->IN->cellAttributes() ?>>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_IN" class="form-group sorting_dw_IN">
<input type="text" data-table="sorting_dw" data-field="x_IN" name="x<?php echo $sorting_dw_grid->RowIndex ?>_IN" id="x<?php echo $sorting_dw_grid->RowIndex ?>_IN" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->IN->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->IN->EditValue ?>"<?php echo $sorting_dw->IN->editAttributes() ?>>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_IN" name="o<?php echo $sorting_dw_grid->RowIndex ?>_IN" id="o<?php echo $sorting_dw_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($sorting_dw->IN->OldValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_IN" class="form-group sorting_dw_IN">
<input type="text" data-table="sorting_dw" data-field="x_IN" name="x<?php echo $sorting_dw_grid->RowIndex ?>_IN" id="x<?php echo $sorting_dw_grid->RowIndex ?>_IN" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->IN->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->IN->EditValue ?>"<?php echo $sorting_dw->IN->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_IN" class="sorting_dw_IN">
<span<?php echo $sorting_dw->IN->viewAttributes() ?>>
<?php echo $sorting_dw->IN->getViewValue() ?></span>
</span>
<?php if (!$sorting_dw->isConfirm()) { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_IN" name="x<?php echo $sorting_dw_grid->RowIndex ?>_IN" id="x<?php echo $sorting_dw_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($sorting_dw->IN->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_IN" name="o<?php echo $sorting_dw_grid->RowIndex ?>_IN" id="o<?php echo $sorting_dw_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($sorting_dw->IN->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_IN" name="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_IN" id="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($sorting_dw->IN->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_IN" name="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_IN" id="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($sorting_dw->IN->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sorting_dw->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $sorting_dw->packets->cellAttributes() ?>>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_packets" class="form-group sorting_dw_packets">
<input type="text" data-table="sorting_dw" data-field="x_packets" name="x<?php echo $sorting_dw_grid->RowIndex ?>_packets" id="x<?php echo $sorting_dw_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->packets->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->packets->EditValue ?>"<?php echo $sorting_dw->packets->editAttributes() ?>>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_packets" name="o<?php echo $sorting_dw_grid->RowIndex ?>_packets" id="o<?php echo $sorting_dw_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sorting_dw->packets->OldValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_packets" class="form-group sorting_dw_packets">
<input type="text" data-table="sorting_dw" data-field="x_packets" name="x<?php echo $sorting_dw_grid->RowIndex ?>_packets" id="x<?php echo $sorting_dw_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->packets->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->packets->EditValue ?>"<?php echo $sorting_dw->packets->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_packets" class="sorting_dw_packets">
<span<?php echo $sorting_dw->packets->viewAttributes() ?>>
<?php echo $sorting_dw->packets->getViewValue() ?></span>
</span>
<?php if (!$sorting_dw->isConfirm()) { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_packets" name="x<?php echo $sorting_dw_grid->RowIndex ?>_packets" id="x<?php echo $sorting_dw_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sorting_dw->packets->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_packets" name="o<?php echo $sorting_dw_grid->RowIndex ?>_packets" id="o<?php echo $sorting_dw_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sorting_dw->packets->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_packets" name="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_packets" id="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sorting_dw->packets->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_packets" name="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_packets" id="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sorting_dw->packets->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sorting_dw->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $sorting_dw->packing_type->cellAttributes() ?>>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_packing_type" class="form-group sorting_dw_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_packing_type" data-value-separator="<?php echo $sorting_dw->packing_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" name="x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type"<?php echo $sorting_dw->packing_type->editAttributes() ?>>
		<?php echo $sorting_dw->packing_type->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$sorting_dw->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sorting_dw->packing_type->caption() ?>" data-title="<?php echo $sorting_dw->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sorting_dw->packing_type->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_packing_type") ?>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_packing_type" name="o<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" id="o<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($sorting_dw->packing_type->OldValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_packing_type" class="form-group sorting_dw_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_packing_type" data-value-separator="<?php echo $sorting_dw->packing_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" name="x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type"<?php echo $sorting_dw->packing_type->editAttributes() ?>>
		<?php echo $sorting_dw->packing_type->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$sorting_dw->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sorting_dw->packing_type->caption() ?>" data-title="<?php echo $sorting_dw->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sorting_dw->packing_type->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_packing_type") ?>
</span>
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_packing_type" class="sorting_dw_packing_type">
<span<?php echo $sorting_dw->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->packing_type->getViewValue())) && $sorting_dw->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->packing_type->linkAttributes() ?>><?php echo $sorting_dw->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sorting_dw->isConfirm()) { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_packing_type" name="x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" id="x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($sorting_dw->packing_type->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_packing_type" name="o<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" id="o<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($sorting_dw->packing_type->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_packing_type" name="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" id="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($sorting_dw->packing_type->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_packing_type" name="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" id="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($sorting_dw->packing_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sorting_dw->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $sorting_dw->godown->cellAttributes() ?>>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_godown" class="form-group sorting_dw_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_godown" data-value-separator="<?php echo $sorting_dw->godown->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_godown" name="x<?php echo $sorting_dw_grid->RowIndex ?>_godown"<?php echo $sorting_dw->godown->editAttributes() ?>>
		<?php echo $sorting_dw->godown->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_godown") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "godown_table") && !$sorting_dw->godown->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $sorting_dw_grid->RowIndex ?>_godown" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sorting_dw->godown->caption() ?>" data-title="<?php echo $sorting_dw->godown->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $sorting_dw_grid->RowIndex ?>_godown',url:'godown_tableaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sorting_dw->godown->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_godown") ?>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_godown" name="o<?php echo $sorting_dw_grid->RowIndex ?>_godown" id="o<?php echo $sorting_dw_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sorting_dw->godown->OldValue) ?>">
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_godown" class="form-group sorting_dw_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_godown" data-value-separator="<?php echo $sorting_dw->godown->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_godown" name="x<?php echo $sorting_dw_grid->RowIndex ?>_godown"<?php echo $sorting_dw->godown->editAttributes() ?>>
		<?php echo $sorting_dw->godown->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_godown") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "godown_table") && !$sorting_dw->godown->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $sorting_dw_grid->RowIndex ?>_godown" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sorting_dw->godown->caption() ?>" data-title="<?php echo $sorting_dw->godown->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $sorting_dw_grid->RowIndex ?>_godown',url:'godown_tableaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sorting_dw->godown->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_godown") ?>
</span>
<?php } ?>
<?php if ($sorting_dw->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sorting_dw_grid->RowCnt ?>_sorting_dw_godown" class="sorting_dw_godown">
<span<?php echo $sorting_dw->godown->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->godown->getViewValue())) && $sorting_dw->godown->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->godown->linkAttributes() ?>><?php echo $sorting_dw->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sorting_dw->isConfirm()) { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_godown" name="x<?php echo $sorting_dw_grid->RowIndex ?>_godown" id="x<?php echo $sorting_dw_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sorting_dw->godown->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_godown" name="o<?php echo $sorting_dw_grid->RowIndex ?>_godown" id="o<?php echo $sorting_dw_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sorting_dw->godown->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sorting_dw" data-field="x_godown" name="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_godown" id="fsorting_dwgrid$x<?php echo $sorting_dw_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sorting_dw->godown->FormValue) ?>">
<input type="hidden" data-table="sorting_dw" data-field="x_godown" name="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_godown" id="fsorting_dwgrid$o<?php echo $sorting_dw_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sorting_dw->godown->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sorting_dw_grid->ListOptions->render("body", "right", $sorting_dw_grid->RowCnt);
?>
	</tr>
<?php if ($sorting_dw->RowType == ROWTYPE_ADD || $sorting_dw->RowType == ROWTYPE_EDIT) { ?>
<script>
fsorting_dwgrid.updateLists(<?php echo $sorting_dw_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$sorting_dw->isGridAdd() || $sorting_dw->CurrentMode == "copy")
		if (!$sorting_dw_grid->Recordset->EOF)
			$sorting_dw_grid->Recordset->moveNext();
}
?>
<?php
	if ($sorting_dw->CurrentMode == "add" || $sorting_dw->CurrentMode == "copy" || $sorting_dw->CurrentMode == "edit") {
		$sorting_dw_grid->RowIndex = '$rowindex$';
		$sorting_dw_grid->loadRowValues();

		// Set row properties
		$sorting_dw->resetAttributes();
		$sorting_dw->RowAttrs = array_merge($sorting_dw->RowAttrs, array('data-rowindex'=>$sorting_dw_grid->RowIndex, 'id'=>'r0_sorting_dw', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($sorting_dw->RowAttrs["class"], "ew-template");
		$sorting_dw->RowType = ROWTYPE_ADD;

		// Render row
		$sorting_dw_grid->renderRow();

		// Render list options
		$sorting_dw_grid->renderListOptions();
		$sorting_dw_grid->StartRowCnt = 0;
?>
	<tr<?php echo $sorting_dw->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sorting_dw_grid->ListOptions->render("body", "left", $sorting_dw_grid->RowIndex);
?>
	<?php if ($sorting_dw->id->Visible) { // id ?>
		<td data-name="id">
<?php if (!$sorting_dw->isConfirm()) { ?>
<span id="el$rowindex$_sorting_dw_id" class="form-group sorting_dw_id">
<input type="text" data-table="sorting_dw" data-field="x_id" name="x<?php echo $sorting_dw_grid->RowIndex ?>_id" id="x<?php echo $sorting_dw_grid->RowIndex ?>_id" placeholder="<?php echo HtmlEncode($sorting_dw->id->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->id->EditValue ?>"<?php echo $sorting_dw->id->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_id" class="form-group sorting_dw_id">
<span<?php echo $sorting_dw->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->id->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_id" name="x<?php echo $sorting_dw_grid->RowIndex ?>_id" id="x<?php echo $sorting_dw_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($sorting_dw->id->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_id" name="o<?php echo $sorting_dw_grid->RowIndex ?>_id" id="o<?php echo $sorting_dw_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($sorting_dw->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sorting_dw->dated->Visible) { // dated ?>
		<td data-name="dated">
<?php if (!$sorting_dw->isConfirm()) { ?>
<span id="el$rowindex$_sorting_dw_dated" class="form-group sorting_dw_dated">
<input type="text" data-table="sorting_dw" data-field="x_dated" name="x<?php echo $sorting_dw_grid->RowIndex ?>_dated" id="x<?php echo $sorting_dw_grid->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($sorting_dw->dated->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->dated->EditValue ?>"<?php echo $sorting_dw->dated->editAttributes() ?>>
<?php if (!$sorting_dw->dated->ReadOnly && !$sorting_dw->dated->Disabled && !isset($sorting_dw->dated->EditAttrs["readonly"]) && !isset($sorting_dw->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsorting_dwgrid", "x<?php echo $sorting_dw_grid->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_dated" class="form-group sorting_dw_dated">
<span<?php echo $sorting_dw->dated->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->dated->ViewValue)) && $sorting_dw->dated->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->dated->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->dated->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->dated->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_dated" name="x<?php echo $sorting_dw_grid->RowIndex ?>_dated" id="x<?php echo $sorting_dw_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($sorting_dw->dated->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_dated" name="o<?php echo $sorting_dw_grid->RowIndex ?>_dated" id="o<?php echo $sorting_dw_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($sorting_dw->dated->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sorting_dw->product->Visible) { // product ?>
		<td data-name="product">
<?php if (!$sorting_dw->isConfirm()) { ?>
<span id="el$rowindex$_sorting_dw_product" class="form-group sorting_dw_product">
<?php $sorting_dw->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$sorting_dw->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_product" data-value-separator="<?php echo $sorting_dw->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_product" name="x<?php echo $sorting_dw_grid->RowIndex ?>_product"<?php echo $sorting_dw->product->editAttributes() ?>>
		<?php echo $sorting_dw->product->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $sorting_dw->product->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_product") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_product" class="form-group sorting_dw_product">
<span<?php echo $sorting_dw->product->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->product->ViewValue)) && $sorting_dw->product->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->product->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->product->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->product->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_product" name="x<?php echo $sorting_dw_grid->RowIndex ?>_product" id="x<?php echo $sorting_dw_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sorting_dw->product->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_product" name="o<?php echo $sorting_dw_grid->RowIndex ?>_product" id="o<?php echo $sorting_dw_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sorting_dw->product->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sorting_dw->rid->Visible) { // rid ?>
		<td data-name="rid">
<?php if (!$sorting_dw->isConfirm()) { ?>
<span id="el$rowindex$_sorting_dw_rid" class="form-group sorting_dw_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_rid" data-value-separator="<?php echo $sorting_dw->rid->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_rid" name="x<?php echo $sorting_dw_grid->RowIndex ?>_rid"<?php echo $sorting_dw->rid->editAttributes() ?>>
		<?php echo $sorting_dw->rid->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_rid") ?>
	</select>
</div>
<?php echo $sorting_dw->rid->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_rid") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_rid" class="form-group sorting_dw_rid">
<span<?php echo $sorting_dw->rid->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->rid->ViewValue)) && $sorting_dw->rid->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->rid->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->rid->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->rid->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_rid" name="x<?php echo $sorting_dw_grid->RowIndex ?>_rid" id="x<?php echo $sorting_dw_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sorting_dw->rid->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_rid" name="o<?php echo $sorting_dw_grid->RowIndex ?>_rid" id="o<?php echo $sorting_dw_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sorting_dw->rid->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sorting_dw->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot">
<?php if (!$sorting_dw->isConfirm()) { ?>
<?php if ($sorting_dw->tmp_lot->getSessionValue() <> "") { ?>
<span id="el$rowindex$_sorting_dw_tmp_lot" class="form-group sorting_dw_tmp_lot">
<span<?php echo $sorting_dw->tmp_lot->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->tmp_lot->ViewValue)) && $sorting_dw->tmp_lot->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->tmp_lot->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->tmp_lot->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->tmp_lot->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" name="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" value="<?php echo HtmlEncode($sorting_dw->tmp_lot->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_tmp_lot" class="form-group sorting_dw_tmp_lot">
<input type="text" data-table="sorting_dw" data-field="x_tmp_lot" name="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" id="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->tmp_lot->EditValue ?>"<?php echo $sorting_dw->tmp_lot->editAttributes() ?>>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_tmp_lot" class="form-group sorting_dw_tmp_lot">
<span<?php echo $sorting_dw->tmp_lot->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->tmp_lot->ViewValue)) && $sorting_dw->tmp_lot->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->tmp_lot->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->tmp_lot->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->tmp_lot->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_tmp_lot" name="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" id="x<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" value="<?php echo HtmlEncode($sorting_dw->tmp_lot->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_tmp_lot" name="o<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" id="o<?php echo $sorting_dw_grid->RowIndex ?>_tmp_lot" value="<?php echo HtmlEncode($sorting_dw->tmp_lot->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sorting_dw->sorting_type->Visible) { // sorting_type ?>
		<td data-name="sorting_type">
<?php if (!$sorting_dw->isConfirm()) { ?>
<span id="el$rowindex$_sorting_dw_sorting_type" class="form-group sorting_dw_sorting_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_sorting_type" data-value-separator="<?php echo $sorting_dw->sorting_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" name="x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type"<?php echo $sorting_dw->sorting_type->editAttributes() ?>>
		<?php echo $sorting_dw->sorting_type->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "process_type_f") && !$sorting_dw->sorting_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sorting_dw->sorting_type->caption() ?>" data-title="<?php echo $sorting_dw->sorting_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type',url:'process_type_faddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sorting_dw->sorting_type->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_sorting_type") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_sorting_type" class="form-group sorting_dw_sorting_type">
<span<?php echo $sorting_dw->sorting_type->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->sorting_type->ViewValue)) && $sorting_dw->sorting_type->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->sorting_type->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->sorting_type->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->sorting_type->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_sorting_type" name="x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" id="x<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" value="<?php echo HtmlEncode($sorting_dw->sorting_type->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_sorting_type" name="o<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" id="o<?php echo $sorting_dw_grid->RowIndex ?>_sorting_type" value="<?php echo HtmlEncode($sorting_dw->sorting_type->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sorting_dw->IN->Visible) { // IN ?>
		<td data-name="IN">
<?php if (!$sorting_dw->isConfirm()) { ?>
<span id="el$rowindex$_sorting_dw_IN" class="form-group sorting_dw_IN">
<input type="text" data-table="sorting_dw" data-field="x_IN" name="x<?php echo $sorting_dw_grid->RowIndex ?>_IN" id="x<?php echo $sorting_dw_grid->RowIndex ?>_IN" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->IN->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->IN->EditValue ?>"<?php echo $sorting_dw->IN->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_IN" class="form-group sorting_dw_IN">
<span<?php echo $sorting_dw->IN->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->IN->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_IN" name="x<?php echo $sorting_dw_grid->RowIndex ?>_IN" id="x<?php echo $sorting_dw_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($sorting_dw->IN->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_IN" name="o<?php echo $sorting_dw_grid->RowIndex ?>_IN" id="o<?php echo $sorting_dw_grid->RowIndex ?>_IN" value="<?php echo HtmlEncode($sorting_dw->IN->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sorting_dw->packets->Visible) { // packets ?>
		<td data-name="packets">
<?php if (!$sorting_dw->isConfirm()) { ?>
<span id="el$rowindex$_sorting_dw_packets" class="form-group sorting_dw_packets">
<input type="text" data-table="sorting_dw" data-field="x_packets" name="x<?php echo $sorting_dw_grid->RowIndex ?>_packets" id="x<?php echo $sorting_dw_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->packets->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->packets->EditValue ?>"<?php echo $sorting_dw->packets->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_packets" class="form-group sorting_dw_packets">
<span<?php echo $sorting_dw->packets->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->packets->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_packets" name="x<?php echo $sorting_dw_grid->RowIndex ?>_packets" id="x<?php echo $sorting_dw_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sorting_dw->packets->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_packets" name="o<?php echo $sorting_dw_grid->RowIndex ?>_packets" id="o<?php echo $sorting_dw_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sorting_dw->packets->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sorting_dw->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type">
<?php if (!$sorting_dw->isConfirm()) { ?>
<span id="el$rowindex$_sorting_dw_packing_type" class="form-group sorting_dw_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_packing_type" data-value-separator="<?php echo $sorting_dw->packing_type->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" name="x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type"<?php echo $sorting_dw->packing_type->editAttributes() ?>>
		<?php echo $sorting_dw->packing_type->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$sorting_dw->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sorting_dw->packing_type->caption() ?>" data-title="<?php echo $sorting_dw->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sorting_dw->packing_type->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_packing_type") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_packing_type" class="form-group sorting_dw_packing_type">
<span<?php echo $sorting_dw->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->packing_type->ViewValue)) && $sorting_dw->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->packing_type->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->packing_type->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->packing_type->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_packing_type" name="x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" id="x<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($sorting_dw->packing_type->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_packing_type" name="o<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" id="o<?php echo $sorting_dw_grid->RowIndex ?>_packing_type" value="<?php echo HtmlEncode($sorting_dw->packing_type->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sorting_dw->godown->Visible) { // godown ?>
		<td data-name="godown">
<?php if (!$sorting_dw->isConfirm()) { ?>
<span id="el$rowindex$_sorting_dw_godown" class="form-group sorting_dw_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_godown" data-value-separator="<?php echo $sorting_dw->godown->displayValueSeparatorAttribute() ?>" id="x<?php echo $sorting_dw_grid->RowIndex ?>_godown" name="x<?php echo $sorting_dw_grid->RowIndex ?>_godown"<?php echo $sorting_dw->godown->editAttributes() ?>>
		<?php echo $sorting_dw->godown->selectOptionListHtml("x<?php echo $sorting_dw_grid->RowIndex ?>_godown") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "godown_table") && !$sorting_dw->godown->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $sorting_dw_grid->RowIndex ?>_godown" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sorting_dw->godown->caption() ?>" data-title="<?php echo $sorting_dw->godown->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $sorting_dw_grid->RowIndex ?>_godown',url:'godown_tableaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sorting_dw->godown->Lookup->getParamTag("p_x" . $sorting_dw_grid->RowIndex . "_godown") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_sorting_dw_godown" class="form-group sorting_dw_godown">
<span<?php echo $sorting_dw->godown->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->godown->ViewValue)) && $sorting_dw->godown->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->godown->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->godown->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sorting_dw->godown->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sorting_dw" data-field="x_godown" name="x<?php echo $sorting_dw_grid->RowIndex ?>_godown" id="x<?php echo $sorting_dw_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sorting_dw->godown->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sorting_dw" data-field="x_godown" name="o<?php echo $sorting_dw_grid->RowIndex ?>_godown" id="o<?php echo $sorting_dw_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sorting_dw->godown->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sorting_dw_grid->ListOptions->render("body", "right", $sorting_dw_grid->RowIndex);
?>
<script>
fsorting_dwgrid.updateLists(<?php echo $sorting_dw_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
<?php

// Render aggregate row
$sorting_dw->RowType = ROWTYPE_AGGREGATE;
$sorting_dw->resetAttributes();
$sorting_dw_grid->renderRow();
?>
<?php if ($sorting_dw_grid->TotalRecs > 0 && $sorting_dw->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$sorting_dw_grid->renderListOptions();

// Render list options (footer, left)
$sorting_dw_grid->ListOptions->render("footer", "left");
?>
	<?php if ($sorting_dw->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $sorting_dw->id->footerCellClass() ?>"><span id="elf_sorting_dw_id" class="sorting_dw_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_dw->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $sorting_dw->dated->footerCellClass() ?>"><span id="elf_sorting_dw_dated" class="sorting_dw_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_dw->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $sorting_dw->product->footerCellClass() ?>"><span id="elf_sorting_dw_product" class="sorting_dw_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_dw->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $sorting_dw->rid->footerCellClass() ?>"><span id="elf_sorting_dw_rid" class="sorting_dw_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_dw->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $sorting_dw->tmp_lot->footerCellClass() ?>"><span id="elf_sorting_dw_tmp_lot" class="sorting_dw_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_dw->sorting_type->Visible) { // sorting_type ?>
		<td data-name="sorting_type" class="<?php echo $sorting_dw->sorting_type->footerCellClass() ?>"><span id="elf_sorting_dw_sorting_type" class="sorting_dw_sorting_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_dw->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $sorting_dw->IN->footerCellClass() ?>"><span id="elf_sorting_dw_IN" class="sorting_dw_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $sorting_dw->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($sorting_dw->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $sorting_dw->packets->footerCellClass() ?>"><span id="elf_sorting_dw_packets" class="sorting_dw_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $sorting_dw->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($sorting_dw->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $sorting_dw->packing_type->footerCellClass() ?>"><span id="elf_sorting_dw_packing_type" class="sorting_dw_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_dw->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $sorting_dw->godown->footerCellClass() ?>"><span id="elf_sorting_dw_godown" class="sorting_dw_godown">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$sorting_dw_grid->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($sorting_dw->CurrentMode == "add" || $sorting_dw->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $sorting_dw_grid->FormKeyCountName ?>" id="<?php echo $sorting_dw_grid->FormKeyCountName ?>" value="<?php echo $sorting_dw_grid->KeyCount ?>">
<?php echo $sorting_dw_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($sorting_dw->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $sorting_dw_grid->FormKeyCountName ?>" id="<?php echo $sorting_dw_grid->FormKeyCountName ?>" value="<?php echo $sorting_dw_grid->KeyCount ?>">
<?php echo $sorting_dw_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($sorting_dw->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fsorting_dwgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($sorting_dw_grid->Recordset)
	$sorting_dw_grid->Recordset->Close();
?>
</div>
<?php if ($sorting_dw_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $sorting_dw_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sorting_dw_grid->TotalRecs == 0 && !$sorting_dw->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sorting_dw_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sorting_dw_grid->terminate();
?>
<?php if (!$sorting_dw->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sorting_dw", "100%", "500px");
</script>
<?php } ?>