<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$sorting_dw_preview = new sorting_dw_preview();

// Run the page
$sorting_dw_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sorting_dw_preview->Page_Render();
?>
<?php $sorting_dw_preview->showPageHeader(); ?>
<div class="card ew-grid sorting_dw"><!-- .card -->
<?php if ($sorting_dw_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$sorting_dw_preview->renderListOptions();

// Render list options (header, left)
$sorting_dw_preview->ListOptions->render("header", "left");
?>
<?php if ($sorting_dw->id->Visible) { // id ?>
	<?php if ($sorting_dw->SortUrl($sorting_dw->id) == "") { ?>
		<th class="<?php echo $sorting_dw->id->headerCellClass() ?>"><?php echo $sorting_dw->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sorting_dw->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sorting_dw->id->Name) ?>" data-sort-order="<?php echo $sorting_dw_preview->SortField == $sorting_dw->id->Name && $sorting_dw_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw_preview->SortField == $sorting_dw->id->Name) { ?><?php if ($sorting_dw_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->dated->Visible) { // dated ?>
	<?php if ($sorting_dw->SortUrl($sorting_dw->dated) == "") { ?>
		<th class="<?php echo $sorting_dw->dated->headerCellClass() ?>"><?php echo $sorting_dw->dated->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sorting_dw->dated->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sorting_dw->dated->Name) ?>" data-sort-order="<?php echo $sorting_dw_preview->SortField == $sorting_dw->dated->Name && $sorting_dw_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw_preview->SortField == $sorting_dw->dated->Name) { ?><?php if ($sorting_dw_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->product->Visible) { // product ?>
	<?php if ($sorting_dw->SortUrl($sorting_dw->product) == "") { ?>
		<th class="<?php echo $sorting_dw->product->headerCellClass() ?>"><?php echo $sorting_dw->product->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sorting_dw->product->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sorting_dw->product->Name) ?>" data-sort-order="<?php echo $sorting_dw_preview->SortField == $sorting_dw->product->Name && $sorting_dw_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw_preview->SortField == $sorting_dw->product->Name) { ?><?php if ($sorting_dw_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->rid->Visible) { // rid ?>
	<?php if ($sorting_dw->SortUrl($sorting_dw->rid) == "") { ?>
		<th class="<?php echo $sorting_dw->rid->headerCellClass() ?>"><?php echo $sorting_dw->rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sorting_dw->rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sorting_dw->rid->Name) ?>" data-sort-order="<?php echo $sorting_dw_preview->SortField == $sorting_dw->rid->Name && $sorting_dw_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw_preview->SortField == $sorting_dw->rid->Name) { ?><?php if ($sorting_dw_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($sorting_dw->SortUrl($sorting_dw->tmp_lot) == "") { ?>
		<th class="<?php echo $sorting_dw->tmp_lot->headerCellClass() ?>"><?php echo $sorting_dw->tmp_lot->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sorting_dw->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sorting_dw->tmp_lot->Name) ?>" data-sort-order="<?php echo $sorting_dw_preview->SortField == $sorting_dw->tmp_lot->Name && $sorting_dw_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw_preview->SortField == $sorting_dw->tmp_lot->Name) { ?><?php if ($sorting_dw_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->sorting_type->Visible) { // sorting_type ?>
	<?php if ($sorting_dw->SortUrl($sorting_dw->sorting_type) == "") { ?>
		<th class="<?php echo $sorting_dw->sorting_type->headerCellClass() ?>"><?php echo $sorting_dw->sorting_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sorting_dw->sorting_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sorting_dw->sorting_type->Name) ?>" data-sort-order="<?php echo $sorting_dw_preview->SortField == $sorting_dw->sorting_type->Name && $sorting_dw_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->sorting_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw_preview->SortField == $sorting_dw->sorting_type->Name) { ?><?php if ($sorting_dw_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->IN->Visible) { // IN ?>
	<?php if ($sorting_dw->SortUrl($sorting_dw->IN) == "") { ?>
		<th class="<?php echo $sorting_dw->IN->headerCellClass() ?>"><?php echo $sorting_dw->IN->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sorting_dw->IN->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sorting_dw->IN->Name) ?>" data-sort-order="<?php echo $sorting_dw_preview->SortField == $sorting_dw->IN->Name && $sorting_dw_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw_preview->SortField == $sorting_dw->IN->Name) { ?><?php if ($sorting_dw_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->packets->Visible) { // packets ?>
	<?php if ($sorting_dw->SortUrl($sorting_dw->packets) == "") { ?>
		<th class="<?php echo $sorting_dw->packets->headerCellClass() ?>"><?php echo $sorting_dw->packets->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sorting_dw->packets->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sorting_dw->packets->Name) ?>" data-sort-order="<?php echo $sorting_dw_preview->SortField == $sorting_dw->packets->Name && $sorting_dw_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw_preview->SortField == $sorting_dw->packets->Name) { ?><?php if ($sorting_dw_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->packing_type->Visible) { // packing_type ?>
	<?php if ($sorting_dw->SortUrl($sorting_dw->packing_type) == "") { ?>
		<th class="<?php echo $sorting_dw->packing_type->headerCellClass() ?>"><?php echo $sorting_dw->packing_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sorting_dw->packing_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sorting_dw->packing_type->Name) ?>" data-sort-order="<?php echo $sorting_dw_preview->SortField == $sorting_dw->packing_type->Name && $sorting_dw_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw_preview->SortField == $sorting_dw->packing_type->Name) { ?><?php if ($sorting_dw_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_dw->godown->Visible) { // godown ?>
	<?php if ($sorting_dw->SortUrl($sorting_dw->godown) == "") { ?>
		<th class="<?php echo $sorting_dw->godown->headerCellClass() ?>"><?php echo $sorting_dw->godown->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sorting_dw->godown->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sorting_dw->godown->Name) ?>" data-sort-order="<?php echo $sorting_dw_preview->SortField == $sorting_dw->godown->Name && $sorting_dw_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_dw->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_dw_preview->SortField == $sorting_dw->godown->Name) { ?><?php if ($sorting_dw_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_dw_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sorting_dw_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$sorting_dw_preview->RecCount = 0;
$sorting_dw_preview->RowCnt = 0;
while ($sorting_dw_preview->Recordset && !$sorting_dw_preview->Recordset->EOF) {

	// Init row class and style
	$sorting_dw_preview->RecCount++;
	$sorting_dw_preview->RowCnt++;
	$sorting_dw_preview->CssStyle = "";
	$sorting_dw_preview->loadListRowValues($sorting_dw_preview->Recordset);
	$sorting_dw_preview->aggregateListRowValues(); // Aggregate row values

	// Render row
	$sorting_dw_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$sorting_dw_preview->resetAttributes();
	$sorting_dw_preview->renderListRow();

	// Render list options
	$sorting_dw_preview->renderListOptions();
?>
	<tr<?php echo $sorting_dw_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sorting_dw_preview->ListOptions->render("body", "left", $sorting_dw_preview->RowCnt);
?>
<?php if ($sorting_dw->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $sorting_dw->id->cellAttributes() ?>>
<span<?php echo $sorting_dw->id->viewAttributes() ?>>
<?php echo $sorting_dw->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($sorting_dw->dated->Visible) { // dated ?>
		<!-- dated -->
		<td<?php echo $sorting_dw->dated->cellAttributes() ?>>
<span<?php echo $sorting_dw->dated->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->dated->getViewValue())) && $sorting_dw->dated->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->dated->linkAttributes() ?>><?php echo $sorting_dw->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->dated->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($sorting_dw->product->Visible) { // product ?>
		<!-- product -->
		<td<?php echo $sorting_dw->product->cellAttributes() ?>>
<span<?php echo $sorting_dw->product->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->product->getViewValue())) && $sorting_dw->product->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->product->linkAttributes() ?>><?php echo $sorting_dw->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->product->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($sorting_dw->rid->Visible) { // rid ?>
		<!-- rid -->
		<td<?php echo $sorting_dw->rid->cellAttributes() ?>>
<span<?php echo $sorting_dw->rid->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->rid->getViewValue())) && $sorting_dw->rid->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->rid->linkAttributes() ?>><?php echo $sorting_dw->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->rid->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($sorting_dw->tmp_lot->Visible) { // tmp_lot ?>
		<!-- tmp_lot -->
		<td<?php echo $sorting_dw->tmp_lot->cellAttributes() ?>>
<span<?php echo $sorting_dw->tmp_lot->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->tmp_lot->getViewValue())) && $sorting_dw->tmp_lot->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->tmp_lot->linkAttributes() ?>><?php echo $sorting_dw->tmp_lot->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->tmp_lot->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($sorting_dw->sorting_type->Visible) { // sorting_type ?>
		<!-- sorting_type -->
		<td<?php echo $sorting_dw->sorting_type->cellAttributes() ?>>
<span<?php echo $sorting_dw->sorting_type->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->sorting_type->getViewValue())) && $sorting_dw->sorting_type->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->sorting_type->linkAttributes() ?>><?php echo $sorting_dw->sorting_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->sorting_type->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($sorting_dw->IN->Visible) { // IN ?>
		<!-- IN -->
		<td<?php echo $sorting_dw->IN->cellAttributes() ?>>
<span<?php echo $sorting_dw->IN->viewAttributes() ?>>
<?php echo $sorting_dw->IN->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($sorting_dw->packets->Visible) { // packets ?>
		<!-- packets -->
		<td<?php echo $sorting_dw->packets->cellAttributes() ?>>
<span<?php echo $sorting_dw->packets->viewAttributes() ?>>
<?php echo $sorting_dw->packets->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($sorting_dw->packing_type->Visible) { // packing_type ?>
		<!-- packing_type -->
		<td<?php echo $sorting_dw->packing_type->cellAttributes() ?>>
<span<?php echo $sorting_dw->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->packing_type->getViewValue())) && $sorting_dw->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->packing_type->linkAttributes() ?>><?php echo $sorting_dw->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->packing_type->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($sorting_dw->godown->Visible) { // godown ?>
		<!-- godown -->
		<td<?php echo $sorting_dw->godown->cellAttributes() ?>>
<span<?php echo $sorting_dw->godown->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_dw->godown->getViewValue())) && $sorting_dw->godown->linkAttributes() <> "") { ?>
<a<?php echo $sorting_dw->godown->linkAttributes() ?>><?php echo $sorting_dw->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_dw->godown->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$sorting_dw_preview->ListOptions->render("body", "right", $sorting_dw_preview->RowCnt);
?>
	</tr>
<?php
	$sorting_dw_preview->Recordset->MoveNext();
}
?>
	</tbody>
<?php

	// Render aggregate row
	$sorting_dw_preview->RowType = ROWTYPE_AGGREGATE; // Aggregate
	$sorting_dw_preview->aggregateListRow(); // Prepare aggregate row

	// Render list options
	$sorting_dw_preview->renderListOptions();
?>
	<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options (footer, left)
$sorting_dw_preview->ListOptions->render("footer", "left");
?>
<?php if ($sorting_dw->id->Visible) { // id ?>
		<!-- id -->
		<td class="<?php echo $sorting_dw->id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($sorting_dw->dated->Visible) { // dated ?>
		<!-- dated -->
		<td class="<?php echo $sorting_dw->dated->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($sorting_dw->product->Visible) { // product ?>
		<!-- product -->
		<td class="<?php echo $sorting_dw->product->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($sorting_dw->rid->Visible) { // rid ?>
		<!-- rid -->
		<td class="<?php echo $sorting_dw->rid->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($sorting_dw->tmp_lot->Visible) { // tmp_lot ?>
		<!-- tmp_lot -->
		<td class="<?php echo $sorting_dw->tmp_lot->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($sorting_dw->sorting_type->Visible) { // sorting_type ?>
		<!-- sorting_type -->
		<td class="<?php echo $sorting_dw->sorting_type->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($sorting_dw->IN->Visible) { // IN ?>
		<!-- IN -->
		<td class="<?php echo $sorting_dw->IN->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $sorting_dw->IN->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($sorting_dw->packets->Visible) { // packets ?>
		<!-- packets -->
		<td class="<?php echo $sorting_dw->packets->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $sorting_dw->packets->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($sorting_dw->packing_type->Visible) { // packing_type ?>
		<!-- packing_type -->
		<td class="<?php echo $sorting_dw->packing_type->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($sorting_dw->godown->Visible) { // godown ?>
		<!-- godown -->
		<td class="<?php echo $sorting_dw->godown->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php

// Render list options (footer, right)
$sorting_dw_preview->ListOptions->render("footer", "right");
?>
	</tr>
	</tfoot>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($sorting_dw_preview->TotalRecs > 0) { ?>
<?php if (!isset($sorting_dw_preview->Pager)) $sorting_dw_preview->Pager = new PrevNextPager($sorting_dw_preview->StartRec, $sorting_dw_preview->DisplayRecs, $sorting_dw_preview->TotalRecs) ?>
<?php if ($sorting_dw_preview->Pager->RecordCount > 0 && $sorting_dw_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($sorting_dw_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $sorting_dw_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($sorting_dw_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $sorting_dw_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($sorting_dw_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $sorting_dw_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($sorting_dw_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $sorting_dw_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $sorting_dw_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $sorting_dw_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $sorting_dw_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($sorting_dw_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$sorting_dw_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($sorting_dw_preview->Recordset)
	$sorting_dw_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$sorting_dw_preview->terminate();
?>