<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sorting_dw_search = new sorting_dw_search();

// Run the page
$sorting_dw_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sorting_dw_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($sorting_dw_search->IsModal) { ?>
var fsorting_dwsearch = currentAdvancedSearchForm = new ew.Form("fsorting_dwsearch", "search");
<?php } else { ?>
var fsorting_dwsearch = currentForm = new ew.Form("fsorting_dwsearch", "search");
<?php } ?>

// Form_CustomValidate event
fsorting_dwsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsorting_dwsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsorting_dwsearch.lists["x_product"] = <?php echo $sorting_dw_search->product->Lookup->toClientList() ?>;
fsorting_dwsearch.lists["x_product"].options = <?php echo JsonEncode($sorting_dw_search->product->lookupOptions()) ?>;
fsorting_dwsearch.lists["x_rid"] = <?php echo $sorting_dw_search->rid->Lookup->toClientList() ?>;
fsorting_dwsearch.lists["x_rid"].options = <?php echo JsonEncode($sorting_dw_search->rid->lookupOptions()) ?>;
fsorting_dwsearch.lists["x_sorting_type"] = <?php echo $sorting_dw_search->sorting_type->Lookup->toClientList() ?>;
fsorting_dwsearch.lists["x_sorting_type"].options = <?php echo JsonEncode($sorting_dw_search->sorting_type->lookupOptions()) ?>;
fsorting_dwsearch.lists["x_packing_type"] = <?php echo $sorting_dw_search->packing_type->Lookup->toClientList() ?>;
fsorting_dwsearch.lists["x_packing_type"].options = <?php echo JsonEncode($sorting_dw_search->packing_type->lookupOptions()) ?>;
fsorting_dwsearch.lists["x_godown"] = <?php echo $sorting_dw_search->godown->Lookup->toClientList() ?>;
fsorting_dwsearch.lists["x_godown"].options = <?php echo JsonEncode($sorting_dw_search->godown->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fsorting_dwsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_dw->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_dw->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_dw->tmp_lot->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_dw->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_dw->packets->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sorting_dw_search->showPageHeader(); ?>
<?php
$sorting_dw_search->showMessage();
?>
<form name="fsorting_dwsearch" id="fsorting_dwsearch" class="<?php echo $sorting_dw_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sorting_dw_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sorting_dw_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sorting_dw">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$sorting_dw_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($sorting_dw->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $sorting_dw_search->LeftColumnClass ?>"><span id="elh_sorting_dw_id"><?php echo $sorting_dw->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $sorting_dw_search->RightColumnClass ?>"><div<?php echo $sorting_dw->id->cellAttributes() ?>>
			<span id="el_sorting_dw_id">
<input type="text" data-table="sorting_dw" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($sorting_dw->id->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->id->EditValue ?>"<?php echo $sorting_dw->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_dw->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $sorting_dw_search->LeftColumnClass ?>"><span id="elh_sorting_dw_dated"><?php echo $sorting_dw->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $sorting_dw_search->RightColumnClass ?>"><div<?php echo $sorting_dw->dated->cellAttributes() ?>>
			<span id="el_sorting_dw_dated">
<input type="text" data-table="sorting_dw" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($sorting_dw->dated->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->dated->EditValue ?>"<?php echo $sorting_dw->dated->editAttributes() ?>>
<?php if (!$sorting_dw->dated->ReadOnly && !$sorting_dw->dated->Disabled && !isset($sorting_dw->dated->EditAttrs["readonly"]) && !isset($sorting_dw->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsorting_dwsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_dw->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $sorting_dw_search->LeftColumnClass ?>"><span id="elh_sorting_dw_product"><?php echo $sorting_dw->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $sorting_dw_search->RightColumnClass ?>"><div<?php echo $sorting_dw->product->cellAttributes() ?>>
			<span id="el_sorting_dw_product">
<?php $sorting_dw->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$sorting_dw->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_product" data-value-separator="<?php echo $sorting_dw->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $sorting_dw->product->editAttributes() ?>>
		<?php echo $sorting_dw->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $sorting_dw->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_dw->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $sorting_dw_search->LeftColumnClass ?>"><span id="elh_sorting_dw_rid"><?php echo $sorting_dw->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $sorting_dw_search->RightColumnClass ?>"><div<?php echo $sorting_dw->rid->cellAttributes() ?>>
			<span id="el_sorting_dw_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_rid" data-value-separator="<?php echo $sorting_dw->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $sorting_dw->rid->editAttributes() ?>>
		<?php echo $sorting_dw->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $sorting_dw->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_dw->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $sorting_dw_search->LeftColumnClass ?>"><span id="elh_sorting_dw_tmp_lot"><?php echo $sorting_dw->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="="></span>
		</label>
		<div class="<?php echo $sorting_dw_search->RightColumnClass ?>"><div<?php echo $sorting_dw->tmp_lot->cellAttributes() ?>>
			<span id="el_sorting_dw_tmp_lot">
<input type="text" data-table="sorting_dw" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->tmp_lot->EditValue ?>"<?php echo $sorting_dw->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_dw->sorting_type->Visible) { // sorting_type ?>
	<div id="r_sorting_type" class="form-group row">
		<label for="x_sorting_type" class="<?php echo $sorting_dw_search->LeftColumnClass ?>"><span id="elh_sorting_dw_sorting_type"><?php echo $sorting_dw->sorting_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sorting_type" id="z_sorting_type" value="="></span>
		</label>
		<div class="<?php echo $sorting_dw_search->RightColumnClass ?>"><div<?php echo $sorting_dw->sorting_type->cellAttributes() ?>>
			<span id="el_sorting_dw_sorting_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_sorting_type" data-value-separator="<?php echo $sorting_dw->sorting_type->displayValueSeparatorAttribute() ?>" id="x_sorting_type" name="x_sorting_type"<?php echo $sorting_dw->sorting_type->editAttributes() ?>>
		<?php echo $sorting_dw->sorting_type->selectOptionListHtml("x_sorting_type") ?>
	</select>
</div>
<?php echo $sorting_dw->sorting_type->Lookup->getParamTag("p_x_sorting_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_dw->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $sorting_dw_search->LeftColumnClass ?>"><span id="elh_sorting_dw_IN"><?php echo $sorting_dw->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $sorting_dw_search->RightColumnClass ?>"><div<?php echo $sorting_dw->IN->cellAttributes() ?>>
			<span id="el_sorting_dw_IN">
<input type="text" data-table="sorting_dw" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->IN->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->IN->EditValue ?>"<?php echo $sorting_dw->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_dw->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $sorting_dw_search->LeftColumnClass ?>"><span id="elh_sorting_dw_packets"><?php echo $sorting_dw->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $sorting_dw_search->RightColumnClass ?>"><div<?php echo $sorting_dw->packets->cellAttributes() ?>>
			<span id="el_sorting_dw_packets">
<input type="text" data-table="sorting_dw" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($sorting_dw->packets->getPlaceHolder()) ?>" value="<?php echo $sorting_dw->packets->EditValue ?>"<?php echo $sorting_dw->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_dw->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $sorting_dw_search->LeftColumnClass ?>"><span id="elh_sorting_dw_packing_type"><?php echo $sorting_dw->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $sorting_dw_search->RightColumnClass ?>"><div<?php echo $sorting_dw->packing_type->cellAttributes() ?>>
			<span id="el_sorting_dw_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_packing_type" data-value-separator="<?php echo $sorting_dw->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $sorting_dw->packing_type->editAttributes() ?>>
		<?php echo $sorting_dw->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $sorting_dw->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_dw->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $sorting_dw_search->LeftColumnClass ?>"><span id="elh_sorting_dw_godown"><?php echo $sorting_dw->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $sorting_dw_search->RightColumnClass ?>"><div<?php echo $sorting_dw->godown->cellAttributes() ?>>
			<span id="el_sorting_dw_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_dw" data-field="x_godown" data-value-separator="<?php echo $sorting_dw->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $sorting_dw->godown->editAttributes() ?>>
		<?php echo $sorting_dw->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $sorting_dw->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sorting_dw_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sorting_dw_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sorting_dw_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sorting_dw_search->terminate();
?>