<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sorting_table_list = new sorting_table_list();

// Run the page
$sorting_table_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sorting_table_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sorting_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsorting_tablelist = currentForm = new ew.Form("fsorting_tablelist", "list");
fsorting_tablelist.formKeyCountName = '<?php echo $sorting_table_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsorting_tablelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsorting_tablelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsorting_tablelist.lists["x_rid"] = <?php echo $sorting_table_list->rid->Lookup->toClientList() ?>;
fsorting_tablelist.lists["x_rid"].options = <?php echo JsonEncode($sorting_table_list->rid->lookupOptions()) ?>;
fsorting_tablelist.lists["x_product"] = <?php echo $sorting_table_list->product->Lookup->toClientList() ?>;
fsorting_tablelist.lists["x_product"].options = <?php echo JsonEncode($sorting_table_list->product->lookupOptions()) ?>;
fsorting_tablelist.lists["x_sorting_type"] = <?php echo $sorting_table_list->sorting_type->Lookup->toClientList() ?>;
fsorting_tablelist.lists["x_sorting_type"].options = <?php echo JsonEncode($sorting_table_list->sorting_type->lookupOptions()) ?>;
fsorting_tablelist.lists["x_packing_type"] = <?php echo $sorting_table_list->packing_type->Lookup->toClientList() ?>;
fsorting_tablelist.lists["x_packing_type"].options = <?php echo JsonEncode($sorting_table_list->packing_type->lookupOptions()) ?>;
fsorting_tablelist.lists["x_quantity_avg_act"] = <?php echo $sorting_table_list->quantity_avg_act->Lookup->toClientList() ?>;
fsorting_tablelist.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($sorting_table_list->quantity_avg_act->options(FALSE, TRUE)) ?>;
fsorting_tablelist.lists["x_godown"] = <?php echo $sorting_table_list->godown->Lookup->toClientList() ?>;
fsorting_tablelist.lists["x_godown"].options = <?php echo JsonEncode($sorting_table_list->godown->lookupOptions()) ?>;
fsorting_tablelist.lists["x_employee_id[]"] = <?php echo $sorting_table_list->employee_id->Lookup->toClientList() ?>;
fsorting_tablelist.lists["x_employee_id[]"].options = <?php echo JsonEncode($sorting_table_list->employee_id->lookupOptions()) ?>;
fsorting_tablelist.lists["x_next_process"] = <?php echo $sorting_table_list->next_process->Lookup->toClientList() ?>;
fsorting_tablelist.lists["x_next_process"].options = <?php echo JsonEncode($sorting_table_list->next_process->lookupOptions()) ?>;
fsorting_tablelist.lists["x_next_godown"] = <?php echo $sorting_table_list->next_godown->Lookup->toClientList() ?>;
fsorting_tablelist.lists["x_next_godown"].options = <?php echo JsonEncode($sorting_table_list->next_godown->lookupOptions()) ?>;
fsorting_tablelist.lists["x_operator"] = <?php echo $sorting_table_list->operator->Lookup->toClientList() ?>;
fsorting_tablelist.lists["x_operator"].options = <?php echo JsonEncode($sorting_table_list->operator->lookupOptions()) ?>;
fsorting_tablelist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fsorting_tablelistsrch = currentSearchForm = new ew.Form("fsorting_tablelistsrch");

// Filters
fsorting_tablelistsrch.filterList = <?php echo $sorting_table_list->getFilterList() ?>;

// Init search panel as collapsed
fsorting_tablelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sorting_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($sorting_table_list->TotalRecs > 0 && $sorting_table_list->ExportOptions->visible()) { ?>
<?php $sorting_table_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($sorting_table_list->ImportOptions->visible()) { ?>
<?php $sorting_table_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($sorting_table_list->SearchOptions->visible()) { ?>
<?php $sorting_table_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($sorting_table_list->FilterOptions->visible()) { ?>
<?php $sorting_table_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$sorting_table_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$sorting_table->isExport() && !$sorting_table->CurrentAction) { ?>
<form name="fsorting_tablelistsrch" id="fsorting_tablelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($sorting_table_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsorting_tablelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sorting_table">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($sorting_table_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($sorting_table_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $sorting_table_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($sorting_table_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($sorting_table_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($sorting_table_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($sorting_table_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sorting_table_list->showPageHeader(); ?>
<?php
$sorting_table_list->showMessage();
?>
<?php if ($sorting_table_list->TotalRecs > 0 || $sorting_table->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sorting_table_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sorting_table">
<?php if (!$sorting_table->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$sorting_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sorting_table_list->Pager)) $sorting_table_list->Pager = new PrevNextPager($sorting_table_list->StartRec, $sorting_table_list->DisplayRecs, $sorting_table_list->TotalRecs, $sorting_table_list->AutoHidePager) ?>
<?php if ($sorting_table_list->Pager->RecordCount > 0 && $sorting_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sorting_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sorting_table_list->pageUrl() ?>start=<?php echo $sorting_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sorting_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sorting_table_list->pageUrl() ?>start=<?php echo $sorting_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sorting_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sorting_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sorting_table_list->pageUrl() ?>start=<?php echo $sorting_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sorting_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sorting_table_list->pageUrl() ?>start=<?php echo $sorting_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sorting_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sorting_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sorting_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sorting_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sorting_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sorting_table_list->TotalRecs > 0 && (!$sorting_table_list->AutoHidePageSizeSelector || $sorting_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sorting_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sorting_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sorting_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sorting_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sorting_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sorting_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sorting_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sorting_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsorting_tablelist" id="fsorting_tablelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sorting_table_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sorting_table_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sorting_table">
<div id="gmp_sorting_table" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($sorting_table_list->TotalRecs > 0 || $sorting_table->isGridEdit()) { ?>
<table id="tbl_sorting_tablelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sorting_table_list->RowType = ROWTYPE_HEADER;

// Render list options
$sorting_table_list->renderListOptions();

// Render list options (header, left)
$sorting_table_list->ListOptions->render("header", "left");
?>
<?php if ($sorting_table->id->Visible) { // id ?>
	<?php if ($sorting_table->sortUrl($sorting_table->id) == "") { ?>
		<th data-name="id" class="<?php echo $sorting_table->id->headerCellClass() ?>"><div id="elh_sorting_table_id" class="sorting_table_id"><div class="ew-table-header-caption"><?php echo $sorting_table->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $sorting_table->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->id) ?>',2);"><div id="elh_sorting_table_id" class="sorting_table_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->rid->Visible) { // rid ?>
	<?php if ($sorting_table->sortUrl($sorting_table->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $sorting_table->rid->headerCellClass() ?>"><div id="elh_sorting_table_rid" class="sorting_table_rid"><div class="ew-table-header-caption"><?php echo $sorting_table->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $sorting_table->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->rid) ?>',2);"><div id="elh_sorting_table_rid" class="sorting_table_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->product->Visible) { // product ?>
	<?php if ($sorting_table->sortUrl($sorting_table->product) == "") { ?>
		<th data-name="product" class="<?php echo $sorting_table->product->headerCellClass() ?>"><div id="elh_sorting_table_product" class="sorting_table_product"><div class="ew-table-header-caption"><?php echo $sorting_table->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $sorting_table->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->product) ?>',2);"><div id="elh_sorting_table_product" class="sorting_table_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->sorting_type->Visible) { // sorting_type ?>
	<?php if ($sorting_table->sortUrl($sorting_table->sorting_type) == "") { ?>
		<th data-name="sorting_type" class="<?php echo $sorting_table->sorting_type->headerCellClass() ?>"><div id="elh_sorting_table_sorting_type" class="sorting_table_sorting_type"><div class="ew-table-header-caption"><?php echo $sorting_table->sorting_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sorting_type" class="<?php echo $sorting_table->sorting_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->sorting_type) ?>',2);"><div id="elh_sorting_table_sorting_type" class="sorting_table_sorting_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->sorting_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->sorting_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->sorting_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->packing_type->Visible) { // packing_type ?>
	<?php if ($sorting_table->sortUrl($sorting_table->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $sorting_table->packing_type->headerCellClass() ?>"><div id="elh_sorting_table_packing_type" class="sorting_table_packing_type"><div class="ew-table-header-caption"><?php echo $sorting_table->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $sorting_table->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->packing_type) ?>',2);"><div id="elh_sorting_table_packing_type" class="sorting_table_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<?php if ($sorting_table->sortUrl($sorting_table->quantity_avg_act) == "") { ?>
		<th data-name="quantity_avg_act" class="<?php echo $sorting_table->quantity_avg_act->headerCellClass() ?>"><div id="elh_sorting_table_quantity_avg_act" class="sorting_table_quantity_avg_act"><div class="ew-table-header-caption"><?php echo $sorting_table->quantity_avg_act->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_avg_act" class="<?php echo $sorting_table->quantity_avg_act->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->quantity_avg_act) ?>',2);"><div id="elh_sorting_table_quantity_avg_act" class="sorting_table_quantity_avg_act">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->quantity_avg_act->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->quantity_avg_act->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->quantity_avg_act->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->packets->Visible) { // packets ?>
	<?php if ($sorting_table->sortUrl($sorting_table->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $sorting_table->packets->headerCellClass() ?>"><div id="elh_sorting_table_packets" class="sorting_table_packets"><div class="ew-table-header-caption"><?php echo $sorting_table->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $sorting_table->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->packets) ?>',2);"><div id="elh_sorting_table_packets" class="sorting_table_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->quantity->Visible) { // quantity ?>
	<?php if ($sorting_table->sortUrl($sorting_table->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $sorting_table->quantity->headerCellClass() ?>"><div id="elh_sorting_table_quantity" class="sorting_table_quantity"><div class="ew-table-header-caption"><?php echo $sorting_table->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $sorting_table->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->quantity) ?>',2);"><div id="elh_sorting_table_quantity" class="sorting_table_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->godown->Visible) { // godown ?>
	<?php if ($sorting_table->sortUrl($sorting_table->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $sorting_table->godown->headerCellClass() ?>"><div id="elh_sorting_table_godown" class="sorting_table_godown"><div class="ew-table-header-caption"><?php echo $sorting_table->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $sorting_table->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->godown) ?>',2);"><div id="elh_sorting_table_godown" class="sorting_table_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->dated->Visible) { // dated ?>
	<?php if ($sorting_table->sortUrl($sorting_table->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $sorting_table->dated->headerCellClass() ?>"><div id="elh_sorting_table_dated" class="sorting_table_dated"><div class="ew-table-header-caption"><?php echo $sorting_table->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $sorting_table->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->dated) ?>',2);"><div id="elh_sorting_table_dated" class="sorting_table_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->employee_id->Visible) { // employee_id ?>
	<?php if ($sorting_table->sortUrl($sorting_table->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $sorting_table->employee_id->headerCellClass() ?>"><div id="elh_sorting_table_employee_id" class="sorting_table_employee_id"><div class="ew-table-header-caption"><?php echo $sorting_table->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $sorting_table->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->employee_id) ?>',2);"><div id="elh_sorting_table_employee_id" class="sorting_table_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->next_process->Visible) { // next_process ?>
	<?php if ($sorting_table->sortUrl($sorting_table->next_process) == "") { ?>
		<th data-name="next_process" class="<?php echo $sorting_table->next_process->headerCellClass() ?>"><div id="elh_sorting_table_next_process" class="sorting_table_next_process"><div class="ew-table-header-caption"><?php echo $sorting_table->next_process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="next_process" class="<?php echo $sorting_table->next_process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->next_process) ?>',2);"><div id="elh_sorting_table_next_process" class="sorting_table_next_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->next_process->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->next_process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->next_process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->next_godown->Visible) { // next_godown ?>
	<?php if ($sorting_table->sortUrl($sorting_table->next_godown) == "") { ?>
		<th data-name="next_godown" class="<?php echo $sorting_table->next_godown->headerCellClass() ?>"><div id="elh_sorting_table_next_godown" class="sorting_table_next_godown"><div class="ew-table-header-caption"><?php echo $sorting_table->next_godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="next_godown" class="<?php echo $sorting_table->next_godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->next_godown) ?>',2);"><div id="elh_sorting_table_next_godown" class="sorting_table_next_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->next_godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->next_godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->next_godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->remarks->Visible) { // remarks ?>
	<?php if ($sorting_table->sortUrl($sorting_table->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $sorting_table->remarks->headerCellClass() ?>"><div id="elh_sorting_table_remarks" class="sorting_table_remarks"><div class="ew-table-header-caption"><?php echo $sorting_table->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $sorting_table->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->remarks) ?>',2);"><div id="elh_sorting_table_remarks" class="sorting_table_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->operator->Visible) { // operator ?>
	<?php if ($sorting_table->sortUrl($sorting_table->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $sorting_table->operator->headerCellClass() ?>"><div id="elh_sorting_table_operator" class="sorting_table_operator"><div class="ew-table-header-caption"><?php echo $sorting_table->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $sorting_table->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->operator) ?>',2);"><div id="elh_sorting_table_operator" class="sorting_table_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sorting_table->datetime->Visible) { // datetime ?>
	<?php if ($sorting_table->sortUrl($sorting_table->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $sorting_table->datetime->headerCellClass() ?>"><div id="elh_sorting_table_datetime" class="sorting_table_datetime"><div class="ew-table-header-caption"><?php echo $sorting_table->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $sorting_table->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sorting_table->SortUrl($sorting_table->datetime) ?>',2);"><div id="elh_sorting_table_datetime" class="sorting_table_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sorting_table->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($sorting_table->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sorting_table->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sorting_table_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sorting_table->ExportAll && $sorting_table->isExport()) {
	$sorting_table_list->StopRec = $sorting_table_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sorting_table_list->TotalRecs > $sorting_table_list->StartRec + $sorting_table_list->DisplayRecs - 1)
		$sorting_table_list->StopRec = $sorting_table_list->StartRec + $sorting_table_list->DisplayRecs - 1;
	else
		$sorting_table_list->StopRec = $sorting_table_list->TotalRecs;
}
$sorting_table_list->RecCnt = $sorting_table_list->StartRec - 1;
if ($sorting_table_list->Recordset && !$sorting_table_list->Recordset->EOF) {
	$sorting_table_list->Recordset->moveFirst();
	$selectLimit = $sorting_table_list->UseSelectLimit;
	if (!$selectLimit && $sorting_table_list->StartRec > 1)
		$sorting_table_list->Recordset->move($sorting_table_list->StartRec - 1);
} elseif (!$sorting_table->AllowAddDeleteRow && $sorting_table_list->StopRec == 0) {
	$sorting_table_list->StopRec = $sorting_table->GridAddRowCount;
}

// Initialize aggregate
$sorting_table->RowType = ROWTYPE_AGGREGATEINIT;
$sorting_table->resetAttributes();
$sorting_table_list->renderRow();
while ($sorting_table_list->RecCnt < $sorting_table_list->StopRec) {
	$sorting_table_list->RecCnt++;
	if ($sorting_table_list->RecCnt >= $sorting_table_list->StartRec) {
		$sorting_table_list->RowCnt++;

		// Set up key count
		$sorting_table_list->KeyCount = $sorting_table_list->RowIndex;

		// Init row class and style
		$sorting_table->resetAttributes();
		$sorting_table->CssClass = "";
		if ($sorting_table->isGridAdd()) {
		} else {
			$sorting_table_list->loadRowValues($sorting_table_list->Recordset); // Load row values
		}
		$sorting_table->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sorting_table->RowAttrs = array_merge($sorting_table->RowAttrs, array('data-rowindex'=>$sorting_table_list->RowCnt, 'id'=>'r' . $sorting_table_list->RowCnt . '_sorting_table', 'data-rowtype'=>$sorting_table->RowType));

		// Render row
		$sorting_table_list->renderRow();

		// Render list options
		$sorting_table_list->renderListOptions();
?>
	<tr<?php echo $sorting_table->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sorting_table_list->ListOptions->render("body", "left", $sorting_table_list->RowCnt);
?>
	<?php if ($sorting_table->id->Visible) { // id ?>
		<td data-name="id"<?php echo $sorting_table->id->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_id" class="sorting_table_id">
<span<?php echo $sorting_table->id->viewAttributes() ?>>
<?php echo $sorting_table->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $sorting_table->rid->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_rid" class="sorting_table_rid">
<span<?php echo $sorting_table->rid->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->rid->getViewValue())) && $sorting_table->rid->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->rid->linkAttributes() ?>><?php echo $sorting_table->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->product->Visible) { // product ?>
		<td data-name="product"<?php echo $sorting_table->product->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_product" class="sorting_table_product">
<span<?php echo $sorting_table->product->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->product->getViewValue())) && $sorting_table->product->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->product->linkAttributes() ?>><?php echo $sorting_table->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->sorting_type->Visible) { // sorting_type ?>
		<td data-name="sorting_type"<?php echo $sorting_table->sorting_type->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_sorting_type" class="sorting_table_sorting_type">
<span<?php echo $sorting_table->sorting_type->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->sorting_type->getViewValue())) && $sorting_table->sorting_type->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->sorting_type->linkAttributes() ?>><?php echo $sorting_table->sorting_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->sorting_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $sorting_table->packing_type->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_packing_type" class="sorting_table_packing_type">
<span<?php echo $sorting_table->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->packing_type->getViewValue())) && $sorting_table->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->packing_type->linkAttributes() ?>><?php echo $sorting_table->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act"<?php echo $sorting_table->quantity_avg_act->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_quantity_avg_act" class="sorting_table_quantity_avg_act">
<span<?php echo $sorting_table->quantity_avg_act->viewAttributes() ?>>
<?php echo $sorting_table->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $sorting_table->packets->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_packets" class="sorting_table_packets">
<span<?php echo $sorting_table->packets->viewAttributes() ?>>
<?php echo $sorting_table->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $sorting_table->quantity->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_quantity" class="sorting_table_quantity">
<span<?php echo $sorting_table->quantity->viewAttributes() ?>>
<?php echo $sorting_table->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $sorting_table->godown->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_godown" class="sorting_table_godown">
<span<?php echo $sorting_table->godown->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->godown->getViewValue())) && $sorting_table->godown->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->godown->linkAttributes() ?>><?php echo $sorting_table->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $sorting_table->dated->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_dated" class="sorting_table_dated">
<span<?php echo $sorting_table->dated->viewAttributes() ?>>
<?php echo $sorting_table->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $sorting_table->employee_id->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_employee_id" class="sorting_table_employee_id">
<span<?php echo $sorting_table->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->employee_id->getViewValue())) && $sorting_table->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->employee_id->linkAttributes() ?>><?php echo $sorting_table->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->next_process->Visible) { // next_process ?>
		<td data-name="next_process"<?php echo $sorting_table->next_process->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_next_process" class="sorting_table_next_process">
<span<?php echo $sorting_table->next_process->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->next_process->getViewValue())) && $sorting_table->next_process->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->next_process->linkAttributes() ?>><?php echo $sorting_table->next_process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->next_process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->next_godown->Visible) { // next_godown ?>
		<td data-name="next_godown"<?php echo $sorting_table->next_godown->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_next_godown" class="sorting_table_next_godown">
<span<?php echo $sorting_table->next_godown->viewAttributes() ?>>
<?php echo $sorting_table->next_godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $sorting_table->remarks->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_remarks" class="sorting_table_remarks">
<span<?php echo $sorting_table->remarks->viewAttributes() ?>>
<?php echo $sorting_table->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $sorting_table->operator->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_operator" class="sorting_table_operator">
<span<?php echo $sorting_table->operator->viewAttributes() ?>>
<?php echo $sorting_table->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sorting_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $sorting_table->datetime->cellAttributes() ?>>
<span id="el<?php echo $sorting_table_list->RowCnt ?>_sorting_table_datetime" class="sorting_table_datetime">
<span<?php echo $sorting_table->datetime->viewAttributes() ?>>
<?php echo $sorting_table->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sorting_table_list->ListOptions->render("body", "right", $sorting_table_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$sorting_table->isGridAdd())
		$sorting_table_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$sorting_table->RowType = ROWTYPE_AGGREGATE;
$sorting_table->resetAttributes();
$sorting_table_list->renderRow();
?>
<?php if ($sorting_table_list->TotalRecs > 0 && !$sorting_table->isGridAdd() && !$sorting_table->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$sorting_table_list->renderListOptions();

// Render list options (footer, left)
$sorting_table_list->ListOptions->render("footer", "left");
?>
	<?php if ($sorting_table->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $sorting_table->id->footerCellClass() ?>"><span id="elf_sorting_table_id" class="sorting_table_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $sorting_table->rid->footerCellClass() ?>"><span id="elf_sorting_table_rid" class="sorting_table_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $sorting_table->product->footerCellClass() ?>"><span id="elf_sorting_table_product" class="sorting_table_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->sorting_type->Visible) { // sorting_type ?>
		<td data-name="sorting_type" class="<?php echo $sorting_table->sorting_type->footerCellClass() ?>"><span id="elf_sorting_table_sorting_type" class="sorting_table_sorting_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $sorting_table->packing_type->footerCellClass() ?>"><span id="elf_sorting_table_packing_type" class="sorting_table_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act" class="<?php echo $sorting_table->quantity_avg_act->footerCellClass() ?>"><span id="elf_sorting_table_quantity_avg_act" class="sorting_table_quantity_avg_act">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $sorting_table->packets->footerCellClass() ?>"><span id="elf_sorting_table_packets" class="sorting_table_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $sorting_table->quantity->footerCellClass() ?>"><span id="elf_sorting_table_quantity" class="sorting_table_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $sorting_table->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $sorting_table->godown->footerCellClass() ?>"><span id="elf_sorting_table_godown" class="sorting_table_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $sorting_table->dated->footerCellClass() ?>"><span id="elf_sorting_table_dated" class="sorting_table_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id" class="<?php echo $sorting_table->employee_id->footerCellClass() ?>"><span id="elf_sorting_table_employee_id" class="sorting_table_employee_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->next_process->Visible) { // next_process ?>
		<td data-name="next_process" class="<?php echo $sorting_table->next_process->footerCellClass() ?>"><span id="elf_sorting_table_next_process" class="sorting_table_next_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->next_godown->Visible) { // next_godown ?>
		<td data-name="next_godown" class="<?php echo $sorting_table->next_godown->footerCellClass() ?>"><span id="elf_sorting_table_next_godown" class="sorting_table_next_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $sorting_table->remarks->footerCellClass() ?>"><span id="elf_sorting_table_remarks" class="sorting_table_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $sorting_table->operator->footerCellClass() ?>"><span id="elf_sorting_table_operator" class="sorting_table_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($sorting_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $sorting_table->datetime->footerCellClass() ?>"><span id="elf_sorting_table_datetime" class="sorting_table_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$sorting_table_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$sorting_table->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($sorting_table_list->Recordset)
	$sorting_table_list->Recordset->Close();
?>
<?php if (!$sorting_table->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$sorting_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sorting_table_list->Pager)) $sorting_table_list->Pager = new PrevNextPager($sorting_table_list->StartRec, $sorting_table_list->DisplayRecs, $sorting_table_list->TotalRecs, $sorting_table_list->AutoHidePager) ?>
<?php if ($sorting_table_list->Pager->RecordCount > 0 && $sorting_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sorting_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sorting_table_list->pageUrl() ?>start=<?php echo $sorting_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sorting_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sorting_table_list->pageUrl() ?>start=<?php echo $sorting_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sorting_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sorting_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sorting_table_list->pageUrl() ?>start=<?php echo $sorting_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sorting_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sorting_table_list->pageUrl() ?>start=<?php echo $sorting_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sorting_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sorting_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sorting_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sorting_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sorting_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sorting_table_list->TotalRecs > 0 && (!$sorting_table_list->AutoHidePageSizeSelector || $sorting_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sorting_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sorting_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sorting_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sorting_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sorting_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sorting_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sorting_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sorting_table_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sorting_table_list->TotalRecs == 0 && !$sorting_table->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sorting_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sorting_table_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sorting_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$sorting_table->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sorting_table", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sorting_table_list->terminate();
?>