<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sorting_table_search = new sorting_table_search();

// Run the page
$sorting_table_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sorting_table_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($sorting_table_search->IsModal) { ?>
var fsorting_tablesearch = currentAdvancedSearchForm = new ew.Form("fsorting_tablesearch", "search");
<?php } else { ?>
var fsorting_tablesearch = currentForm = new ew.Form("fsorting_tablesearch", "search");
<?php } ?>

// Form_CustomValidate event
fsorting_tablesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsorting_tablesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsorting_tablesearch.lists["x_rid"] = <?php echo $sorting_table_search->rid->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_rid"].options = <?php echo JsonEncode($sorting_table_search->rid->lookupOptions()) ?>;
fsorting_tablesearch.lists["x_product"] = <?php echo $sorting_table_search->product->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_product"].options = <?php echo JsonEncode($sorting_table_search->product->lookupOptions()) ?>;
fsorting_tablesearch.lists["x_ref"] = <?php echo $sorting_table_search->ref->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_ref"].options = <?php echo JsonEncode($sorting_table_search->ref->lookupOptions()) ?>;
fsorting_tablesearch.lists["x_sorting_type"] = <?php echo $sorting_table_search->sorting_type->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_sorting_type"].options = <?php echo JsonEncode($sorting_table_search->sorting_type->lookupOptions()) ?>;
fsorting_tablesearch.lists["x_packing_type"] = <?php echo $sorting_table_search->packing_type->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_packing_type"].options = <?php echo JsonEncode($sorting_table_search->packing_type->lookupOptions()) ?>;
fsorting_tablesearch.lists["x_quantity_avg_act"] = <?php echo $sorting_table_search->quantity_avg_act->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($sorting_table_search->quantity_avg_act->options(FALSE, TRUE)) ?>;
fsorting_tablesearch.lists["x_godown"] = <?php echo $sorting_table_search->godown->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_godown"].options = <?php echo JsonEncode($sorting_table_search->godown->lookupOptions()) ?>;
fsorting_tablesearch.lists["x_employee_id[]"] = <?php echo $sorting_table_search->employee_id->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_employee_id[]"].options = <?php echo JsonEncode($sorting_table_search->employee_id->lookupOptions()) ?>;
fsorting_tablesearch.lists["x_next_issue_yn"] = <?php echo $sorting_table_search->next_issue_yn->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_next_issue_yn"].options = <?php echo JsonEncode($sorting_table_search->next_issue_yn->options(FALSE, TRUE)) ?>;
fsorting_tablesearch.lists["x_next_process"] = <?php echo $sorting_table_search->next_process->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_next_process"].options = <?php echo JsonEncode($sorting_table_search->next_process->lookupOptions()) ?>;
fsorting_tablesearch.lists["x_next_godown"] = <?php echo $sorting_table_search->next_godown->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_next_godown"].options = <?php echo JsonEncode($sorting_table_search->next_godown->lookupOptions()) ?>;
fsorting_tablesearch.lists["x_operator"] = <?php echo $sorting_table_search->operator->Lookup->toClientList() ?>;
fsorting_tablesearch.lists["x_operator"].options = <?php echo JsonEncode($sorting_table_search->operator->lookupOptions()) ?>;
fsorting_tablesearch.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fsorting_tablesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_table->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_table->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_table->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_table->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_table->operator->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sorting_table_search->showPageHeader(); ?>
<?php
$sorting_table_search->showMessage();
?>
<form name="fsorting_tablesearch" id="fsorting_tablesearch" class="<?php echo $sorting_table_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sorting_table_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sorting_table_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sorting_table">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$sorting_table_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($sorting_table->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_id"><?php echo $sorting_table->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->id->cellAttributes() ?>>
			<span id="el_sorting_table_id">
<input type="text" data-table="sorting_table" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($sorting_table->id->getPlaceHolder()) ?>" value="<?php echo $sorting_table->id->EditValue ?>"<?php echo $sorting_table->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_rid"><?php echo $sorting_table->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->rid->cellAttributes() ?>>
			<span id="el_sorting_table_rid">
<div id="tp_x_rid" class="ew-template"><input type="radio" class="form-check-input" data-table="sorting_table" data-field="x_rid" data-value-separator="<?php echo $sorting_table->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="{value}"<?php echo $sorting_table->rid->editAttributes() ?>></div>
<div id="dsl_x_rid" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $sorting_table->rid->radioButtonListHtml(FALSE, "x_rid") ?>
</div></div>
<?php echo $sorting_table->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_product"><?php echo $sorting_table->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->product->cellAttributes() ?>>
			<span id="el_sorting_table_product">
<?php $sorting_table->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$sorting_table->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_table" data-field="x_product" data-value-separator="<?php echo $sorting_table->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $sorting_table->product->editAttributes() ?>>
		<?php echo $sorting_table->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $sorting_table->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_ref"><?php echo $sorting_table->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ref" id="z_ref" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->ref->cellAttributes() ?>>
			<span id="el_sorting_table_ref">
<div id="tp_x_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="sorting_table" data-field="x_ref" data-value-separator="<?php echo $sorting_table->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="{value}"<?php echo $sorting_table->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $sorting_table->ref->radioButtonListHtml(FALSE, "x_ref") ?>
</div></div>
<?php echo $sorting_table->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->sorting_type->Visible) { // sorting_type ?>
	<div id="r_sorting_type" class="form-group row">
		<label for="x_sorting_type" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_sorting_type"><?php echo $sorting_table->sorting_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sorting_type" id="z_sorting_type" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->sorting_type->cellAttributes() ?>>
			<span id="el_sorting_table_sorting_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_table" data-field="x_sorting_type" data-value-separator="<?php echo $sorting_table->sorting_type->displayValueSeparatorAttribute() ?>" id="x_sorting_type" name="x_sorting_type"<?php echo $sorting_table->sorting_type->editAttributes() ?>>
		<?php echo $sorting_table->sorting_type->selectOptionListHtml("x_sorting_type") ?>
	</select>
</div>
<?php echo $sorting_table->sorting_type->Lookup->getParamTag("p_x_sorting_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_packing_type"><?php echo $sorting_table->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->packing_type->cellAttributes() ?>>
			<span id="el_sorting_table_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_table" data-field="x_packing_type" data-value-separator="<?php echo $sorting_table->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $sorting_table->packing_type->editAttributes() ?>>
		<?php echo $sorting_table->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $sorting_table->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_quantity_avg_act"><?php echo $sorting_table->quantity_avg_act->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity_avg_act" id="z_quantity_avg_act" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->quantity_avg_act->cellAttributes() ?>>
			<span id="el_sorting_table_quantity_avg_act">
<div id="tp_x_quantity_avg_act" class="ew-template"><input type="radio" class="form-check-input" data-table="sorting_table" data-field="x_quantity_avg_act" data-value-separator="<?php echo $sorting_table->quantity_avg_act->displayValueSeparatorAttribute() ?>" name="x_quantity_avg_act" id="x_quantity_avg_act" value="{value}"<?php echo $sorting_table->quantity_avg_act->editAttributes() ?>></div>
<div id="dsl_x_quantity_avg_act" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $sorting_table->quantity_avg_act->radioButtonListHtml(FALSE, "x_quantity_avg_act") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_packets"><?php echo $sorting_table->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->packets->cellAttributes() ?>>
			<span id="el_sorting_table_packets">
<input type="text" data-table="sorting_table" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($sorting_table->packets->getPlaceHolder()) ?>" value="<?php echo $sorting_table->packets->EditValue ?>"<?php echo $sorting_table->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->avg_yield->Visible) { // avg_yield ?>
	<div id="r_avg_yield" class="form-group row">
		<label for="x_avg_yield" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_avg_yield"><?php echo $sorting_table->avg_yield->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_avg_yield" id="z_avg_yield" value="LIKE"></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->avg_yield->cellAttributes() ?>>
			<span id="el_sorting_table_avg_yield">
<input type="text" data-table="sorting_table" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" placeholder="<?php echo HtmlEncode($sorting_table->avg_yield->getPlaceHolder()) ?>" value="<?php echo $sorting_table->avg_yield->EditValue ?>"<?php echo $sorting_table->avg_yield->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_quantity"><?php echo $sorting_table->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->quantity->cellAttributes() ?>>
			<span id="el_sorting_table_quantity">
<input type="text" data-table="sorting_table" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($sorting_table->quantity->getPlaceHolder()) ?>" value="<?php echo $sorting_table->quantity->EditValue ?>"<?php echo $sorting_table->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label for="x_max_qty" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_max_qty"><?php echo $sorting_table->max_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_max_qty" id="z_max_qty" value="LIKE"></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->max_qty->cellAttributes() ?>>
			<span id="el_sorting_table_max_qty">
<input type="text" data-table="sorting_table" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" placeholder="<?php echo HtmlEncode($sorting_table->max_qty->getPlaceHolder()) ?>" value="<?php echo $sorting_table->max_qty->EditValue ?>"<?php echo $sorting_table->max_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_godown"><?php echo $sorting_table->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->godown->cellAttributes() ?>>
			<span id="el_sorting_table_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_table" data-field="x_godown" data-value-separator="<?php echo $sorting_table->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $sorting_table->godown->editAttributes() ?>>
		<?php echo $sorting_table->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $sorting_table->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_dated"><?php echo $sorting_table->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->dated->cellAttributes() ?>>
			<span id="el_sorting_table_dated">
<input type="text" data-table="sorting_table" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($sorting_table->dated->getPlaceHolder()) ?>" value="<?php echo $sorting_table->dated->EditValue ?>"<?php echo $sorting_table->dated->editAttributes() ?>>
<?php if (!$sorting_table->dated->ReadOnly && !$sorting_table->dated->Disabled && !isset($sorting_table->dated->EditAttrs["readonly"]) && !isset($sorting_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsorting_tablesearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label for="x_employee_id" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_employee_id"><?php echo $sorting_table->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->employee_id->cellAttributes() ?>>
			<span id="el_sorting_table_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($sorting_table->employee_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($sorting_table->employee_id->AdvancedSearch->ViewValue) : $sorting_table->employee_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($sorting_table->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($sorting_table->employee_id->ReadOnly || $sorting_table->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:20});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $sorting_table->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="sorting_table" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $sorting_table->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $sorting_table->employee_id->AdvancedSearch->SearchValue ?>"<?php echo $sorting_table->employee_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->next_issue_yn->Visible) { // next_issue_yn ?>
	<div id="r_next_issue_yn" class="form-group row">
		<label class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_next_issue_yn"><?php echo $sorting_table->next_issue_yn->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_next_issue_yn" id="z_next_issue_yn" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->next_issue_yn->cellAttributes() ?>>
			<span id="el_sorting_table_next_issue_yn">
<div id="tp_x_next_issue_yn" class="ew-template"><input type="radio" class="form-check-input" data-table="sorting_table" data-field="x_next_issue_yn" data-value-separator="<?php echo $sorting_table->next_issue_yn->displayValueSeparatorAttribute() ?>" name="x_next_issue_yn" id="x_next_issue_yn" value="{value}"<?php echo $sorting_table->next_issue_yn->editAttributes() ?>></div>
<div id="dsl_x_next_issue_yn" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $sorting_table->next_issue_yn->radioButtonListHtml(FALSE, "x_next_issue_yn") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->next_process->Visible) { // next_process ?>
	<div id="r_next_process" class="form-group row">
		<label class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_next_process"><?php echo $sorting_table->next_process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_next_process" id="z_next_process" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->next_process->cellAttributes() ?>>
			<span id="el_sorting_table_next_process">
<div id="tp_x_next_process" class="ew-template"><input type="radio" class="form-check-input" data-table="sorting_table" data-field="x_next_process" data-value-separator="<?php echo $sorting_table->next_process->displayValueSeparatorAttribute() ?>" name="x_next_process" id="x_next_process" value="{value}"<?php echo $sorting_table->next_process->editAttributes() ?>></div>
<div id="dsl_x_next_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $sorting_table->next_process->radioButtonListHtml(FALSE, "x_next_process") ?>
</div></div>
<?php echo $sorting_table->next_process->Lookup->getParamTag("p_x_next_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->next_godown->Visible) { // next_godown ?>
	<div id="r_next_godown" class="form-group row">
		<label for="x_next_godown" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_next_godown"><?php echo $sorting_table->next_godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_next_godown" id="z_next_godown" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->next_godown->cellAttributes() ?>>
			<span id="el_sorting_table_next_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sorting_table" data-field="x_next_godown" data-value-separator="<?php echo $sorting_table->next_godown->displayValueSeparatorAttribute() ?>" id="x_next_godown" name="x_next_godown"<?php echo $sorting_table->next_godown->editAttributes() ?>>
		<?php echo $sorting_table->next_godown->selectOptionListHtml("x_next_godown") ?>
	</select>
</div>
<?php echo $sorting_table->next_godown->Lookup->getParamTag("p_x_next_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_remarks"><?php echo $sorting_table->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->remarks->cellAttributes() ?>>
			<span id="el_sorting_table_remarks">
<input type="text" data-table="sorting_table" data-field="x_remarks" name="x_remarks" id="x_remarks" size="31" maxlength="255" placeholder="<?php echo HtmlEncode($sorting_table->remarks->getPlaceHolder()) ?>" value="<?php echo $sorting_table->remarks->EditValue ?>"<?php echo $sorting_table->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_operator"><?php echo $sorting_table->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->operator->cellAttributes() ?>>
			<span id="el_sorting_table_operator">
<?php
$wrkonchange = "" . trim(@$sorting_table->operator->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$sorting_table->operator->EditAttrs["onchange"] = "";
?>
<span id="as_x_operator" class="text-nowrap" style="z-index: 8810">
	<input type="text" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?php echo RemoveHtml($sorting_table->operator->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($sorting_table->operator->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($sorting_table->operator->getPlaceHolder()) ?>"<?php echo $sorting_table->operator->editAttributes() ?>>
</span>
<input type="hidden" data-table="sorting_table" data-field="x_operator" data-value-separator="<?php echo $sorting_table->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($sorting_table->operator->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fsorting_tablesearch.createAutoSuggest({"id":"x_operator","forceSelect":false});
</script>
<?php echo $sorting_table->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_table->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $sorting_table_search->LeftColumnClass ?>"><span id="elh_sorting_table_datetime"><?php echo $sorting_table->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $sorting_table_search->RightColumnClass ?>"><div<?php echo $sorting_table->datetime->cellAttributes() ?>>
			<span id="el_sorting_table_datetime">
<input type="text" data-table="sorting_table" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($sorting_table->datetime->getPlaceHolder()) ?>" value="<?php echo $sorting_table->datetime->EditValue ?>"<?php echo $sorting_table->datetime->editAttributes() ?>>
<?php if (!$sorting_table->datetime->ReadOnly && !$sorting_table->datetime->Disabled && !isset($sorting_table->datetime->EditAttrs["readonly"]) && !isset($sorting_table->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsorting_tablesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sorting_table_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sorting_table_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sorting_table_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sorting_table_search->terminate();
?>