<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sorting_table_view = new sorting_table_view();

// Run the page
$sorting_table_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sorting_table_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sorting_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsorting_tableview = currentForm = new ew.Form("fsorting_tableview", "view");

// Form_CustomValidate event
fsorting_tableview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsorting_tableview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsorting_tableview.lists["x_rid"] = <?php echo $sorting_table_view->rid->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_rid"].options = <?php echo JsonEncode($sorting_table_view->rid->lookupOptions()) ?>;
fsorting_tableview.lists["x_product"] = <?php echo $sorting_table_view->product->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_product"].options = <?php echo JsonEncode($sorting_table_view->product->lookupOptions()) ?>;
fsorting_tableview.lists["x_ref"] = <?php echo $sorting_table_view->ref->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_ref"].options = <?php echo JsonEncode($sorting_table_view->ref->lookupOptions()) ?>;
fsorting_tableview.lists["x_sorting_type"] = <?php echo $sorting_table_view->sorting_type->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_sorting_type"].options = <?php echo JsonEncode($sorting_table_view->sorting_type->lookupOptions()) ?>;
fsorting_tableview.lists["x_packing_type"] = <?php echo $sorting_table_view->packing_type->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_packing_type"].options = <?php echo JsonEncode($sorting_table_view->packing_type->lookupOptions()) ?>;
fsorting_tableview.lists["x_quantity_avg_act"] = <?php echo $sorting_table_view->quantity_avg_act->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($sorting_table_view->quantity_avg_act->options(FALSE, TRUE)) ?>;
fsorting_tableview.lists["x_godown"] = <?php echo $sorting_table_view->godown->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_godown"].options = <?php echo JsonEncode($sorting_table_view->godown->lookupOptions()) ?>;
fsorting_tableview.lists["x_employee_id[]"] = <?php echo $sorting_table_view->employee_id->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_employee_id[]"].options = <?php echo JsonEncode($sorting_table_view->employee_id->lookupOptions()) ?>;
fsorting_tableview.lists["x_next_issue_yn"] = <?php echo $sorting_table_view->next_issue_yn->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_next_issue_yn"].options = <?php echo JsonEncode($sorting_table_view->next_issue_yn->options(FALSE, TRUE)) ?>;
fsorting_tableview.lists["x_next_process"] = <?php echo $sorting_table_view->next_process->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_next_process"].options = <?php echo JsonEncode($sorting_table_view->next_process->lookupOptions()) ?>;
fsorting_tableview.lists["x_next_godown"] = <?php echo $sorting_table_view->next_godown->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_next_godown"].options = <?php echo JsonEncode($sorting_table_view->next_godown->lookupOptions()) ?>;
fsorting_tableview.lists["x_operator"] = <?php echo $sorting_table_view->operator->Lookup->toClientList() ?>;
fsorting_tableview.lists["x_operator"].options = <?php echo JsonEncode($sorting_table_view->operator->lookupOptions()) ?>;
fsorting_tableview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sorting_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $sorting_table_view->ExportOptions->render("body") ?>
<?php $sorting_table_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $sorting_table_view->showPageHeader(); ?>
<?php
$sorting_table_view->showMessage();
?>
<form name="fsorting_tableview" id="fsorting_tableview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sorting_table_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sorting_table_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sorting_table">
<input type="hidden" name="modal" value="<?php echo (int)$sorting_table_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($sorting_table->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_id"><?php echo $sorting_table->id->caption() ?></span></td>
		<td data-name="id"<?php echo $sorting_table->id->cellAttributes() ?>>
<span id="el_sorting_table_id">
<span<?php echo $sorting_table->id->viewAttributes() ?>>
<?php echo $sorting_table->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_rid"><?php echo $sorting_table->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $sorting_table->rid->cellAttributes() ?>>
<span id="el_sorting_table_rid">
<span<?php echo $sorting_table->rid->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->rid->getViewValue())) && $sorting_table->rid->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->rid->linkAttributes() ?>><?php echo $sorting_table->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_product"><?php echo $sorting_table->product->caption() ?></span></td>
		<td data-name="product"<?php echo $sorting_table->product->cellAttributes() ?>>
<span id="el_sorting_table_product">
<span<?php echo $sorting_table->product->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->product->getViewValue())) && $sorting_table->product->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->product->linkAttributes() ?>><?php echo $sorting_table->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->ref->Visible) { // ref ?>
	<tr id="r_ref">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_ref"><?php echo $sorting_table->ref->caption() ?></span></td>
		<td data-name="ref"<?php echo $sorting_table->ref->cellAttributes() ?>>
<span id="el_sorting_table_ref">
<span<?php echo $sorting_table->ref->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->ref->getViewValue())) && $sorting_table->ref->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->ref->linkAttributes() ?>><?php echo $sorting_table->ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->sorting_type->Visible) { // sorting_type ?>
	<tr id="r_sorting_type">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_sorting_type"><?php echo $sorting_table->sorting_type->caption() ?></span></td>
		<td data-name="sorting_type"<?php echo $sorting_table->sorting_type->cellAttributes() ?>>
<span id="el_sorting_table_sorting_type">
<span<?php echo $sorting_table->sorting_type->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->sorting_type->getViewValue())) && $sorting_table->sorting_type->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->sorting_type->linkAttributes() ?>><?php echo $sorting_table->sorting_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->sorting_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_packing_type"><?php echo $sorting_table->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $sorting_table->packing_type->cellAttributes() ?>>
<span id="el_sorting_table_packing_type">
<span<?php echo $sorting_table->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->packing_type->getViewValue())) && $sorting_table->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->packing_type->linkAttributes() ?>><?php echo $sorting_table->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<tr id="r_quantity_avg_act">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_quantity_avg_act"><?php echo $sorting_table->quantity_avg_act->caption() ?></span></td>
		<td data-name="quantity_avg_act"<?php echo $sorting_table->quantity_avg_act->cellAttributes() ?>>
<span id="el_sorting_table_quantity_avg_act">
<span<?php echo $sorting_table->quantity_avg_act->viewAttributes() ?>>
<?php echo $sorting_table->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->packets->Visible) { // packets ?>
	<tr id="r_packets">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_packets"><?php echo $sorting_table->packets->caption() ?></span></td>
		<td data-name="packets"<?php echo $sorting_table->packets->cellAttributes() ?>>
<span id="el_sorting_table_packets">
<span<?php echo $sorting_table->packets->viewAttributes() ?>>
<?php echo $sorting_table->packets->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->avg_yield->Visible) { // avg_yield ?>
	<tr id="r_avg_yield">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_avg_yield"><?php echo $sorting_table->avg_yield->caption() ?></span></td>
		<td data-name="avg_yield"<?php echo $sorting_table->avg_yield->cellAttributes() ?>>
<span id="el_sorting_table_avg_yield">
<span<?php echo $sorting_table->avg_yield->viewAttributes() ?>>
<?php echo $sorting_table->avg_yield->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_quantity"><?php echo $sorting_table->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $sorting_table->quantity->cellAttributes() ?>>
<span id="el_sorting_table_quantity">
<span<?php echo $sorting_table->quantity->viewAttributes() ?>>
<?php echo $sorting_table->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->max_qty->Visible) { // max_qty ?>
	<tr id="r_max_qty">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_max_qty"><?php echo $sorting_table->max_qty->caption() ?></span></td>
		<td data-name="max_qty"<?php echo $sorting_table->max_qty->cellAttributes() ?>>
<span id="el_sorting_table_max_qty">
<span<?php echo $sorting_table->max_qty->viewAttributes() ?>>
<?php echo $sorting_table->max_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->godown->Visible) { // godown ?>
	<tr id="r_godown">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_godown"><?php echo $sorting_table->godown->caption() ?></span></td>
		<td data-name="godown"<?php echo $sorting_table->godown->cellAttributes() ?>>
<span id="el_sorting_table_godown">
<span<?php echo $sorting_table->godown->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->godown->getViewValue())) && $sorting_table->godown->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->godown->linkAttributes() ?>><?php echo $sorting_table->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_dated"><?php echo $sorting_table->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $sorting_table->dated->cellAttributes() ?>>
<span id="el_sorting_table_dated">
<span<?php echo $sorting_table->dated->viewAttributes() ?>>
<?php echo $sorting_table->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->employee_id->Visible) { // employee_id ?>
	<tr id="r_employee_id">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_employee_id"><?php echo $sorting_table->employee_id->caption() ?></span></td>
		<td data-name="employee_id"<?php echo $sorting_table->employee_id->cellAttributes() ?>>
<span id="el_sorting_table_employee_id">
<span<?php echo $sorting_table->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->employee_id->getViewValue())) && $sorting_table->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->employee_id->linkAttributes() ?>><?php echo $sorting_table->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->next_issue_yn->Visible) { // next_issue_yn ?>
	<tr id="r_next_issue_yn">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_next_issue_yn"><?php echo $sorting_table->next_issue_yn->caption() ?></span></td>
		<td data-name="next_issue_yn"<?php echo $sorting_table->next_issue_yn->cellAttributes() ?>>
<span id="el_sorting_table_next_issue_yn">
<span<?php echo $sorting_table->next_issue_yn->viewAttributes() ?>>
<?php echo $sorting_table->next_issue_yn->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->next_process->Visible) { // next_process ?>
	<tr id="r_next_process">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_next_process"><?php echo $sorting_table->next_process->caption() ?></span></td>
		<td data-name="next_process"<?php echo $sorting_table->next_process->cellAttributes() ?>>
<span id="el_sorting_table_next_process">
<span<?php echo $sorting_table->next_process->viewAttributes() ?>>
<?php if ((!EmptyString($sorting_table->next_process->getViewValue())) && $sorting_table->next_process->linkAttributes() <> "") { ?>
<a<?php echo $sorting_table->next_process->linkAttributes() ?>><?php echo $sorting_table->next_process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sorting_table->next_process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->next_godown->Visible) { // next_godown ?>
	<tr id="r_next_godown">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_next_godown"><?php echo $sorting_table->next_godown->caption() ?></span></td>
		<td data-name="next_godown"<?php echo $sorting_table->next_godown->cellAttributes() ?>>
<span id="el_sorting_table_next_godown">
<span<?php echo $sorting_table->next_godown->viewAttributes() ?>>
<?php echo $sorting_table->next_godown->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_remarks"><?php echo $sorting_table->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $sorting_table->remarks->cellAttributes() ?>>
<span id="el_sorting_table_remarks">
<span<?php echo $sorting_table->remarks->viewAttributes() ?>>
<?php echo $sorting_table->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_operator"><?php echo $sorting_table->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $sorting_table->operator->cellAttributes() ?>>
<span id="el_sorting_table_operator">
<span<?php echo $sorting_table->operator->viewAttributes() ?>>
<?php echo $sorting_table->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sorting_table->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $sorting_table_view->TableLeftColumnClass ?>"><span id="elh_sorting_table_datetime"><?php echo $sorting_table->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $sorting_table->datetime->cellAttributes() ?>>
<span id="el_sorting_table_datetime">
<span<?php echo $sorting_table->datetime->viewAttributes() ?>>
<?php echo $sorting_table->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$sorting_table_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sorting_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sorting_table_view->terminate();
?>