<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sorting_type_search = new sorting_type_search();

// Run the page
$sorting_type_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sorting_type_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($sorting_type_search->IsModal) { ?>
var fsorting_typesearch = currentAdvancedSearchForm = new ew.Form("fsorting_typesearch", "search");
<?php } else { ?>
var fsorting_typesearch = currentForm = new ew.Form("fsorting_typesearch", "search");
<?php } ?>

// Form_CustomValidate event
fsorting_typesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsorting_typesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search
// Validate function for search

fsorting_typesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_type->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_process");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_type->process->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_type->product->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avg_yield");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_type->avg_yield->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_status");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_type->status->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_type->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sorting_type->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sorting_type_search->showPageHeader(); ?>
<?php
$sorting_type_search->showMessage();
?>
<form name="fsorting_typesearch" id="fsorting_typesearch" class="<?php echo $sorting_type_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sorting_type_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sorting_type_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sorting_type">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$sorting_type_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($sorting_type->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_id"><?php echo $sorting_type->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->id->cellAttributes() ?>>
			<span id="el_sorting_type_id">
<input type="text" data-table="sorting_type" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($sorting_type->id->getPlaceHolder()) ?>" value="<?php echo $sorting_type->id->EditValue ?>"<?php echo $sorting_type->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_type->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_process"><?php echo $sorting_type->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->process->cellAttributes() ?>>
			<span id="el_sorting_type_process">
<input type="text" data-table="sorting_type" data-field="x_process" name="x_process" id="x_process" size="30" placeholder="<?php echo HtmlEncode($sorting_type->process->getPlaceHolder()) ?>" value="<?php echo $sorting_type->process->EditValue ?>"<?php echo $sorting_type->process->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_type->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_product"><?php echo $sorting_type->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->product->cellAttributes() ?>>
			<span id="el_sorting_type_product">
<input type="text" data-table="sorting_type" data-field="x_product" name="x_product" id="x_product" size="30" placeholder="<?php echo HtmlEncode($sorting_type->product->getPlaceHolder()) ?>" value="<?php echo $sorting_type->product->EditValue ?>"<?php echo $sorting_type->product->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_type->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_name"><?php echo $sorting_type->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->name->cellAttributes() ?>>
			<span id="el_sorting_type_name">
<input type="text" data-table="sorting_type" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($sorting_type->name->getPlaceHolder()) ?>" value="<?php echo $sorting_type->name->EditValue ?>"<?php echo $sorting_type->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_type->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_code"><?php echo $sorting_type->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->code->cellAttributes() ?>>
			<span id="el_sorting_type_code">
<input type="text" data-table="sorting_type" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($sorting_type->code->getPlaceHolder()) ?>" value="<?php echo $sorting_type->code->EditValue ?>"<?php echo $sorting_type->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_type->avg_yield->Visible) { // avg_yield ?>
	<div id="r_avg_yield" class="form-group row">
		<label for="x_avg_yield" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_avg_yield"><?php echo $sorting_type->avg_yield->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avg_yield" id="z_avg_yield" value="="></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->avg_yield->cellAttributes() ?>>
			<span id="el_sorting_type_avg_yield">
<input type="text" data-table="sorting_type" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" size="30" placeholder="<?php echo HtmlEncode($sorting_type->avg_yield->getPlaceHolder()) ?>" value="<?php echo $sorting_type->avg_yield->EditValue ?>"<?php echo $sorting_type->avg_yield->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_type->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_remarks"><?php echo $sorting_type->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->remarks->cellAttributes() ?>>
			<span id="el_sorting_type_remarks">
<input type="text" data-table="sorting_type" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($sorting_type->remarks->getPlaceHolder()) ?>" value="<?php echo $sorting_type->remarks->EditValue ?>"<?php echo $sorting_type->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_status"><?php echo $sorting_type->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->status->cellAttributes() ?>>
			<span id="el_sorting_type_status">
<input type="text" data-table="sorting_type" data-field="x_status" name="x_status" id="x_status" size="30" placeholder="<?php echo HtmlEncode($sorting_type->status->getPlaceHolder()) ?>" value="<?php echo $sorting_type->status->EditValue ?>"<?php echo $sorting_type->status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_type->UID->Visible) { // UID ?>
	<div id="r_UID" class="form-group row">
		<label for="x_UID" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_UID"><?php echo $sorting_type->UID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_UID" id="z_UID" value="LIKE"></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->UID->cellAttributes() ?>>
			<span id="el_sorting_type_UID">
<input type="text" data-table="sorting_type" data-field="x_UID" name="x_UID" id="x_UID" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($sorting_type->UID->getPlaceHolder()) ?>" value="<?php echo $sorting_type->UID->EditValue ?>"<?php echo $sorting_type->UID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_type->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_operator"><?php echo $sorting_type->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->operator->cellAttributes() ?>>
			<span id="el_sorting_type_operator">
<input type="text" data-table="sorting_type" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($sorting_type->operator->getPlaceHolder()) ?>" value="<?php echo $sorting_type->operator->EditValue ?>"<?php echo $sorting_type->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sorting_type->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $sorting_type_search->LeftColumnClass ?>"><span id="elh_sorting_type_datetime"><?php echo $sorting_type->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $sorting_type_search->RightColumnClass ?>"><div<?php echo $sorting_type->datetime->cellAttributes() ?>>
			<span id="el_sorting_type_datetime">
<input type="text" data-table="sorting_type" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($sorting_type->datetime->getPlaceHolder()) ?>" value="<?php echo $sorting_type->datetime->EditValue ?>"<?php echo $sorting_type->datetime->editAttributes() ?>>
<?php if (!$sorting_type->datetime->ReadOnly && !$sorting_type->datetime->Disabled && !isset($sorting_type->datetime->EditAttrs["readonly"]) && !isset($sorting_type->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsorting_typesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sorting_type_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sorting_type_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sorting_type_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sorting_type_search->terminate();
?>