<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$special_permissions_view = new special_permissions_view();

// Run the page
$special_permissions_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$special_permissions_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$special_permissions->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fspecial_permissionsview = currentForm = new ew.Form("fspecial_permissionsview", "view");

// Form_CustomValidate event
fspecial_permissionsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fspecial_permissionsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fspecial_permissionsview.lists["x_user_id[]"] = <?php echo $special_permissions_view->user_id->Lookup->toClientList() ?>;
fspecial_permissionsview.lists["x_user_id[]"].options = <?php echo JsonEncode($special_permissions_view->user_id->lookupOptions()) ?>;
fspecial_permissionsview.lists["x__tablename"] = <?php echo $special_permissions_view->_tablename->Lookup->toClientList() ?>;
fspecial_permissionsview.lists["x__tablename"].options = <?php echo JsonEncode($special_permissions_view->_tablename->lookupOptions()) ?>;
fspecial_permissionsview.lists["x_field"] = <?php echo $special_permissions_view->field->Lookup->toClientList() ?>;
fspecial_permissionsview.lists["x_field"].options = <?php echo JsonEncode($special_permissions_view->field->lookupOptions()) ?>;
fspecial_permissionsview.lists["x_field_operator"] = <?php echo $special_permissions_view->field_operator->Lookup->toClientList() ?>;
fspecial_permissionsview.lists["x_field_operator"].options = <?php echo JsonEncode($special_permissions_view->field_operator->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$special_permissions->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $special_permissions_view->ExportOptions->render("body") ?>
<?php $special_permissions_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $special_permissions_view->showPageHeader(); ?>
<?php
$special_permissions_view->showMessage();
?>
<form name="fspecial_permissionsview" id="fspecial_permissionsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($special_permissions_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $special_permissions_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="special_permissions">
<input type="hidden" name="modal" value="<?php echo (int)$special_permissions_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($special_permissions->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $special_permissions_view->TableLeftColumnClass ?>"><span id="elh_special_permissions_id"><?php echo $special_permissions->id->caption() ?></span></td>
		<td data-name="id"<?php echo $special_permissions->id->cellAttributes() ?>>
<span id="el_special_permissions_id">
<span<?php echo $special_permissions->id->viewAttributes() ?>>
<?php echo $special_permissions->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_permissions->user_id->Visible) { // user_id ?>
	<tr id="r_user_id">
		<td class="<?php echo $special_permissions_view->TableLeftColumnClass ?>"><span id="elh_special_permissions_user_id"><?php echo $special_permissions->user_id->caption() ?></span></td>
		<td data-name="user_id"<?php echo $special_permissions->user_id->cellAttributes() ?>>
<span id="el_special_permissions_user_id">
<span<?php echo $special_permissions->user_id->viewAttributes() ?>>
<?php echo $special_permissions->user_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_permissions->_tablename->Visible) { // tablename ?>
	<tr id="r__tablename">
		<td class="<?php echo $special_permissions_view->TableLeftColumnClass ?>"><span id="elh_special_permissions__tablename"><?php echo $special_permissions->_tablename->caption() ?></span></td>
		<td data-name="_tablename"<?php echo $special_permissions->_tablename->cellAttributes() ?>>
<span id="el_special_permissions__tablename">
<span<?php echo $special_permissions->_tablename->viewAttributes() ?>>
<?php echo $special_permissions->_tablename->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_permissions->field->Visible) { // field ?>
	<tr id="r_field">
		<td class="<?php echo $special_permissions_view->TableLeftColumnClass ?>"><span id="elh_special_permissions_field"><?php echo $special_permissions->field->caption() ?></span></td>
		<td data-name="field"<?php echo $special_permissions->field->cellAttributes() ?>>
<span id="el_special_permissions_field">
<span<?php echo $special_permissions->field->viewAttributes() ?>>
<?php echo $special_permissions->field->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_permissions->field_operator->Visible) { // field_operator ?>
	<tr id="r_field_operator">
		<td class="<?php echo $special_permissions_view->TableLeftColumnClass ?>"><span id="elh_special_permissions_field_operator"><?php echo $special_permissions->field_operator->caption() ?></span></td>
		<td data-name="field_operator"<?php echo $special_permissions->field_operator->cellAttributes() ?>>
<span id="el_special_permissions_field_operator">
<span<?php echo $special_permissions->field_operator->viewAttributes() ?>>
<?php echo $special_permissions->field_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_permissions->field_value->Visible) { // field_value ?>
	<tr id="r_field_value">
		<td class="<?php echo $special_permissions_view->TableLeftColumnClass ?>"><span id="elh_special_permissions_field_value"><?php echo $special_permissions->field_value->caption() ?></span></td>
		<td data-name="field_value"<?php echo $special_permissions->field_value->cellAttributes() ?>>
<span id="el_special_permissions_field_value">
<span<?php echo $special_permissions->field_value->viewAttributes() ?>>
<?php echo $special_permissions->field_value->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_permissions->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $special_permissions_view->TableLeftColumnClass ?>"><span id="elh_special_permissions_code"><?php echo $special_permissions->code->caption() ?></span></td>
		<td data-name="code"<?php echo $special_permissions->code->cellAttributes() ?>>
<span id="el_special_permissions_code">
<span<?php echo $special_permissions->code->viewAttributes() ?>>
<?php echo $special_permissions->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_permissions->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $special_permissions_view->TableLeftColumnClass ?>"><span id="elh_special_permissions_remarks"><?php echo $special_permissions->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $special_permissions->remarks->cellAttributes() ?>>
<span id="el_special_permissions_remarks">
<span<?php echo $special_permissions->remarks->viewAttributes() ?>>
<?php echo $special_permissions->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_permissions->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $special_permissions_view->TableLeftColumnClass ?>"><span id="elh_special_permissions_operator"><?php echo $special_permissions->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $special_permissions->operator->cellAttributes() ?>>
<span id="el_special_permissions_operator">
<span<?php echo $special_permissions->operator->viewAttributes() ?>>
<?php echo $special_permissions->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_permissions->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $special_permissions_view->TableLeftColumnClass ?>"><span id="elh_special_permissions_datetime"><?php echo $special_permissions->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $special_permissions->datetime->cellAttributes() ?>>
<span id="el_special_permissions_datetime">
<span<?php echo $special_permissions->datetime->viewAttributes() ?>>
<?php echo $special_permissions->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$special_permissions_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$special_permissions->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$special_permissions_view->terminate();
?>