<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$special_task_edit = new special_task_edit();

// Run the page
$special_task_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$special_task_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fspecial_taskedit = currentForm = new ew.Form("fspecial_taskedit", "edit");

// Validate form
fspecial_taskedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($special_task_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $special_task->id->caption(), $special_task->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($special_task_edit->task_title->Required) { ?>
			elm = this.getElements("x" + infix + "_task_title");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $special_task->task_title->caption(), $special_task->task_title->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($special_task_edit->task_description->Required) { ?>
			elm = this.getElements("x" + infix + "_task_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $special_task->task_description->caption(), $special_task->task_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($special_task_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $special_task->operator->caption(), $special_task->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($special_task_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $special_task->datetime->caption(), $special_task->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fspecial_taskedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fspecial_taskedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fspecial_taskedit.lists["x_operator"] = <?php echo $special_task_edit->operator->Lookup->toClientList() ?>;
fspecial_taskedit.lists["x_operator"].options = <?php echo JsonEncode($special_task_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $special_task_edit->showPageHeader(); ?>
<?php
$special_task_edit->showMessage();
?>
<form name="fspecial_taskedit" id="fspecial_taskedit" class="<?php echo $special_task_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($special_task_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $special_task_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="special_task">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$special_task_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($special_task->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_special_task_id" class="<?php echo $special_task_edit->LeftColumnClass ?>"><?php echo $special_task->id->caption() ?><?php echo ($special_task->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $special_task_edit->RightColumnClass ?>"><div<?php echo $special_task->id->cellAttributes() ?>>
<span id="el_special_task_id">
<span<?php echo $special_task->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($special_task->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="special_task" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($special_task->id->CurrentValue) ?>">
<?php echo $special_task->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($special_task->task_title->Visible) { // task_title ?>
	<div id="r_task_title" class="form-group row">
		<label id="elh_special_task_task_title" for="x_task_title" class="<?php echo $special_task_edit->LeftColumnClass ?>"><?php echo $special_task->task_title->caption() ?><?php echo ($special_task->task_title->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $special_task_edit->RightColumnClass ?>"><div<?php echo $special_task->task_title->cellAttributes() ?>>
<span id="el_special_task_task_title">
<input type="text" data-table="special_task" data-field="x_task_title" name="x_task_title" id="x_task_title" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($special_task->task_title->getPlaceHolder()) ?>" value="<?php echo $special_task->task_title->EditValue ?>"<?php echo $special_task->task_title->editAttributes() ?>>
</span>
<?php echo $special_task->task_title->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($special_task->task_description->Visible) { // task_description ?>
	<div id="r_task_description" class="form-group row">
		<label id="elh_special_task_task_description" for="x_task_description" class="<?php echo $special_task_edit->LeftColumnClass ?>"><?php echo $special_task->task_description->caption() ?><?php echo ($special_task->task_description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $special_task_edit->RightColumnClass ?>"><div<?php echo $special_task->task_description->cellAttributes() ?>>
<span id="el_special_task_task_description">
<textarea data-table="special_task" data-field="x_task_description" name="x_task_description" id="x_task_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($special_task->task_description->getPlaceHolder()) ?>"<?php echo $special_task->task_description->editAttributes() ?>><?php echo $special_task->task_description->EditValue ?></textarea>
</span>
<?php echo $special_task->task_description->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$special_task_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $special_task_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $special_task_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$special_task_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$special_task_edit->terminate();
?>