<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$special_task_list = new special_task_list();

// Run the page
$special_task_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$special_task_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$special_task->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fspecial_tasklist = currentForm = new ew.Form("fspecial_tasklist", "list");
fspecial_tasklist.formKeyCountName = '<?php echo $special_task_list->FormKeyCountName ?>';

// Form_CustomValidate event
fspecial_tasklist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fspecial_tasklist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fspecial_tasklist.lists["x_operator"] = <?php echo $special_task_list->operator->Lookup->toClientList() ?>;
fspecial_tasklist.lists["x_operator"].options = <?php echo JsonEncode($special_task_list->operator->lookupOptions()) ?>;

// Form object for search
var fspecial_tasklistsrch = currentSearchForm = new ew.Form("fspecial_tasklistsrch");

// Filters
fspecial_tasklistsrch.filterList = <?php echo $special_task_list->getFilterList() ?>;

// Init search panel as collapsed
fspecial_tasklistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$special_task->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($special_task_list->TotalRecs > 0 && $special_task_list->ExportOptions->visible()) { ?>
<?php $special_task_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($special_task_list->ImportOptions->visible()) { ?>
<?php $special_task_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($special_task_list->SearchOptions->visible()) { ?>
<?php $special_task_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($special_task_list->FilterOptions->visible()) { ?>
<?php $special_task_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$special_task_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$special_task->isExport() && !$special_task->CurrentAction) { ?>
<form name="fspecial_tasklistsrch" id="fspecial_tasklistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($special_task_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fspecial_tasklistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="special_task">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($special_task_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($special_task_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $special_task_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($special_task_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($special_task_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($special_task_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($special_task_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $special_task_list->showPageHeader(); ?>
<?php
$special_task_list->showMessage();
?>
<?php if ($special_task_list->TotalRecs > 0 || $special_task->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($special_task_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> special_task">
<?php if (!$special_task->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$special_task->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($special_task_list->Pager)) $special_task_list->Pager = new PrevNextPager($special_task_list->StartRec, $special_task_list->DisplayRecs, $special_task_list->TotalRecs, $special_task_list->AutoHidePager) ?>
<?php if ($special_task_list->Pager->RecordCount > 0 && $special_task_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($special_task_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $special_task_list->pageUrl() ?>start=<?php echo $special_task_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($special_task_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $special_task_list->pageUrl() ?>start=<?php echo $special_task_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $special_task_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($special_task_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $special_task_list->pageUrl() ?>start=<?php echo $special_task_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($special_task_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $special_task_list->pageUrl() ?>start=<?php echo $special_task_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $special_task_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($special_task_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $special_task_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $special_task_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $special_task_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($special_task_list->TotalRecs > 0 && (!$special_task_list->AutoHidePageSizeSelector || $special_task_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="special_task">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($special_task_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($special_task_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($special_task_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($special_task_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($special_task_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($special_task->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $special_task_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fspecial_tasklist" id="fspecial_tasklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($special_task_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $special_task_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="special_task">
<div id="gmp_special_task" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($special_task_list->TotalRecs > 0 || $special_task->isGridEdit()) { ?>
<table id="tbl_special_tasklist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$special_task_list->RowType = ROWTYPE_HEADER;

// Render list options
$special_task_list->renderListOptions();

// Render list options (header, left)
$special_task_list->ListOptions->render("header", "left");
?>
<?php if ($special_task->id->Visible) { // id ?>
	<?php if ($special_task->sortUrl($special_task->id) == "") { ?>
		<th data-name="id" class="<?php echo $special_task->id->headerCellClass() ?>"><div id="elh_special_task_id" class="special_task_id"><div class="ew-table-header-caption"><?php echo $special_task->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $special_task->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $special_task->SortUrl($special_task->id) ?>',2);"><div id="elh_special_task_id" class="special_task_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $special_task->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($special_task->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($special_task->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($special_task->task_title->Visible) { // task_title ?>
	<?php if ($special_task->sortUrl($special_task->task_title) == "") { ?>
		<th data-name="task_title" class="<?php echo $special_task->task_title->headerCellClass() ?>"><div id="elh_special_task_task_title" class="special_task_task_title"><div class="ew-table-header-caption"><?php echo $special_task->task_title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="task_title" class="<?php echo $special_task->task_title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $special_task->SortUrl($special_task->task_title) ?>',2);"><div id="elh_special_task_task_title" class="special_task_task_title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $special_task->task_title->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($special_task->task_title->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($special_task->task_title->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($special_task->operator->Visible) { // operator ?>
	<?php if ($special_task->sortUrl($special_task->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $special_task->operator->headerCellClass() ?>"><div id="elh_special_task_operator" class="special_task_operator"><div class="ew-table-header-caption"><?php echo $special_task->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $special_task->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $special_task->SortUrl($special_task->operator) ?>',2);"><div id="elh_special_task_operator" class="special_task_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $special_task->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($special_task->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($special_task->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($special_task->datetime->Visible) { // datetime ?>
	<?php if ($special_task->sortUrl($special_task->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $special_task->datetime->headerCellClass() ?>"><div id="elh_special_task_datetime" class="special_task_datetime"><div class="ew-table-header-caption"><?php echo $special_task->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $special_task->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $special_task->SortUrl($special_task->datetime) ?>',2);"><div id="elh_special_task_datetime" class="special_task_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $special_task->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($special_task->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($special_task->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$special_task_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($special_task->ExportAll && $special_task->isExport()) {
	$special_task_list->StopRec = $special_task_list->TotalRecs;
} else {

	// Set the last record to display
	if ($special_task_list->TotalRecs > $special_task_list->StartRec + $special_task_list->DisplayRecs - 1)
		$special_task_list->StopRec = $special_task_list->StartRec + $special_task_list->DisplayRecs - 1;
	else
		$special_task_list->StopRec = $special_task_list->TotalRecs;
}
$special_task_list->RecCnt = $special_task_list->StartRec - 1;
if ($special_task_list->Recordset && !$special_task_list->Recordset->EOF) {
	$special_task_list->Recordset->moveFirst();
	$selectLimit = $special_task_list->UseSelectLimit;
	if (!$selectLimit && $special_task_list->StartRec > 1)
		$special_task_list->Recordset->move($special_task_list->StartRec - 1);
} elseif (!$special_task->AllowAddDeleteRow && $special_task_list->StopRec == 0) {
	$special_task_list->StopRec = $special_task->GridAddRowCount;
}

// Initialize aggregate
$special_task->RowType = ROWTYPE_AGGREGATEINIT;
$special_task->resetAttributes();
$special_task_list->renderRow();
while ($special_task_list->RecCnt < $special_task_list->StopRec) {
	$special_task_list->RecCnt++;
	if ($special_task_list->RecCnt >= $special_task_list->StartRec) {
		$special_task_list->RowCnt++;

		// Set up key count
		$special_task_list->KeyCount = $special_task_list->RowIndex;

		// Init row class and style
		$special_task->resetAttributes();
		$special_task->CssClass = "";
		if ($special_task->isGridAdd()) {
		} else {
			$special_task_list->loadRowValues($special_task_list->Recordset); // Load row values
		}
		$special_task->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$special_task->RowAttrs = array_merge($special_task->RowAttrs, array('data-rowindex'=>$special_task_list->RowCnt, 'id'=>'r' . $special_task_list->RowCnt . '_special_task', 'data-rowtype'=>$special_task->RowType));

		// Render row
		$special_task_list->renderRow();

		// Render list options
		$special_task_list->renderListOptions();
?>
	<tr<?php echo $special_task->rowAttributes() ?>>
<?php

// Render list options (body, left)
$special_task_list->ListOptions->render("body", "left", $special_task_list->RowCnt);
?>
	<?php if ($special_task->id->Visible) { // id ?>
		<td data-name="id"<?php echo $special_task->id->cellAttributes() ?>>
<span id="el<?php echo $special_task_list->RowCnt ?>_special_task_id" class="special_task_id">
<span<?php echo $special_task->id->viewAttributes() ?>>
<?php echo $special_task->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($special_task->task_title->Visible) { // task_title ?>
		<td data-name="task_title"<?php echo $special_task->task_title->cellAttributes() ?>>
<span id="el<?php echo $special_task_list->RowCnt ?>_special_task_task_title" class="special_task_task_title">
<span<?php echo $special_task->task_title->viewAttributes() ?>>
<?php echo $special_task->task_title->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($special_task->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $special_task->operator->cellAttributes() ?>>
<span id="el<?php echo $special_task_list->RowCnt ?>_special_task_operator" class="special_task_operator">
<span<?php echo $special_task->operator->viewAttributes() ?>>
<?php echo $special_task->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($special_task->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $special_task->datetime->cellAttributes() ?>>
<span id="el<?php echo $special_task_list->RowCnt ?>_special_task_datetime" class="special_task_datetime">
<span<?php echo $special_task->datetime->viewAttributes() ?>>
<?php echo $special_task->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$special_task_list->ListOptions->render("body", "right", $special_task_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$special_task->isGridAdd())
		$special_task_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$special_task->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($special_task_list->Recordset)
	$special_task_list->Recordset->Close();
?>
<?php if (!$special_task->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$special_task->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($special_task_list->Pager)) $special_task_list->Pager = new PrevNextPager($special_task_list->StartRec, $special_task_list->DisplayRecs, $special_task_list->TotalRecs, $special_task_list->AutoHidePager) ?>
<?php if ($special_task_list->Pager->RecordCount > 0 && $special_task_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($special_task_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $special_task_list->pageUrl() ?>start=<?php echo $special_task_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($special_task_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $special_task_list->pageUrl() ?>start=<?php echo $special_task_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $special_task_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($special_task_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $special_task_list->pageUrl() ?>start=<?php echo $special_task_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($special_task_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $special_task_list->pageUrl() ?>start=<?php echo $special_task_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $special_task_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($special_task_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $special_task_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $special_task_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $special_task_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($special_task_list->TotalRecs > 0 && (!$special_task_list->AutoHidePageSizeSelector || $special_task_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="special_task">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($special_task_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($special_task_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($special_task_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($special_task_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($special_task_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($special_task->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $special_task_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($special_task_list->TotalRecs == 0 && !$special_task->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $special_task_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$special_task_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$special_task->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$special_task->isExport()) { ?>
<script>
ew.scrollableTable("gmp_special_task", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$special_task_list->terminate();
?>