<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$special_task_view = new special_task_view();

// Run the page
$special_task_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$special_task_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$special_task->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fspecial_taskview = currentForm = new ew.Form("fspecial_taskview", "view");

// Form_CustomValidate event
fspecial_taskview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fspecial_taskview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fspecial_taskview.lists["x_operator"] = <?php echo $special_task_view->operator->Lookup->toClientList() ?>;
fspecial_taskview.lists["x_operator"].options = <?php echo JsonEncode($special_task_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$special_task->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $special_task_view->ExportOptions->render("body") ?>
<?php $special_task_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $special_task_view->showPageHeader(); ?>
<?php
$special_task_view->showMessage();
?>
<form name="fspecial_taskview" id="fspecial_taskview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($special_task_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $special_task_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="special_task">
<input type="hidden" name="modal" value="<?php echo (int)$special_task_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($special_task->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $special_task_view->TableLeftColumnClass ?>"><span id="elh_special_task_id"><?php echo $special_task->id->caption() ?></span></td>
		<td data-name="id"<?php echo $special_task->id->cellAttributes() ?>>
<span id="el_special_task_id">
<span<?php echo $special_task->id->viewAttributes() ?>>
<?php echo $special_task->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_task->task_title->Visible) { // task_title ?>
	<tr id="r_task_title">
		<td class="<?php echo $special_task_view->TableLeftColumnClass ?>"><span id="elh_special_task_task_title"><?php echo $special_task->task_title->caption() ?></span></td>
		<td data-name="task_title"<?php echo $special_task->task_title->cellAttributes() ?>>
<span id="el_special_task_task_title">
<span<?php echo $special_task->task_title->viewAttributes() ?>>
<?php echo $special_task->task_title->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_task->task_description->Visible) { // task_description ?>
	<tr id="r_task_description">
		<td class="<?php echo $special_task_view->TableLeftColumnClass ?>"><span id="elh_special_task_task_description"><?php echo $special_task->task_description->caption() ?></span></td>
		<td data-name="task_description"<?php echo $special_task->task_description->cellAttributes() ?>>
<span id="el_special_task_task_description">
<span<?php echo $special_task->task_description->viewAttributes() ?>>
<?php echo $special_task->task_description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_task->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $special_task_view->TableLeftColumnClass ?>"><span id="elh_special_task_operator"><?php echo $special_task->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $special_task->operator->cellAttributes() ?>>
<span id="el_special_task_operator">
<span<?php echo $special_task->operator->viewAttributes() ?>>
<?php echo $special_task->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($special_task->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $special_task_view->TableLeftColumnClass ?>"><span id="elh_special_task_datetime"><?php echo $special_task->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $special_task->datetime->cellAttributes() ?>>
<span id="el_special_task_datetime">
<span<?php echo $special_task->datetime->viewAttributes() ?>>
<?php echo $special_task->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$special_task_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$special_task->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$special_task_view->terminate();
?>