<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$static_pages_add = new static_pages_add();

// Run the page
$static_pages_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$static_pages_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fstatic_pagesadd = currentForm = new ew.Form("fstatic_pagesadd", "add");

// Validate form
fstatic_pagesadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($static_pages_add->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $static_pages->id->caption(), $static_pages->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($static_pages->id->errorMessage()) ?>");
		<?php if ($static_pages_add->menu_id->Required) { ?>
			elm = this.getElements("x" + infix + "_menu_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $static_pages->menu_id->caption(), $static_pages->menu_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_menu_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($static_pages->menu_id->errorMessage()) ?>");
		<?php if ($static_pages_add->meta_desc->Required) { ?>
			elm = this.getElements("x" + infix + "_meta_desc");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $static_pages->meta_desc->caption(), $static_pages->meta_desc->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($static_pages_add->meta_keyword->Required) { ?>
			elm = this.getElements("x" + infix + "_meta_keyword");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $static_pages->meta_keyword->caption(), $static_pages->meta_keyword->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($static_pages_add->page_desc->Required) { ?>
			elm = this.getElements("x" + infix + "_page_desc");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $static_pages->page_desc->caption(), $static_pages->page_desc->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($static_pages_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $static_pages->operator->caption(), $static_pages->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($static_pages_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $static_pages->datetime->caption(), $static_pages->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fstatic_pagesadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstatic_pagesadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $static_pages_add->showPageHeader(); ?>
<?php
$static_pages_add->showMessage();
?>
<form name="fstatic_pagesadd" id="fstatic_pagesadd" class="<?php echo $static_pages_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($static_pages_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $static_pages_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="static_pages">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$static_pages_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($static_pages->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_static_pages_id" for="x_id" class="<?php echo $static_pages_add->LeftColumnClass ?>"><?php echo $static_pages->id->caption() ?><?php echo ($static_pages->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $static_pages_add->RightColumnClass ?>"><div<?php echo $static_pages->id->cellAttributes() ?>>
<span id="el_static_pages_id">
<input type="text" data-table="static_pages" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($static_pages->id->getPlaceHolder()) ?>" value="<?php echo $static_pages->id->EditValue ?>"<?php echo $static_pages->id->editAttributes() ?>>
</span>
<?php echo $static_pages->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($static_pages->menu_id->Visible) { // menu_id ?>
	<div id="r_menu_id" class="form-group row">
		<label id="elh_static_pages_menu_id" for="x_menu_id" class="<?php echo $static_pages_add->LeftColumnClass ?>"><?php echo $static_pages->menu_id->caption() ?><?php echo ($static_pages->menu_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $static_pages_add->RightColumnClass ?>"><div<?php echo $static_pages->menu_id->cellAttributes() ?>>
<span id="el_static_pages_menu_id">
<input type="text" data-table="static_pages" data-field="x_menu_id" name="x_menu_id" id="x_menu_id" size="30" placeholder="<?php echo HtmlEncode($static_pages->menu_id->getPlaceHolder()) ?>" value="<?php echo $static_pages->menu_id->EditValue ?>"<?php echo $static_pages->menu_id->editAttributes() ?>>
</span>
<?php echo $static_pages->menu_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($static_pages->meta_desc->Visible) { // meta_desc ?>
	<div id="r_meta_desc" class="form-group row">
		<label id="elh_static_pages_meta_desc" for="x_meta_desc" class="<?php echo $static_pages_add->LeftColumnClass ?>"><?php echo $static_pages->meta_desc->caption() ?><?php echo ($static_pages->meta_desc->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $static_pages_add->RightColumnClass ?>"><div<?php echo $static_pages->meta_desc->cellAttributes() ?>>
<span id="el_static_pages_meta_desc">
<input type="text" data-table="static_pages" data-field="x_meta_desc" name="x_meta_desc" id="x_meta_desc" size="30" maxlength="160" placeholder="<?php echo HtmlEncode($static_pages->meta_desc->getPlaceHolder()) ?>" value="<?php echo $static_pages->meta_desc->EditValue ?>"<?php echo $static_pages->meta_desc->editAttributes() ?>>
</span>
<?php echo $static_pages->meta_desc->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($static_pages->meta_keyword->Visible) { // meta_keyword ?>
	<div id="r_meta_keyword" class="form-group row">
		<label id="elh_static_pages_meta_keyword" for="x_meta_keyword" class="<?php echo $static_pages_add->LeftColumnClass ?>"><?php echo $static_pages->meta_keyword->caption() ?><?php echo ($static_pages->meta_keyword->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $static_pages_add->RightColumnClass ?>"><div<?php echo $static_pages->meta_keyword->cellAttributes() ?>>
<span id="el_static_pages_meta_keyword">
<input type="text" data-table="static_pages" data-field="x_meta_keyword" name="x_meta_keyword" id="x_meta_keyword" size="30" maxlength="160" placeholder="<?php echo HtmlEncode($static_pages->meta_keyword->getPlaceHolder()) ?>" value="<?php echo $static_pages->meta_keyword->EditValue ?>"<?php echo $static_pages->meta_keyword->editAttributes() ?>>
</span>
<?php echo $static_pages->meta_keyword->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($static_pages->page_desc->Visible) { // page_desc ?>
	<div id="r_page_desc" class="form-group row">
		<label id="elh_static_pages_page_desc" class="<?php echo $static_pages_add->LeftColumnClass ?>"><?php echo $static_pages->page_desc->caption() ?><?php echo ($static_pages->page_desc->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $static_pages_add->RightColumnClass ?>"><div<?php echo $static_pages->page_desc->cellAttributes() ?>>
<span id="el_static_pages_page_desc">
<?php AppendClass($static_pages->page_desc->EditAttrs["class"], "editor"); ?>
<textarea data-table="static_pages" data-field="x_page_desc" name="x_page_desc" id="x_page_desc" cols="35" rows="4" placeholder="<?php echo HtmlEncode($static_pages->page_desc->getPlaceHolder()) ?>"<?php echo $static_pages->page_desc->editAttributes() ?>><?php echo $static_pages->page_desc->EditValue ?></textarea>
<script>
ew.createEditor("fstatic_pagesadd", "x_page_desc", 35, 4, <?php echo ($static_pages->page_desc->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $static_pages->page_desc->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$static_pages_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $static_pages_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $static_pages_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$static_pages_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$static_pages_add->terminate();
?>