<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$static_pages_list = new static_pages_list();

// Run the page
$static_pages_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$static_pages_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$static_pages->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstatic_pageslist = currentForm = new ew.Form("fstatic_pageslist", "list");
fstatic_pageslist.formKeyCountName = '<?php echo $static_pages_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstatic_pageslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstatic_pageslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fstatic_pageslistsrch = currentSearchForm = new ew.Form("fstatic_pageslistsrch");

// Filters
fstatic_pageslistsrch.filterList = <?php echo $static_pages_list->getFilterList() ?>;

// Init search panel as collapsed
fstatic_pageslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$static_pages->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($static_pages_list->TotalRecs > 0 && $static_pages_list->ExportOptions->visible()) { ?>
<?php $static_pages_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($static_pages_list->ImportOptions->visible()) { ?>
<?php $static_pages_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($static_pages_list->SearchOptions->visible()) { ?>
<?php $static_pages_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($static_pages_list->FilterOptions->visible()) { ?>
<?php $static_pages_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$static_pages_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$static_pages->isExport() && !$static_pages->CurrentAction) { ?>
<form name="fstatic_pageslistsrch" id="fstatic_pageslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($static_pages_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstatic_pageslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="static_pages">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($static_pages_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($static_pages_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $static_pages_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($static_pages_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($static_pages_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($static_pages_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($static_pages_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $static_pages_list->showPageHeader(); ?>
<?php
$static_pages_list->showMessage();
?>
<?php if ($static_pages_list->TotalRecs > 0 || $static_pages->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($static_pages_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> static_pages">
<?php if (!$static_pages->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$static_pages->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($static_pages_list->Pager)) $static_pages_list->Pager = new PrevNextPager($static_pages_list->StartRec, $static_pages_list->DisplayRecs, $static_pages_list->TotalRecs, $static_pages_list->AutoHidePager) ?>
<?php if ($static_pages_list->Pager->RecordCount > 0 && $static_pages_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($static_pages_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $static_pages_list->pageUrl() ?>start=<?php echo $static_pages_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($static_pages_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $static_pages_list->pageUrl() ?>start=<?php echo $static_pages_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $static_pages_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($static_pages_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $static_pages_list->pageUrl() ?>start=<?php echo $static_pages_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($static_pages_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $static_pages_list->pageUrl() ?>start=<?php echo $static_pages_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $static_pages_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($static_pages_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $static_pages_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $static_pages_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $static_pages_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($static_pages_list->TotalRecs > 0 && (!$static_pages_list->AutoHidePageSizeSelector || $static_pages_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="static_pages">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($static_pages_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($static_pages_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($static_pages_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($static_pages_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($static_pages_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($static_pages->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $static_pages_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstatic_pageslist" id="fstatic_pageslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($static_pages_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $static_pages_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="static_pages">
<div id="gmp_static_pages" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($static_pages_list->TotalRecs > 0 || $static_pages->isGridEdit()) { ?>
<table id="tbl_static_pageslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$static_pages_list->RowType = ROWTYPE_HEADER;

// Render list options
$static_pages_list->renderListOptions();

// Render list options (header, left)
$static_pages_list->ListOptions->render("header", "left");
?>
<?php if ($static_pages->id->Visible) { // id ?>
	<?php if ($static_pages->sortUrl($static_pages->id) == "") { ?>
		<th data-name="id" class="<?php echo $static_pages->id->headerCellClass() ?>"><div id="elh_static_pages_id" class="static_pages_id"><div class="ew-table-header-caption"><?php echo $static_pages->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $static_pages->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $static_pages->SortUrl($static_pages->id) ?>',2);"><div id="elh_static_pages_id" class="static_pages_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $static_pages->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($static_pages->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($static_pages->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($static_pages->menu_id->Visible) { // menu_id ?>
	<?php if ($static_pages->sortUrl($static_pages->menu_id) == "") { ?>
		<th data-name="menu_id" class="<?php echo $static_pages->menu_id->headerCellClass() ?>"><div id="elh_static_pages_menu_id" class="static_pages_menu_id"><div class="ew-table-header-caption"><?php echo $static_pages->menu_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="menu_id" class="<?php echo $static_pages->menu_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $static_pages->SortUrl($static_pages->menu_id) ?>',2);"><div id="elh_static_pages_menu_id" class="static_pages_menu_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $static_pages->menu_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($static_pages->menu_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($static_pages->menu_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($static_pages->meta_desc->Visible) { // meta_desc ?>
	<?php if ($static_pages->sortUrl($static_pages->meta_desc) == "") { ?>
		<th data-name="meta_desc" class="<?php echo $static_pages->meta_desc->headerCellClass() ?>"><div id="elh_static_pages_meta_desc" class="static_pages_meta_desc"><div class="ew-table-header-caption"><?php echo $static_pages->meta_desc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="meta_desc" class="<?php echo $static_pages->meta_desc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $static_pages->SortUrl($static_pages->meta_desc) ?>',2);"><div id="elh_static_pages_meta_desc" class="static_pages_meta_desc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $static_pages->meta_desc->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($static_pages->meta_desc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($static_pages->meta_desc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($static_pages->meta_keyword->Visible) { // meta_keyword ?>
	<?php if ($static_pages->sortUrl($static_pages->meta_keyword) == "") { ?>
		<th data-name="meta_keyword" class="<?php echo $static_pages->meta_keyword->headerCellClass() ?>"><div id="elh_static_pages_meta_keyword" class="static_pages_meta_keyword"><div class="ew-table-header-caption"><?php echo $static_pages->meta_keyword->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="meta_keyword" class="<?php echo $static_pages->meta_keyword->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $static_pages->SortUrl($static_pages->meta_keyword) ?>',2);"><div id="elh_static_pages_meta_keyword" class="static_pages_meta_keyword">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $static_pages->meta_keyword->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($static_pages->meta_keyword->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($static_pages->meta_keyword->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($static_pages->operator->Visible) { // operator ?>
	<?php if ($static_pages->sortUrl($static_pages->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $static_pages->operator->headerCellClass() ?>"><div id="elh_static_pages_operator" class="static_pages_operator"><div class="ew-table-header-caption"><?php echo $static_pages->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $static_pages->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $static_pages->SortUrl($static_pages->operator) ?>',2);"><div id="elh_static_pages_operator" class="static_pages_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $static_pages->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($static_pages->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($static_pages->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($static_pages->datetime->Visible) { // datetime ?>
	<?php if ($static_pages->sortUrl($static_pages->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $static_pages->datetime->headerCellClass() ?>"><div id="elh_static_pages_datetime" class="static_pages_datetime"><div class="ew-table-header-caption"><?php echo $static_pages->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $static_pages->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $static_pages->SortUrl($static_pages->datetime) ?>',2);"><div id="elh_static_pages_datetime" class="static_pages_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $static_pages->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($static_pages->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($static_pages->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$static_pages_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($static_pages->ExportAll && $static_pages->isExport()) {
	$static_pages_list->StopRec = $static_pages_list->TotalRecs;
} else {

	// Set the last record to display
	if ($static_pages_list->TotalRecs > $static_pages_list->StartRec + $static_pages_list->DisplayRecs - 1)
		$static_pages_list->StopRec = $static_pages_list->StartRec + $static_pages_list->DisplayRecs - 1;
	else
		$static_pages_list->StopRec = $static_pages_list->TotalRecs;
}
$static_pages_list->RecCnt = $static_pages_list->StartRec - 1;
if ($static_pages_list->Recordset && !$static_pages_list->Recordset->EOF) {
	$static_pages_list->Recordset->moveFirst();
	$selectLimit = $static_pages_list->UseSelectLimit;
	if (!$selectLimit && $static_pages_list->StartRec > 1)
		$static_pages_list->Recordset->move($static_pages_list->StartRec - 1);
} elseif (!$static_pages->AllowAddDeleteRow && $static_pages_list->StopRec == 0) {
	$static_pages_list->StopRec = $static_pages->GridAddRowCount;
}

// Initialize aggregate
$static_pages->RowType = ROWTYPE_AGGREGATEINIT;
$static_pages->resetAttributes();
$static_pages_list->renderRow();
while ($static_pages_list->RecCnt < $static_pages_list->StopRec) {
	$static_pages_list->RecCnt++;
	if ($static_pages_list->RecCnt >= $static_pages_list->StartRec) {
		$static_pages_list->RowCnt++;

		// Set up key count
		$static_pages_list->KeyCount = $static_pages_list->RowIndex;

		// Init row class and style
		$static_pages->resetAttributes();
		$static_pages->CssClass = "";
		if ($static_pages->isGridAdd()) {
		} else {
			$static_pages_list->loadRowValues($static_pages_list->Recordset); // Load row values
		}
		$static_pages->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$static_pages->RowAttrs = array_merge($static_pages->RowAttrs, array('data-rowindex'=>$static_pages_list->RowCnt, 'id'=>'r' . $static_pages_list->RowCnt . '_static_pages', 'data-rowtype'=>$static_pages->RowType));

		// Render row
		$static_pages_list->renderRow();

		// Render list options
		$static_pages_list->renderListOptions();
?>
	<tr<?php echo $static_pages->rowAttributes() ?>>
<?php

// Render list options (body, left)
$static_pages_list->ListOptions->render("body", "left", $static_pages_list->RowCnt);
?>
	<?php if ($static_pages->id->Visible) { // id ?>
		<td data-name="id"<?php echo $static_pages->id->cellAttributes() ?>>
<span id="el<?php echo $static_pages_list->RowCnt ?>_static_pages_id" class="static_pages_id">
<span<?php echo $static_pages->id->viewAttributes() ?>>
<?php echo $static_pages->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($static_pages->menu_id->Visible) { // menu_id ?>
		<td data-name="menu_id"<?php echo $static_pages->menu_id->cellAttributes() ?>>
<span id="el<?php echo $static_pages_list->RowCnt ?>_static_pages_menu_id" class="static_pages_menu_id">
<span<?php echo $static_pages->menu_id->viewAttributes() ?>>
<?php echo $static_pages->menu_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($static_pages->meta_desc->Visible) { // meta_desc ?>
		<td data-name="meta_desc"<?php echo $static_pages->meta_desc->cellAttributes() ?>>
<span id="el<?php echo $static_pages_list->RowCnt ?>_static_pages_meta_desc" class="static_pages_meta_desc">
<span<?php echo $static_pages->meta_desc->viewAttributes() ?>>
<?php echo $static_pages->meta_desc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($static_pages->meta_keyword->Visible) { // meta_keyword ?>
		<td data-name="meta_keyword"<?php echo $static_pages->meta_keyword->cellAttributes() ?>>
<span id="el<?php echo $static_pages_list->RowCnt ?>_static_pages_meta_keyword" class="static_pages_meta_keyword">
<span<?php echo $static_pages->meta_keyword->viewAttributes() ?>>
<?php echo $static_pages->meta_keyword->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($static_pages->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $static_pages->operator->cellAttributes() ?>>
<span id="el<?php echo $static_pages_list->RowCnt ?>_static_pages_operator" class="static_pages_operator">
<span<?php echo $static_pages->operator->viewAttributes() ?>>
<?php echo $static_pages->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($static_pages->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $static_pages->datetime->cellAttributes() ?>>
<span id="el<?php echo $static_pages_list->RowCnt ?>_static_pages_datetime" class="static_pages_datetime">
<span<?php echo $static_pages->datetime->viewAttributes() ?>>
<?php echo $static_pages->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$static_pages_list->ListOptions->render("body", "right", $static_pages_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$static_pages->isGridAdd())
		$static_pages_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$static_pages->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($static_pages_list->Recordset)
	$static_pages_list->Recordset->Close();
?>
<?php if (!$static_pages->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$static_pages->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($static_pages_list->Pager)) $static_pages_list->Pager = new PrevNextPager($static_pages_list->StartRec, $static_pages_list->DisplayRecs, $static_pages_list->TotalRecs, $static_pages_list->AutoHidePager) ?>
<?php if ($static_pages_list->Pager->RecordCount > 0 && $static_pages_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($static_pages_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $static_pages_list->pageUrl() ?>start=<?php echo $static_pages_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($static_pages_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $static_pages_list->pageUrl() ?>start=<?php echo $static_pages_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $static_pages_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($static_pages_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $static_pages_list->pageUrl() ?>start=<?php echo $static_pages_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($static_pages_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $static_pages_list->pageUrl() ?>start=<?php echo $static_pages_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $static_pages_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($static_pages_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $static_pages_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $static_pages_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $static_pages_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($static_pages_list->TotalRecs > 0 && (!$static_pages_list->AutoHidePageSizeSelector || $static_pages_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="static_pages">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($static_pages_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($static_pages_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($static_pages_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($static_pages_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($static_pages_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($static_pages->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $static_pages_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($static_pages_list->TotalRecs == 0 && !$static_pages->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $static_pages_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$static_pages_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$static_pages->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$static_pages->isExport()) { ?>
<script>
ew.scrollableTable("gmp_static_pages", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$static_pages_list->terminate();
?>