<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$status_edit = new status_edit();

// Run the page
$status_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$status_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fstatusedit = currentForm = new ew.Form("fstatusedit", "edit");

// Validate form
fstatusedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($status_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $status->id->caption(), $status->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($status_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $status->item->caption(), $status->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($status_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $status->grp->caption(), $status->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($status->grp->errorMessage()) ?>");
		<?php if ($status_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $status->status->caption(), $status->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($status_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $status->operator->caption(), $status->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($status_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $status->datetime->caption(), $status->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fstatusedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstatusedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstatusedit.lists["x_status"] = <?php echo $status_edit->status->Lookup->toClientList() ?>;
fstatusedit.lists["x_status"].options = <?php echo JsonEncode($status_edit->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $status_edit->showPageHeader(); ?>
<?php
$status_edit->showMessage();
?>
<form name="fstatusedit" id="fstatusedit" class="<?php echo $status_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($status_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $status_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="status">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$status_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($status->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_status_id" class="<?php echo $status_edit->LeftColumnClass ?>"><?php echo $status->id->caption() ?><?php echo ($status->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $status_edit->RightColumnClass ?>"><div<?php echo $status->id->cellAttributes() ?>>
<span id="el_status_id">
<span<?php echo $status->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($status->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="status" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($status->id->CurrentValue) ?>">
<?php echo $status->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($status->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_status_item" for="x_item" class="<?php echo $status_edit->LeftColumnClass ?>"><?php echo $status->item->caption() ?><?php echo ($status->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $status_edit->RightColumnClass ?>"><div<?php echo $status->item->cellAttributes() ?>>
<span id="el_status_item">
<input type="text" data-table="status" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($status->item->getPlaceHolder()) ?>" value="<?php echo $status->item->EditValue ?>"<?php echo $status->item->editAttributes() ?>>
</span>
<?php echo $status->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($status->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_status_grp" for="x_grp" class="<?php echo $status_edit->LeftColumnClass ?>"><?php echo $status->grp->caption() ?><?php echo ($status->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $status_edit->RightColumnClass ?>"><div<?php echo $status->grp->cellAttributes() ?>>
<span id="el_status_grp">
<input type="text" data-table="status" data-field="x_grp" name="x_grp" id="x_grp" size="30" placeholder="<?php echo HtmlEncode($status->grp->getPlaceHolder()) ?>" value="<?php echo $status->grp->EditValue ?>"<?php echo $status->grp->editAttributes() ?>>
</span>
<?php echo $status->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($status->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_status_status" for="x_status" class="<?php echo $status_edit->LeftColumnClass ?>"><?php echo $status->status->caption() ?><?php echo ($status->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $status_edit->RightColumnClass ?>"><div<?php echo $status->status->cellAttributes() ?>>
<span id="el_status_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="status" data-field="x_status" data-value-separator="<?php echo $status->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $status->status->editAttributes() ?>>
		<?php echo $status->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $status->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$status_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $status_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $status_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$status_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$status_edit->terminate();
?>