<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$status_list = new status_list();

// Run the page
$status_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$status_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$status->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstatuslist = currentForm = new ew.Form("fstatuslist", "list");
fstatuslist.formKeyCountName = '<?php echo $status_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstatuslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstatuslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstatuslist.lists["x_status"] = <?php echo $status_list->status->Lookup->toClientList() ?>;
fstatuslist.lists["x_status"].options = <?php echo JsonEncode($status_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fstatuslistsrch = currentSearchForm = new ew.Form("fstatuslistsrch");

// Filters
fstatuslistsrch.filterList = <?php echo $status_list->getFilterList() ?>;

// Init search panel as collapsed
fstatuslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$status->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($status_list->TotalRecs > 0 && $status_list->ExportOptions->visible()) { ?>
<?php $status_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($status_list->ImportOptions->visible()) { ?>
<?php $status_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($status_list->SearchOptions->visible()) { ?>
<?php $status_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($status_list->FilterOptions->visible()) { ?>
<?php $status_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$status_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$status->isExport() && !$status->CurrentAction) { ?>
<form name="fstatuslistsrch" id="fstatuslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($status_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstatuslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="status">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($status_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($status_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $status_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($status_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($status_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($status_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($status_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $status_list->showPageHeader(); ?>
<?php
$status_list->showMessage();
?>
<?php if ($status_list->TotalRecs > 0 || $status->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($status_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> status">
<?php if (!$status->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$status->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($status_list->Pager)) $status_list->Pager = new PrevNextPager($status_list->StartRec, $status_list->DisplayRecs, $status_list->TotalRecs, $status_list->AutoHidePager) ?>
<?php if ($status_list->Pager->RecordCount > 0 && $status_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($status_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $status_list->pageUrl() ?>start=<?php echo $status_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($status_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $status_list->pageUrl() ?>start=<?php echo $status_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $status_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($status_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $status_list->pageUrl() ?>start=<?php echo $status_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($status_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $status_list->pageUrl() ?>start=<?php echo $status_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $status_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($status_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $status_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $status_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $status_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($status_list->TotalRecs > 0 && (!$status_list->AutoHidePageSizeSelector || $status_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="status">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($status_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($status_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($status_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($status_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($status_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($status->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $status_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstatuslist" id="fstatuslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($status_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $status_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="status">
<div id="gmp_status" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($status_list->TotalRecs > 0 || $status->isGridEdit()) { ?>
<table id="tbl_statuslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$status_list->RowType = ROWTYPE_HEADER;

// Render list options
$status_list->renderListOptions();

// Render list options (header, left)
$status_list->ListOptions->render("header", "left");
?>
<?php if ($status->id->Visible) { // id ?>
	<?php if ($status->sortUrl($status->id) == "") { ?>
		<th data-name="id" class="<?php echo $status->id->headerCellClass() ?>"><div id="elh_status_id" class="status_id"><div class="ew-table-header-caption"><?php echo $status->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $status->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $status->SortUrl($status->id) ?>',2);"><div id="elh_status_id" class="status_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $status->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($status->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($status->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($status->item->Visible) { // item ?>
	<?php if ($status->sortUrl($status->item) == "") { ?>
		<th data-name="item" class="<?php echo $status->item->headerCellClass() ?>"><div id="elh_status_item" class="status_item"><div class="ew-table-header-caption"><?php echo $status->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $status->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $status->SortUrl($status->item) ?>',2);"><div id="elh_status_item" class="status_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $status->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($status->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($status->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($status->grp->Visible) { // grp ?>
	<?php if ($status->sortUrl($status->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $status->grp->headerCellClass() ?>"><div id="elh_status_grp" class="status_grp"><div class="ew-table-header-caption"><?php echo $status->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $status->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $status->SortUrl($status->grp) ?>',2);"><div id="elh_status_grp" class="status_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $status->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($status->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($status->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($status->status->Visible) { // status ?>
	<?php if ($status->sortUrl($status->status) == "") { ?>
		<th data-name="status" class="<?php echo $status->status->headerCellClass() ?>"><div id="elh_status_status" class="status_status"><div class="ew-table-header-caption"><?php echo $status->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $status->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $status->SortUrl($status->status) ?>',2);"><div id="elh_status_status" class="status_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $status->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($status->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($status->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($status->operator->Visible) { // operator ?>
	<?php if ($status->sortUrl($status->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $status->operator->headerCellClass() ?>"><div id="elh_status_operator" class="status_operator"><div class="ew-table-header-caption"><?php echo $status->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $status->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $status->SortUrl($status->operator) ?>',2);"><div id="elh_status_operator" class="status_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $status->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($status->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($status->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($status->datetime->Visible) { // datetime ?>
	<?php if ($status->sortUrl($status->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $status->datetime->headerCellClass() ?>"><div id="elh_status_datetime" class="status_datetime"><div class="ew-table-header-caption"><?php echo $status->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $status->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $status->SortUrl($status->datetime) ?>',2);"><div id="elh_status_datetime" class="status_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $status->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($status->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($status->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$status_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($status->ExportAll && $status->isExport()) {
	$status_list->StopRec = $status_list->TotalRecs;
} else {

	// Set the last record to display
	if ($status_list->TotalRecs > $status_list->StartRec + $status_list->DisplayRecs - 1)
		$status_list->StopRec = $status_list->StartRec + $status_list->DisplayRecs - 1;
	else
		$status_list->StopRec = $status_list->TotalRecs;
}
$status_list->RecCnt = $status_list->StartRec - 1;
if ($status_list->Recordset && !$status_list->Recordset->EOF) {
	$status_list->Recordset->moveFirst();
	$selectLimit = $status_list->UseSelectLimit;
	if (!$selectLimit && $status_list->StartRec > 1)
		$status_list->Recordset->move($status_list->StartRec - 1);
} elseif (!$status->AllowAddDeleteRow && $status_list->StopRec == 0) {
	$status_list->StopRec = $status->GridAddRowCount;
}

// Initialize aggregate
$status->RowType = ROWTYPE_AGGREGATEINIT;
$status->resetAttributes();
$status_list->renderRow();
while ($status_list->RecCnt < $status_list->StopRec) {
	$status_list->RecCnt++;
	if ($status_list->RecCnt >= $status_list->StartRec) {
		$status_list->RowCnt++;

		// Set up key count
		$status_list->KeyCount = $status_list->RowIndex;

		// Init row class and style
		$status->resetAttributes();
		$status->CssClass = "";
		if ($status->isGridAdd()) {
		} else {
			$status_list->loadRowValues($status_list->Recordset); // Load row values
		}
		$status->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$status->RowAttrs = array_merge($status->RowAttrs, array('data-rowindex'=>$status_list->RowCnt, 'id'=>'r' . $status_list->RowCnt . '_status', 'data-rowtype'=>$status->RowType));

		// Render row
		$status_list->renderRow();

		// Render list options
		$status_list->renderListOptions();
?>
	<tr<?php echo $status->rowAttributes() ?>>
<?php

// Render list options (body, left)
$status_list->ListOptions->render("body", "left", $status_list->RowCnt);
?>
	<?php if ($status->id->Visible) { // id ?>
		<td data-name="id"<?php echo $status->id->cellAttributes() ?>>
<span id="el<?php echo $status_list->RowCnt ?>_status_id" class="status_id">
<span<?php echo $status->id->viewAttributes() ?>>
<?php echo $status->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($status->item->Visible) { // item ?>
		<td data-name="item"<?php echo $status->item->cellAttributes() ?>>
<span id="el<?php echo $status_list->RowCnt ?>_status_item" class="status_item">
<span<?php echo $status->item->viewAttributes() ?>>
<?php echo $status->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($status->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $status->grp->cellAttributes() ?>>
<span id="el<?php echo $status_list->RowCnt ?>_status_grp" class="status_grp">
<span<?php echo $status->grp->viewAttributes() ?>>
<?php echo $status->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($status->status->Visible) { // status ?>
		<td data-name="status"<?php echo $status->status->cellAttributes() ?>>
<span id="el<?php echo $status_list->RowCnt ?>_status_status" class="status_status">
<span<?php echo $status->status->viewAttributes() ?>>
<?php echo $status->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($status->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $status->operator->cellAttributes() ?>>
<span id="el<?php echo $status_list->RowCnt ?>_status_operator" class="status_operator">
<span<?php echo $status->operator->viewAttributes() ?>>
<?php echo $status->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($status->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $status->datetime->cellAttributes() ?>>
<span id="el<?php echo $status_list->RowCnt ?>_status_datetime" class="status_datetime">
<span<?php echo $status->datetime->viewAttributes() ?>>
<?php echo $status->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$status_list->ListOptions->render("body", "right", $status_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$status->isGridAdd())
		$status_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$status->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($status_list->Recordset)
	$status_list->Recordset->Close();
?>
<?php if (!$status->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$status->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($status_list->Pager)) $status_list->Pager = new PrevNextPager($status_list->StartRec, $status_list->DisplayRecs, $status_list->TotalRecs, $status_list->AutoHidePager) ?>
<?php if ($status_list->Pager->RecordCount > 0 && $status_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($status_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $status_list->pageUrl() ?>start=<?php echo $status_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($status_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $status_list->pageUrl() ?>start=<?php echo $status_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $status_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($status_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $status_list->pageUrl() ?>start=<?php echo $status_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($status_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $status_list->pageUrl() ?>start=<?php echo $status_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $status_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($status_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $status_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $status_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $status_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($status_list->TotalRecs > 0 && (!$status_list->AutoHidePageSizeSelector || $status_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="status">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($status_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($status_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($status_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($status_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($status_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($status->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $status_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($status_list->TotalRecs == 0 && !$status->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $status_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$status_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$status->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$status->isExport()) { ?>
<script>
ew.scrollableTable("gmp_status", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$status_list->terminate();
?>