<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$status_search = new status_search();

// Run the page
$status_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$status_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($status_search->IsModal) { ?>
var fstatussearch = currentAdvancedSearchForm = new ew.Form("fstatussearch", "search");
<?php } else { ?>
var fstatussearch = currentForm = new ew.Form("fstatussearch", "search");
<?php } ?>

// Form_CustomValidate event
fstatussearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstatussearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstatussearch.lists["x_status"] = <?php echo $status_search->status->Lookup->toClientList() ?>;
fstatussearch.lists["x_status"].options = <?php echo JsonEncode($status_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fstatussearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($status->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($status->grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($status->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($status->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $status_search->showPageHeader(); ?>
<?php
$status_search->showMessage();
?>
<form name="fstatussearch" id="fstatussearch" class="<?php echo $status_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($status_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $status_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="status">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$status_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($status->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $status_search->LeftColumnClass ?>"><span id="elh_status_id"><?php echo $status->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $status_search->RightColumnClass ?>"><div<?php echo $status->id->cellAttributes() ?>>
			<span id="el_status_id">
<input type="text" data-table="status" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($status->id->getPlaceHolder()) ?>" value="<?php echo $status->id->EditValue ?>"<?php echo $status->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($status->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $status_search->LeftColumnClass ?>"><span id="elh_status_item"><?php echo $status->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $status_search->RightColumnClass ?>"><div<?php echo $status->item->cellAttributes() ?>>
			<span id="el_status_item">
<input type="text" data-table="status" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($status->item->getPlaceHolder()) ?>" value="<?php echo $status->item->EditValue ?>"<?php echo $status->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($status->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $status_search->LeftColumnClass ?>"><span id="elh_status_grp"><?php echo $status->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $status_search->RightColumnClass ?>"><div<?php echo $status->grp->cellAttributes() ?>>
			<span id="el_status_grp">
<input type="text" data-table="status" data-field="x_grp" name="x_grp" id="x_grp" size="30" placeholder="<?php echo HtmlEncode($status->grp->getPlaceHolder()) ?>" value="<?php echo $status->grp->EditValue ?>"<?php echo $status->grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($status->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $status_search->LeftColumnClass ?>"><span id="elh_status_status"><?php echo $status->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $status_search->RightColumnClass ?>"><div<?php echo $status->status->cellAttributes() ?>>
			<span id="el_status_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="status" data-field="x_status" data-value-separator="<?php echo $status->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $status->status->editAttributes() ?>>
		<?php echo $status->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($status->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $status_search->LeftColumnClass ?>"><span id="elh_status_operator"><?php echo $status->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $status_search->RightColumnClass ?>"><div<?php echo $status->operator->cellAttributes() ?>>
			<span id="el_status_operator">
<input type="text" data-table="status" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($status->operator->getPlaceHolder()) ?>" value="<?php echo $status->operator->EditValue ?>"<?php echo $status->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($status->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $status_search->LeftColumnClass ?>"><span id="elh_status_datetime"><?php echo $status->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $status_search->RightColumnClass ?>"><div<?php echo $status->datetime->cellAttributes() ?>>
			<span id="el_status_datetime">
<input type="text" data-table="status" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($status->datetime->getPlaceHolder()) ?>" value="<?php echo $status->datetime->EditValue ?>"<?php echo $status->datetime->editAttributes() ?>>
<?php if (!$status->datetime->ReadOnly && !$status->datetime->Disabled && !isset($status->datetime->EditAttrs["readonly"]) && !isset($status->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstatussearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$status_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $status_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$status_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$status_search->terminate();
?>