<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_barcode_list = new stock_barcode_list();

// Run the page
$stock_barcode_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_barcode_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_barcode->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_barcodelist = currentForm = new ew.Form("fstock_barcodelist", "list");
fstock_barcodelist.formKeyCountName = '<?php echo $stock_barcode_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_barcodelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_barcodelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_barcodelist.lists["x_product"] = <?php echo $stock_barcode_list->product->Lookup->toClientList() ?>;
fstock_barcodelist.lists["x_product"].options = <?php echo JsonEncode($stock_barcode_list->product->lookupOptions()) ?>;
fstock_barcodelist.lists["x_rid"] = <?php echo $stock_barcode_list->rid->Lookup->toClientList() ?>;
fstock_barcodelist.lists["x_rid"].options = <?php echo JsonEncode($stock_barcode_list->rid->lookupOptions()) ?>;
fstock_barcodelist.lists["x_godown"] = <?php echo $stock_barcode_list->godown->Lookup->toClientList() ?>;
fstock_barcodelist.lists["x_godown"].options = <?php echo JsonEncode($stock_barcode_list->godown->lookupOptions()) ?>;

// Form object for search
var fstock_barcodelistsrch = currentSearchForm = new ew.Form("fstock_barcodelistsrch");

// Validate function for search
fstock_barcodelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstock_barcodelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_barcodelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_barcodelistsrch.lists["x_godown"] = <?php echo $stock_barcode_list->godown->Lookup->toClientList() ?>;
fstock_barcodelistsrch.lists["x_godown"].options = <?php echo JsonEncode($stock_barcode_list->godown->lookupOptions()) ?>;

// Filters
fstock_barcodelistsrch.filterList = <?php echo $stock_barcode_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_barcodelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_barcode->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_barcode_list->TotalRecs > 0 && $stock_barcode_list->ExportOptions->visible()) { ?>
<?php $stock_barcode_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_barcode_list->ImportOptions->visible()) { ?>
<?php $stock_barcode_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_barcode_list->SearchOptions->visible()) { ?>
<?php $stock_barcode_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_barcode_list->FilterOptions->visible()) { ?>
<?php $stock_barcode_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_barcode_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_barcode->isExport() && !$stock_barcode->CurrentAction) { ?>
<form name="fstock_barcodelistsrch" id="fstock_barcodelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_barcode_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_barcodelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_barcode">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_barcode_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock_barcode->RowType = ROWTYPE_SEARCH;

// Render row
$stock_barcode->resetAttributes();
$stock_barcode_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock_barcode->godown->Visible) { // godown ?>
	<div id="xsc_godown" class="ew-cell form-group">
		<label for="x_godown" class="ew-search-caption ew-label"><?php echo $stock_barcode->godown->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_barcode" data-field="x_godown" data-value-separator="<?php echo $stock_barcode->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_barcode->godown->editAttributes() ?>>
		<?php echo $stock_barcode->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_barcode->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
	</div>
<?php } ?>
<?php if ($stock_barcode->lot_no->Visible) { // lot_no ?>
	<div id="xsc_lot_no" class="ew-cell form-group">
		<label for="x_lot_no" class="ew-search-caption ew-label"><?php echo $stock_barcode->lot_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_barcode" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($stock_barcode->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->lot_no->EditValue ?>"<?php echo $stock_barcode->lot_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_barcode_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_barcode_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_barcode_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_barcode_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_barcode_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_barcode_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_barcode_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_barcode_list->showPageHeader(); ?>
<?php
$stock_barcode_list->showMessage();
?>
<?php if ($stock_barcode_list->TotalRecs > 0 || $stock_barcode->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_barcode_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_barcode">
<?php if (!$stock_barcode->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_barcode->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_barcode_list->Pager)) $stock_barcode_list->Pager = new PrevNextPager($stock_barcode_list->StartRec, $stock_barcode_list->DisplayRecs, $stock_barcode_list->TotalRecs, $stock_barcode_list->AutoHidePager) ?>
<?php if ($stock_barcode_list->Pager->RecordCount > 0 && $stock_barcode_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_barcode_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_barcode_list->pageUrl() ?>start=<?php echo $stock_barcode_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_barcode_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_barcode_list->pageUrl() ?>start=<?php echo $stock_barcode_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_barcode_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_barcode_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_barcode_list->pageUrl() ?>start=<?php echo $stock_barcode_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_barcode_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_barcode_list->pageUrl() ?>start=<?php echo $stock_barcode_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_barcode_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_barcode_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_barcode_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_barcode_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_barcode_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_barcode_list->TotalRecs > 0 && (!$stock_barcode_list->AutoHidePageSizeSelector || $stock_barcode_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_barcode">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_barcode_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_barcode_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_barcode_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_barcode_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_barcode_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_barcode->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_barcode_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_barcodelist" id="fstock_barcodelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_barcode_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_barcode_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_barcode">
<div id="gmp_stock_barcode" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_barcode_list->TotalRecs > 0 || $stock_barcode->isGridEdit()) { ?>
<table id="tbl_stock_barcodelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_barcode_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_barcode_list->renderListOptions();

// Render list options (header, left)
$stock_barcode_list->ListOptions->render("header", "left");
?>
<?php if ($stock_barcode->product->Visible) { // product ?>
	<?php if ($stock_barcode->sortUrl($stock_barcode->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_barcode->product->headerCellClass() ?>"><div id="elh_stock_barcode_product" class="stock_barcode_product"><div class="ew-table-header-caption"><?php echo $stock_barcode->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_barcode->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_barcode->SortUrl($stock_barcode->product) ?>',2);"><div id="elh_stock_barcode_product" class="stock_barcode_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_barcode->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_barcode->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_barcode->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_barcode->rid->Visible) { // rid ?>
	<?php if ($stock_barcode->sortUrl($stock_barcode->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $stock_barcode->rid->headerCellClass() ?>"><div id="elh_stock_barcode_rid" class="stock_barcode_rid"><div class="ew-table-header-caption"><?php echo $stock_barcode->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $stock_barcode->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_barcode->SortUrl($stock_barcode->rid) ?>',2);"><div id="elh_stock_barcode_rid" class="stock_barcode_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_barcode->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_barcode->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_barcode->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_barcode->godown->Visible) { // godown ?>
	<?php if ($stock_barcode->sortUrl($stock_barcode->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_barcode->godown->headerCellClass() ?>"><div id="elh_stock_barcode_godown" class="stock_barcode_godown"><div class="ew-table-header-caption"><?php echo $stock_barcode->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_barcode->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_barcode->SortUrl($stock_barcode->godown) ?>',2);"><div id="elh_stock_barcode_godown" class="stock_barcode_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_barcode->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_barcode->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_barcode->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_barcode->IN->Visible) { // IN ?>
	<?php if ($stock_barcode->sortUrl($stock_barcode->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_barcode->IN->headerCellClass() ?>"><div id="elh_stock_barcode_IN" class="stock_barcode_IN"><div class="ew-table-header-caption"><?php echo $stock_barcode->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_barcode->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_barcode->SortUrl($stock_barcode->IN) ?>',2);"><div id="elh_stock_barcode_IN" class="stock_barcode_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_barcode->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_barcode->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_barcode->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_barcode->OUT->Visible) { // OUT ?>
	<?php if ($stock_barcode->sortUrl($stock_barcode->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_barcode->OUT->headerCellClass() ?>"><div id="elh_stock_barcode_OUT" class="stock_barcode_OUT"><div class="ew-table-header-caption"><?php echo $stock_barcode->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_barcode->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_barcode->SortUrl($stock_barcode->OUT) ?>',2);"><div id="elh_stock_barcode_OUT" class="stock_barcode_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_barcode->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_barcode->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_barcode->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_barcode->Balance->Visible) { // Balance ?>
	<?php if ($stock_barcode->sortUrl($stock_barcode->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $stock_barcode->Balance->headerCellClass() ?>"><div id="elh_stock_barcode_Balance" class="stock_barcode_Balance"><div class="ew-table-header-caption"><?php echo $stock_barcode->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $stock_barcode->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_barcode->SortUrl($stock_barcode->Balance) ?>',2);"><div id="elh_stock_barcode_Balance" class="stock_barcode_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_barcode->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_barcode->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_barcode->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_barcode->packets->Visible) { // packets ?>
	<?php if ($stock_barcode->sortUrl($stock_barcode->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_barcode->packets->headerCellClass() ?>"><div id="elh_stock_barcode_packets" class="stock_barcode_packets"><div class="ew-table-header-caption"><?php echo $stock_barcode->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_barcode->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_barcode->SortUrl($stock_barcode->packets) ?>',2);"><div id="elh_stock_barcode_packets" class="stock_barcode_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_barcode->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_barcode->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_barcode->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_barcode->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_barcode->sortUrl($stock_barcode->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_barcode->lot_no->headerCellClass() ?>"><div id="elh_stock_barcode_lot_no" class="stock_barcode_lot_no"><div class="ew-table-header-caption"><?php echo $stock_barcode->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_barcode->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_barcode->SortUrl($stock_barcode->lot_no) ?>',2);"><div id="elh_stock_barcode_lot_no" class="stock_barcode_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_barcode->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_barcode->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_barcode->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_barcode->type->Visible) { // type ?>
	<?php if ($stock_barcode->sortUrl($stock_barcode->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_barcode->type->headerCellClass() ?>"><div id="elh_stock_barcode_type" class="stock_barcode_type"><div class="ew-table-header-caption"><?php echo $stock_barcode->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_barcode->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_barcode->SortUrl($stock_barcode->type) ?>',2);"><div id="elh_stock_barcode_type" class="stock_barcode_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_barcode->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_barcode->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_barcode->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_barcode->company_id->Visible) { // company_id ?>
	<?php if ($stock_barcode->sortUrl($stock_barcode->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $stock_barcode->company_id->headerCellClass() ?>"><div id="elh_stock_barcode_company_id" class="stock_barcode_company_id"><div class="ew-table-header-caption"><?php echo $stock_barcode->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $stock_barcode->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_barcode->SortUrl($stock_barcode->company_id) ?>',2);"><div id="elh_stock_barcode_company_id" class="stock_barcode_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_barcode->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_barcode->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_barcode->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_barcode_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_barcode->ExportAll && $stock_barcode->isExport()) {
	$stock_barcode_list->StopRec = $stock_barcode_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_barcode_list->TotalRecs > $stock_barcode_list->StartRec + $stock_barcode_list->DisplayRecs - 1)
		$stock_barcode_list->StopRec = $stock_barcode_list->StartRec + $stock_barcode_list->DisplayRecs - 1;
	else
		$stock_barcode_list->StopRec = $stock_barcode_list->TotalRecs;
}
$stock_barcode_list->RecCnt = $stock_barcode_list->StartRec - 1;
if ($stock_barcode_list->Recordset && !$stock_barcode_list->Recordset->EOF) {
	$stock_barcode_list->Recordset->moveFirst();
	$selectLimit = $stock_barcode_list->UseSelectLimit;
	if (!$selectLimit && $stock_barcode_list->StartRec > 1)
		$stock_barcode_list->Recordset->move($stock_barcode_list->StartRec - 1);
} elseif (!$stock_barcode->AllowAddDeleteRow && $stock_barcode_list->StopRec == 0) {
	$stock_barcode_list->StopRec = $stock_barcode->GridAddRowCount;
}

// Initialize aggregate
$stock_barcode->RowType = ROWTYPE_AGGREGATEINIT;
$stock_barcode->resetAttributes();
$stock_barcode_list->renderRow();
while ($stock_barcode_list->RecCnt < $stock_barcode_list->StopRec) {
	$stock_barcode_list->RecCnt++;
	if ($stock_barcode_list->RecCnt >= $stock_barcode_list->StartRec) {
		$stock_barcode_list->RowCnt++;

		// Set up key count
		$stock_barcode_list->KeyCount = $stock_barcode_list->RowIndex;

		// Init row class and style
		$stock_barcode->resetAttributes();
		$stock_barcode->CssClass = "";
		if ($stock_barcode->isGridAdd()) {
		} else {
			$stock_barcode_list->loadRowValues($stock_barcode_list->Recordset); // Load row values
		}
		$stock_barcode->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_barcode->RowAttrs = array_merge($stock_barcode->RowAttrs, array('data-rowindex'=>$stock_barcode_list->RowCnt, 'id'=>'r' . $stock_barcode_list->RowCnt . '_stock_barcode', 'data-rowtype'=>$stock_barcode->RowType));

		// Render row
		$stock_barcode_list->renderRow();

		// Render list options
		$stock_barcode_list->renderListOptions();
?>
	<tr<?php echo $stock_barcode->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_barcode_list->ListOptions->render("body", "left", $stock_barcode_list->RowCnt);
?>
	<?php if ($stock_barcode->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_barcode->product->cellAttributes() ?>>
<span id="el<?php echo $stock_barcode_list->RowCnt ?>_stock_barcode_product" class="stock_barcode_product">
<span<?php echo $stock_barcode->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_barcode->product->getViewValue())) && $stock_barcode->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_barcode->product->linkAttributes() ?>><?php echo $stock_barcode->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_barcode->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_barcode->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $stock_barcode->rid->cellAttributes() ?>>
<span id="el<?php echo $stock_barcode_list->RowCnt ?>_stock_barcode_rid" class="stock_barcode_rid">
<span<?php echo $stock_barcode->rid->viewAttributes() ?>>
<?php echo $stock_barcode->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_barcode->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_barcode->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_barcode_list->RowCnt ?>_stock_barcode_godown" class="stock_barcode_godown">
<span<?php echo $stock_barcode->godown->viewAttributes() ?>>
<?php echo $stock_barcode->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_barcode->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_barcode->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_barcode_list->RowCnt ?>_stock_barcode_IN" class="stock_barcode_IN">
<span<?php echo $stock_barcode->IN->viewAttributes() ?>>
<?php echo $stock_barcode->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_barcode->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_barcode->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_barcode_list->RowCnt ?>_stock_barcode_OUT" class="stock_barcode_OUT">
<span<?php echo $stock_barcode->OUT->viewAttributes() ?>>
<?php echo $stock_barcode->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_barcode->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $stock_barcode->Balance->cellAttributes() ?>>
<span id="el<?php echo $stock_barcode_list->RowCnt ?>_stock_barcode_Balance" class="stock_barcode_Balance">
<span<?php echo $stock_barcode->Balance->viewAttributes() ?>>
<?php if ((!EmptyString($stock_barcode->Balance->getViewValue())) && $stock_barcode->Balance->linkAttributes() <> "") { ?>
<a<?php echo $stock_barcode->Balance->linkAttributes() ?>><?php echo $stock_barcode->Balance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_barcode->Balance->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_barcode->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_barcode->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_barcode_list->RowCnt ?>_stock_barcode_packets" class="stock_barcode_packets">
<span<?php echo $stock_barcode->packets->viewAttributes() ?>>
<?php echo $stock_barcode->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_barcode->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_barcode->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_barcode_list->RowCnt ?>_stock_barcode_lot_no" class="stock_barcode_lot_no">
<span<?php echo $stock_barcode->lot_no->viewAttributes() ?>>
<?php echo $stock_barcode->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_barcode->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_barcode->type->cellAttributes() ?>>
<span id="el<?php echo $stock_barcode_list->RowCnt ?>_stock_barcode_type" class="stock_barcode_type">
<span<?php echo $stock_barcode->type->viewAttributes() ?>>
<?php echo $stock_barcode->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_barcode->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $stock_barcode->company_id->cellAttributes() ?>>
<span id="el<?php echo $stock_barcode_list->RowCnt ?>_stock_barcode_company_id" class="stock_barcode_company_id">
<span<?php echo $stock_barcode->company_id->viewAttributes() ?>>
<?php echo $stock_barcode->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_barcode_list->ListOptions->render("body", "right", $stock_barcode_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_barcode->isGridAdd())
		$stock_barcode_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_barcode->RowType = ROWTYPE_AGGREGATE;
$stock_barcode->resetAttributes();
$stock_barcode_list->renderRow();
?>
<?php if ($stock_barcode_list->TotalRecs > 0 && !$stock_barcode->isGridAdd() && !$stock_barcode->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_barcode_list->renderListOptions();

// Render list options (footer, left)
$stock_barcode_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_barcode->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_barcode->product->footerCellClass() ?>"><span id="elf_stock_barcode_product" class="stock_barcode_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_barcode->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $stock_barcode->rid->footerCellClass() ?>"><span id="elf_stock_barcode_rid" class="stock_barcode_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_barcode->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_barcode->godown->footerCellClass() ?>"><span id="elf_stock_barcode_godown" class="stock_barcode_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_barcode->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_barcode->IN->footerCellClass() ?>"><span id="elf_stock_barcode_IN" class="stock_barcode_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_barcode->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_barcode->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_barcode->OUT->footerCellClass() ?>"><span id="elf_stock_barcode_OUT" class="stock_barcode_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_barcode->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_barcode->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $stock_barcode->Balance->footerCellClass() ?>"><span id="elf_stock_barcode_Balance" class="stock_barcode_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_barcode->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_barcode->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_barcode->packets->footerCellClass() ?>"><span id="elf_stock_barcode_packets" class="stock_barcode_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_barcode->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_barcode->lot_no->footerCellClass() ?>"><span id="elf_stock_barcode_lot_no" class="stock_barcode_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_barcode->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $stock_barcode->type->footerCellClass() ?>"><span id="elf_stock_barcode_type" class="stock_barcode_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_barcode->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $stock_barcode->company_id->footerCellClass() ?>"><span id="elf_stock_barcode_company_id" class="stock_barcode_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_barcode_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_barcode->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_barcode_list->Recordset)
	$stock_barcode_list->Recordset->Close();
?>
<?php if (!$stock_barcode->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_barcode->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_barcode_list->Pager)) $stock_barcode_list->Pager = new PrevNextPager($stock_barcode_list->StartRec, $stock_barcode_list->DisplayRecs, $stock_barcode_list->TotalRecs, $stock_barcode_list->AutoHidePager) ?>
<?php if ($stock_barcode_list->Pager->RecordCount > 0 && $stock_barcode_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_barcode_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_barcode_list->pageUrl() ?>start=<?php echo $stock_barcode_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_barcode_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_barcode_list->pageUrl() ?>start=<?php echo $stock_barcode_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_barcode_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_barcode_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_barcode_list->pageUrl() ?>start=<?php echo $stock_barcode_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_barcode_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_barcode_list->pageUrl() ?>start=<?php echo $stock_barcode_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_barcode_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_barcode_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_barcode_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_barcode_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_barcode_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_barcode_list->TotalRecs > 0 && (!$stock_barcode_list->AutoHidePageSizeSelector || $stock_barcode_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_barcode">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_barcode_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_barcode_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_barcode_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_barcode_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_barcode_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_barcode->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_barcode_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_barcode_list->TotalRecs == 0 && !$stock_barcode->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_barcode_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_barcode_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_barcode->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_barcode->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_barcode", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_barcode_list->terminate();
?>