<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_barcode_search = new stock_barcode_search();

// Run the page
$stock_barcode_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_barcode_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($stock_barcode_search->IsModal) { ?>
var fstock_barcodesearch = currentAdvancedSearchForm = new ew.Form("fstock_barcodesearch", "search");
<?php } else { ?>
var fstock_barcodesearch = currentForm = new ew.Form("fstock_barcodesearch", "search");
<?php } ?>

// Form_CustomValidate event
fstock_barcodesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_barcodesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_barcodesearch.lists["x_product"] = <?php echo $stock_barcode_search->product->Lookup->toClientList() ?>;
fstock_barcodesearch.lists["x_product"].options = <?php echo JsonEncode($stock_barcode_search->product->lookupOptions()) ?>;
fstock_barcodesearch.lists["x_rid"] = <?php echo $stock_barcode_search->rid->Lookup->toClientList() ?>;
fstock_barcodesearch.lists["x_rid"].options = <?php echo JsonEncode($stock_barcode_search->rid->lookupOptions()) ?>;
fstock_barcodesearch.lists["x_godown"] = <?php echo $stock_barcode_search->godown->Lookup->toClientList() ?>;
fstock_barcodesearch.lists["x_godown"].options = <?php echo JsonEncode($stock_barcode_search->godown->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fstock_barcodesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_barcode->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_barcode->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_barcode->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_barcode->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packing_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_barcode->packing_type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_barcode->company_id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_barcode_search->showPageHeader(); ?>
<?php
$stock_barcode_search->showMessage();
?>
<form name="fstock_barcodesearch" id="fstock_barcodesearch" class="<?php echo $stock_barcode_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_barcode_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_barcode_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_barcode">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$stock_barcode_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($stock_barcode->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_product"><?php echo $stock_barcode->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->product->cellAttributes() ?>>
			<span id="el_stock_barcode_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_barcode" data-field="x_product" data-value-separator="<?php echo $stock_barcode->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_barcode->product->editAttributes() ?>>
		<?php echo $stock_barcode->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_barcode->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_rid"><?php echo $stock_barcode->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->rid->cellAttributes() ?>>
			<span id="el_stock_barcode_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_barcode" data-field="x_rid" data-value-separator="<?php echo $stock_barcode->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $stock_barcode->rid->editAttributes() ?>>
		<?php echo $stock_barcode->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $stock_barcode->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_godown"><?php echo $stock_barcode->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->godown->cellAttributes() ?>>
			<span id="el_stock_barcode_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_barcode" data-field="x_godown" data-value-separator="<?php echo $stock_barcode->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_barcode->godown->editAttributes() ?>>
		<?php echo $stock_barcode->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_barcode->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_IN"><?php echo $stock_barcode->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->IN->cellAttributes() ?>>
			<span id="el_stock_barcode_IN">
<input type="text" data-table="stock_barcode" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($stock_barcode->IN->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->IN->EditValue ?>"<?php echo $stock_barcode->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_OUT"><?php echo $stock_barcode->OUT->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->OUT->cellAttributes() ?>>
			<span id="el_stock_barcode_OUT">
<input type="text" data-table="stock_barcode" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($stock_barcode->OUT->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->OUT->EditValue ?>"<?php echo $stock_barcode->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_Balance"><?php echo $stock_barcode->Balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Balance" id="z_Balance" value="="></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->Balance->cellAttributes() ?>>
			<span id="el_stock_barcode_Balance">
<input type="text" data-table="stock_barcode" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($stock_barcode->Balance->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->Balance->EditValue ?>"<?php echo $stock_barcode->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_packets"><?php echo $stock_barcode->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->packets->cellAttributes() ?>>
			<span id="el_stock_barcode_packets">
<input type="text" data-table="stock_barcode" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($stock_barcode->packets->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->packets->EditValue ?>"<?php echo $stock_barcode->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_packing_type"><?php echo $stock_barcode->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->packing_type->cellAttributes() ?>>
			<span id="el_stock_barcode_packing_type">
<input type="text" data-table="stock_barcode" data-field="x_packing_type" name="x_packing_type" id="x_packing_type" size="30" placeholder="<?php echo HtmlEncode($stock_barcode->packing_type->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->packing_type->EditValue ?>"<?php echo $stock_barcode->packing_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_lot_no"><?php echo $stock_barcode->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->lot_no->cellAttributes() ?>>
			<span id="el_stock_barcode_lot_no">
<input type="text" data-table="stock_barcode" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($stock_barcode->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->lot_no->EditValue ?>"<?php echo $stock_barcode->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_dated"><?php echo $stock_barcode->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_dated" id="z_dated" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->dated->cellAttributes() ?>>
			<span id="el_stock_barcode_dated">
<input type="text" data-table="stock_barcode" data-field="x_dated" name="x_dated" id="x_dated" size="35" placeholder="<?php echo HtmlEncode($stock_barcode->dated->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->dated->EditValue ?>"<?php echo $stock_barcode->dated->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_type"><?php echo $stock_barcode->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->type->cellAttributes() ?>>
			<span id="el_stock_barcode_type">
<input type="text" data-table="stock_barcode" data-field="x_type" name="x_type" id="x_type" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($stock_barcode->type->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->type->EditValue ?>"<?php echo $stock_barcode->type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label for="x_url" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_url"><?php echo $stock_barcode->url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url" id="z_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->url->cellAttributes() ?>>
			<span id="el_stock_barcode_url">
<input type="text" data-table="stock_barcode" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="187" placeholder="<?php echo HtmlEncode($stock_barcode->url->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->url->EditValue ?>"<?php echo $stock_barcode->url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_barcode->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $stock_barcode_search->LeftColumnClass ?>"><span id="elh_stock_barcode_company_id"><?php echo $stock_barcode->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $stock_barcode_search->RightColumnClass ?>"><div<?php echo $stock_barcode->company_id->cellAttributes() ?>>
			<span id="el_stock_barcode_company_id">
<input type="text" data-table="stock_barcode" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($stock_barcode->company_id->getPlaceHolder()) ?>" value="<?php echo $stock_barcode->company_id->EditValue ?>"<?php echo $stock_barcode->company_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_barcode_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_barcode_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_barcode_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_barcode_search->terminate();
?>