<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_blending_list = new stock_blending_list();

// Run the page
$stock_blending_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_blending_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_blending->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_blendinglist = currentForm = new ew.Form("fstock_blendinglist", "list");
fstock_blendinglist.formKeyCountName = '<?php echo $stock_blending_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_blendinglist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_blendinglist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_blendinglist.lists["x_product"] = <?php echo $stock_blending_list->product->Lookup->toClientList() ?>;
fstock_blendinglist.lists["x_product"].options = <?php echo JsonEncode($stock_blending_list->product->lookupOptions()) ?>;
fstock_blendinglist.lists["x_godown"] = <?php echo $stock_blending_list->godown->Lookup->toClientList() ?>;
fstock_blendinglist.lists["x_godown"].options = <?php echo JsonEncode($stock_blending_list->godown->lookupOptions()) ?>;
fstock_blendinglist.lists["x_packing_type"] = <?php echo $stock_blending_list->packing_type->Lookup->toClientList() ?>;
fstock_blendinglist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_blending_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fstock_blendinglistsrch = currentSearchForm = new ew.Form("fstock_blendinglistsrch");

// Filters
fstock_blendinglistsrch.filterList = <?php echo $stock_blending_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_blendinglistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_blending->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_blending_list->TotalRecs > 0 && $stock_blending_list->ExportOptions->visible()) { ?>
<?php $stock_blending_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_blending_list->ImportOptions->visible()) { ?>
<?php $stock_blending_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_blending_list->SearchOptions->visible()) { ?>
<?php $stock_blending_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_blending_list->FilterOptions->visible()) { ?>
<?php $stock_blending_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_blending_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_blending->isExport() && !$stock_blending->CurrentAction) { ?>
<form name="fstock_blendinglistsrch" id="fstock_blendinglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_blending_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_blendinglistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_blending">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_blending_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_blending_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_blending_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_blending_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_blending_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_blending_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_blending_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_blending_list->showPageHeader(); ?>
<?php
$stock_blending_list->showMessage();
?>
<?php if ($stock_blending_list->TotalRecs > 0 || $stock_blending->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_blending_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_blending">
<?php if (!$stock_blending->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_blending->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_blending_list->Pager)) $stock_blending_list->Pager = new PrevNextPager($stock_blending_list->StartRec, $stock_blending_list->DisplayRecs, $stock_blending_list->TotalRecs, $stock_blending_list->AutoHidePager) ?>
<?php if ($stock_blending_list->Pager->RecordCount > 0 && $stock_blending_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_blending_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_blending_list->pageUrl() ?>start=<?php echo $stock_blending_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_blending_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_blending_list->pageUrl() ?>start=<?php echo $stock_blending_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_blending_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_blending_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_blending_list->pageUrl() ?>start=<?php echo $stock_blending_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_blending_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_blending_list->pageUrl() ?>start=<?php echo $stock_blending_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_blending_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_blending_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_blending_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_blending_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_blending_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_blending_list->TotalRecs > 0 && (!$stock_blending_list->AutoHidePageSizeSelector || $stock_blending_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_blending">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_blending_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_blending_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_blending_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_blending_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_blending_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_blending->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_blending_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_blendinglist" id="fstock_blendinglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_blending_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_blending_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_blending">
<div id="gmp_stock_blending" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_blending_list->TotalRecs > 0 || $stock_blending->isGridEdit()) { ?>
<table id="tbl_stock_blendinglist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_blending_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_blending_list->renderListOptions();

// Render list options (header, left)
$stock_blending_list->ListOptions->render("header", "left");
?>
<?php if ($stock_blending->product->Visible) { // product ?>
	<?php if ($stock_blending->sortUrl($stock_blending->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_blending->product->headerCellClass() ?>"><div id="elh_stock_blending_product" class="stock_blending_product"><div class="ew-table-header-caption"><?php echo $stock_blending->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_blending->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_blending->SortUrl($stock_blending->product) ?>',2);"><div id="elh_stock_blending_product" class="stock_blending_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_blending->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_blending->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_blending->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_blending->product_code->Visible) { // product_code ?>
	<?php if ($stock_blending->sortUrl($stock_blending->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_blending->product_code->headerCellClass() ?>"><div id="elh_stock_blending_product_code" class="stock_blending_product_code"><div class="ew-table-header-caption"><?php echo $stock_blending->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_blending->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_blending->SortUrl($stock_blending->product_code) ?>',2);"><div id="elh_stock_blending_product_code" class="stock_blending_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_blending->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_blending->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_blending->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_blending->godown->Visible) { // godown ?>
	<?php if ($stock_blending->sortUrl($stock_blending->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_blending->godown->headerCellClass() ?>"><div id="elh_stock_blending_godown" class="stock_blending_godown"><div class="ew-table-header-caption"><?php echo $stock_blending->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_blending->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_blending->SortUrl($stock_blending->godown) ?>',2);"><div id="elh_stock_blending_godown" class="stock_blending_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_blending->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_blending->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_blending->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_blending->IN->Visible) { // IN ?>
	<?php if ($stock_blending->sortUrl($stock_blending->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_blending->IN->headerCellClass() ?>"><div id="elh_stock_blending_IN" class="stock_blending_IN"><div class="ew-table-header-caption"><?php echo $stock_blending->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_blending->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_blending->SortUrl($stock_blending->IN) ?>',2);"><div id="elh_stock_blending_IN" class="stock_blending_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_blending->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_blending->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_blending->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_blending->packets->Visible) { // packets ?>
	<?php if ($stock_blending->sortUrl($stock_blending->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_blending->packets->headerCellClass() ?>"><div id="elh_stock_blending_packets" class="stock_blending_packets"><div class="ew-table-header-caption"><?php echo $stock_blending->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_blending->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_blending->SortUrl($stock_blending->packets) ?>',2);"><div id="elh_stock_blending_packets" class="stock_blending_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_blending->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_blending->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_blending->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_blending->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_blending->sortUrl($stock_blending->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_blending->packing_type->headerCellClass() ?>"><div id="elh_stock_blending_packing_type" class="stock_blending_packing_type"><div class="ew-table-header-caption"><?php echo $stock_blending->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_blending->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_blending->SortUrl($stock_blending->packing_type) ?>',2);"><div id="elh_stock_blending_packing_type" class="stock_blending_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_blending->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_blending->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_blending->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_blending->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_blending->sortUrl($stock_blending->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_blending->lot_no->headerCellClass() ?>"><div id="elh_stock_blending_lot_no" class="stock_blending_lot_no"><div class="ew-table-header-caption"><?php echo $stock_blending->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_blending->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_blending->SortUrl($stock_blending->lot_no) ?>',2);"><div id="elh_stock_blending_lot_no" class="stock_blending_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_blending->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_blending->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_blending->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_blending->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($stock_blending->sortUrl($stock_blending->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_blending->tmp_lot->headerCellClass() ?>"><div id="elh_stock_blending_tmp_lot" class="stock_blending_tmp_lot"><div class="ew-table-header-caption"><?php echo $stock_blending->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $stock_blending->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_blending->SortUrl($stock_blending->tmp_lot) ?>',2);"><div id="elh_stock_blending_tmp_lot" class="stock_blending_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_blending->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_blending->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_blending->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_blending_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_blending->ExportAll && $stock_blending->isExport()) {
	$stock_blending_list->StopRec = $stock_blending_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_blending_list->TotalRecs > $stock_blending_list->StartRec + $stock_blending_list->DisplayRecs - 1)
		$stock_blending_list->StopRec = $stock_blending_list->StartRec + $stock_blending_list->DisplayRecs - 1;
	else
		$stock_blending_list->StopRec = $stock_blending_list->TotalRecs;
}
$stock_blending_list->RecCnt = $stock_blending_list->StartRec - 1;
if ($stock_blending_list->Recordset && !$stock_blending_list->Recordset->EOF) {
	$stock_blending_list->Recordset->moveFirst();
	$selectLimit = $stock_blending_list->UseSelectLimit;
	if (!$selectLimit && $stock_blending_list->StartRec > 1)
		$stock_blending_list->Recordset->move($stock_blending_list->StartRec - 1);
} elseif (!$stock_blending->AllowAddDeleteRow && $stock_blending_list->StopRec == 0) {
	$stock_blending_list->StopRec = $stock_blending->GridAddRowCount;
}

// Initialize aggregate
$stock_blending->RowType = ROWTYPE_AGGREGATEINIT;
$stock_blending->resetAttributes();
$stock_blending_list->renderRow();
while ($stock_blending_list->RecCnt < $stock_blending_list->StopRec) {
	$stock_blending_list->RecCnt++;
	if ($stock_blending_list->RecCnt >= $stock_blending_list->StartRec) {
		$stock_blending_list->RowCnt++;

		// Set up key count
		$stock_blending_list->KeyCount = $stock_blending_list->RowIndex;

		// Init row class and style
		$stock_blending->resetAttributes();
		$stock_blending->CssClass = "";
		if ($stock_blending->isGridAdd()) {
		} else {
			$stock_blending_list->loadRowValues($stock_blending_list->Recordset); // Load row values
		}
		$stock_blending->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_blending->RowAttrs = array_merge($stock_blending->RowAttrs, array('data-rowindex'=>$stock_blending_list->RowCnt, 'id'=>'r' . $stock_blending_list->RowCnt . '_stock_blending', 'data-rowtype'=>$stock_blending->RowType));

		// Render row
		$stock_blending_list->renderRow();

		// Render list options
		$stock_blending_list->renderListOptions();
?>
	<tr<?php echo $stock_blending->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_blending_list->ListOptions->render("body", "left", $stock_blending_list->RowCnt);
?>
	<?php if ($stock_blending->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_blending->product->cellAttributes() ?>>
<span id="el<?php echo $stock_blending_list->RowCnt ?>_stock_blending_product" class="stock_blending_product">
<span<?php echo $stock_blending->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_blending->product->getViewValue())) && $stock_blending->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_blending->product->linkAttributes() ?>><?php echo $stock_blending->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_blending->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_blending->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_blending->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_blending_list->RowCnt ?>_stock_blending_product_code" class="stock_blending_product_code">
<span<?php echo $stock_blending->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_blending->product_code->getViewValue())) && $stock_blending->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_blending->product_code->linkAttributes() ?>><?php echo $stock_blending->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_blending->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_blending->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_blending->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_blending_list->RowCnt ?>_stock_blending_godown" class="stock_blending_godown">
<span<?php echo $stock_blending->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_blending->godown->getViewValue())) && $stock_blending->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_blending->godown->linkAttributes() ?>><?php echo $stock_blending->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_blending->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_blending->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_blending->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_blending_list->RowCnt ?>_stock_blending_IN" class="stock_blending_IN">
<span<?php echo $stock_blending->IN->viewAttributes() ?>>
<?php echo $stock_blending->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_blending->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_blending->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_blending_list->RowCnt ?>_stock_blending_packets" class="stock_blending_packets">
<span<?php echo $stock_blending->packets->viewAttributes() ?>>
<?php echo $stock_blending->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_blending->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_blending->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_blending_list->RowCnt ?>_stock_blending_packing_type" class="stock_blending_packing_type">
<span<?php echo $stock_blending->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_blending->packing_type->getViewValue())) && $stock_blending->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $stock_blending->packing_type->linkAttributes() ?>><?php echo $stock_blending->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_blending->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_blending->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_blending->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_blending_list->RowCnt ?>_stock_blending_lot_no" class="stock_blending_lot_no">
<span<?php echo $stock_blending->lot_no->viewAttributes() ?>>
<?php if ((!EmptyString($stock_blending->lot_no->getViewValue())) && $stock_blending->lot_no->linkAttributes() <> "") { ?>
<a<?php echo $stock_blending->lot_no->linkAttributes() ?>><?php echo $stock_blending->lot_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_blending->lot_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_blending->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $stock_blending->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $stock_blending_list->RowCnt ?>_stock_blending_tmp_lot" class="stock_blending_tmp_lot">
<span<?php echo $stock_blending->tmp_lot->viewAttributes() ?>>
<?php echo $stock_blending->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_blending_list->ListOptions->render("body", "right", $stock_blending_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_blending->isGridAdd())
		$stock_blending_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_blending->RowType = ROWTYPE_AGGREGATE;
$stock_blending->resetAttributes();
$stock_blending_list->renderRow();
?>
<?php if ($stock_blending_list->TotalRecs > 0 && !$stock_blending->isGridAdd() && !$stock_blending->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_blending_list->renderListOptions();

// Render list options (footer, left)
$stock_blending_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_blending->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_blending->product->footerCellClass() ?>"><span id="elf_stock_blending_product" class="stock_blending_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_blending->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_blending->product_code->footerCellClass() ?>"><span id="elf_stock_blending_product_code" class="stock_blending_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_blending->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_blending->godown->footerCellClass() ?>"><span id="elf_stock_blending_godown" class="stock_blending_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_blending->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_blending->IN->footerCellClass() ?>"><span id="elf_stock_blending_IN" class="stock_blending_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_blending->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_blending->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_blending->packets->footerCellClass() ?>"><span id="elf_stock_blending_packets" class="stock_blending_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_blending->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_blending->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_blending->packing_type->footerCellClass() ?>"><span id="elf_stock_blending_packing_type" class="stock_blending_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_blending->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_blending->lot_no->footerCellClass() ?>"><span id="elf_stock_blending_lot_no" class="stock_blending_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_blending->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $stock_blending->tmp_lot->footerCellClass() ?>"><span id="elf_stock_blending_tmp_lot" class="stock_blending_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_blending_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_blending->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_blending_list->Recordset)
	$stock_blending_list->Recordset->Close();
?>
<?php if (!$stock_blending->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_blending->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_blending_list->Pager)) $stock_blending_list->Pager = new PrevNextPager($stock_blending_list->StartRec, $stock_blending_list->DisplayRecs, $stock_blending_list->TotalRecs, $stock_blending_list->AutoHidePager) ?>
<?php if ($stock_blending_list->Pager->RecordCount > 0 && $stock_blending_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_blending_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_blending_list->pageUrl() ?>start=<?php echo $stock_blending_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_blending_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_blending_list->pageUrl() ?>start=<?php echo $stock_blending_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_blending_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_blending_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_blending_list->pageUrl() ?>start=<?php echo $stock_blending_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_blending_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_blending_list->pageUrl() ?>start=<?php echo $stock_blending_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_blending_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_blending_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_blending_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_blending_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_blending_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_blending_list->TotalRecs > 0 && (!$stock_blending_list->AutoHidePageSizeSelector || $stock_blending_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_blending">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_blending_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_blending_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_blending_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_blending_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_blending_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_blending->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_blending_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_blending_list->TotalRecs == 0 && !$stock_blending->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_blending_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_blending_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_blending->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_blending->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_blending", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_blending_list->terminate();
?>