<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_consume_delete = new stock_consume_delete();

// Run the page
$stock_consume_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_consume_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fstock_consumedelete = currentForm = new ew.Form("fstock_consumedelete", "delete");

// Form_CustomValidate event
fstock_consumedelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_consumedelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_consumedelete.lists["x_location"] = <?php echo $stock_consume_delete->location->Lookup->toClientList() ?>;
fstock_consumedelete.lists["x_location"].options = <?php echo JsonEncode($stock_consume_delete->location->lookupOptions()) ?>;
fstock_consumedelete.lists["x_design_id"] = <?php echo $stock_consume_delete->design_id->Lookup->toClientList() ?>;
fstock_consumedelete.lists["x_design_id"].options = <?php echo JsonEncode($stock_consume_delete->design_id->lookupOptions()) ?>;
fstock_consumedelete.lists["x_status"] = <?php echo $stock_consume_delete->status->Lookup->toClientList() ?>;
fstock_consumedelete.lists["x_status"].options = <?php echo JsonEncode($stock_consume_delete->status->lookupOptions()) ?>;
fstock_consumedelete.lists["x_consumed_status"] = <?php echo $stock_consume_delete->consumed_status->Lookup->toClientList() ?>;
fstock_consumedelete.lists["x_consumed_status"].options = <?php echo JsonEncode($stock_consume_delete->consumed_status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_consume_delete->showPageHeader(); ?>
<?php
$stock_consume_delete->showMessage();
?>
<form name="fstock_consumedelete" id="fstock_consumedelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_consume_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_consume_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_consume">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($stock_consume_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($stock_consume->location->Visible) { // location ?>
		<th class="<?php echo $stock_consume->location->headerCellClass() ?>"><span id="elh_stock_consume_location" class="stock_consume_location"><?php echo $stock_consume->location->caption() ?></span></th>
<?php } ?>
<?php if ($stock_consume->_barcode->Visible) { // barcode ?>
		<th class="<?php echo $stock_consume->_barcode->headerCellClass() ?>"><span id="elh_stock_consume__barcode" class="stock_consume__barcode"><?php echo $stock_consume->_barcode->caption() ?></span></th>
<?php } ?>
<?php if ($stock_consume->design_id->Visible) { // design_id ?>
		<th class="<?php echo $stock_consume->design_id->headerCellClass() ?>"><span id="elh_stock_consume_design_id" class="stock_consume_design_id"><?php echo $stock_consume->design_id->caption() ?></span></th>
<?php } ?>
<?php if ($stock_consume->sqm->Visible) { // sqm ?>
		<th class="<?php echo $stock_consume->sqm->headerCellClass() ?>"><span id="elh_stock_consume_sqm" class="stock_consume_sqm"><?php echo $stock_consume->sqm->caption() ?></span></th>
<?php } ?>
<?php if ($stock_consume->status->Visible) { // status ?>
		<th class="<?php echo $stock_consume->status->headerCellClass() ?>"><span id="elh_stock_consume_status" class="stock_consume_status"><?php echo $stock_consume->status->caption() ?></span></th>
<?php } ?>
<?php if ($stock_consume->remarks->Visible) { // remarks ?>
		<th class="<?php echo $stock_consume->remarks->headerCellClass() ?>"><span id="elh_stock_consume_remarks" class="stock_consume_remarks"><?php echo $stock_consume->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($stock_consume->consumed_by->Visible) { // consumed_by ?>
		<th class="<?php echo $stock_consume->consumed_by->headerCellClass() ?>"><span id="elh_stock_consume_consumed_by" class="stock_consume_consumed_by"><?php echo $stock_consume->consumed_by->caption() ?></span></th>
<?php } ?>
<?php if ($stock_consume->consumed_status->Visible) { // consumed_status ?>
		<th class="<?php echo $stock_consume->consumed_status->headerCellClass() ?>"><span id="elh_stock_consume_consumed_status" class="stock_consume_consumed_status"><?php echo $stock_consume->consumed_status->caption() ?></span></th>
<?php } ?>
<?php if ($stock_consume->consumed_sqm->Visible) { // consumed_sqm ?>
		<th class="<?php echo $stock_consume->consumed_sqm->headerCellClass() ?>"><span id="elh_stock_consume_consumed_sqm" class="stock_consume_consumed_sqm"><?php echo $stock_consume->consumed_sqm->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$stock_consume_delete->RecCnt = 0;
$i = 0;
while (!$stock_consume_delete->Recordset->EOF) {
	$stock_consume_delete->RecCnt++;
	$stock_consume_delete->RowCnt++;

	// Set row properties
	$stock_consume->resetAttributes();
	$stock_consume->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$stock_consume_delete->loadRowValues($stock_consume_delete->Recordset);

	// Render row
	$stock_consume_delete->renderRow();
?>
	<tr<?php echo $stock_consume->rowAttributes() ?>>
<?php if ($stock_consume->location->Visible) { // location ?>
		<td<?php echo $stock_consume->location->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_delete->RowCnt ?>_stock_consume_location" class="stock_consume_location">
<span<?php echo $stock_consume->location->viewAttributes() ?>>
<?php echo $stock_consume->location->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($stock_consume->_barcode->Visible) { // barcode ?>
		<td<?php echo $stock_consume->_barcode->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_delete->RowCnt ?>_stock_consume__barcode" class="stock_consume__barcode">
<span<?php echo $stock_consume->_barcode->viewAttributes() ?>>
<?php echo $stock_consume->_barcode->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($stock_consume->design_id->Visible) { // design_id ?>
		<td<?php echo $stock_consume->design_id->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_delete->RowCnt ?>_stock_consume_design_id" class="stock_consume_design_id">
<span<?php echo $stock_consume->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($stock_consume->design_id->getViewValue())) && $stock_consume->design_id->linkAttributes() <> "") { ?>
<a<?php echo $stock_consume->design_id->linkAttributes() ?>><?php echo $stock_consume->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_consume->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($stock_consume->sqm->Visible) { // sqm ?>
		<td<?php echo $stock_consume->sqm->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_delete->RowCnt ?>_stock_consume_sqm" class="stock_consume_sqm">
<span<?php echo $stock_consume->sqm->viewAttributes() ?>>
<?php echo $stock_consume->sqm->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($stock_consume->status->Visible) { // status ?>
		<td<?php echo $stock_consume->status->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_delete->RowCnt ?>_stock_consume_status" class="stock_consume_status">
<span<?php echo $stock_consume->status->viewAttributes() ?>>
<?php echo $stock_consume->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($stock_consume->remarks->Visible) { // remarks ?>
		<td<?php echo $stock_consume->remarks->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_delete->RowCnt ?>_stock_consume_remarks" class="stock_consume_remarks">
<span<?php echo $stock_consume->remarks->viewAttributes() ?>>
<?php echo $stock_consume->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($stock_consume->consumed_by->Visible) { // consumed_by ?>
		<td<?php echo $stock_consume->consumed_by->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_delete->RowCnt ?>_stock_consume_consumed_by" class="stock_consume_consumed_by">
<span<?php echo $stock_consume->consumed_by->viewAttributes() ?>>
<?php echo $stock_consume->consumed_by->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($stock_consume->consumed_status->Visible) { // consumed_status ?>
		<td<?php echo $stock_consume->consumed_status->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_delete->RowCnt ?>_stock_consume_consumed_status" class="stock_consume_consumed_status">
<span<?php echo $stock_consume->consumed_status->viewAttributes() ?>>
<?php echo $stock_consume->consumed_status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($stock_consume->consumed_sqm->Visible) { // consumed_sqm ?>
		<td<?php echo $stock_consume->consumed_sqm->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_delete->RowCnt ?>_stock_consume_consumed_sqm" class="stock_consume_consumed_sqm">
<span<?php echo $stock_consume->consumed_sqm->viewAttributes() ?>>
<?php echo $stock_consume->consumed_sqm->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$stock_consume_delete->Recordset->moveNext();
}
$stock_consume_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $stock_consume_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$stock_consume_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_consume_delete->terminate();
?>