<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_consume_edit = new stock_consume_edit();

// Run the page
$stock_consume_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_consume_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fstock_consumeedit = currentForm = new ew.Form("fstock_consumeedit", "edit");

// Validate form
fstock_consumeedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($stock_consume_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->id->caption(), $stock_consume->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->location->caption(), $stock_consume->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->_barcode->caption(), $stock_consume->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->design_id->Required) { ?>
			elm = this.getElements("x" + infix + "_design_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->design_id->caption(), $stock_consume->design_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->sqm->caption(), $stock_consume->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->status->caption(), $stock_consume->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->remarks->caption(), $stock_consume->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->consumed_by->Required) { ?>
			elm = this.getElements("x" + infix + "_consumed_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->consumed_by->caption(), $stock_consume->consumed_by->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->consumed_status->Required) { ?>
			elm = this.getElements("x" + infix + "_consumed_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->consumed_status->caption(), $stock_consume->consumed_status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->consumed_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_consumed_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->consumed_sqm->caption(), $stock_consume->consumed_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->operator->caption(), $stock_consume->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($stock_consume_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $stock_consume->datetime->caption(), $stock_consume->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fstock_consumeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_consumeedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_consumeedit.lists["x_location"] = <?php echo $stock_consume_edit->location->Lookup->toClientList() ?>;
fstock_consumeedit.lists["x_location"].options = <?php echo JsonEncode($stock_consume_edit->location->lookupOptions()) ?>;
fstock_consumeedit.lists["x_design_id"] = <?php echo $stock_consume_edit->design_id->Lookup->toClientList() ?>;
fstock_consumeedit.lists["x_design_id"].options = <?php echo JsonEncode($stock_consume_edit->design_id->lookupOptions()) ?>;
fstock_consumeedit.lists["x_status"] = <?php echo $stock_consume_edit->status->Lookup->toClientList() ?>;
fstock_consumeedit.lists["x_status"].options = <?php echo JsonEncode($stock_consume_edit->status->lookupOptions()) ?>;
fstock_consumeedit.lists["x_consumed_status"] = <?php echo $stock_consume_edit->consumed_status->Lookup->toClientList() ?>;
fstock_consumeedit.lists["x_consumed_status"].options = <?php echo JsonEncode($stock_consume_edit->consumed_status->options(FALSE, TRUE)) ?>;
fstock_consumeedit.lists["x_operator"] = <?php echo $stock_consume_edit->operator->Lookup->toClientList() ?>;
fstock_consumeedit.lists["x_operator"].options = <?php echo JsonEncode($stock_consume_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_consume_edit->showPageHeader(); ?>
<?php
$stock_consume_edit->showMessage();
?>
<form name="fstock_consumeedit" id="fstock_consumeedit" class="<?php echo $stock_consume_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_consume_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_consume_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_consume">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$stock_consume_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($stock_consume->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_stock_consume_id" class="<?php echo $stock_consume_edit->LeftColumnClass ?>"><?php echo $stock_consume->id->caption() ?><?php echo ($stock_consume->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_consume_edit->RightColumnClass ?>"><div<?php echo $stock_consume->id->cellAttributes() ?>>
<span id="el_stock_consume_id">
<span<?php echo $stock_consume->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_consume->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_consume" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($stock_consume->id->CurrentValue) ?>">
<?php echo $stock_consume->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_consume->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_stock_consume_location" for="x_location" class="<?php echo $stock_consume_edit->LeftColumnClass ?>"><?php echo $stock_consume->location->caption() ?><?php echo ($stock_consume->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_consume_edit->RightColumnClass ?>"><div<?php echo $stock_consume->location->cellAttributes() ?>>
<span id="el_stock_consume_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_consume" data-field="x_location" data-value-separator="<?php echo $stock_consume->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $stock_consume->location->editAttributes() ?>>
		<?php echo $stock_consume->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $stock_consume->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $stock_consume->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_consume->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_stock_consume__barcode" for="x__barcode" class="<?php echo $stock_consume_edit->LeftColumnClass ?>"><?php echo $stock_consume->_barcode->caption() ?><?php echo ($stock_consume->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_consume_edit->RightColumnClass ?>"><div<?php echo $stock_consume->_barcode->cellAttributes() ?>>
<span id="el_stock_consume__barcode">
<span<?php echo $stock_consume->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_consume->_barcode->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_consume" data-field="x__barcode" name="x__barcode" id="x__barcode" value="<?php echo HtmlEncode($stock_consume->_barcode->CurrentValue) ?>">
<?php echo $stock_consume->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_consume->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label id="elh_stock_consume_design_id" for="x_design_id" class="<?php echo $stock_consume_edit->LeftColumnClass ?>"><?php echo $stock_consume->design_id->caption() ?><?php echo ($stock_consume->design_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_consume_edit->RightColumnClass ?>"><div<?php echo $stock_consume->design_id->cellAttributes() ?>>
<span id="el_stock_consume_design_id">
<span<?php echo $stock_consume->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($stock_consume->design_id->EditValue)) && $stock_consume->design_id->linkAttributes() <> "") { ?>
<a<?php echo $stock_consume->design_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_consume->design_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_consume->design_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="stock_consume" data-field="x_design_id" name="x_design_id" id="x_design_id" value="<?php echo HtmlEncode($stock_consume->design_id->CurrentValue) ?>">
<?php echo $stock_consume->design_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_consume->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_stock_consume_sqm" for="x_sqm" class="<?php echo $stock_consume_edit->LeftColumnClass ?>"><?php echo $stock_consume->sqm->caption() ?><?php echo ($stock_consume->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_consume_edit->RightColumnClass ?>"><div<?php echo $stock_consume->sqm->cellAttributes() ?>>
<span id="el_stock_consume_sqm">
<span<?php echo $stock_consume->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_consume->sqm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_consume" data-field="x_sqm" name="x_sqm" id="x_sqm" value="<?php echo HtmlEncode($stock_consume->sqm->CurrentValue) ?>">
<?php echo $stock_consume->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_consume->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_stock_consume_status" for="x_status" class="<?php echo $stock_consume_edit->LeftColumnClass ?>"><?php echo $stock_consume->status->caption() ?><?php echo ($stock_consume->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_consume_edit->RightColumnClass ?>"><div<?php echo $stock_consume->status->cellAttributes() ?>>
<span id="el_stock_consume_status">
<span<?php echo $stock_consume->status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_consume->status->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_consume" data-field="x_status" name="x_status" id="x_status" value="<?php echo HtmlEncode($stock_consume->status->CurrentValue) ?>">
<?php echo $stock_consume->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_consume->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_stock_consume_remarks" for="x_remarks" class="<?php echo $stock_consume_edit->LeftColumnClass ?>"><?php echo $stock_consume->remarks->caption() ?><?php echo ($stock_consume->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_consume_edit->RightColumnClass ?>"><div<?php echo $stock_consume->remarks->cellAttributes() ?>>
<span id="el_stock_consume_remarks">
<input type="text" data-table="stock_consume" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_consume->remarks->getPlaceHolder()) ?>" value="<?php echo $stock_consume->remarks->EditValue ?>"<?php echo $stock_consume->remarks->editAttributes() ?>>
</span>
<?php echo $stock_consume->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_consume->consumed_by->Visible) { // consumed_by ?>
	<div id="r_consumed_by" class="form-group row">
		<label id="elh_stock_consume_consumed_by" for="x_consumed_by" class="<?php echo $stock_consume_edit->LeftColumnClass ?>"><?php echo $stock_consume->consumed_by->caption() ?><?php echo ($stock_consume->consumed_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_consume_edit->RightColumnClass ?>"><div<?php echo $stock_consume->consumed_by->cellAttributes() ?>>
<span id="el_stock_consume_consumed_by">
<span<?php echo $stock_consume->consumed_by->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_consume->consumed_by->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_consume" data-field="x_consumed_by" name="x_consumed_by" id="x_consumed_by" value="<?php echo HtmlEncode($stock_consume->consumed_by->CurrentValue) ?>">
<?php echo $stock_consume->consumed_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_consume->consumed_status->Visible) { // consumed_status ?>
	<div id="r_consumed_status" class="form-group row">
		<label id="elh_stock_consume_consumed_status" for="x_consumed_status" class="<?php echo $stock_consume_edit->LeftColumnClass ?>"><?php echo $stock_consume->consumed_status->caption() ?><?php echo ($stock_consume->consumed_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_consume_edit->RightColumnClass ?>"><div<?php echo $stock_consume->consumed_status->cellAttributes() ?>>
<span id="el_stock_consume_consumed_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_consume" data-field="x_consumed_status" data-value-separator="<?php echo $stock_consume->consumed_status->displayValueSeparatorAttribute() ?>" id="x_consumed_status" name="x_consumed_status"<?php echo $stock_consume->consumed_status->editAttributes() ?>>
		<?php echo $stock_consume->consumed_status->selectOptionListHtml("x_consumed_status") ?>
	</select>
</div>
</span>
<?php echo $stock_consume->consumed_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stock_consume->consumed_sqm->Visible) { // consumed_sqm ?>
	<div id="r_consumed_sqm" class="form-group row">
		<label id="elh_stock_consume_consumed_sqm" for="x_consumed_sqm" class="<?php echo $stock_consume_edit->LeftColumnClass ?>"><?php echo $stock_consume->consumed_sqm->caption() ?><?php echo ($stock_consume->consumed_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $stock_consume_edit->RightColumnClass ?>"><div<?php echo $stock_consume->consumed_sqm->cellAttributes() ?>>
<span id="el_stock_consume_consumed_sqm">
<span<?php echo $stock_consume->consumed_sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($stock_consume->consumed_sqm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="stock_consume" data-field="x_consumed_sqm" name="x_consumed_sqm" id="x_consumed_sqm" value="<?php echo HtmlEncode($stock_consume->consumed_sqm->CurrentValue) ?>">
<?php echo $stock_consume->consumed_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_consume_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_consume_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $stock_consume_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_consume_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_consume_edit->terminate();
?>