<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_consume_list = new stock_consume_list();

// Run the page
$stock_consume_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_consume_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_consume->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_consumelist = currentForm = new ew.Form("fstock_consumelist", "list");
fstock_consumelist.formKeyCountName = '<?php echo $stock_consume_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_consumelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_consumelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_consumelist.lists["x_location"] = <?php echo $stock_consume_list->location->Lookup->toClientList() ?>;
fstock_consumelist.lists["x_location"].options = <?php echo JsonEncode($stock_consume_list->location->lookupOptions()) ?>;
fstock_consumelist.lists["x_design_id"] = <?php echo $stock_consume_list->design_id->Lookup->toClientList() ?>;
fstock_consumelist.lists["x_design_id"].options = <?php echo JsonEncode($stock_consume_list->design_id->lookupOptions()) ?>;
fstock_consumelist.lists["x_status"] = <?php echo $stock_consume_list->status->Lookup->toClientList() ?>;
fstock_consumelist.lists["x_status"].options = <?php echo JsonEncode($stock_consume_list->status->lookupOptions()) ?>;
fstock_consumelist.lists["x_consumed_status"] = <?php echo $stock_consume_list->consumed_status->Lookup->toClientList() ?>;
fstock_consumelist.lists["x_consumed_status"].options = <?php echo JsonEncode($stock_consume_list->consumed_status->options(FALSE, TRUE)) ?>;

// Form object for search
var fstock_consumelistsrch = currentSearchForm = new ew.Form("fstock_consumelistsrch");

// Validate function for search
fstock_consumelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_consume->_barcode->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstock_consumelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_consumelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_consumelistsrch.lists["x_status"] = <?php echo $stock_consume_list->status->Lookup->toClientList() ?>;
fstock_consumelistsrch.lists["x_status"].options = <?php echo JsonEncode($stock_consume_list->status->lookupOptions()) ?>;

// Filters
fstock_consumelistsrch.filterList = <?php echo $stock_consume_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_consumelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_consume->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_consume_list->TotalRecs > 0 && $stock_consume_list->ExportOptions->visible()) { ?>
<?php $stock_consume_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_consume_list->ImportOptions->visible()) { ?>
<?php $stock_consume_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_consume_list->SearchOptions->visible()) { ?>
<?php $stock_consume_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_consume_list->FilterOptions->visible()) { ?>
<?php $stock_consume_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_consume_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_consume->isExport() && !$stock_consume->CurrentAction) { ?>
<form name="fstock_consumelistsrch" id="fstock_consumelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_consume_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_consumelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_consume">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_consume_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock_consume->RowType = ROWTYPE_SEARCH;

// Render row
$stock_consume->resetAttributes();
$stock_consume_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock_consume->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $stock_consume->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock_consume->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock_consume->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock_consume->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock_consume->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock_consume->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock_consume->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($stock_consume->_barcode->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock_consume->_barcode->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock_consume->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_consume" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($stock_consume->_barcode->getPlaceHolder()) ?>" value="<?php echo $stock_consume->_barcode->EditValue ?>"<?php echo $stock_consume->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="stock_consume" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($stock_consume->_barcode->getPlaceHolder()) ?>" value="<?php echo $stock_consume->_barcode->EditValue2 ?>"<?php echo $stock_consume->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($stock_consume->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $stock_consume->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_consume" data-field="x_status" data-value-separator="<?php echo $stock_consume->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $stock_consume->status->editAttributes() ?>>
		<?php echo $stock_consume->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $stock_consume->status->Lookup->getParamTag("p_x_status") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_consume_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_consume_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_consume_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_consume_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_consume_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_consume_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_consume_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_consume_list->showPageHeader(); ?>
<?php
$stock_consume_list->showMessage();
?>
<?php if ($stock_consume_list->TotalRecs > 0 || $stock_consume->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_consume_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_consume">
<?php if (!$stock_consume->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_consume->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_consume_list->Pager)) $stock_consume_list->Pager = new PrevNextPager($stock_consume_list->StartRec, $stock_consume_list->DisplayRecs, $stock_consume_list->TotalRecs, $stock_consume_list->AutoHidePager) ?>
<?php if ($stock_consume_list->Pager->RecordCount > 0 && $stock_consume_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_consume_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_consume_list->pageUrl() ?>start=<?php echo $stock_consume_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_consume_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_consume_list->pageUrl() ?>start=<?php echo $stock_consume_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_consume_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_consume_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_consume_list->pageUrl() ?>start=<?php echo $stock_consume_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_consume_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_consume_list->pageUrl() ?>start=<?php echo $stock_consume_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_consume_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_consume_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_consume_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_consume_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_consume_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_consume_list->TotalRecs > 0 && (!$stock_consume_list->AutoHidePageSizeSelector || $stock_consume_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_consume">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_consume_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_consume_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_consume_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_consume_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_consume_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_consume->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_consume_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_consumelist" id="fstock_consumelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_consume_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_consume_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_consume">
<div id="gmp_stock_consume" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_consume_list->TotalRecs > 0 || $stock_consume->isGridEdit()) { ?>
<table id="tbl_stock_consumelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_consume_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_consume_list->renderListOptions();

// Render list options (header, left)
$stock_consume_list->ListOptions->render("header", "left");
?>
<?php if ($stock_consume->location->Visible) { // location ?>
	<?php if ($stock_consume->sortUrl($stock_consume->location) == "") { ?>
		<th data-name="location" class="<?php echo $stock_consume->location->headerCellClass() ?>"><div id="elh_stock_consume_location" class="stock_consume_location"><div class="ew-table-header-caption"><?php echo $stock_consume->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $stock_consume->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_consume->SortUrl($stock_consume->location) ?>',2);"><div id="elh_stock_consume_location" class="stock_consume_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_consume->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_consume->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_consume->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_consume->_barcode->Visible) { // barcode ?>
	<?php if ($stock_consume->sortUrl($stock_consume->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $stock_consume->_barcode->headerCellClass() ?>" style="width: 300px;"><div id="elh_stock_consume__barcode" class="stock_consume__barcode"><div class="ew-table-header-caption"><?php echo $stock_consume->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $stock_consume->_barcode->headerCellClass() ?>" style="width: 300px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_consume->SortUrl($stock_consume->_barcode) ?>',2);"><div id="elh_stock_consume__barcode" class="stock_consume__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_consume->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_consume->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_consume->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_consume->design_id->Visible) { // design_id ?>
	<?php if ($stock_consume->sortUrl($stock_consume->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $stock_consume->design_id->headerCellClass() ?>"><div id="elh_stock_consume_design_id" class="stock_consume_design_id"><div class="ew-table-header-caption"><?php echo $stock_consume->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $stock_consume->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_consume->SortUrl($stock_consume->design_id) ?>',2);"><div id="elh_stock_consume_design_id" class="stock_consume_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_consume->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_consume->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_consume->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_consume->sqm->Visible) { // sqm ?>
	<?php if ($stock_consume->sortUrl($stock_consume->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $stock_consume->sqm->headerCellClass() ?>"><div id="elh_stock_consume_sqm" class="stock_consume_sqm"><div class="ew-table-header-caption"><?php echo $stock_consume->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $stock_consume->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_consume->SortUrl($stock_consume->sqm) ?>',2);"><div id="elh_stock_consume_sqm" class="stock_consume_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_consume->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_consume->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_consume->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_consume->status->Visible) { // status ?>
	<?php if ($stock_consume->sortUrl($stock_consume->status) == "") { ?>
		<th data-name="status" class="<?php echo $stock_consume->status->headerCellClass() ?>"><div id="elh_stock_consume_status" class="stock_consume_status"><div class="ew-table-header-caption"><?php echo $stock_consume->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $stock_consume->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_consume->SortUrl($stock_consume->status) ?>',2);"><div id="elh_stock_consume_status" class="stock_consume_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_consume->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_consume->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_consume->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_consume->remarks->Visible) { // remarks ?>
	<?php if ($stock_consume->sortUrl($stock_consume->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $stock_consume->remarks->headerCellClass() ?>"><div id="elh_stock_consume_remarks" class="stock_consume_remarks"><div class="ew-table-header-caption"><?php echo $stock_consume->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $stock_consume->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_consume->SortUrl($stock_consume->remarks) ?>',2);"><div id="elh_stock_consume_remarks" class="stock_consume_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_consume->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_consume->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_consume->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_consume->consumed_by->Visible) { // consumed_by ?>
	<?php if ($stock_consume->sortUrl($stock_consume->consumed_by) == "") { ?>
		<th data-name="consumed_by" class="<?php echo $stock_consume->consumed_by->headerCellClass() ?>"><div id="elh_stock_consume_consumed_by" class="stock_consume_consumed_by"><div class="ew-table-header-caption"><?php echo $stock_consume->consumed_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consumed_by" class="<?php echo $stock_consume->consumed_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_consume->SortUrl($stock_consume->consumed_by) ?>',2);"><div id="elh_stock_consume_consumed_by" class="stock_consume_consumed_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_consume->consumed_by->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_consume->consumed_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_consume->consumed_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_consume->consumed_status->Visible) { // consumed_status ?>
	<?php if ($stock_consume->sortUrl($stock_consume->consumed_status) == "") { ?>
		<th data-name="consumed_status" class="<?php echo $stock_consume->consumed_status->headerCellClass() ?>"><div id="elh_stock_consume_consumed_status" class="stock_consume_consumed_status"><div class="ew-table-header-caption"><?php echo $stock_consume->consumed_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consumed_status" class="<?php echo $stock_consume->consumed_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_consume->SortUrl($stock_consume->consumed_status) ?>',2);"><div id="elh_stock_consume_consumed_status" class="stock_consume_consumed_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_consume->consumed_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_consume->consumed_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_consume->consumed_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_consume->consumed_sqm->Visible) { // consumed_sqm ?>
	<?php if ($stock_consume->sortUrl($stock_consume->consumed_sqm) == "") { ?>
		<th data-name="consumed_sqm" class="<?php echo $stock_consume->consumed_sqm->headerCellClass() ?>"><div id="elh_stock_consume_consumed_sqm" class="stock_consume_consumed_sqm"><div class="ew-table-header-caption"><?php echo $stock_consume->consumed_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consumed_sqm" class="<?php echo $stock_consume->consumed_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_consume->SortUrl($stock_consume->consumed_sqm) ?>',2);"><div id="elh_stock_consume_consumed_sqm" class="stock_consume_consumed_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_consume->consumed_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_consume->consumed_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_consume->consumed_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_consume_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_consume->ExportAll && $stock_consume->isExport()) {
	$stock_consume_list->StopRec = $stock_consume_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_consume_list->TotalRecs > $stock_consume_list->StartRec + $stock_consume_list->DisplayRecs - 1)
		$stock_consume_list->StopRec = $stock_consume_list->StartRec + $stock_consume_list->DisplayRecs - 1;
	else
		$stock_consume_list->StopRec = $stock_consume_list->TotalRecs;
}
$stock_consume_list->RecCnt = $stock_consume_list->StartRec - 1;
if ($stock_consume_list->Recordset && !$stock_consume_list->Recordset->EOF) {
	$stock_consume_list->Recordset->moveFirst();
	$selectLimit = $stock_consume_list->UseSelectLimit;
	if (!$selectLimit && $stock_consume_list->StartRec > 1)
		$stock_consume_list->Recordset->move($stock_consume_list->StartRec - 1);
} elseif (!$stock_consume->AllowAddDeleteRow && $stock_consume_list->StopRec == 0) {
	$stock_consume_list->StopRec = $stock_consume->GridAddRowCount;
}

// Initialize aggregate
$stock_consume->RowType = ROWTYPE_AGGREGATEINIT;
$stock_consume->resetAttributes();
$stock_consume_list->renderRow();
while ($stock_consume_list->RecCnt < $stock_consume_list->StopRec) {
	$stock_consume_list->RecCnt++;
	if ($stock_consume_list->RecCnt >= $stock_consume_list->StartRec) {
		$stock_consume_list->RowCnt++;

		// Set up key count
		$stock_consume_list->KeyCount = $stock_consume_list->RowIndex;

		// Init row class and style
		$stock_consume->resetAttributes();
		$stock_consume->CssClass = "";
		if ($stock_consume->isGridAdd()) {
		} else {
			$stock_consume_list->loadRowValues($stock_consume_list->Recordset); // Load row values
		}
		$stock_consume->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_consume->RowAttrs = array_merge($stock_consume->RowAttrs, array('data-rowindex'=>$stock_consume_list->RowCnt, 'id'=>'r' . $stock_consume_list->RowCnt . '_stock_consume', 'data-rowtype'=>$stock_consume->RowType));

		// Render row
		$stock_consume_list->renderRow();

		// Render list options
		$stock_consume_list->renderListOptions();
?>
	<tr<?php echo $stock_consume->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_consume_list->ListOptions->render("body", "left", $stock_consume_list->RowCnt);
?>
	<?php if ($stock_consume->location->Visible) { // location ?>
		<td data-name="location"<?php echo $stock_consume->location->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_list->RowCnt ?>_stock_consume_location" class="stock_consume_location">
<span<?php echo $stock_consume->location->viewAttributes() ?>>
<?php echo $stock_consume->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_consume->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $stock_consume->_barcode->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_list->RowCnt ?>_stock_consume__barcode" class="stock_consume__barcode">
<span<?php echo $stock_consume->_barcode->viewAttributes() ?>>
<?php echo $stock_consume->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_consume->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $stock_consume->design_id->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_list->RowCnt ?>_stock_consume_design_id" class="stock_consume_design_id">
<span<?php echo $stock_consume->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($stock_consume->design_id->getViewValue())) && $stock_consume->design_id->linkAttributes() <> "") { ?>
<a<?php echo $stock_consume->design_id->linkAttributes() ?>><?php echo $stock_consume->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_consume->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_consume->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $stock_consume->sqm->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_list->RowCnt ?>_stock_consume_sqm" class="stock_consume_sqm">
<span<?php echo $stock_consume->sqm->viewAttributes() ?>>
<?php echo $stock_consume->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_consume->status->Visible) { // status ?>
		<td data-name="status"<?php echo $stock_consume->status->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_list->RowCnt ?>_stock_consume_status" class="stock_consume_status">
<span<?php echo $stock_consume->status->viewAttributes() ?>>
<?php echo $stock_consume->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_consume->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $stock_consume->remarks->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_list->RowCnt ?>_stock_consume_remarks" class="stock_consume_remarks">
<span<?php echo $stock_consume->remarks->viewAttributes() ?>>
<?php echo $stock_consume->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_consume->consumed_by->Visible) { // consumed_by ?>
		<td data-name="consumed_by"<?php echo $stock_consume->consumed_by->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_list->RowCnt ?>_stock_consume_consumed_by" class="stock_consume_consumed_by">
<span<?php echo $stock_consume->consumed_by->viewAttributes() ?>>
<?php echo $stock_consume->consumed_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_consume->consumed_status->Visible) { // consumed_status ?>
		<td data-name="consumed_status"<?php echo $stock_consume->consumed_status->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_list->RowCnt ?>_stock_consume_consumed_status" class="stock_consume_consumed_status">
<span<?php echo $stock_consume->consumed_status->viewAttributes() ?>>
<?php echo $stock_consume->consumed_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_consume->consumed_sqm->Visible) { // consumed_sqm ?>
		<td data-name="consumed_sqm"<?php echo $stock_consume->consumed_sqm->cellAttributes() ?>>
<span id="el<?php echo $stock_consume_list->RowCnt ?>_stock_consume_consumed_sqm" class="stock_consume_consumed_sqm">
<span<?php echo $stock_consume->consumed_sqm->viewAttributes() ?>>
<?php echo $stock_consume->consumed_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_consume_list->ListOptions->render("body", "right", $stock_consume_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_consume->isGridAdd())
		$stock_consume_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_consume->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_consume_list->Recordset)
	$stock_consume_list->Recordset->Close();
?>
<?php if (!$stock_consume->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_consume->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_consume_list->Pager)) $stock_consume_list->Pager = new PrevNextPager($stock_consume_list->StartRec, $stock_consume_list->DisplayRecs, $stock_consume_list->TotalRecs, $stock_consume_list->AutoHidePager) ?>
<?php if ($stock_consume_list->Pager->RecordCount > 0 && $stock_consume_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_consume_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_consume_list->pageUrl() ?>start=<?php echo $stock_consume_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_consume_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_consume_list->pageUrl() ?>start=<?php echo $stock_consume_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_consume_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_consume_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_consume_list->pageUrl() ?>start=<?php echo $stock_consume_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_consume_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_consume_list->pageUrl() ?>start=<?php echo $stock_consume_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_consume_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_consume_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_consume_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_consume_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_consume_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_consume_list->TotalRecs > 0 && (!$stock_consume_list->AutoHidePageSizeSelector || $stock_consume_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_consume">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_consume_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_consume_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_consume_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_consume_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_consume_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_consume->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_consume_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_consume_list->TotalRecs == 0 && !$stock_consume->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_consume_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_consume_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_consume->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_consume->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_consume", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_consume_list->terminate();
?>