<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_consume_view = new stock_consume_view();

// Run the page
$stock_consume_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_consume_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_consume->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fstock_consumeview = currentForm = new ew.Form("fstock_consumeview", "view");

// Form_CustomValidate event
fstock_consumeview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_consumeview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_consumeview.lists["x_location"] = <?php echo $stock_consume_view->location->Lookup->toClientList() ?>;
fstock_consumeview.lists["x_location"].options = <?php echo JsonEncode($stock_consume_view->location->lookupOptions()) ?>;
fstock_consumeview.lists["x_design_id"] = <?php echo $stock_consume_view->design_id->Lookup->toClientList() ?>;
fstock_consumeview.lists["x_design_id"].options = <?php echo JsonEncode($stock_consume_view->design_id->lookupOptions()) ?>;
fstock_consumeview.lists["x_status"] = <?php echo $stock_consume_view->status->Lookup->toClientList() ?>;
fstock_consumeview.lists["x_status"].options = <?php echo JsonEncode($stock_consume_view->status->lookupOptions()) ?>;
fstock_consumeview.lists["x_consumed_status"] = <?php echo $stock_consume_view->consumed_status->Lookup->toClientList() ?>;
fstock_consumeview.lists["x_consumed_status"].options = <?php echo JsonEncode($stock_consume_view->consumed_status->options(FALSE, TRUE)) ?>;
fstock_consumeview.lists["x_operator"] = <?php echo $stock_consume_view->operator->Lookup->toClientList() ?>;
fstock_consumeview.lists["x_operator"].options = <?php echo JsonEncode($stock_consume_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_consume->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $stock_consume_view->ExportOptions->render("body") ?>
<?php $stock_consume_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $stock_consume_view->showPageHeader(); ?>
<?php
$stock_consume_view->showMessage();
?>
<form name="fstock_consumeview" id="fstock_consumeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_consume_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_consume_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_consume">
<input type="hidden" name="modal" value="<?php echo (int)$stock_consume_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($stock_consume->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_id"><?php echo $stock_consume->id->caption() ?></span></td>
		<td data-name="id"<?php echo $stock_consume->id->cellAttributes() ?>>
<span id="el_stock_consume_id">
<span<?php echo $stock_consume->id->viewAttributes() ?>>
<?php echo $stock_consume->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_location"><?php echo $stock_consume->location->caption() ?></span></td>
		<td data-name="location"<?php echo $stock_consume->location->cellAttributes() ?>>
<span id="el_stock_consume_location">
<span<?php echo $stock_consume->location->viewAttributes() ?>>
<?php echo $stock_consume->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume__barcode"><?php echo $stock_consume->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $stock_consume->_barcode->cellAttributes() ?>>
<span id="el_stock_consume__barcode">
<span<?php echo $stock_consume->_barcode->viewAttributes() ?>>
<?php echo $stock_consume->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->design_id->Visible) { // design_id ?>
	<tr id="r_design_id">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_design_id"><?php echo $stock_consume->design_id->caption() ?></span></td>
		<td data-name="design_id"<?php echo $stock_consume->design_id->cellAttributes() ?>>
<span id="el_stock_consume_design_id">
<span<?php echo $stock_consume->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($stock_consume->design_id->getViewValue())) && $stock_consume->design_id->linkAttributes() <> "") { ?>
<a<?php echo $stock_consume->design_id->linkAttributes() ?>><?php echo $stock_consume->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_consume->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_sqm"><?php echo $stock_consume->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $stock_consume->sqm->cellAttributes() ?>>
<span id="el_stock_consume_sqm">
<span<?php echo $stock_consume->sqm->viewAttributes() ?>>
<?php echo $stock_consume->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_status"><?php echo $stock_consume->status->caption() ?></span></td>
		<td data-name="status"<?php echo $stock_consume->status->cellAttributes() ?>>
<span id="el_stock_consume_status">
<span<?php echo $stock_consume->status->viewAttributes() ?>>
<?php echo $stock_consume->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_remarks"><?php echo $stock_consume->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $stock_consume->remarks->cellAttributes() ?>>
<span id="el_stock_consume_remarks">
<span<?php echo $stock_consume->remarks->viewAttributes() ?>>
<?php echo $stock_consume->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->consumed_by->Visible) { // consumed_by ?>
	<tr id="r_consumed_by">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_consumed_by"><?php echo $stock_consume->consumed_by->caption() ?></span></td>
		<td data-name="consumed_by"<?php echo $stock_consume->consumed_by->cellAttributes() ?>>
<span id="el_stock_consume_consumed_by">
<span<?php echo $stock_consume->consumed_by->viewAttributes() ?>>
<?php echo $stock_consume->consumed_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->consumed_status->Visible) { // consumed_status ?>
	<tr id="r_consumed_status">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_consumed_status"><?php echo $stock_consume->consumed_status->caption() ?></span></td>
		<td data-name="consumed_status"<?php echo $stock_consume->consumed_status->cellAttributes() ?>>
<span id="el_stock_consume_consumed_status">
<span<?php echo $stock_consume->consumed_status->viewAttributes() ?>>
<?php echo $stock_consume->consumed_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->consumed_sqm->Visible) { // consumed_sqm ?>
	<tr id="r_consumed_sqm">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_consumed_sqm"><?php echo $stock_consume->consumed_sqm->caption() ?></span></td>
		<td data-name="consumed_sqm"<?php echo $stock_consume->consumed_sqm->cellAttributes() ?>>
<span id="el_stock_consume_consumed_sqm">
<span<?php echo $stock_consume->consumed_sqm->viewAttributes() ?>>
<?php echo $stock_consume->consumed_sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_operator"><?php echo $stock_consume->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $stock_consume->operator->cellAttributes() ?>>
<span id="el_stock_consume_operator">
<span<?php echo $stock_consume->operator->viewAttributes() ?>>
<?php echo $stock_consume->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($stock_consume->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $stock_consume_view->TableLeftColumnClass ?>"><span id="elh_stock_consume_datetime"><?php echo $stock_consume->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $stock_consume->datetime->cellAttributes() ?>>
<span id="el_stock_consume_datetime">
<span<?php echo $stock_consume->datetime->viewAttributes() ?>>
<?php echo $stock_consume->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$stock_consume_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_consume->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_consume_view->terminate();
?>