<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_datewise_list = new stock_datewise_list();

// Run the page
$stock_datewise_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_datewise_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$stock_datewise->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fstock_datewiselist = currentForm = new ew.Form("fstock_datewiselist", "list");
fstock_datewiselist.formKeyCountName = '<?php echo $stock_datewise_list->FormKeyCountName ?>';

// Form_CustomValidate event
fstock_datewiselist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_datewiselist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_datewiselist.lists["x_product"] = <?php echo $stock_datewise_list->product->Lookup->toClientList() ?>;
fstock_datewiselist.lists["x_product"].options = <?php echo JsonEncode($stock_datewise_list->product->lookupOptions()) ?>;
fstock_datewiselist.lists["x_godown"] = <?php echo $stock_datewise_list->godown->Lookup->toClientList() ?>;
fstock_datewiselist.lists["x_godown"].options = <?php echo JsonEncode($stock_datewise_list->godown->lookupOptions()) ?>;
fstock_datewiselist.lists["x_packing_type"] = <?php echo $stock_datewise_list->packing_type->Lookup->toClientList() ?>;
fstock_datewiselist.lists["x_packing_type"].options = <?php echo JsonEncode($stock_datewise_list->packing_type->lookupOptions()) ?>;
fstock_datewiselist.lists["x_type"] = <?php echo $stock_datewise_list->type->Lookup->toClientList() ?>;
fstock_datewiselist.lists["x_type"].options = <?php echo JsonEncode($stock_datewise_list->type->lookupOptions()) ?>;

// Form object for search
var fstock_datewiselistsrch = currentSearchForm = new ew.Form("fstock_datewiselistsrch");

// Validate function for search
fstock_datewiselistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_datewise->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fstock_datewiselistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_datewiselistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_datewiselistsrch.lists["x_product"] = <?php echo $stock_datewise_list->product->Lookup->toClientList() ?>;
fstock_datewiselistsrch.lists["x_product"].options = <?php echo JsonEncode($stock_datewise_list->product->lookupOptions()) ?>;
fstock_datewiselistsrch.lists["x_godown"] = <?php echo $stock_datewise_list->godown->Lookup->toClientList() ?>;
fstock_datewiselistsrch.lists["x_godown"].options = <?php echo JsonEncode($stock_datewise_list->godown->lookupOptions()) ?>;
fstock_datewiselistsrch.lists["x_type"] = <?php echo $stock_datewise_list->type->Lookup->toClientList() ?>;
fstock_datewiselistsrch.lists["x_type"].options = <?php echo JsonEncode($stock_datewise_list->type->lookupOptions()) ?>;

// Filters
fstock_datewiselistsrch.filterList = <?php echo $stock_datewise_list->getFilterList() ?>;

// Init search panel as collapsed
fstock_datewiselistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$stock_datewise->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($stock_datewise_list->TotalRecs > 0 && $stock_datewise_list->ExportOptions->visible()) { ?>
<?php $stock_datewise_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_datewise_list->ImportOptions->visible()) { ?>
<?php $stock_datewise_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($stock_datewise_list->SearchOptions->visible()) { ?>
<?php $stock_datewise_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($stock_datewise_list->FilterOptions->visible()) { ?>
<?php $stock_datewise_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$stock_datewise_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$stock_datewise->isExport() && !$stock_datewise->CurrentAction) { ?>
<form name="fstock_datewiselistsrch" id="fstock_datewiselistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($stock_datewise_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fstock_datewiselistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="stock_datewise">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$stock_datewise_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$stock_datewise->RowType = ROWTYPE_SEARCH;

// Render row
$stock_datewise->resetAttributes();
$stock_datewise_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($stock_datewise->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $stock_datewise->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_datewise" data-field="x_product" data-value-separator="<?php echo $stock_datewise->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_datewise->product->editAttributes() ?>>
		<?php echo $stock_datewise->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_datewise->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($stock_datewise->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $stock_datewise->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_datewise" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_datewise->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->product_code->EditValue ?>"<?php echo $stock_datewise->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($stock_datewise->godown->Visible) { // godown ?>
	<div id="xsc_godown" class="ew-cell form-group">
		<label for="x_godown" class="ew-search-caption ew-label"><?php echo $stock_datewise->godown->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_datewise" data-field="x_godown" data-value-separator="<?php echo $stock_datewise->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_datewise->godown->editAttributes() ?>>
		<?php echo $stock_datewise->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_datewise->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($stock_datewise->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $stock_datewise->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="stock_datewise" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($stock_datewise->dated->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->dated->EditValue ?>"<?php echo $stock_datewise->dated->editAttributes() ?>>
<?php if (!$stock_datewise->dated->ReadOnly && !$stock_datewise->dated->Disabled && !isset($stock_datewise->dated->EditAttrs["readonly"]) && !isset($stock_datewise->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_datewiselistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="stock_datewise" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($stock_datewise->dated->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->dated->EditValue2 ?>"<?php echo $stock_datewise->dated->editAttributes() ?>>
<?php if (!$stock_datewise->dated->ReadOnly && !$stock_datewise->dated->Disabled && !isset($stock_datewise->dated->EditAttrs["readonly"]) && !isset($stock_datewise->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_datewiselistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($stock_datewise->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $stock_datewise->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_datewise" data-field="x_type" data-value-separator="<?php echo $stock_datewise->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $stock_datewise->type->editAttributes() ?>>
		<?php echo $stock_datewise->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $stock_datewise->type->Lookup->getParamTag("p_x_type") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($stock_datewise_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($stock_datewise_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $stock_datewise_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($stock_datewise_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($stock_datewise_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($stock_datewise_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($stock_datewise_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $stock_datewise_list->showPageHeader(); ?>
<?php
$stock_datewise_list->showMessage();
?>
<?php if ($stock_datewise_list->TotalRecs > 0 || $stock_datewise->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($stock_datewise_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> stock_datewise">
<?php if (!$stock_datewise->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$stock_datewise->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_datewise_list->Pager)) $stock_datewise_list->Pager = new PrevNextPager($stock_datewise_list->StartRec, $stock_datewise_list->DisplayRecs, $stock_datewise_list->TotalRecs, $stock_datewise_list->AutoHidePager) ?>
<?php if ($stock_datewise_list->Pager->RecordCount > 0 && $stock_datewise_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_datewise_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_datewise_list->pageUrl() ?>start=<?php echo $stock_datewise_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_datewise_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_datewise_list->pageUrl() ?>start=<?php echo $stock_datewise_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_datewise_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_datewise_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_datewise_list->pageUrl() ?>start=<?php echo $stock_datewise_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_datewise_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_datewise_list->pageUrl() ?>start=<?php echo $stock_datewise_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_datewise_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_datewise_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_datewise_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_datewise_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_datewise_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_datewise_list->TotalRecs > 0 && (!$stock_datewise_list->AutoHidePageSizeSelector || $stock_datewise_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_datewise">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_datewise_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_datewise_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_datewise_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_datewise_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_datewise_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_datewise->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_datewise_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstock_datewiselist" id="fstock_datewiselist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_datewise_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_datewise_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_datewise">
<div id="gmp_stock_datewise" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($stock_datewise_list->TotalRecs > 0 || $stock_datewise->isGridEdit()) { ?>
<table id="tbl_stock_datewiselist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$stock_datewise_list->RowType = ROWTYPE_HEADER;

// Render list options
$stock_datewise_list->renderListOptions();

// Render list options (header, left)
$stock_datewise_list->ListOptions->render("header", "left");
?>
<?php if ($stock_datewise->product->Visible) { // product ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->product) == "") { ?>
		<th data-name="product" class="<?php echo $stock_datewise->product->headerCellClass() ?>"><div id="elh_stock_datewise_product" class="stock_datewise_product"><div class="ew-table-header-caption"><?php echo $stock_datewise->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $stock_datewise->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->product) ?>',2);"><div id="elh_stock_datewise_product" class="stock_datewise_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->product_code->Visible) { // product_code ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $stock_datewise->product_code->headerCellClass() ?>"><div id="elh_stock_datewise_product_code" class="stock_datewise_product_code"><div class="ew-table-header-caption"><?php echo $stock_datewise->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $stock_datewise->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->product_code) ?>',2);"><div id="elh_stock_datewise_product_code" class="stock_datewise_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->godown->Visible) { // godown ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $stock_datewise->godown->headerCellClass() ?>"><div id="elh_stock_datewise_godown" class="stock_datewise_godown"><div class="ew-table-header-caption"><?php echo $stock_datewise->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $stock_datewise->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->godown) ?>',2);"><div id="elh_stock_datewise_godown" class="stock_datewise_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->IN->Visible) { // IN ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $stock_datewise->IN->headerCellClass() ?>"><div id="elh_stock_datewise_IN" class="stock_datewise_IN"><div class="ew-table-header-caption"><?php echo $stock_datewise->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $stock_datewise->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->IN) ?>',2);"><div id="elh_stock_datewise_IN" class="stock_datewise_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->OUT->Visible) { // OUT ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $stock_datewise->OUT->headerCellClass() ?>"><div id="elh_stock_datewise_OUT" class="stock_datewise_OUT"><div class="ew-table-header-caption"><?php echo $stock_datewise->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $stock_datewise->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->OUT) ?>',2);"><div id="elh_stock_datewise_OUT" class="stock_datewise_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->balance->Visible) { // balance ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $stock_datewise->balance->headerCellClass() ?>"><div id="elh_stock_datewise_balance" class="stock_datewise_balance"><div class="ew-table-header-caption"><?php echo $stock_datewise->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $stock_datewise->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->balance) ?>',2);"><div id="elh_stock_datewise_balance" class="stock_datewise_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->packets->Visible) { // packets ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $stock_datewise->packets->headerCellClass() ?>"><div id="elh_stock_datewise_packets" class="stock_datewise_packets"><div class="ew-table-header-caption"><?php echo $stock_datewise->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $stock_datewise->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->packets) ?>',2);"><div id="elh_stock_datewise_packets" class="stock_datewise_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->packing_type->Visible) { // packing_type ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $stock_datewise->packing_type->headerCellClass() ?>"><div id="elh_stock_datewise_packing_type" class="stock_datewise_packing_type"><div class="ew-table-header-caption"><?php echo $stock_datewise->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $stock_datewise->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->packing_type) ?>',2);"><div id="elh_stock_datewise_packing_type" class="stock_datewise_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->lot_no->Visible) { // lot_no ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $stock_datewise->lot_no->headerCellClass() ?>"><div id="elh_stock_datewise_lot_no" class="stock_datewise_lot_no"><div class="ew-table-header-caption"><?php echo $stock_datewise->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $stock_datewise->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->lot_no) ?>',2);"><div id="elh_stock_datewise_lot_no" class="stock_datewise_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->dated->Visible) { // dated ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $stock_datewise->dated->headerCellClass() ?>"><div id="elh_stock_datewise_dated" class="stock_datewise_dated"><div class="ew-table-header-caption"><?php echo $stock_datewise->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $stock_datewise->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->dated) ?>',2);"><div id="elh_stock_datewise_dated" class="stock_datewise_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->type->Visible) { // type ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->type) == "") { ?>
		<th data-name="type" class="<?php echo $stock_datewise->type->headerCellClass() ?>"><div id="elh_stock_datewise_type" class="stock_datewise_type"><div class="ew-table-header-caption"><?php echo $stock_datewise->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $stock_datewise->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->type) ?>',2);"><div id="elh_stock_datewise_type" class="stock_datewise_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($stock_datewise->age->Visible) { // age ?>
	<?php if ($stock_datewise->sortUrl($stock_datewise->age) == "") { ?>
		<th data-name="age" class="<?php echo $stock_datewise->age->headerCellClass() ?>"><div id="elh_stock_datewise_age" class="stock_datewise_age"><div class="ew-table-header-caption"><?php echo $stock_datewise->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $stock_datewise->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $stock_datewise->SortUrl($stock_datewise->age) ?>',2);"><div id="elh_stock_datewise_age" class="stock_datewise_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $stock_datewise->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($stock_datewise->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($stock_datewise->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$stock_datewise_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($stock_datewise->ExportAll && $stock_datewise->isExport()) {
	$stock_datewise_list->StopRec = $stock_datewise_list->TotalRecs;
} else {

	// Set the last record to display
	if ($stock_datewise_list->TotalRecs > $stock_datewise_list->StartRec + $stock_datewise_list->DisplayRecs - 1)
		$stock_datewise_list->StopRec = $stock_datewise_list->StartRec + $stock_datewise_list->DisplayRecs - 1;
	else
		$stock_datewise_list->StopRec = $stock_datewise_list->TotalRecs;
}
$stock_datewise_list->RecCnt = $stock_datewise_list->StartRec - 1;
if ($stock_datewise_list->Recordset && !$stock_datewise_list->Recordset->EOF) {
	$stock_datewise_list->Recordset->moveFirst();
	$selectLimit = $stock_datewise_list->UseSelectLimit;
	if (!$selectLimit && $stock_datewise_list->StartRec > 1)
		$stock_datewise_list->Recordset->move($stock_datewise_list->StartRec - 1);
} elseif (!$stock_datewise->AllowAddDeleteRow && $stock_datewise_list->StopRec == 0) {
	$stock_datewise_list->StopRec = $stock_datewise->GridAddRowCount;
}

// Initialize aggregate
$stock_datewise->RowType = ROWTYPE_AGGREGATEINIT;
$stock_datewise->resetAttributes();
$stock_datewise_list->renderRow();
while ($stock_datewise_list->RecCnt < $stock_datewise_list->StopRec) {
	$stock_datewise_list->RecCnt++;
	if ($stock_datewise_list->RecCnt >= $stock_datewise_list->StartRec) {
		$stock_datewise_list->RowCnt++;

		// Set up key count
		$stock_datewise_list->KeyCount = $stock_datewise_list->RowIndex;

		// Init row class and style
		$stock_datewise->resetAttributes();
		$stock_datewise->CssClass = "";
		if ($stock_datewise->isGridAdd()) {
		} else {
			$stock_datewise_list->loadRowValues($stock_datewise_list->Recordset); // Load row values
		}
		$stock_datewise->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$stock_datewise->RowAttrs = array_merge($stock_datewise->RowAttrs, array('data-rowindex'=>$stock_datewise_list->RowCnt, 'id'=>'r' . $stock_datewise_list->RowCnt . '_stock_datewise', 'data-rowtype'=>$stock_datewise->RowType));

		// Render row
		$stock_datewise_list->renderRow();

		// Render list options
		$stock_datewise_list->renderListOptions();
?>
	<tr<?php echo $stock_datewise->rowAttributes() ?>>
<?php

// Render list options (body, left)
$stock_datewise_list->ListOptions->render("body", "left", $stock_datewise_list->RowCnt);
?>
	<?php if ($stock_datewise->product->Visible) { // product ?>
		<td data-name="product"<?php echo $stock_datewise->product->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_product" class="stock_datewise_product">
<span<?php echo $stock_datewise->product->viewAttributes() ?>>
<?php if ((!EmptyString($stock_datewise->product->getViewValue())) && $stock_datewise->product->linkAttributes() <> "") { ?>
<a<?php echo $stock_datewise->product->linkAttributes() ?>><?php echo $stock_datewise->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_datewise->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $stock_datewise->product_code->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_product_code" class="stock_datewise_product_code">
<span<?php echo $stock_datewise->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($stock_datewise->product_code->getViewValue())) && $stock_datewise->product_code->linkAttributes() <> "") { ?>
<a<?php echo $stock_datewise->product_code->linkAttributes() ?>><?php echo $stock_datewise->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_datewise->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $stock_datewise->godown->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_godown" class="stock_datewise_godown">
<span<?php echo $stock_datewise->godown->viewAttributes() ?>>
<?php if ((!EmptyString($stock_datewise->godown->getViewValue())) && $stock_datewise->godown->linkAttributes() <> "") { ?>
<a<?php echo $stock_datewise->godown->linkAttributes() ?>><?php echo $stock_datewise->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_datewise->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $stock_datewise->IN->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_IN" class="stock_datewise_IN">
<span<?php echo $stock_datewise->IN->viewAttributes() ?>>
<?php echo $stock_datewise->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $stock_datewise->OUT->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_OUT" class="stock_datewise_OUT">
<span<?php echo $stock_datewise->OUT->viewAttributes() ?>>
<?php echo $stock_datewise->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $stock_datewise->balance->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_balance" class="stock_datewise_balance">
<span<?php echo $stock_datewise->balance->viewAttributes() ?>>
<?php echo $stock_datewise->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $stock_datewise->packets->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_packets" class="stock_datewise_packets">
<span<?php echo $stock_datewise->packets->viewAttributes() ?>>
<?php if ((!EmptyString($stock_datewise->packets->getViewValue())) && $stock_datewise->packets->linkAttributes() <> "") { ?>
<a<?php echo $stock_datewise->packets->linkAttributes() ?>><?php echo $stock_datewise->packets->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_datewise->packets->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $stock_datewise->packing_type->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_packing_type" class="stock_datewise_packing_type">
<span<?php echo $stock_datewise->packing_type->viewAttributes() ?>>
<?php echo $stock_datewise->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $stock_datewise->lot_no->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_lot_no" class="stock_datewise_lot_no">
<span<?php echo $stock_datewise->lot_no->viewAttributes() ?>>
<?php echo $stock_datewise->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $stock_datewise->dated->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_dated" class="stock_datewise_dated">
<span<?php echo $stock_datewise->dated->viewAttributes() ?>>
<?php echo $stock_datewise->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->type->Visible) { // type ?>
		<td data-name="type"<?php echo $stock_datewise->type->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_type" class="stock_datewise_type">
<span<?php echo $stock_datewise->type->viewAttributes() ?>>
<?php if ((!EmptyString($stock_datewise->type->getViewValue())) && $stock_datewise->type->linkAttributes() <> "") { ?>
<a<?php echo $stock_datewise->type->linkAttributes() ?>><?php echo $stock_datewise->type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $stock_datewise->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($stock_datewise->age->Visible) { // age ?>
		<td data-name="age"<?php echo $stock_datewise->age->cellAttributes() ?>>
<span id="el<?php echo $stock_datewise_list->RowCnt ?>_stock_datewise_age" class="stock_datewise_age">
<span<?php echo $stock_datewise->age->viewAttributes() ?>>
<?php echo $stock_datewise->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$stock_datewise_list->ListOptions->render("body", "right", $stock_datewise_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$stock_datewise->isGridAdd())
		$stock_datewise_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$stock_datewise->RowType = ROWTYPE_AGGREGATE;
$stock_datewise->resetAttributes();
$stock_datewise_list->renderRow();
?>
<?php if ($stock_datewise_list->TotalRecs > 0 && !$stock_datewise->isGridAdd() && !$stock_datewise->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$stock_datewise_list->renderListOptions();

// Render list options (footer, left)
$stock_datewise_list->ListOptions->render("footer", "left");
?>
	<?php if ($stock_datewise->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $stock_datewise->product->footerCellClass() ?>"><span id="elf_stock_datewise_product" class="stock_datewise_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $stock_datewise->product_code->footerCellClass() ?>"><span id="elf_stock_datewise_product_code" class="stock_datewise_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $stock_datewise->godown->footerCellClass() ?>"><span id="elf_stock_datewise_godown" class="stock_datewise_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $stock_datewise->IN->footerCellClass() ?>"><span id="elf_stock_datewise_IN" class="stock_datewise_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_datewise->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $stock_datewise->OUT->footerCellClass() ?>"><span id="elf_stock_datewise_OUT" class="stock_datewise_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_datewise->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->balance->Visible) { // balance ?>
		<td data-name="balance" class="<?php echo $stock_datewise->balance->footerCellClass() ?>"><span id="elf_stock_datewise_balance" class="stock_datewise_balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $stock_datewise->balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $stock_datewise->packets->footerCellClass() ?>"><span id="elf_stock_datewise_packets" class="stock_datewise_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $stock_datewise->packing_type->footerCellClass() ?>"><span id="elf_stock_datewise_packing_type" class="stock_datewise_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $stock_datewise->lot_no->footerCellClass() ?>"><span id="elf_stock_datewise_lot_no" class="stock_datewise_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $stock_datewise->dated->footerCellClass() ?>"><span id="elf_stock_datewise_dated" class="stock_datewise_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $stock_datewise->type->footerCellClass() ?>"><span id="elf_stock_datewise_type" class="stock_datewise_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($stock_datewise->age->Visible) { // age ?>
		<td data-name="age" class="<?php echo $stock_datewise->age->footerCellClass() ?>"><span id="elf_stock_datewise_age" class="stock_datewise_age">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$stock_datewise_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$stock_datewise->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($stock_datewise_list->Recordset)
	$stock_datewise_list->Recordset->Close();
?>
<?php if (!$stock_datewise->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$stock_datewise->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($stock_datewise_list->Pager)) $stock_datewise_list->Pager = new PrevNextPager($stock_datewise_list->StartRec, $stock_datewise_list->DisplayRecs, $stock_datewise_list->TotalRecs, $stock_datewise_list->AutoHidePager) ?>
<?php if ($stock_datewise_list->Pager->RecordCount > 0 && $stock_datewise_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($stock_datewise_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $stock_datewise_list->pageUrl() ?>start=<?php echo $stock_datewise_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($stock_datewise_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $stock_datewise_list->pageUrl() ?>start=<?php echo $stock_datewise_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $stock_datewise_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($stock_datewise_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $stock_datewise_list->pageUrl() ?>start=<?php echo $stock_datewise_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($stock_datewise_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $stock_datewise_list->pageUrl() ?>start=<?php echo $stock_datewise_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $stock_datewise_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($stock_datewise_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $stock_datewise_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $stock_datewise_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $stock_datewise_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($stock_datewise_list->TotalRecs > 0 && (!$stock_datewise_list->AutoHidePageSizeSelector || $stock_datewise_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="stock_datewise">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($stock_datewise_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($stock_datewise_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($stock_datewise_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($stock_datewise_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($stock_datewise_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($stock_datewise->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $stock_datewise_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($stock_datewise_list->TotalRecs == 0 && !$stock_datewise->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $stock_datewise_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$stock_datewise_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$stock_datewise->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$stock_datewise->isExport()) { ?>
<script>
ew.scrollableTable("gmp_stock_datewise", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stock_datewise_list->terminate();
?>