<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$stock_datewise_search = new stock_datewise_search();

// Run the page
$stock_datewise_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$stock_datewise_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($stock_datewise_search->IsModal) { ?>
var fstock_datewisesearch = currentAdvancedSearchForm = new ew.Form("fstock_datewisesearch", "search");
<?php } else { ?>
var fstock_datewisesearch = currentForm = new ew.Form("fstock_datewisesearch", "search");
<?php } ?>

// Form_CustomValidate event
fstock_datewisesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fstock_datewisesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fstock_datewisesearch.lists["x_product"] = <?php echo $stock_datewise_search->product->Lookup->toClientList() ?>;
fstock_datewisesearch.lists["x_product"].options = <?php echo JsonEncode($stock_datewise_search->product->lookupOptions()) ?>;
fstock_datewisesearch.lists["x_godown"] = <?php echo $stock_datewise_search->godown->Lookup->toClientList() ?>;
fstock_datewisesearch.lists["x_godown"].options = <?php echo JsonEncode($stock_datewise_search->godown->lookupOptions()) ?>;
fstock_datewisesearch.lists["x_packing_type"] = <?php echo $stock_datewise_search->packing_type->Lookup->toClientList() ?>;
fstock_datewisesearch.lists["x_packing_type"].options = <?php echo JsonEncode($stock_datewise_search->packing_type->lookupOptions()) ?>;
fstock_datewisesearch.lists["x_type"] = <?php echo $stock_datewise_search->type->Lookup->toClientList() ?>;
fstock_datewisesearch.lists["x_type"].options = <?php echo JsonEncode($stock_datewise_search->type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fstock_datewisesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_datewise->rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_datewise->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_datewise->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_datewise->balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_datewise->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_datewise->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_age");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($stock_datewise->age->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $stock_datewise_search->showPageHeader(); ?>
<?php
$stock_datewise_search->showMessage();
?>
<form name="fstock_datewisesearch" id="fstock_datewisesearch" class="<?php echo $stock_datewise_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($stock_datewise_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $stock_datewise_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stock_datewise">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$stock_datewise_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($stock_datewise->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_product"><?php echo $stock_datewise->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->product->cellAttributes() ?>>
			<span id="el_stock_datewise_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_datewise" data-field="x_product" data-value-separator="<?php echo $stock_datewise->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $stock_datewise->product->editAttributes() ?>>
		<?php echo $stock_datewise->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $stock_datewise->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_rid"><?php echo $stock_datewise->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->rid->cellAttributes() ?>>
			<span id="el_stock_datewise_rid">
<input type="text" data-table="stock_datewise" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($stock_datewise->rid->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->rid->EditValue ?>"<?php echo $stock_datewise->rid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_code"><?php echo $stock_datewise->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->code->cellAttributes() ?>>
			<span id="el_stock_datewise_code">
<input type="text" data-table="stock_datewise" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($stock_datewise->code->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->code->EditValue ?>"<?php echo $stock_datewise->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_product_code"><?php echo $stock_datewise->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->product_code->cellAttributes() ?>>
			<span id="el_stock_datewise_product_code">
<input type="text" data-table="stock_datewise" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($stock_datewise->product_code->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->product_code->EditValue ?>"<?php echo $stock_datewise->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_godown"><?php echo $stock_datewise->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->godown->cellAttributes() ?>>
			<span id="el_stock_datewise_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_datewise" data-field="x_godown" data-value-separator="<?php echo $stock_datewise->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $stock_datewise->godown->editAttributes() ?>>
		<?php echo $stock_datewise->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $stock_datewise->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_IN"><?php echo $stock_datewise->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->IN->cellAttributes() ?>>
			<span id="el_stock_datewise_IN">
<input type="text" data-table="stock_datewise" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($stock_datewise->IN->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->IN->EditValue ?>"<?php echo $stock_datewise->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_OUT"><?php echo $stock_datewise->OUT->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->OUT->cellAttributes() ?>>
			<span id="el_stock_datewise_OUT">
<input type="text" data-table="stock_datewise" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($stock_datewise->OUT->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->OUT->EditValue ?>"<?php echo $stock_datewise->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_balance"><?php echo $stock_datewise->balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_balance" id="z_balance" value="="></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->balance->cellAttributes() ?>>
			<span id="el_stock_datewise_balance">
<input type="text" data-table="stock_datewise" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($stock_datewise->balance->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->balance->EditValue ?>"<?php echo $stock_datewise->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_packets"><?php echo $stock_datewise->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->packets->cellAttributes() ?>>
			<span id="el_stock_datewise_packets">
<input type="text" data-table="stock_datewise" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($stock_datewise->packets->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->packets->EditValue ?>"<?php echo $stock_datewise->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_packing_type"><?php echo $stock_datewise->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->packing_type->cellAttributes() ?>>
			<span id="el_stock_datewise_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_datewise" data-field="x_packing_type" data-value-separator="<?php echo $stock_datewise->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $stock_datewise->packing_type->editAttributes() ?>>
		<?php echo $stock_datewise->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $stock_datewise->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_lot_no"><?php echo $stock_datewise->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->lot_no->cellAttributes() ?>>
			<span id="el_stock_datewise_lot_no">
<input type="text" data-table="stock_datewise" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($stock_datewise->lot_no->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->lot_no->EditValue ?>"<?php echo $stock_datewise->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_dated"><?php echo $stock_datewise->dated->caption() ?></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($stock_datewise->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_stock_datewise_dated">
<input type="text" data-table="stock_datewise" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($stock_datewise->dated->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->dated->EditValue ?>"<?php echo $stock_datewise->dated->editAttributes() ?>>
<?php if (!$stock_datewise->dated->ReadOnly && !$stock_datewise->dated->Disabled && !isset($stock_datewise->dated->EditAttrs["readonly"]) && !isset($stock_datewise->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_datewisesearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_stock_datewise_dated" class="btw1_dated d-none">
<input type="text" data-table="stock_datewise" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($stock_datewise->dated->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->dated->EditValue2 ?>"<?php echo $stock_datewise->dated->editAttributes() ?>>
<?php if (!$stock_datewise->dated->ReadOnly && !$stock_datewise->dated->Disabled && !isset($stock_datewise->dated->EditAttrs["readonly"]) && !isset($stock_datewise->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fstock_datewisesearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_type"><?php echo $stock_datewise->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->type->cellAttributes() ?>>
			<span id="el_stock_datewise_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="stock_datewise" data-field="x_type" data-value-separator="<?php echo $stock_datewise->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $stock_datewise->type->editAttributes() ?>>
		<?php echo $stock_datewise->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $stock_datewise->type->Lookup->getParamTag("p_x_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($stock_datewise->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label for="x_age" class="<?php echo $stock_datewise_search->LeftColumnClass ?>"><span id="elh_stock_datewise_age"><?php echo $stock_datewise->age->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_age" id="z_age" value="="></span>
		</label>
		<div class="<?php echo $stock_datewise_search->RightColumnClass ?>"><div<?php echo $stock_datewise->age->cellAttributes() ?>>
			<span id="el_stock_datewise_age">
<input type="text" data-table="stock_datewise" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($stock_datewise->age->getPlaceHolder()) ?>" value="<?php echo $stock_datewise->age->EditValue ?>"<?php echo $stock_datewise->age->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$stock_datewise_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $stock_datewise_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$stock_datewise_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$stock_datewise_search->terminate();
?>